/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jbosh;

import com.kenai.jbosh.AbstractBody;
import com.kenai.jbosh.BOSHException;
import com.kenai.jbosh.BodyParser;
import com.kenai.jbosh.BodyParserResults;
import com.kenai.jbosh.BodyQName;
import java.io.IOException;
import java.io.StringReader;
import java.lang.ref.SoftReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

final class BodyParserXmlPull
implements BodyParser {
    private static final Logger LOG = Logger.getLogger(BodyParserXmlPull.class.getName());
    private static final ThreadLocal<SoftReference<XmlPullParser>> XPP_PARSER = new ThreadLocal<SoftReference<XmlPullParser>>(){

        @Override
        protected SoftReference<XmlPullParser> initialValue() {
            return new SoftReference<Object>(null);
        }
    };

    BodyParserXmlPull() {
    }

    @Override
    public BodyParserResults parse(String xml) throws BOSHException {
        Exception thrown;
        BodyParserResults result = new BodyParserResults();
        try {
            XmlPullParser xpp = BodyParserXmlPull.getXmlPullParser();
            xpp.setInput(new StringReader(xml));
            int eventType = xpp.getEventType();
            while (eventType != 1) {
                BodyQName bodyName;
                if (eventType == 2) {
                    if (LOG.isLoggable(Level.FINEST)) {
                        LOG.finest("Start tag: " + xpp.getName());
                    }
                } else {
                    eventType = xpp.next();
                    continue;
                }
                String prefix = xpp.getPrefix();
                if (prefix == null) {
                    prefix = "";
                }
                String uri = xpp.getNamespace();
                String localName = xpp.getName();
                QName name = new QName(uri, localName, prefix);
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.finest("Start element: ");
                    LOG.finest("    prefix: " + prefix);
                    LOG.finest("    URI: " + uri);
                    LOG.finest("    local: " + localName);
                }
                if (!(bodyName = AbstractBody.getBodyQName()).equalsQName(name)) {
                    throw new IllegalStateException("Root element was not '" + bodyName.getLocalPart() + "' in the '" + bodyName.getNamespaceURI() + "' namespace.  (Was '" + localName + "' in '" + uri + "')");
                }
                for (int idx = 0; idx < xpp.getAttributeCount(); ++idx) {
                    String attrPrefix;
                    String attrURI = xpp.getAttributeNamespace(idx);
                    if (attrURI.length() == 0) {
                        attrURI = xpp.getNamespace(null);
                    }
                    if ((attrPrefix = xpp.getAttributePrefix(idx)) == null) {
                        attrPrefix = "";
                    }
                    String attrLN = xpp.getAttributeName(idx);
                    String attrVal = xpp.getAttributeValue(idx);
                    BodyQName aqn = BodyQName.createWithPrefix(attrURI, attrLN, attrPrefix);
                    if (LOG.isLoggable(Level.FINEST)) {
                        LOG.finest("        Attribute: {" + attrURI + "}" + attrLN + " = '" + attrVal + "'");
                    }
                    result.addBodyAttributeValue(aqn, attrVal);
                }
            }
            return result;
        }
        catch (RuntimeException rtx) {
            thrown = rtx;
        }
        catch (XmlPullParserException xmlppx) {
            thrown = xmlppx;
        }
        catch (IOException iox) {
            thrown = iox;
        }
        throw new BOSHException("Could not parse body:\n" + xml, thrown);
    }

    private static XmlPullParser getXmlPullParser() {
        SoftReference<XmlPullParser> ref = XPP_PARSER.get();
        XmlPullParser result = ref.get();
        if (result == null) {
            try {
                XmlPullParserFactory factory = XmlPullParserFactory.newInstance();
                factory.setNamespaceAware(true);
                factory.setValidating(false);
                result = factory.newPullParser();
                ref = new SoftReference<XmlPullParser>(result);
                XPP_PARSER.set(ref);
                return result;
            }
            catch (Exception ex) {
                Exception thrown = ex;
                throw new IllegalStateException("Could not create XmlPull parser", thrown);
            }
        }
        return result;
    }
}

