/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.certificates;

import com.paterva.maltego.certificates.CertificateRepository;
import com.paterva.maltego.certificates.CertificateUtils;
import com.paterva.maltego.certificates.NoTrustedCertificateChainFoundException;
import com.paterva.maltego.certificates.impl.MultiKeyStoreTrustManager;
import com.paterva.maltego.certificates.impl.SimpleX509TrustManager;
import com.paterva.maltego.util.StringUtilities;
import com.paterva.maltego.util.Version;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManager;
import org.apache.commons.io.IOUtils;
import org.openide.util.Exceptions;

public class HttpAgent {
    private static final Logger LOG = Logger.getLogger(HttpAgent.class.getName());
    private URL _url;
    private URLConnection _cn;
    private int _readTimeout = -1;
    private int _connectTimeout = -1;
    private String _userAgent;
    private String _mimeType;
    private String _characterSet;
    private int _contentLength;
    private boolean _responseParsed = false;
    private boolean _trustAllCerts = false;
    private String _requireCNSuffix = null;
    private String _contentEncoding;
    private String _acceptEncoding;
    private boolean _allowNonHttp = false;

    public HttpAgent(URL url) {
        LOG.log(Level.FINE, "{0} URL: {1}", new Object[]{this.getHash(), url});
        this._url = url;
        this._userAgent = this.getDefaultUserAgent();
        HttpURLConnection.setFollowRedirects(true);
    }

    public boolean trustAllCerts() {
        return this._trustAllCerts;
    }

    public void setTrustAllCerts(boolean trustAll) {
        this._trustAllCerts = trustAll;
    }

    public boolean isAllowNonHttp() {
        return this._allowNonHttp;
    }

    public void setAllowNonHttp(boolean allowNonHttp) {
        this._allowNonHttp = allowNonHttp;
    }

    public void doGet() throws IOException {
        try {
            this.connect(false);
            this.parseResponse();
        }
        catch (Exception ex) {
            throw this.wrapException(ex, "GET");
        }
    }

    public OutputStream doPost(String contentType) throws IOException {
        try {
            this.connect(true);
            this._cn.setRequestProperty("Content-Type", contentType);
            return this._cn.getOutputStream();
        }
        catch (Exception ex) {
            throw this.wrapException(ex, "POST");
        }
    }

    private IOException wrapException(Exception ex, String method) {
        StringBuilder msg = new StringBuilder(method);
        msg.append(" ");
        msg.append(ex instanceof SocketTimeoutException ? "timeout" : "error");
        msg.append(", URL: ");
        msg.append(this._url);
        return new IOException(msg.toString(), ex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String doPostString(String contentType, String content) throws IOException {
        try (OutputStream os = this.doPost(contentType);){
            os.write(content.getBytes("UTF-8"));
        }
        return StringUtilities.toString((InputStream)this.getInputStream(), (String)this._characterSet);
    }

    public String getContentAsString() throws IOException {
        this.parseResponse();
        return StringUtilities.toString((InputStream)this.getInputStream(), (String)this._characterSet);
    }

    public byte[] getContentAsBytes() throws IOException {
        this.parseResponse();
        return IOUtils.toByteArray((InputStream)this.getInputStream());
    }

    private void connect(boolean doPost) throws IOException {
        LOG.log(Level.FINE, "{0} Connect - doPost: {1}", new Object[]{this.getHash(), doPost});
        this._responseParsed = false;
        URLConnection uconn = this._url.openConnection();
        if (!this._allowNonHttp && !(uconn instanceof HttpURLConnection)) {
            throw new IllegalArgumentException("URL protocol must be HTTP or HTTPS.");
        }
        if (uconn instanceof HttpsURLConnection) {
            try {
                this.configureHttpsConnection(uconn, false, false, false);
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        this._cn = uconn;
        if (this.getConnectTimeout() > -1) {
            this._cn.setConnectTimeout(this.getConnectTimeout());
        }
        if (this.getReadTimeout() > -1) {
            this._cn.setReadTimeout(this.getReadTimeout());
        }
        this._cn.setRequestProperty("User-Agent", this.getUserAgent());
        if (this._acceptEncoding != null) {
            this._cn.setRequestProperty("accept-encoding", this._acceptEncoding);
        }
        this._cn.setDoOutput(doPost);
        this._cn.setUseCaches(false);
        this._cn.setDoInput(true);
        if (this._cn instanceof HttpURLConnection) {
            HttpURLConnection httpURLConnection = (HttpURLConnection)this._cn;
            if (doPost) {
                httpURLConnection.setRequestMethod("POST");
            } else {
                httpURLConnection.setRequestMethod("GET");
            }
        }
    }

    private HttpsURLConnection configureHttpsConnection(URLConnection uconn, boolean testing, boolean overrideBackoff, boolean attachCertAction) throws NoSuchAlgorithmException, NoSuchProviderException, IOException, KeyStoreException, KeyManagementException, GeneralSecurityException {
        HostnameVerifier allowSelected = (urlHost, session) -> this._trustAllCerts ? true : urlHost.equalsIgnoreCase(CertificateUtils.getPeerHost(session));
        HttpsURLConnection ssl = (HttpsURLConnection)uconn;
        SSLContext sc = SSLContext.getInstance("SSL");
        KeyStore maltegoKeyStore = CertificateRepository.getDefault().getKeyStore(true);
        MultiKeyStoreTrustManager mkstm = new MultiKeyStoreTrustManager(testing, overrideBackoff, attachCertAction, maltegoKeyStore);
        SimpleX509TrustManager trustManager = new SimpleX509TrustManager(mkstm, this._trustAllCerts, attachCertAction);
        trustManager.setRequireInCN(this._requireCNSuffix);
        sc.init(null, new TrustManager[]{trustManager}, null);
        ssl.setSSLSocketFactory(sc.getSocketFactory());
        ssl.setHostnameVerifier(allowSelected);
        return ssl;
    }

    public InputStream getInputStream() throws IOException {
        this.parseResponse();
        return this._cn.getInputStream();
    }

    public void disconnect() {
        if (this._cn instanceof HttpURLConnection) {
            HttpURLConnection httpURLConnection = (HttpURLConnection)this._cn;
            httpURLConnection.disconnect();
        }
    }

    private void tryParseResponse() {
        if (!this._responseParsed) {
            try {
                this.parseResponse();
            }
            catch (IOException ex) {
                LOG.log(Level.WARNING, "Error parsing the response: {0}", ex.getMessage());
            }
        }
    }

    private void parseResponse() throws IOException {
        LOG.log(Level.FINE, "{0} Parse response", new Object[]{this.getHash()});
        if (this._cn instanceof HttpURLConnection) {
            boolean redirect;
            int responseCode = Integer.MAX_VALUE;
            String errorString = null;
            do {
                URL location;
                redirect = false;
                HttpURLConnection httpURLConnection = (HttpURLConnection)this._cn;
                try {
                    responseCode = httpURLConnection.getResponseCode();
                }
                catch (IOException ex) {
                    errorString = String.format("Error getting a response code for %s: %s", this._url, ex.getMessage());
                    LOG.log(Level.WARNING, errorString);
                }
                if (responseCode != 301 && responseCode != 302 || (location = this.getLocation()) == null || location.equals(this._url)) continue;
                redirect = true;
                this._url = location;
                this.connect(false);
            } while (redirect);
            if (responseCode == Integer.MAX_VALUE && errorString != null) {
                throw new IOException(errorString);
            }
            if (responseCode < 200 || responseCode >= 300) {
                throw new IOException("Unexpected HTTP response: " + responseCode + " for " + this._url);
            }
        }
        this._contentLength = this._cn.getContentLength();
        this._contentEncoding = this._cn.getContentEncoding();
        String type = this._cn.getContentType();
        String charset = null;
        if (type != null) {
            String[] parts = type.split(";");
            this._mimeType = parts[0].trim();
            for (int i = 1; i < parts.length && charset == null; ++i) {
                String t = parts[i].trim();
                int index = t.toLowerCase().indexOf("charset=");
                if (index == -1) continue;
                charset = t.substring(index + 8);
            }
        }
        this._characterSet = charset;
    }

    public URL getLocation() {
        URL url = null;
        String location = this._cn.getHeaderField("Location");
        if (location != null) {
            try {
                url = new URL(location);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return url;
    }

    private Object readStream(int length, InputStream stream, String charset) throws IOException {
        int buflen = Math.max(1024, Math.max(length, stream.available()));
        byte[] buf = new byte[buflen];
        byte[] bytes = null;
        int nRead = stream.read(buf);
        while (nRead != -1) {
            if (bytes == null) {
                bytes = buf;
                buf = new byte[buflen];
            } else {
                byte[] newBytes = new byte[bytes.length + nRead];
                System.arraycopy(bytes, 0, newBytes, 0, bytes.length);
                System.arraycopy(buf, 0, newBytes, bytes.length, nRead);
                bytes = newBytes;
            }
            nRead = stream.read(buf);
        }
        if (charset == null) {
            return bytes;
        }
        try {
            return new String(bytes, charset);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return bytes;
        }
    }

    public int getReadTimeout() {
        return this._readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this._readTimeout = readTimeout;
    }

    public int getConnectTimeout() {
        return this._connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this._connectTimeout = connectTimeout;
    }

    public String getUserAgent() {
        return this._userAgent;
    }

    public void setUserAgent(String userAgent) {
        this._userAgent = userAgent;
    }

    public String getMimeType() {
        this.tryParseResponse();
        return this._mimeType;
    }

    public String getCharacterSet() {
        this.tryParseResponse();
        return this._characterSet;
    }

    public int getContentLength() {
        this.tryParseResponse();
        return this._contentLength;
    }

    public String getContentEncoding() {
        this.tryParseResponse();
        return this._contentEncoding;
    }

    private String getDefaultUserAgent() {
        Version version = Version.getCurrent();
        return String.format("%s; %s %s", version.toString(true, true, false), System.getProperty("os.name"), System.getProperty("os.version"));
    }

    public void setRequireCNSuffix(String s) {
        this._requireCNSuffix = s;
    }

    public String getRequireCNSuffix() {
        return this._requireCNSuffix;
    }

    public void setAcceptEncoding(String encoding) {
        this._acceptEncoding = encoding;
    }

    public Optional<X509Certificate> getServerCertificate() throws IOException, GeneralSecurityException, NoTrustedCertificateChainFoundException {
        return this.getServerCertificate(false);
    }

    public Optional<X509Certificate> getServerCertificate(boolean attachCertAction) throws IOException, GeneralSecurityException, NoTrustedCertificateChainFoundException {
        return this.getServerCertificate(false, attachCertAction);
    }

    public Optional<X509Certificate> getServerCertificate(boolean overrideBackoff, boolean attachCertAction) throws IOException, GeneralSecurityException, NoTrustedCertificateChainFoundException {
        return this.getServerCertificate(false, overrideBackoff, attachCertAction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<X509Certificate> getServerCertificate(boolean testing, boolean overrideBackoff, boolean attachCertAction) throws IOException, GeneralSecurityException, NoTrustedCertificateChainFoundException {
        IOException ioEx = null;
        NoTrustedCertificateChainFoundException ntccfe = null;
        X509Certificate cert = null;
        URLConnection uconn = this._url.openConnection();
        if (uconn instanceof HttpURLConnection) {
            HttpURLConnection httpConn = (HttpURLConnection)uconn;
            try {
                if (uconn instanceof HttpsURLConnection) {
                    HttpsURLConnection ssl = this.configureHttpsConnection(uconn, testing, overrideBackoff, attachCertAction);
                    ssl.connect();
                    Certificate[] certificates = ssl.getServerCertificates();
                    if (certificates != null && certificates.length > 0 && certificates[0] instanceof X509Certificate) {
                        cert = (X509Certificate)certificates[0];
                    }
                }
            }
            catch (Exception ex) {
                if (cert == null && ex instanceof SSLException) {
                    ntccfe = new NoTrustedCertificateChainFoundException(ex);
                    if (!testing) {
                        LOG.log(Level.WARNING, "Error getting certificate for {0}: {1}", new Object[]{this._url, ex.getClass().getCanonicalName()});
                    }
                } else if (ex instanceof IOException) {
                    ioEx = (IOException)ex;
                    if (!testing) {
                        LOG.log(Level.WARNING, "Could not connect to {0}: {1}", new Object[]{this._url, ex.getClass().getCanonicalName()});
                    }
                }
            }
            finally {
                httpConn.disconnect();
            }
        }
        if (ioEx != null) {
            throw ioEx;
        }
        if (ntccfe == null) {
            return Optional.ofNullable(cert);
        }
        throw ntccfe;
    }

    private String getHash() {
        return LOG.isLoggable(Level.FINE) ? Integer.toString(System.identityHashCode(this), 36).toUpperCase() : "";
    }
}

