/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.certificates;

import com.google.common.net.InternetDomainName;
import com.paterva.maltego.certificates.CertificateDefinition;
import com.paterva.maltego.certificates.CertificateInputDialog;
import com.paterva.maltego.certificates.CertificateNeedValidationException;
import com.paterva.maltego.certificates.CertificateRepository;
import com.paterva.maltego.certificates.CertificateTrustHandler;
import com.paterva.maltego.certificates.HttpAgent;
import com.paterva.maltego.certificates.NoTrustedCertificateChainFoundException;
import com.paterva.maltego.util.Base64;
import com.paterva.maltego.util.FileUtilities;
import com.paterva.maltego.util.SlownessDetector;
import com.paterva.maltego.util.StringUtilities;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLSession;
import javax.security.cert.CertificateEncodingException;
import javax.security.cert.X509Certificate;
import javax.swing.SwingUtilities;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.validator.routines.InetAddressValidator;
import org.apache.commons.validator.routines.UrlValidator;
import org.bouncycastle.util.encoders.Hex;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Exceptions;

public class CertificateUtils {
    public static final String IOEXCEPTION_MESSAGE_KEY = "IOException connection problem";
    public static final String IOEXCEPTION_MESSAGE = "%s. Please check your network and proxy settings.";
    public static final String PROXY_HTTPS_HOST = "https.proxyHost";
    public static final String ACTION_PREFIX = " [Action:";
    public static final String CERTIFICATE_UNTRUSTED_CHAIN = "No valid certificate chain found.";
    public static final String CERTIFICATE_BLOCKED_MISMATCH_SANS_CN = " URL does not match certificate Subject Alternative Names (SANs), nor subject Common Name (CN). Otherwise the certificate may be revoked, have an incomplete chain, or a cipher issue.";
    public static final String CERTIFICATE_INVALID_DATE = "Transform certificate has invalid date.";
    public static final String CERTIFICATE_BLACKLISTED = "Certificate blacklisted in Maltego \"Certificate Manager\" (find under the \"Transforms\" ribbon tab).";
    public static final String CERTIFICATE_JAVA_KEYSTORE = "Certificate not trusted by the Java keystore.";
    public static final String CERTIFICATE_NO_SANS_CN = "ertificate has no parseable Subject Alternative Names (SANs), nor subject Common Name (CN).";
    public static final String CERTIFICATE_URL_MALTEGO_HOSTNAME_MISMATCH = "Certificate is trusted by the Maltego \"Certificate Manager\" (find under the \"Transforms\" ribbon tab), however the certificate has no parseable Subject Alternative Names (SANs), nor subject Common Name (CN).";
    public static final String CERTIFICATE_URL_MALTEGO_HOSTNAME_MISMATCH2 = " URL does not match any trusted hostnames.";
    public static final String CERTIFICATE_PROXY_ISSUE_BRIEF = "roxy settings may be incorrect.";
    public static final String CERTIFICATE_PROXY_ISSUE = "roxy settings may be incorrect. To change them click on the options button, then rerun this wizard from the \"Transform Hub\" item under the \"Transforms\" ribbon tab.";
    public static final String CERTIFICATE_BLOCKED_MESSAGE = "he transform certificate is blocked because of an invalid date, Subject Alternative Names (SANs) and subject Common Name (CN) that do not match the queried URL, or the certificate is blacklisted in the \"Certificate Manager\" (find under the \"Transforms\" ribbon tab).";
    public static final String CERTIFICATE_TABBED_VIEW_MESSAGE = "A summary of the certificate information is shown below, with more detailed information shown on the \"Details\" tab.";
    public static final String DATE_STRING = "EEE, dd MMM y 'at' h:mm:ss a z";
    private static final String SUBJECT_COMMON_NAME = "cn";
    private static final Logger LOG = Logger.getLogger(CertificateUtils.class.getName());

    private CertificateUtils() {
    }

    public static String getPeerHost(SSLSession session) {
        String peerHost = session.getPeerHost();
        peerHost = peerHost == null ? null : peerHost.replace("[", "").replace("]", "");
        return peerHost;
    }

    public static String stripUrl(String url) {
        return url.replaceFirst("^(https?:/+[^/\\?]+).*", "$1");
    }

    public static String getSubjectCommonName(java.security.cert.X509Certificate cert) {
        return CertificateUtils.getSubjectEntry(cert, SUBJECT_COMMON_NAME);
    }

    private static String getSubjectEntry(java.security.cert.X509Certificate cert, String entryKey) {
        String[] split;
        String subject = cert.getSubjectDN().getName();
        for (String s : split = subject.split(",")) {
            String trimmed = s.trim().toLowerCase();
            if (!trimmed.startsWith(entryKey + "=")) continue;
            return trimmed.substring(entryKey.length() + 1);
        }
        return null;
    }

    public static java.security.cert.X509Certificate decode(String base64Pem) throws IOException, CertificateException {
        byte[] bytes = Base64.decode((String)base64Pem);
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
        return (java.security.cert.X509Certificate)certFactory.generateCertificate(in);
    }

    public static java.security.cert.X509Certificate decode(File certificateFile, boolean forceDecode, boolean ignorePKCS12) {
        if (SwingUtilities.isEventDispatchThread() || forceDecode) {
            try {
                if (CertificateUtils.isPKCS12Certificate(certificateFile) && !ignorePKCS12) {
                    return CertificateUtils.loadPKCS12Cert(certificateFile, null, true);
                }
                CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
                Certificate cert = certFactory.generateCertificate(new FileInputStream(certificateFile));
                if (cert != null && cert instanceof java.security.cert.X509Certificate) {
                    return (java.security.cert.X509Certificate)cert;
                }
            }
            catch (Exception ex) {
                LOG.log(Level.WARNING, "Error decoding file {0}: {1}", new Object[]{certificateFile.getAbsolutePath(), ex.toString()});
            }
        }
        return null;
    }

    public static boolean isPKCS12Certificate(File certificateFile) {
        String fileName = certificateFile.getName().toLowerCase();
        return fileName.endsWith(".pfx") || fileName.endsWith(".p12");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static java.security.cert.X509Certificate loadPKCS12Cert(File certificateFile, String password, boolean retry) {
        boolean retryAfterFail;
        block18: {
            retryAfterFail = false;
            try (FileInputStream stream = new FileInputStream(certificateFile);){
                KeyStore keystore = KeyStore.getInstance("PKCS12");
                keystore.load(stream, password == null ? null : password.toCharArray());
                Enumeration<String> aliases = keystore.aliases();
                while (aliases.hasMoreElements()) {
                    java.security.cert.X509Certificate cert;
                    String alias = aliases.nextElement();
                    if (!keystore.getCertificate(alias).getType().equals("X.509")) continue;
                    java.security.cert.X509Certificate x509Certificate = cert = (java.security.cert.X509Certificate)keystore.getCertificate(alias);
                    return x509Certificate;
                }
            }
            catch (Exception ex) {
                LOG.log(Level.WARNING, "Error decoding file {0}: {1}", new Object[]{certificateFile.getAbsolutePath(), ex.toString()});
                if (!retry) break block18;
                retryAfterFail = true;
            }
        }
        if (!retryAfterFail) return null;
        return CertificateInputDialog.getDefault().loadCertificate(certificateFile);
    }

    public static String encode(java.security.cert.X509Certificate cert) throws java.security.cert.CertificateEncodingException {
        byte[] bytes = cert.getEncoded();
        String encodeBytes = Base64.encodeBytes((byte[])bytes);
        return encodeBytes;
    }

    public static String toPrettyString(java.security.cert.X509Certificate cert) {
        StringBuilder sb = new StringBuilder();
        sb.append("For:\n   ").append(cert.getSubjectDN()).append("\n");
        sb.append("Issued by:\n   ").append(cert.getIssuerDN()).append("\n");
        sb.append("Valid from ").append(CertificateUtils.toDateOnlyString(cert.getNotBefore()));
        sb.append(" to ").append(CertificateUtils.toDateOnlyString(cert.getNotAfter())).append("\n");
        sb.append("Serial Number: ").append(cert.getSerialNumber()).append("\n");
        sb.append("Generated with ").append(cert.getSigAlgName());
        return sb.toString();
    }

    public static String toPrettyString2(java.security.cert.X509Certificate cert) {
        String str = cert.toString();
        str = str.replaceAll("qualifier: 0000", "qualifier:\n0000");
        str = StringUtilities.indent((String)str, (char)'[', (char)']', (String)"  ");
        str = str.replaceAll("(\\d{60})(\\d)", "$1\n             $2");
        return str;
    }

    public static String toStringLine(java.security.cert.X509Certificate cert) {
        return CertificateUtils.toPrettyString(cert).replaceAll("\\s+", " ");
    }

    private static String toDateOnlyString(Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        return dateFormat.format(date);
    }

    public static String getDisplayString(String param, String suffix) {
        String value = StringUtilities.isNullOrEmpty((String)param) || "null".equals(param.trim().toLowerCase()) ? "<none>" : param + suffix;
        return value;
    }

    public static String getDisplayString(String param) {
        String value = StringUtilities.isNullOrEmpty((String)param) || "null".equals(param.trim().toLowerCase()) ? "<none>" : param;
        return value;
    }

    public static String toDateString(Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_STRING);
        return dateFormat.format(date);
    }

    public static boolean isValid(java.security.cert.X509Certificate cert) {
        boolean valid = true;
        try {
            cert.checkValidity();
        }
        catch (NullPointerException | CertificateExpiredException | CertificateNotYetValidException ex) {
            valid = false;
        }
        return valid;
    }

    public static boolean isSigningCa(java.security.cert.X509Certificate caCert, java.security.cert.X509Certificate cert) {
        boolean isSigningCa = false;
        try {
            cert.verify(caCert.getPublicKey());
            isSigningCa = true;
        }
        catch (NullPointerException | InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException | CertificateException exception) {
            // empty catch block
        }
        return isSigningCa;
    }

    public static boolean isBlackListedInCertRepo(CertificateRepository certRepo, java.security.cert.X509Certificate cert) {
        boolean isBlackListed = false;
        if (certRepo.contains(cert, false) || certRepo.containsCa(cert, false) && !certRepo.contains(cert)) {
            isBlackListed = true;
        }
        return isBlackListed;
    }

    public static boolean isShippedCert(CertificateRepository certRepo, java.security.cert.X509Certificate cert) {
        return certRepo.contains(cert, true) && !certRepo.getAllDisplay().contains(cert);
    }

    public static boolean hasParsableSansOrCN(java.security.cert.X509Certificate cert) {
        boolean hasParsableSansOrCN = false;
        if (cert != null) {
            CertificateDefinition certDef = new CertificateDefinition(cert);
            List<String> sans = certDef.getSubjectAlternativeNames();
            String cn = certDef.getSubjectName();
            String string = cn = StringUtilities.isNullOrEmpty((String)cn) ? cn : cn.trim();
            if (!StringUtilities.isNullOrEmpty((String)cn) && !sans.contains(cn)) {
                sans.add(cn);
            }
            for (String san : sans) {
                if (!CertificateUtils.isValidHostname(san)) continue;
                hasParsableSansOrCN = true;
                break;
            }
        }
        return hasParsableSansOrCN;
    }

    static boolean isValidHostname(String text) {
        boolean isValid = false;
        if (text != null) {
            UrlValidator defaultValidator;
            if ("*.".equalsIgnoreCase((text = text.trim()).substring(0, 2))) {
                text = text.substring(2);
            }
            if (!(isValid = CertificateUtils.isValidUrl(defaultValidator = new UrlValidator(8L), text))) {
                String prefixed = "http://" + text;
                isValid = CertificateUtils.isValidUrl(defaultValidator, prefixed);
            }
        }
        return isValid;
    }

    static boolean isValidUrl(UrlValidator defaultValidator, String text) {
        boolean isValid = false;
        if (defaultValidator.isValid(text) || defaultValidator.isValid(text.replaceFirst("\\.\\p{Alpha}[\\p{Alnum}-]*\\p{Alnum}$", ".com"))) {
            try {
                URL url = new URL(text);
                String hostname = url.getHost();
                isValid = true;
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return isValid;
    }

    public static boolean urlMatchesSansOrCN(java.security.cert.X509Certificate cert, URL url) {
        boolean hasSansOrCN = false;
        if (cert != null) {
            CertificateDefinition certDef = new CertificateDefinition(cert);
            List<String> sans = certDef.getSubjectAlternativeNames();
            String cn = certDef.getSubjectName();
            String string = cn = StringUtilities.isNullOrEmpty((String)cn) ? cn : cn.trim();
            if (!StringUtilities.isNullOrEmpty((String)cn) && !sans.contains(cn)) {
                sans.add(cn);
            }
            hasSansOrCN = CertificateUtils.urlMatchesHostnames(sans, url);
        }
        return hasSansOrCN;
    }

    public static boolean urlMatchesHostnames(List<String> hostnames, URL url) {
        boolean matches = false;
        if (url != null) {
            String urlHost = url.getHost().toLowerCase();
            for (String host : hostnames) {
                if (host == null) continue;
                if ("*.".equalsIgnoreCase((host = host.trim().toLowerCase()).substring(0, 2))) {
                    int index = urlHost.indexOf(".");
                    if (index <= 0) continue;
                    String hostMinusWildcard = host.substring(2);
                    String rem = urlHost.replace(hostMinusWildcard, "");
                    if (!urlHost.endsWith(hostMinusWildcard) || CertificateUtils.countDots(rem) != 0 && (CertificateUtils.countDots(rem) != 1 || !rem.endsWith("."))) continue;
                    matches = true;
                    break;
                }
                if (!urlHost.equalsIgnoreCase(host)) continue;
                matches = true;
                break;
            }
        }
        return matches;
    }

    private static int countDots(String s) {
        int count = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != '.') continue;
            ++count;
        }
        return count;
    }

    public static String getRootDomain(String text) {
        String hostname;
        String root = null;
        URL url = CertificateUtils.getValidUrl(text);
        if (url != null && CertificateUtils.isValidHostname(hostname = url.getHost().toLowerCase())) {
            root = CertificateUtils.isIP(hostname) || "localhost".equals(hostname) ? hostname : InternetDomainName.from((String)hostname).topPrivateDomain().toString();
        }
        return root;
    }

    private static boolean isIP(String validHostName) {
        InetAddressValidator ipValidator = InetAddressValidator.getInstance();
        boolean ip = ipValidator.isValid(validHostName.replace("[", "").replace("]", ""));
        return ip;
    }

    private static URL getValidUrl(String urlString) {
        URL url;
        UrlValidator defaultValidator;
        boolean valid = false;
        if (StringUtils.isNotBlank((CharSequence)urlString) && !(valid = CertificateUtils.isValidUrl(defaultValidator = new UrlValidator(8L), urlString = urlString.trim()))) {
            urlString = "http://" + urlString;
            valid = CertificateUtils.isValidUrl(defaultValidator, urlString);
        }
        try {
            url = valid ? new URL(urlString) : null;
        }
        catch (MalformedURLException ex) {
            url = null;
        }
        return url;
    }

    public static boolean checkSubject(java.security.cert.X509Certificate[] chain, String s) {
        if (chain != null && chain.length > 0) {
            java.security.cert.X509Certificate cert = chain[0];
            return CertificateUtils.checkSubject(cert, s);
        }
        return false;
    }

    private static boolean checkSubject(java.security.cert.X509Certificate cert, String s) {
        String cn = CertificateUtils.getSubjectCommonName(cert);
        if (cn == null) {
            return false;
        }
        s = s == null ? null : s.toLowerCase();
        return cn.endsWith(s);
    }

    public static void saveCertificateDevDebug(java.security.cert.X509Certificate cert, File folder) {
        try {
            String fileName = CertificateUtils.getSubjectCommonName(cert);
            String name = CertificateUtils.getId(new CertificateDefinition(cert));
            if (!StringUtilities.isNullOrEmpty((String)name)) {
                fileName = fileName + "_" + name;
            }
            fileName = FileUtilities.replaceIllegalChars((String)fileName);
            File file = new File(folder, fileName + ".cer");
            byte[] buf = cert.getEncoded();
            FileOutputStream os = new FileOutputStream(file);
            os.write(buf);
            os.close();
            OutputStreamWriter wr = new OutputStreamWriter((OutputStream)os, Charset.forName("UTF-8"));
            wr.write(Base64.encodeBytes((byte[])buf));
            ((Writer)wr).flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean isProxyUsed() {
        String proxyHost = System.getProperty(PROXY_HTTPS_HOST);
        return !StringUtilities.isNullOrEmpty((String)proxyHost);
    }

    public static boolean mustShowWizard(String urlStr, boolean overrideBackoff, boolean attachCertAction, boolean showError) {
        boolean showCertInstallWizard;
        block4: {
            showCertInstallWizard = false;
            try {
                URL url = new URL(urlStr);
                CertificateRepository certRepo = CertificateRepository.getDefault();
                showCertInstallWizard = CertificateUtils.testUrl(url, certRepo, overrideBackoff, attachCertAction);
            }
            catch (Exception ex) {
                String errorMsg = null;
                errorMsg = "Request failed with an error.";
                for (Throwable cause = ex; cause != null; cause = cause.getCause()) {
                    errorMsg = errorMsg + "\n" + cause.getClass().getSimpleName() + ": " + cause.getMessage();
                }
                if (showError) {
                    NotifyDescriptor.Message ndError = new NotifyDescriptor.Message((Object)errorMsg);
                    ndError.setTitle("Error");
                    ndError.setMessageType(2);
                    DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)ndError);
                }
                if (!(ex instanceof MalformedURLException)) break block4;
                LOG.log(Level.WARNING, ex.toString());
            }
        }
        return showCertInstallWizard;
    }

    public static boolean testUrl(URL url, CertificateRepository certRepo, boolean overrideBackoff, boolean attachCertAction) throws IOException, NoTrustedCertificateChainFoundException, GeneralSecurityException, Exception {
        boolean success = false;
        HttpAgent httpAgent = new HttpAgent(url);
        httpAgent.setConnectTimeout(8000);
        httpAgent.setReadTimeout(8000);
        Optional<Object> certOpt = Optional.ofNullable(null);
        CertificateTrustHandler.CertificateActions action = null;
        try {
            certOpt = httpAgent.getServerCertificate(overrideBackoff, attachCertAction);
        }
        catch (NoTrustedCertificateChainFoundException ex) {
            action = CertificateUtils.getCertActionFromException(ex);
        }
        if (certOpt.isPresent()) {
            httpAgent.doGet();
            success = true;
        } else if (action != null) {
            String urlString = url == null ? null : url.toString();
            switch (action) {
                case ALLOW: {
                    httpAgent.doGet();
                    success = true;
                    break;
                }
                case BLOCK: {
                    throw new NoTrustedCertificateChainFoundException("No valid certificate chain found. " + CertificateUtils.trimUrl(urlString) + " " + CERTIFICATE_BLOCKED_MISMATCH_SANS_CN + " Alternatively, p" + CERTIFICATE_PROXY_ISSUE_BRIEF + CertificateUtils.getActionString(action));
                }
                case DATE_INVALID: {
                    throw new NoTrustedCertificateChainFoundException("No valid certificate chain found. Transform certificate has invalid date." + CertificateUtils.getActionString(action));
                }
                case BLACKLISTED: {
                    throw new Exception(CERTIFICATE_BLACKLISTED + CertificateUtils.getActionString(action));
                }
                case SHOW_STORE: {
                    throw new CertificateNeedValidationException(CertificateUtils.getValidateFirstMessage(urlString) + " " + CERTIFICATE_JAVA_KEYSTORE + CertificateUtils.getActionString(action));
                }
                case SHOW_STORE_ATTACH_HOSTNAME: {
                    throw new CertificateNeedValidationException(CertificateUtils.getValidateFirstMessage(urlString) + " C" + CERTIFICATE_NO_SANS_CN + CertificateUtils.getActionString(action));
                }
                case SHOW_ATTACH_HOSTNAME: {
                    throw new CertificateNeedValidationException(CertificateUtils.getValidateFirstMessage(urlString) + " " + CERTIFICATE_URL_MALTEGO_HOSTNAME_MISMATCH + " " + CertificateUtils.trimUrl(urlString) + CERTIFICATE_URL_MALTEGO_HOSTNAME_MISMATCH2 + CertificateUtils.getActionString(action));
                }
            }
        } else if (!url.getProtocol().toLowerCase().contains("https")) {
            httpAgent.doGet();
            success = true;
        } else {
            throw new NoTrustedCertificateChainFoundException("No valid certificate chain found. The transform certificate is blocked because of an invalid date, Subject Alternative Names (SANs) and subject Common Name (CN) that do not match the queried URL, or the certificate is blacklisted in the \"Certificate Manager\" (find under the \"Transforms\" ribbon tab).");
        }
        return success;
    }

    public static boolean isCertificateError(Exception ex) {
        return CertificateUtils.isCertificateError(ex, "ValidatorException", "PKIX");
    }

    public static boolean isCertificateError(Exception ex, String ... containing) {
        boolean certError = true;
        String errorMsg = CertificateUtils.getErrorString(ex).replaceAll("\n", " ");
        for (String str : containing) {
            if (errorMsg.contains(str)) continue;
            certError = false;
        }
        return certError;
    }

    public static String getValidateFirstMessage(String url) {
        url = CertificateUtils.trimUrl(url);
        return "Certificate for " + url + " will need to be validated first.";
    }

    public static String trimUrl(String url) {
        int index;
        if (url != null && (index = url.indexOf("?")) > -1) {
            url = url.substring(0, index);
        }
        return url;
    }

    public static String getActionString(CertificateTrustHandler.CertificateActions action) {
        return String.format("%s %s]", ACTION_PREFIX, action.name().toLowerCase());
    }

    public static String getErrorString(Exception ex) {
        String errorMsg = "";
        for (Throwable cause = ex; cause != null; cause = cause.getCause()) {
            errorMsg = errorMsg + "\n" + cause.getClass().getCanonicalName() + ": " + cause.getLocalizedMessage();
        }
        return errorMsg;
    }

    public static CertificateException attachCertActionToException(CertificateTrustHandler.CertificateActions action, CertificateException excep) {
        return new CertificateException(action.name(), excep);
    }

    public static CertificateTrustHandler.CertificateActions getCertActionFromException(NoTrustedCertificateChainFoundException ex) {
        CertificateTrustHandler.CertificateActions certAction = CertificateTrustHandler.CertificateActions.BLOCK;
        for (CertificateTrustHandler.CertificateActions action : CertificateTrustHandler.CertificateActions.values()) {
            if (!CertificateUtils.isCertificateError(ex, action.name() + " ")) continue;
            certAction = action;
            break;
        }
        return certAction;
    }

    public static java.security.cert.X509Certificate[] convertX509Certificates(X509Certificate[] certs) throws CertificateException {
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        ArrayList<java.security.cert.X509Certificate> x509List = new ArrayList<java.security.cert.X509Certificate>();
        for (X509Certificate cert : certs) {
            try {
                ByteArrayInputStream bais = new ByteArrayInputStream(cert.getEncoded());
                java.security.cert.X509Certificate x509Certificate = (java.security.cert.X509Certificate)certificateFactory.generateCertificate(bais);
                if (x509Certificate == null) continue;
                x509List.add(x509Certificate);
            }
            catch (java.security.cert.CertificateEncodingException | CertificateEncodingException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        java.security.cert.X509Certificate[] convertedCerts = x509List.toArray(new java.security.cert.X509Certificate[0]);
        return convertedCerts;
    }

    public static String getId(CertificateDefinition certDef) {
        java.security.cert.X509Certificate cert = certDef.getCertificate();
        String id = null;
        BigInteger serialNumber = cert.getSerialNumber();
        if (serialNumber != null) {
            id = Hex.toHexString((byte[])serialNumber.toByteArray());
        } else {
            try {
                byte[] encoded = cert.getEncoded();
                id = DigestUtils.sha1Hex((byte[])encoded);
            }
            catch (java.security.cert.CertificateEncodingException ex) {
                SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_STRING);
                id = dateFormat.format(cert.getNotAfter());
            }
        }
        String name = certDef.getIssuerName();
        id = StringUtilities.isNullOrEmpty((String)id) ? null : CertificateUtils.replaceIllegalChars(name + "_" + id);
        return id;
    }

    private static String replaceIllegalChars(String filename) {
        return filename.trim().toLowerCase().replaceAll("[^A-Za-z0-9._]", "_");
    }

    public static CertificateTrustHandler.CertificateActions testDevDebug(String urlStr) {
        CertificateTrustHandler.CertificateActions action = null;
        try {
            SlownessDetector.setEnabled((boolean)false);
            URL url = new URL(urlStr);
            while ((action = CertificateUtils.testUrlDevDebug(url, false, null)) == null) {
            }
        }
        catch (Exception ex) {
            LOG.log(Level.INFO, "testDevDebug error - {0}", new Object[]{urlStr});
        }
        finally {
            SlownessDetector.setEnabled((boolean)true);
        }
        return action;
    }

    private static CertificateTrustHandler.CertificateActions testUrlDevDebug(URL url, boolean trustAllCerts, CertificateTrustHandler.CertificateActions certAction) {
        HttpAgent httpAgent = new HttpAgent(url);
        httpAgent.setConnectTimeout(5000);
        httpAgent.setReadTimeout(5000);
        Optional<Object> certOpt = Optional.ofNullable(null);
        CertificateTrustHandler.CertificateActions action = null;
        try {
            if (trustAllCerts) {
                httpAgent.setTrustAllCerts(true);
                certOpt = httpAgent.getServerCertificate();
            } else {
                certOpt = httpAgent.getServerCertificate(true, false, true);
            }
        }
        catch (NoTrustedCertificateChainFoundException ex) {
            action = CertificateUtils.getCertActionFromException(ex);
        }
        catch (IOException | GeneralSecurityException ex) {
            return null;
        }
        if (certOpt.isPresent()) {
            CertificateDefinition certDef = new CertificateDefinition((java.security.cert.X509Certificate)certOpt.get());
            List<String> sans = certDef.getSubjectAlternativeNames();
            LOG.log(Level.INFO, "{0};{1};{2};{3}", new Object[]{url, certDef.getSubjectName(), sans.toString(), certAction == null ? CertificateTrustHandler.CertificateActions.ALLOW.name() : certAction.name()});
            return certAction == null ? CertificateTrustHandler.CertificateActions.ALLOW : certAction;
        }
        if (action != null) {
            return CertificateUtils.testUrlDevDebug(url, true, action);
        }
        return CertificateTrustHandler.CertificateActions.BLOCK;
    }
}

