/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.entity.registry.serializer;

import com.paterva.maltego.entity.api.MaltegoLinkSpec;
import com.paterva.maltego.entity.registry.serializer.LinkSpecStub;
import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.DisplayDescriptorEnumeration;
import com.paterva.maltego.typing.PropertyConfiguration;
import com.paterva.maltego.typing.descriptor.TypeInstantiationException;
import com.paterva.maltego.typing.serializer.FieldsSerializer;
import com.paterva.maltego.util.XmlSerializationException;

class LinkSpecTranslator {
    LinkSpecTranslator() {
    }

    public MaltegoLinkSpec translate(LinkSpecStub stub) throws TypeInstantiationException, XmlSerializationException {
        DisplayDescriptor thicknessProp;
        DisplayDescriptor styleProp;
        DisplayDescriptor colorProp;
        FieldsSerializer serializer = new FieldsSerializer();
        PropertyConfiguration propertyConfig = serializer.readSerializationStub(stub.Properties);
        MaltegoLinkSpec spec = new MaltegoLinkSpec(stub.ID, propertyConfig);
        spec.setDescription(stub.Description);
        spec.setDisplayName(stub.Name);
        spec.setDisplayNamePlural(stub.PluralName);
        spec.setDefaultCategory(stub.Category);
        DisplayDescriptorEnumeration properties = propertyConfig.getProperties();
        DisplayDescriptor showLabelProp = properties.get("maltego.link.show-label");
        if (showLabelProp != null) {
            spec.setShowLabelProperty(showLabelProp);
        }
        if ((colorProp = properties.get("maltego.link.color")) != null) {
            spec.setColorProperty(colorProp);
        }
        if ((styleProp = properties.get("maltego.link.style")) != null) {
            spec.setStyleProperty(styleProp);
        }
        if ((thicknessProp = properties.get("maltego.link.thickness")) != null) {
            spec.setThicknessProperty(thicknessProp);
        }
        return spec;
    }

    public LinkSpecStub translate(MaltegoLinkSpec spec) throws XmlSerializationException {
        LinkSpecStub stub = new LinkSpecStub();
        stub.Description = spec.getDescription();
        stub.ID = spec.getTypeName();
        stub.Name = spec.getDisplayName();
        stub.PluralName = spec.getDisplayNamePlural();
        stub.Category = spec.getDefaultCategory();
        FieldsSerializer serializer = new FieldsSerializer();
        stub.Properties = serializer.createSerializationStub(spec.getPropertyConfiguration());
        return stub;
    }
}

