/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.entity.registry.converter;

import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.entity.registry.converter.AbstractEntityConverter;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.util.ExceptionUtilities;
import com.paterva.maltego.util.StringUtilities;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class RegexEntityConverter
extends AbstractEntityConverter {
    private static final Logger LOG = Logger.getLogger(RegexEntityConverter.class.getName());
    private Pattern _pattern;
    private String _patternString;
    private List<String> _properties;
    private String _mainProperty;

    public void init(String value) throws PatternSyntaxException {
        this._patternString = value;
        this._pattern = Pattern.compile(value, 32);
    }

    public List<String> getProperties() {
        return this._properties;
    }

    public void setProperties(List<String> properties) {
        this._properties = properties;
    }

    public String getMainProperty() {
        return this._mainProperty;
    }

    public void setMainProperty(String property) {
        this._mainProperty = property;
    }

    @Override
    public boolean canConvertFrom(Object value, PropertyDescriptor valueDescriptor) {
        return this._pattern != null && value instanceof String && this._pattern.matcher((String)value).matches();
    }

    @Override
    public MaltegoEntity convertFrom(Object value, MaltegoEntity template, PropertyDescriptor valueDescriptor, boolean resetIfSamplePart) {
        if (this._pattern != null && value instanceof String) {
            if (this._properties == null || this._properties.isEmpty()) {
                PropertyDescriptor mainPd = template.getProperties().get(this._mainProperty);
                if (mainPd != null) {
                    template.setValue(mainPd, value, true, resetIfSamplePart);
                } else if (valueDescriptor != null) {
                    LOG.log(Level.WARNING, "The main property descriptor for entity of type {0} is null, using the inherited value property instead.", template.getTypeName());
                    template.setValue(valueDescriptor, value, true, resetIfSamplePart);
                }
            } else {
                this.setPropertiesFromGroups(value, template, resetIfSamplePart);
            }
        }
        return template;
    }

    private void setPropertiesFromGroups(Object value, MaltegoEntity template, boolean resetIfSamplePart) {
        Matcher m = this._pattern.matcher((String)value);
        if (m.matches()) {
            if (resetIfSamplePart) {
                template.resetIfSamplePart();
            }
            for (int i = 1; i <= m.groupCount() && i <= this._properties.size(); ++i) {
                String groupStr;
                PropertyDescriptor pd;
                String propertyName = this._properties.get(i - 1);
                if (StringUtilities.isNullOrEmpty((String)propertyName) || (pd = template.getProperties().get(propertyName)) == null || (groupStr = m.group(i)) == null) continue;
                try {
                    template.setValue(pd, (Object)groupStr);
                    continue;
                }
                catch (Exception ex) {
                    LOG.log(Level.WARNING, ExceptionUtilities.toDescriptiveOneLiner((Throwable)ex));
                }
            }
        }
    }

    public String toString() {
        return this._patternString;
    }

    public int getPriority() {
        return 10;
    }
}

