/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.entity.registry.converter;

import com.opencsv.CSVParser;
import com.opencsv.CSVParserBuilder;
import com.opencsv.CSVReader;
import com.opencsv.CSVReaderBuilder;
import com.opencsv.ICSVParser;
import com.opencsv.RFC4180Parser;
import com.opencsv.RFC4180ParserBuilder;
import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.TypedPropertyBag;
import com.paterva.maltego.entity.api.EntityConverter;
import com.paterva.maltego.entity.api.EntityFactory;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.EntityStringConverter;
import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.entity.api.inheritance.InheritanceHelper;
import com.paterva.maltego.entity.registry.converter.MatchingOrderComparator;
import com.paterva.maltego.entity.registry.converter.RegexEntityConverter;
import com.paterva.maltego.graph.cache.skeletons.EntitySkeletonProvider;
import com.paterva.maltego.graph.cache.skeletons.SkeletonProviders;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.wrapper.GraphStoreHelper;
import com.paterva.maltego.typing.Converter;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.PropertyDescriptorCollection;
import com.paterva.maltego.typing.descriptor.SpecRegistry;
import com.paterva.maltego.typing.descriptor.TypeInstantiationException;
import com.paterva.maltego.util.StringUtilities;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public class DefaultEntityStringConverter
implements EntityStringConverter {
    public static final String SPACE = " ";
    public static final String PIPE = "|";
    public static final String TWO_PIPES = "||";
    public static final String QUOTE = "\"";
    public static final String TWO_QUOTES = "\"\"";
    private static final String RND_ENCODE_HASH = StringUtilities.randomAlphabetic((int)10);
    private static final String RND_ENCODE_EQUALS = StringUtilities.randomAlphabetic((int)10);
    private static final String RND_DECODE_PIPE = StringUtilities.randomAlphabetic((int)10);
    private static final String RND_DECODE_HASH = StringUtilities.randomAlphabetic((int)10);
    private static final String RND_DECODE_EQUALS = StringUtilities.randomAlphabetic((int)10);

    public String convert(GraphID graphID, Collection<EntityID> entities, boolean withType, boolean withWeight) {
        StringBuilder buffer = new StringBuilder();
        EntitySkeletonProvider skeletons = SkeletonProviders.entitiesForGraph((GraphID)graphID);
        for (EntityID entityID : entities) {
            try {
                MaltegoEntity entity = skeletons.getEntitySkeleton(entityID);
                this.toEntityString(buffer, entity, withType, withWeight, false);
            }
            catch (GraphStoreException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            buffer.append(StringUtilities.newLine());
        }
        return buffer.toString();
    }

    public String convert(GraphID graphID, boolean withProperty, Collection<EntityID> entities, boolean withType) {
        StringBuilder buffer = new StringBuilder();
        for (EntityID entityID : entities) {
            MaltegoEntity entity = GraphStoreHelper.getEntity((GraphID)graphID, (EntityID)entityID);
            this.toEntityString(buffer, entity, withType, false, withProperty);
            buffer.append(StringUtilities.newLine());
        }
        return buffer.toString();
    }

    StringBuilder toEntityString(StringBuilder buffer, MaltegoEntity entity, boolean withType, boolean withWeight, boolean withProperty) {
        String part1 = "";
        if (withType) {
            String type = entity.getTypeName();
            part1 = part1 + type;
            part1 = part1 + "#";
        }
        part1 = part1 + this.encodeHash(entity.getValueString());
        if (withWeight) {
            part1 = part1 + "#";
            part1 = part1 + entity.getWeight();
        }
        buffer.append(this.encodeCSV(part1));
        if (!withWeight && withProperty) {
            PropertyDescriptorCollection properties = entity.getProperties();
            for (PropertyDescriptor pd : properties) {
                String name = pd.getName();
                if ("maltego.automation.dob".equals(name) || "overlays#".equals(name)) continue;
                buffer.append(PIPE);
                String value = Converter.convertTo((Object)entity.getValue(pd), (Class)pd.getType());
                String nameValue = this.encodeEquals(name) + "=" + this.encodeEquals(value);
                buffer.append(this.encodeCSV(nameValue));
            }
        }
        return buffer;
    }

    private String encodeHash(String value) {
        return value.replace("#", RND_ENCODE_HASH);
    }

    private String encodeEquals(String value) {
        return value.replace("=", RND_ENCODE_EQUALS);
    }

    private String encodeCSV(String value) {
        String encoded = value.replace(QUOTE, TWO_QUOTES);
        if (encoded.length() > value.length() || this.mustEncode(encoded)) {
            encoded = encoded.replace(RND_ENCODE_HASH, "\"\"#\"\"");
            encoded = encoded.replace(RND_ENCODE_EQUALS, "\"\"=\"\"");
            encoded = QUOTE + encoded + QUOTE;
        }
        return encoded;
    }

    private boolean mustEncode(String text) {
        return text.contains(PIPE) || text.contains("\n") || text.contains("\r") || text.contains("\r\n") || text.contains("\t") || text.contains("\f") || text.contains("\b") || text.contains(RND_ENCODE_EQUALS) || text.contains(RND_ENCODE_HASH);
    }

    public Collection<MaltegoEntity> convert(String value) {
        EntityRegistry registry = (EntityRegistry)Lookup.getDefault().lookup(EntityRegistry.class);
        return this.convert(registry, value);
    }

    Collection<MaltegoEntity> convert(EntityRegistry registry, String value) {
        assert (registry != null);
        MaltegoEntitySpec[] specs = this.getSpecList(registry);
        ArrayList<MaltegoEntity> entities = new ArrayList<MaltegoEntity>();
        if (value != null) {
            value = value.trim();
            List<String[]> lines = this.getLines(value, true);
            for (String[] lineArray : lines) {
                MaltegoEntity entity;
                String[] lineCols = this.encodeLine(lineArray);
                if (lineCols == null || (entity = this.convertOneImpl(lineCols, registry, specs)) == null) continue;
                entities.add(entity);
            }
        }
        return entities;
    }

    List<String[]> getLines(String value, boolean useRFC4180Parser) {
        List<String[]> lines;
        block5: {
            CSVReader reader;
            if (value.contains("{") && value.contains("}") || value.contains("[") && value.contains("]")) {
                value = value.replaceAll("(?<!\\\\)\\\\\"", "\\\\\"\"");
            }
            StringReader sr = new StringReader(value);
            if (useRFC4180Parser) {
                RFC4180Parser rfc4180Parser = new RFC4180ParserBuilder().withSeparator('|').withQuoteChar('\"').build();
                reader = new CSVReaderBuilder((Reader)sr).withCSVParser((ICSVParser)rfc4180Parser).build();
            } else {
                CSVParser csvParser = new CSVParserBuilder().withSeparator('|').withQuoteChar('\"').withIgnoreQuotations(true).build();
                reader = new CSVReaderBuilder((Reader)sr).withCSVParser((ICSVParser)csvParser).build();
            }
            lines = Collections.emptyList();
            try {
                lines = reader.readAll();
            }
            catch (Exception ex) {
                if (!useRFC4180Parser) break block5;
                lines = this.getLines(value, false);
            }
        }
        return lines;
    }

    private String[] encodeLine(String[] lineArray) {
        for (int i = 0; i < lineArray.length; ++i) {
            lineArray[i] = lineArray[i].trim();
        }
        return lineArray;
    }

    private MaltegoEntity convertOneImpl(String[] lineCols, EntityRegistry registry, MaltegoEntitySpec[] specs) {
        String type;
        MaltegoEntitySpec spec = null;
        MaltegoEntity entity = null;
        LinkedHashMap<String, String> props = this.extractProperties(lineCols);
        String part1 = lineCols[0];
        String[] tokens = part1.replace("\"#\"", RND_DECODE_HASH).split("#");
        if (tokens.length > 1 && (spec = (MaltegoEntitySpec)registry.get(type = tokens[0])) != null) {
            String[] tokensWithoutType = new String[tokens.length - 1];
            for (int i = 0; i < tokens.length - 1; ++i) {
                tokensWithoutType[i] = tokens[i + 1];
            }
            tokens = tokensWithoutType;
        }
        Integer weight = null;
        String string = part1 = tokens.length > 0 ? tokens[0] : "";
        if (tokens.length > 1) {
            String weightStr = tokens[tokens.length - 1];
            try {
                weight = Integer.parseInt(weightStr);
            }
            catch (NumberFormatException i) {
                // empty catch block
            }
            int endValueToken = weight == null ? tokens.length : tokens.length - 1;
            StringBuilder valueBuilder = new StringBuilder();
            for (int i = 0; i < endValueToken; ++i) {
                if (i != 0) {
                    valueBuilder.append("#");
                }
                valueBuilder.append(tokens[i]);
            }
            part1 = valueBuilder.toString();
        }
        if (spec == null) {
            spec = this.findMatch(part1, specs);
        }
        if (spec != null) {
            entity = this.createEntity(spec, part1.replace(RND_DECODE_HASH, "#"), props);
        }
        if (entity != null && weight != null) {
            entity.setWeight(weight);
        }
        return entity;
    }

    private MaltegoEntity createEntity(MaltegoEntitySpec spec, String part1, LinkedHashMap<String, String> props) {
        part1 = this.decodeLine(part1);
        MaltegoEntity entity = null;
        EntityFactory factory = (EntityFactory)Lookup.getDefault().lookup(EntityFactory.class);
        try {
            entity = factory.createInstance(spec, false, true);
            EntityRegistry registry = EntityRegistry.getDefault();
            PropertyDescriptor valuePd = InheritanceHelper.getValueProperty((SpecRegistry)registry, (TypedPropertyBag)entity, (boolean)true);
            EntityConverter converter = InheritanceHelper.getConverter((EntityRegistry)registry, (MaltegoEntity)entity, (String)part1, (PropertyDescriptor)valuePd);
            if (converter != null) {
                entity = converter.convertFrom((Object)part1, entity, valuePd, false);
            } else {
                entity.setValue(valuePd, (Object)part1);
            }
            entity = this.addProperties(entity, props);
        }
        catch (TypeInstantiationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return entity;
    }

    int firstValidDelimiterIndex(String text) {
        int index;
        int firstDelimiter = -1;
        int pos = 0;
        while ((index = text.indexOf(PIPE, pos)) != -1) {
            int nextPos = index + PIPE.length();
            long count = text.substring(0, index).chars().filter(ch -> ch == QUOTE.charAt(0)).count();
            if (count % 2L == 0L) {
                firstDelimiter = index;
                break;
            }
            pos = nextPos;
        }
        return firstDelimiter;
    }

    private String decodeLine(String value) {
        return value;
    }

    private LinkedHashMap<String, String> extractProperties(String[] propArray) {
        LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
        if (propArray.length > 1) {
            int index = 0;
            for (String prop : propArray) {
                if (index == 0) {
                    ++index;
                    continue;
                }
                String tmp = this.encodeWithRnd(prop);
                String[] keyValue = tmp.split("=", 2);
                props.put(this.decodeLine(this.decodeWithRnd(keyValue[0])), keyValue.length == 1 ? "" : this.decodeLine(this.decodeWithRnd(keyValue[1])));
            }
        }
        return props;
    }

    private String encodeWithRnd(String text) {
        return text.replace("\"=\"", RND_DECODE_EQUALS);
    }

    private String decodeWithRnd(String text) {
        return text.replace(RND_DECODE_EQUALS, "=");
    }

    private MaltegoEntity addProperties(MaltegoEntity entity, LinkedHashMap<String, String> props) {
        if (entity != null) {
            entity.getProperties().forEach(pd -> {
                String key = pd.getName();
                if (props.containsKey(key)) {
                    String valueString = (String)props.get(key);
                    try {
                        Object valueObject = Converter.convertFrom((String)valueString, (Class)pd.getType());
                        entity.setValue(pd, valueObject);
                        props.remove(key);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            props.entrySet().forEach(entry -> this.addDymanicProperty(entity, String.class, (String)entry.getKey(), entry.getValue()));
        }
        return entity;
    }

    private void addDymanicProperty(MaltegoEntity entity, Class clazz, String propertyName, Object propertyValue) {
        PropertyDescriptor dp = new PropertyDescriptor(clazz, propertyName);
        entity.addProperty(dp);
        entity.setValue(dp, propertyValue);
    }

    private MaltegoEntitySpec[] getSpecList(EntityRegistry registry) {
        Collection specsList = registry.getAll();
        MaltegoEntitySpec[] specs = specsList.toArray(new MaltegoEntitySpec[specsList.size()]);
        Arrays.sort(specs, new MatchingOrderComparator());
        MaltegoEntitySpec[] reorderedSpecs = this.reorderNonRegexSpecs(specs);
        return reorderedSpecs;
    }

    private MaltegoEntitySpec[] reorderNonRegexSpecs(MaltegoEntitySpec[] specs) {
        ArrayList<MaltegoEntitySpec> nonRegex = new ArrayList<MaltegoEntitySpec>();
        String phraseTypeName = "maltego.Phrase";
        boolean phasePresent = true;
        MaltegoEntitySpec phraseSpec = null;
        ArrayList<MaltegoEntitySpec> reorderedList = new ArrayList<MaltegoEntitySpec>();
        reorderedList.addAll(Arrays.asList(specs));
        Iterator iterator = reorderedList.iterator();
        while (iterator.hasNext()) {
            boolean hasRegex;
            EntityConverter converter;
            MaltegoEntitySpec spec = (MaltegoEntitySpec)iterator.next();
            String typeName = spec.getTypeName();
            if (phraseTypeName.equals(typeName)) {
                phraseSpec = new MaltegoEntitySpec(spec);
            }
            if ((converter = spec.getConverter()) == null || (hasRegex = converter instanceof RegexEntityConverter)) continue;
            if (phraseTypeName.equals(typeName)) {
                phasePresent = false;
            } else {
                nonRegex.add(new MaltegoEntitySpec(spec));
            }
            iterator.remove();
        }
        if (!phasePresent && phraseSpec != null) {
            reorderedList.add(phraseSpec);
        }
        reorderedList.addAll(nonRegex);
        MaltegoEntitySpec[] reorderedSpecs = reorderedList.toArray(new MaltegoEntitySpec[reorderedList.size()]);
        return reorderedSpecs;
    }

    private MaltegoEntitySpec findMatch(String value, MaltegoEntitySpec[] specs) {
        for (MaltegoEntitySpec spec : specs) {
            EntityConverter converter = spec.getConverter();
            if (converter == null || !converter.canConvertFrom((Object)value, (PropertyDescriptor)spec.getValueProperty())) continue;
            return spec;
        }
        return null;
    }
}

