/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb.server;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.xlightweb.Context;
import org.xlightweb.HttpUtils;
import org.xlightweb.IHttpRequestHandler;
import org.xlightweb.IWebHandler;
import org.xlightweb.RequestHandlerChain;
import org.xlightweb.server.HttpProtocolAdapter;
import org.xsocket.DataConverter;
import org.xsocket.IntrospectionBasedDynamicMBean;
import org.xsocket.Resource;
import org.xsocket.connection.IServer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ServerUtils {
    private static final Logger LOG = Logger.getLogger(ServerUtils.class.getName());
    private static Map<String, String> mimeTypeMap;
    private static String componentInfo;

    private ServerUtils() {
    }

    static String getComponentInfo() {
        if (componentInfo == null) {
            componentInfo = "xLightweb/" + HttpUtils.getImplementationVersion();
        }
        return componentInfo;
    }

    static ObjectName exportMbean(MBeanServer mbeanServer, ObjectName objectname, Object handler) throws Exception {
        String namespace = objectname.getDomain();
        if (handler instanceof Context) {
            Context ctx = (Context)handler;
            objectname = new ObjectName(namespace + ":type=HttpContext" + ", name=[" + ctx.getContextPath() + "]");
            for (IWebHandler hdl : ctx.getHandlers()) {
                ServerUtils.exportMbean(mbeanServer, objectname, hdl);
            }
        } else if (handler instanceof RequestHandlerChain) {
            RequestHandlerChain chain = (RequestHandlerChain)handler;
            objectname = new ObjectName(namespace + ":type=HttpRequestHandlerChain" + ", name=" + chain.hashCode());
            for (IHttpRequestHandler hdl : chain.getHandlers()) {
                ServerUtils.exportMbean(mbeanServer, objectname, hdl);
            }
        } else {
            String name = handler.getClass().getSimpleName().trim();
            if (name.length() < 1) {
                name = Integer.toString(handler.hashCode());
            }
            objectname = new ObjectName(namespace + ":type=HttpRequestHandler, name=" + name);
        }
        mbeanServer.registerMBean(new IntrospectionBasedDynamicMBean(handler), objectname);
        return objectname;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized Map<String, String> getMimeTypeMapping() {
        if (mimeTypeMap == null) {
            HashMap<String, String> map = new HashMap<String, String>();
            mimeTypeMap = Collections.unmodifiableMap(map);
            InputStreamReader isr = null;
            BufferedReader lnr = null;
            try {
                isr = new InputStreamReader(ServerUtils.class.getResourceAsStream("/org/xsocket/connection/http/server/mime.types"));
                if (isr != null) {
                    lnr = new LineNumberReader(isr);
                    String line = null;
                    do {
                        if ((line = ((LineNumberReader)lnr).readLine()) == null || (line = line.trim()).startsWith("#")) continue;
                        StringTokenizer st = new StringTokenizer(line);
                        if (st.hasMoreTokens()) {
                            String mimeType = st.nextToken();
                            while (st.hasMoreTokens()) {
                                String extension = st.nextToken();
                                map.put(extension, mimeType);
                                if (!LOG.isLoggable(Level.FINER)) continue;
                                LOG.finer("mapping " + extension + " -> " + mimeType + " added");
                            }
                        } else {
                            if (!LOG.isLoggable(Level.FINE)) continue;
                            LOG.fine("line " + line + "ignored");
                        }
                    } while (line != null);
                    lnr.close();
                }
            }
            catch (IOException ioe) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Error occured by reding version file " + ioe.toString());
                }
            }
            finally {
                block21: {
                    try {
                        if (lnr != null) {
                            lnr.close();
                        }
                        if (isr != null) {
                            isr.close();
                        }
                    }
                    catch (IOException ioe) {
                        if (!LOG.isLoggable(Level.FINE)) break block21;
                        LOG.fine("exception occured by closing version.txt file stream " + ioe.toString());
                    }
                }
            }
        }
        return mimeTypeMap;
    }

    static void injectServerField(Object handler, IServer server) {
        Field[] fields;
        for (Field field : fields = handler.getClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(Resource.class)) continue;
            Resource res = field.getAnnotation(Resource.class);
            if (field.getType() != IServer.class && res.type() != IServer.class) continue;
            field.setAccessible(true);
            try {
                field.set(handler, server);
            }
            catch (IllegalAccessException iae) {
                LOG.warning("could not set HandlerContext for attribute " + field.getName() + ". Reason " + DataConverter.toString((Throwable)iae));
            }
        }
    }

    static void injectProtocolAdapter(Object handler, HttpProtocolAdapter adapter) {
        Field[] fields;
        for (Field field : fields = handler.getClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(Resource.class)) continue;
            Resource res = field.getAnnotation(Resource.class);
            if (field.getType() != HttpProtocolAdapter.class && res.type() != HttpProtocolAdapter.class) continue;
            field.setAccessible(true);
            try {
                field.set(handler, adapter);
            }
            catch (IllegalAccessException iae) {
                LOG.warning("could not set HandlerContext for attribute " + field.getName() + ". Reason " + DataConverter.toString((Throwable)iae));
            }
        }
    }
}

