/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb.client;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xlightweb.IBodyCompleteListener;
import org.xlightweb.IBodyDestroyListener;
import org.xlightweb.IHttpRequestHeader;
import org.xlightweb.IHttpResponse;
import org.xlightweb.IHttpResponseHeader;
import org.xlightweb.NonBlockingBodyDataSource;
import org.xlightweb.client.HttpClientConnection;
import org.xsocket.DataConverter;

final class TransactionMonitor {
    private static final Logger LOG = Logger.getLogger(TransactionMonitor.class.getName());
    private final Map<IHttpRequestHeader, Transaction> pendingTransactions = new HashMap<IHttpRequestHeader, Transaction>();
    private final AtomicInteger pending = new AtomicInteger(0);
    private final TransactionLog transactionLog;

    public TransactionMonitor(TransactionLog transactionLog) {
        this.transactionLog = transactionLog;
    }

    public void register(IHttpRequestHeader requestHeader) {
        Transaction transaction = new Transaction(this);
        transaction.register(requestHeader);
        this.pendingTransactions.put(requestHeader, transaction);
        this.transactionLog.add(transaction);
    }

    public void register(HttpClientConnection con, IHttpRequestHeader requestHeader, IHttpResponse response) {
        Transaction transaction = this.pendingTransactions.remove(requestHeader);
        if (transaction != null) {
            transaction.register(con, response);
        }
    }

    void incPending() {
        this.pending.incrementAndGet();
    }

    void decPending() {
        this.pending.decrementAndGet();
    }

    int getPendingTransactions() {
        return this.pending.get();
    }

    static final class Transaction {
        private final TransactionMonitor monitor;
        private String requestHeaderInfo = "";
        private String requestBodyInfo = "";
        private String responseHeaderInfo = "";
        private String responseBodyInfo = "";
        private String conInfo = "";
        private boolean isHeaderReceived = false;
        private boolean isBodyReceived = false;
        private Long requestHeaderSend = null;
        private Long responseBodyReceived = null;
        private boolean isErrorOccuredByReceivingBody = false;
        private String reveivedBodySize = "0 byte";
        private NonBlockingBodyDataSource responseBody = null;
        private HttpClientConnection con = null;
        private SimpleDateFormat df = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");

        public Transaction(TransactionMonitor monitor) {
            this.monitor = monitor;
        }

        public void register(IHttpRequestHeader requestHeader) {
            this.monitor.incPending();
            this.requestHeaderSend = System.currentTimeMillis();
            this.requestHeaderInfo = requestHeader.getQueryString() != null ? "[" + this.df.format(new Date()) + "] " + requestHeader.getServerName() + ":" + requestHeader.getServerPort() + " " + requestHeader.getMethod() + " " + requestHeader.getRequestURI() + requestHeader.getQueryString() : "[" + this.df.format(new Date()) + "] " + requestHeader.getServerName() + ":" + requestHeader.getServerPort() + " " + requestHeader.getMethod() + " " + requestHeader.getRequestURI();
        }

        public void register(HttpClientConnection con, IHttpResponse response) {
            this.con = con;
            this.isHeaderReceived = true;
            IHttpResponseHeader responseHeader = response.getResponseHeader();
            this.responseHeaderInfo = responseHeader.getStatus() + " " + responseHeader.getReason();
            if (responseHeader.containsHeader("connection")) {
                this.responseHeaderInfo = this.responseHeaderInfo + " (connection: " + responseHeader.getHeader("connection") + ")";
            }
            if (response.hasBody()) {
                try {
                    this.responseBody = response.getNonBlockingBody();
                    this.responseBodyInfo = "(" + response.getNonBlockingBody().getClass().getSimpleName() + ")";
                    BodyListener bodyListener = new BodyListener();
                    NonBlockingBodyDataSource ds = response.getNonBlockingBody();
                    ds.addCompleteListener(bodyListener);
                    ds.addDestroyListener(bodyListener);
                }
                catch (IOException ioe) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("error occured by registering complete listener " + ioe.toString());
                    }
                }
            } else {
                this.responseBodyInfo = "(NO BODY)";
                this.registerCompleteResponseReceived();
            }
            this.conInfo = "id=" + con.getId();
        }

        private void registerCompleteResponseReceived() {
            this.monitor.decPending();
            this.responseBody = null;
            this.con = null;
            this.isBodyReceived = true;
            this.responseBodyReceived = System.currentTimeMillis();
        }

        private String getConInfo() {
            HttpClientConnection c = this.con;
            if (c == null) {
                return this.conInfo;
            }
            return this.conInfo + " isOpen=" + this.con.isOpen();
        }

        public String toString() {
            String elapsed = "";
            elapsed = this.responseBodyReceived != null ? "elapsed=" + DataConverter.toFormatedDuration((long)(this.responseBodyReceived - this.requestHeaderSend)) : "elapsed=" + DataConverter.toFormatedDuration((long)(System.currentTimeMillis() - this.requestHeaderSend));
            if (this.isBodyReceived) {
                if (this.isErrorOccuredByReceivingBody) {
                    return this.requestHeaderInfo + " " + this.requestBodyInfo + "-> " + this.responseHeaderInfo + " " + this.responseBodyInfo + " error occured by receiving body [" + elapsed + " " + " body=" + this.reveivedBodySize + " " + this.getConInfo() + "]";
                }
                return this.requestHeaderInfo + " " + this.requestBodyInfo + "-> " + this.responseHeaderInfo + " " + this.responseBodyInfo + " [" + elapsed + " " + " body=" + this.reveivedBodySize + " " + this.getConInfo() + "]";
            }
            if (this.isHeaderReceived) {
                NonBlockingBodyDataSource rb = this.responseBody;
                if (rb == null) {
                    return this.requestHeaderInfo + " " + this.requestBodyInfo + "-> " + this.responseHeaderInfo + " " + this.responseBodyInfo + " [READING BODY " + elapsed + " " + this.getConInfo() + "]";
                }
                return this.requestHeaderInfo + " " + this.requestBodyInfo + "-> " + this.responseHeaderInfo + " " + this.responseBodyInfo + " [READING BODY " + elapsed + " " + " body=" + DataConverter.toFormatedBytesSize((long)HttpClientConnection.getDataReceived(rb)) + " " + this.getConInfo() + "]";
            }
            return this.requestHeaderInfo + " " + this.requestBodyInfo + "-> " + this.responseHeaderInfo + " " + this.responseBodyInfo + " [WAITING FOR HEADER " + elapsed + " " + this.getConInfo() + "]";
        }

        private final class BodyListener
        implements IBodyCompleteListener,
        IBodyDestroyListener {
            private BodyListener() {
            }

            public void onComplete() throws IOException {
                Transaction.this.reveivedBodySize = DataConverter.toFormatedBytesSize((long)HttpClientConnection.getDataReceived(Transaction.this.responseBody));
                Transaction.this.registerCompleteResponseReceived();
            }

            public void onDestroyed() throws IOException {
                Transaction.this.isErrorOccuredByReceivingBody = true;
                Transaction.this.registerCompleteResponseReceived();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class TransactionLog {
        private LinkedList<Transaction> transactions = new LinkedList();
        private int maxSize = 0;

        TransactionLog(int maxSize) {
            this.maxSize = maxSize;
        }

        void setMaxSize(int maxSize) {
            this.maxSize = maxSize;
            this.removeOddEntries();
        }

        int getMaxSize() {
            return this.maxSize;
        }

        void add(Transaction transaction) {
            this.transactions.add(transaction);
            this.removeOddEntries();
        }

        private void removeOddEntries() {
            while (this.transactions.size() > this.maxSize) {
                try {
                    this.transactions.removeFirst();
                }
                catch (Exception e) {
                    if (!LOG.isLoggable(Level.FINE)) continue;
                    LOG.fine("error occured by removing list entry " + e.toString());
                }
            }
        }

        public List<Transaction> getTransactions() {
            return (List)this.transactions.clone();
        }
    }
}

