/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb;

import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xlightweb.HttpUtils;
import org.xlightweb.IWriteCompleteHandler;
import org.xlightweb.WebSocketConnection;
import org.xsocket.connection.ConnectionUtils;
import org.xsocket.connection.IWriteCompletionHandler;

final class WebSocketMessageCompleteHandlerAdapter
implements IWriteCompletionHandler {
    private static final Logger LOG = Logger.getLogger(WebSocketMessageCompleteHandlerAdapter.class.getName());
    private static final Map<Class, MessageCompleteHandlerInfo> completeHandlerInfoCache = ConnectionUtils.newMapCache((int)25);
    private static final MessageCompleteHandlerInfo EMPTY_COMPLETEHANDLER_INFO = new MessageCompleteHandlerInfo(null);
    private final WebSocketConnection con;
    private final IWriteCompleteHandler handler;
    private final MessageCompleteHandlerInfo handlerInfo;

    public WebSocketMessageCompleteHandlerAdapter(WebSocketConnection con, IWriteCompleteHandler handler) {
        this.con = con;
        this.handler = handler;
        this.handlerInfo = WebSocketMessageCompleteHandlerAdapter.getMessageCompleteHandlerInfo(handler);
    }

    public void onWritten(final int written) throws IOException {
        if (this.handler != null) {
            Runnable task = new Runnable(){

                public void run() {
                    try {
                        WebSocketMessageCompleteHandlerAdapter.this.handler.onWritten(written);
                    }
                    catch (IOException ioe) {
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.fine("[" + WebSocketMessageCompleteHandlerAdapter.this.con.getId() + "] error occured by calling write complete handler " + ioe.toString());
                        }
                        WebSocketMessageCompleteHandlerAdapter.this.con.destroy();
                    }
                }
            };
            if (this.handlerInfo.isOnWrittenMultithreaded()) {
                this.con.processMultithreaded(task);
            } else {
                this.con.processNonthreaded(task);
            }
            this.con.processNonthreaded(task);
        }
    }

    public void onException(final IOException ioe) {
        if (this.handler != null) {
            Runnable task = new Runnable(){

                public void run() {
                    WebSocketMessageCompleteHandlerAdapter.this.handler.onException(ioe);
                }
            };
            if (this.handlerInfo.isOnErrorMultithreaded()) {
                this.con.processMultithreaded(task);
            } else {
                this.con.processNonthreaded(task);
            }
            this.con.processNonthreaded(task);
        }
    }

    private static MessageCompleteHandlerInfo getMessageCompleteHandlerInfo(IWriteCompleteHandler handler) {
        if (handler == null) {
            return EMPTY_COMPLETEHANDLER_INFO;
        }
        MessageCompleteHandlerInfo info = completeHandlerInfoCache.get(handler.getClass());
        if (info == null) {
            info = new MessageCompleteHandlerInfo(handler.getClass());
            completeHandlerInfoCache.put(handler.getClass(), info);
        }
        return info;
    }

    static final class MessageCompleteHandlerInfo {
        private final boolean isOnWrittenMultithreaded;
        private final boolean isOnErrorMultithreaded;

        MessageCompleteHandlerInfo(Class clazz) {
            if (clazz != null) {
                boolean isMultiThreaded = HttpUtils.isHandlerMultithreaded(clazz, true);
                this.isOnWrittenMultithreaded = HttpUtils.isMethodMultithreaded(clazz, "onWritten", isMultiThreaded, Integer.TYPE);
                this.isOnErrorMultithreaded = HttpUtils.isMethodMultithreaded(clazz, "onException", isMultiThreaded, IOException.class);
            } else {
                this.isOnWrittenMultithreaded = false;
                this.isOnErrorMultithreaded = false;
            }
        }

        public boolean isOnWrittenMultithreaded() {
            return this.isOnWrittenMultithreaded;
        }

        public boolean isOnErrorMultithreaded() {
            return this.isOnErrorMultithreaded;
        }
    }
}

