/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.xlightweb.BinaryMessage;
import org.xlightweb.CloseMessage;
import org.xlightweb.IWebMessage;
import org.xlightweb.IWriteCompleteHandler;
import org.xlightweb.TextMessage;
import org.xlightweb.WebSocketConnection;
import org.xsocket.DataConverter;

abstract class WebSocketMessage
implements IWebMessage {
    private final Data data;

    WebSocketMessage(ByteBuffer byteBufferData, String encoding) {
        this.data = new Data(byteBufferData, encoding);
    }

    final Data getData() {
        return this.data;
    }

    boolean isBinaryMessage() {
        return false;
    }

    boolean isTextMessage() {
        return false;
    }

    boolean isCloseMessage() {
        return false;
    }

    abstract int writeTo(WebSocketConnection var1, IWriteCompleteHandler var2) throws IOException;

    static WebSocketMessage parse(ByteBuffer buffer) throws IOException {
        int savePos = buffer.position();
        int saveLimit = buffer.limit();
        WebSocketMessage msg = null;
        byte b = buffer.get();
        if (TextMessage.isTextMessage(b)) {
            msg = TextMessage.parse(buffer);
        } else if (BinaryMessage.isBinaryMessage(b)) {
            msg = BinaryMessage.parse(buffer);
        } else if (CloseMessage.isCloseMessage(b)) {
            msg = CloseMessage.parse(buffer);
        } else {
            buffer.position(savePos);
            buffer.limit(saveLimit);
            throw new IOException("got invalid frame " + DataConverter.toTextAndHexString((ByteBuffer[])new ByteBuffer[]{buffer}, (String)"UTF-8", (int)4000));
        }
        if (msg == null) {
            buffer.position(savePos);
            buffer.limit(saveLimit);
            return null;
        }
        return msg;
    }

    public byte[] toBytes() {
        return this.data.toBytes();
    }

    public String toString() {
        return this.data.toString();
    }

    public String toString(String charset) {
        return this.getData().toString(charset);
    }

    static final class Data {
        private final String encoding;
        private ByteBuffer byteBufferData;
        private byte[] byteData;

        public Data(ByteBuffer byteBufferData, String encoding) {
            this.byteBufferData = byteBufferData;
            this.encoding = encoding;
        }

        public Data(byte[] byteData, String encoding) {
            this.byteData = byteData;
            this.encoding = encoding;
        }

        public byte[] toBytes() {
            if (this.byteData == null) {
                return DataConverter.toBytes((ByteBuffer)this.byteBufferData);
            }
            return this.byteData;
        }

        ByteBuffer getByteBuffer() {
            if (this.byteBufferData == null) {
                this.byteBufferData = DataConverter.toByteBuffer((byte[])this.byteData);
            }
            return this.byteBufferData;
        }

        public String toString() {
            if (this.encoding == null) {
                return DataConverter.toHexString((ByteBuffer[])new ByteBuffer[]{this.getByteBuffer().duplicate()}, (int)Integer.MAX_VALUE);
            }
            return this.toString(this.encoding);
        }

        public String toString(String charset) {
            try {
                return DataConverter.toString((ByteBuffer)this.getByteBuffer().duplicate(), (String)charset);
            }
            catch (Exception e) {
                return "error occured by creating string representation: " + e.toString();
            }
        }
    }
}

