/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.nio.ByteBuffer;
import org.xlightweb.HttpRequest;
import org.xlightweb.HttpRequestHeader;
import org.xlightweb.HttpUtils;
import org.xlightweb.IHttpRequestHeader;
import org.xlightweb.MultivalueMap;
import org.xlightweb.NameValuePair;

public class PostRequest
extends HttpRequest {
    public PostRequest(String url) throws MalformedURLException {
        super(new HttpRequestHeader("POST", url));
    }

    public PostRequest(String url, String contentType) throws IOException, MalformedURLException {
        super("POST", url);
        this.setContentType(contentType);
    }

    public PostRequest(String url, String contentType, String body) throws IOException, MalformedURLException {
        this(url, contentType, body, false);
    }

    public PostRequest(String url, String contentType, String body, boolean compress) throws IOException, MalformedURLException {
        super("POST", url, HttpUtils.addEncodingIfNotPresent(contentType), body, compress);
    }

    public PostRequest(String url, File file) throws IOException, MalformedURLException {
        super((IHttpRequestHeader)new HttpRequestHeader("POST", url, HttpUtils.resolveContentTypeByFileExtension(file)), file);
    }

    public PostRequest(String url, File file, boolean compress) throws IOException, MalformedURLException {
        super((IHttpRequestHeader)new HttpRequestHeader("POST", url, HttpUtils.resolveContentTypeByFileExtension(file)), HttpUtils.readFile(file), compress);
    }

    public PostRequest(String url, String contentType, String encoding, String body) throws IOException, MalformedURLException {
        this(url, contentType, encoding, body, false);
    }

    public PostRequest(String url, String contentType, String encoding, String body, boolean compress) throws IOException, MalformedURLException {
        super("POST", url, contentType, encoding, body, compress);
    }

    public PostRequest(String url, String contentType, byte[] body) throws IOException, MalformedURLException {
        this(url, contentType, body, false);
    }

    public PostRequest(String url, String contentType, byte[] body, boolean compress) throws IOException, MalformedURLException {
        super("POST", url, contentType, body, compress);
    }

    public PostRequest(String url, String contentType, ByteBuffer[] body) throws IOException, MalformedURLException {
        this(url, contentType, body, false);
    }

    public PostRequest(String url, String contentType, ByteBuffer[] body, boolean compress) throws IOException, MalformedURLException {
        super("POST", url, contentType, body, compress);
    }

    public PostRequest(String url, NameValuePair ... formParameters) throws IOException, MalformedURLException {
        super("POST", url, "application/x-www-form-urlencoded; charset=utf-8", new MultivalueMap("utf-8", formParameters).toString());
    }

    public PostRequest(String url, String[] formParameters) throws IOException, MalformedURLException {
        super("POST", url, "application/x-www-form-urlencoded; charset=utf-8", new MultivalueMap("utf-8", formParameters).toString());
    }
}

