/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xlightweb.AbstractHttpConnection;
import org.xlightweb.AbstractListeners;
import org.xlightweb.BadMessageException;
import org.xlightweb.BodyDataSink;
import org.xlightweb.BodyForwarder;
import org.xlightweb.FileDataSink;
import org.xlightweb.HttpUtils;
import org.xlightweb.IBodyAccessListener;
import org.xlightweb.IBodyCloseListener;
import org.xlightweb.IBodyCompleteListener;
import org.xlightweb.IBodyDataHandler;
import org.xlightweb.IBodyDestroyListener;
import org.xlightweb.IHeader;
import org.xlightweb.IPart;
import org.xlightweb.IPartHandler;
import org.xlightweb.NoMultipartTypeException;
import org.xlightweb.PartHandlerInfo;
import org.xlightweb.PartParser;
import org.xlightweb.ProtocolException;
import org.xlightweb.ReceiveTimeoutException;
import org.xsocket.DataConverter;
import org.xsocket.Execution;
import org.xsocket.IDataSource;
import org.xsocket.MaxReadSizeExceededException;
import org.xsocket.connection.AbstractNonBlockingStream;
import org.xsocket.connection.IConnection;
import org.xsocket.connection.IWriteCompletionHandler;

public abstract class NonBlockingBodyDataSource
implements IDataSource,
ReadableByteChannel,
Closeable {
    private static final Logger LOG = Logger.getLogger(NonBlockingBodyDataSource.class.getName());
    private final AtomicBoolean isDestroyed = new AtomicBoolean(false);
    private final AtomicBoolean isComplete = new AtomicBoolean(false);
    private final AtomicReference<IOException> exceptionRef = new AtomicReference();
    private final NonBlockingStream nonBlockingStream = new NonBlockingStream();
    private final AtomicReference<BodyDataHandlerAdapter> bodyDataHandlerAdapterRef = new AtomicReference<BodyDataHandlerAdapter>(new BodyDataHandlerAdapter(null));
    private final CompleteListeners completeListeners = new CompleteListeners();
    private final AbstractListeners.CloseListeners closeListeners = new AbstractListeners.CloseListeners();
    private final AbstractListeners.DestroyListeners destroyListeners = new AbstractListeners.DestroyListeners();
    private final AbstractHttpConnection.IMultimodeExecutor executor;
    private static final long MIN_WATCHDOG_PERIOD_MILLIS = 10000L;
    private long bodyDataReceiveTimeoutMillis = Long.MAX_VALUE;
    private long creationTimeMillis = 0L;
    private long lastTimeDataReceivedMillis = System.currentTimeMillis();
    private TimeoutWatchDogTask watchDogTask;
    private final IHeader header;
    private boolean isIgnoreAppendError = false;
    private boolean isDataRead = false;
    private final AtomicBoolean isDataAppended = new AtomicBoolean(false);
    private IBodyAccessListener bodyAccessListener = null;
    private Boolean isMultipart = null;
    private int dataReceived = 0;

    NonBlockingBodyDataSource(IHeader header, AbstractHttpConnection.IMultimodeExecutor executor) {
        this.nonBlockingStream.setEncoding(header.getCharacterEncoding());
        this.executor = executor;
        this.header = header;
    }

    NonBlockingBodyDataSource(IHeader header, AbstractHttpConnection.IMultimodeExecutor executor, ByteBuffer[] data) throws IOException {
        this.nonBlockingStream.setEncoding(header.getCharacterEncoding());
        this.executor = executor;
        this.header = header;
        if (data != null) {
            this.append(data);
        }
        this.isComplete.set(true);
    }

    final IHeader getHeader() {
        return this.header;
    }

    abstract String getId();

    boolean isForwardable() {
        return false;
    }

    boolean isSimpleMessageBody() {
        return false;
    }

    final void setBodyAccessListener(IBodyAccessListener bodyAccessListener) {
        this.bodyAccessListener = bodyAccessListener;
    }

    private void callBodyAccessListener() {
        boolean remove;
        if (this.bodyAccessListener != null && (remove = this.bodyAccessListener.onBodyAccess())) {
            this.bodyAccessListener = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void addCloseListener(IBodyCloseListener listener) {
        AbstractListeners.CloseListeners closeListeners = this.closeListeners;
        synchronized (closeListeners) {
            this.closeListeners.addListener(listener, !this.isOpen(), this.getExecutor(), HttpUtils.getListenerExecutionMode(listener, "onClose"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean removeCloseListener(IBodyCloseListener closeListener) {
        AbstractListeners.CloseListeners closeListeners = this.closeListeners;
        synchronized (closeListeners) {
            return this.closeListeners.removeListener(closeListener);
        }
    }

    public final void addDestroyListener(IBodyDestroyListener destroyListener) {
        this.callBodyAccessListener();
        this.addDestroyListenerSilence(destroyListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void addDestroyListenerSilence(IBodyDestroyListener listener) {
        AbstractListeners.DestroyListeners destroyListeners = this.destroyListeners;
        synchronized (destroyListeners) {
            this.destroyListeners.addListener(listener, this.isDestroyed(), this.getExecutor(), HttpUtils.getListenerExecutionMode(listener, "onDestroyed"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean removeDestroyListener(IBodyDestroyListener destroyListener) {
        AbstractListeners.DestroyListeners destroyListeners = this.destroyListeners;
        synchronized (destroyListeners) {
            return this.destroyListeners.removeListener(destroyListener);
        }
    }

    int append(ByteBuffer data) throws IOException {
        this.isDataAppended.set(true);
        int added = this.nonBlockingStream.append(data);
        this.dataReceived += added;
        return added;
    }

    int append(ByteBuffer[] data) throws IOException {
        this.isDataAppended.set(true);
        int added = this.nonBlockingStream.append(data);
        this.dataReceived += added;
        return added;
    }

    int append(ByteBuffer[] data, IWriteCompletionHandler completionHandler) throws IOException {
        this.isDataAppended.set(true);
        int added = 0;
        added = completionHandler != null ? this.nonBlockingStream.append(data, completionHandler, false) : this.nonBlockingStream.append(data);
        this.dataReceived += added;
        return added;
    }

    final boolean isMoreInputDataExpected() {
        if (this.isComplete.get()) {
            return false;
        }
        return !this.isDestroyed.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setComplete() throws IOException {
        CompleteListeners completeListeners = this.completeListeners;
        synchronized (completeListeners) {
            this.isComplete.set(true);
            this.nonBlockingStream.setComplete();
        }
        this.completeListeners.callAndRemoveListeners(this.getExecutor());
        this.terminateWatchDog();
    }

    final boolean isCompleteReceived() throws IOException {
        if (this.isComplete.get()) {
            return true;
        }
        this.throwExceptionIfExist();
        return false;
    }

    public final boolean isMultipart() {
        this.callBodyAccessListener();
        if (this.isMultipart == null) {
            this.isMultipart = this.getHeader().getContentType() != null && this.getHeader().getContentType().startsWith("multipart/");
        }
        return this.isMultipart;
    }

    final boolean isComplete() {
        return this.isComplete.get();
    }

    final int getSizeDataReceived() {
        return this.dataReceived;
    }

    final boolean isDestroyed() {
        return this.isDestroyed.get();
    }

    final void setEncoding(String encoding) {
        this.nonBlockingStream.setEncoding(encoding);
    }

    final void setException(IOException ioe) {
        IOException oldException = this.exceptionRef.get();
        if (oldException != null) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + this.getId() + "] warning a exception alreday exits. ignore exception (old: " + oldException + ", new: " + ioe);
            }
            return;
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("[" + this.getId() + "] set exception " + ioe);
        }
        this.exceptionRef.set(ioe);
        this.callBodyDataHandler(true);
        this.destroy(ioe.toString());
    }

    public void destroy() {
        this.destroy("user initiated");
    }

    void destroy(String reason) {
        this.destroy(reason, false);
    }

    void destroy(String reason, boolean isIgnoreAppendError) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("[" + this.getId() + "] initiate destroying sink " + reason);
        }
        this.isIgnoreAppendError = isIgnoreAppendError;
        this.terminateWatchDog();
        this.getExecutor().processNonthreaded(new DestroyTask(reason));
    }

    final boolean isIgnoreAppendError() {
        return this.isIgnoreAppendError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performDestroy(String reason) {
        if (!this.isDestroyed.getAndSet(true)) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + this.getId() + "] destroying data source");
            }
            AbstractListeners.DestroyListeners destroyListeners = this.destroyListeners;
            synchronized (destroyListeners) {
                this.onDestroy(reason);
            }
            this.destroyListeners.callAndRemoveListeners(this.getExecutor());
            this.nonBlockingStream.destroy();
        }
    }

    abstract void onDestroy(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCompleteListener(IBodyCompleteListener listener) {
        this.callBodyAccessListener();
        CompleteListeners completeListeners = this.completeListeners;
        synchronized (completeListeners) {
            this.completeListeners.addListener(listener, this.isComplete.get(), this.getExecutor(), HttpUtils.getListenerExecutionMode(listener, "onComplete"));
        }
    }

    public final void setDataHandler(IBodyDataHandler bodyDataHandler) {
        this.callBodyAccessListener();
        this.setDataHandlerSilence(bodyDataHandler);
    }

    void setDataHandlerSilence(IBodyDataHandler bodyDataHandler) {
        BodyDataHandlerAdapter bodyDataHandlerAdapter = this.bodyDataHandlerAdapterRef.get().newBodyDataHandlerAdapter(bodyDataHandler);
        this.setBodyHandler(bodyDataHandlerAdapter);
        this.callBodyDataHandler(this.isDataAppended.get());
    }

    public IPart readPart() throws NoMultipartTypeException, IOException, BufferUnderflowException {
        if (!this.isMultipart()) {
            throw new NoMultipartTypeException("body ist not a multipart type " + this.getHeader().getContentType());
        }
        this.initPartHandler(null);
        PartParser partParser = (PartParser)this.bodyDataHandlerAdapterRef.get().partParserRef.get();
        if (partParser != null) {
            return partParser.readPart();
        }
        throw new BufferUnderflowException();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private synchronized void initPartHandler(IPartHandler partHandler) throws IOException {
        if (this.bodyDataHandlerAdapterRef.get().getPartParser() == null) {
            String boundary;
            if (!this.isMultipart()) throw new NoMultipartTypeException("body is not multipart type " + this.getHeader().getContentType());
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("part handler set. parsing body");
            }
            if ((boundary = HttpUtils.parseMediaTypeParameter(this.getHeader().getContentType(), "boundary", true, null)) == null) {
                throw new IOException("no boundary set " + this.getHeader().getContentType());
            }
            this.bodyDataHandlerAdapterRef.get().setPartParser(new PartParser(partHandler, this, "--" + boundary, null));
            return;
        } else {
            if (partHandler == null) return;
            this.bodyDataHandlerAdapterRef.get().getPartParser().setPartHandler(partHandler);
        }
    }

    public void setBodyPartHandler(IPartHandler partHandler) throws NoMultipartTypeException, IOException {
        this.callBodyAccessListener();
        this.initPartHandler(new PartHandlerAdapter(partHandler));
    }

    final void setBodyHandler(BodyDataHandlerAdapter handler) {
        this.bodyDataHandlerAdapterRef.set(handler);
    }

    final void callBodyDataHandler(boolean force) {
        IBodyDataHandler bodyDataHandler = this.bodyDataHandlerAdapterRef.get();
        if (bodyDataHandler != null) {
            if (this.getSize() != 0 || force || this.exceptionRef.get() != null) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + this.getId() + "] calling body data handler " + bodyDataHandler.toString() + "#" + bodyDataHandler.hashCode());
                }
                bodyDataHandler.onData(this);
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("body data handler " + bodyDataHandler.getClass().getName() + "#" + bodyDataHandler.hashCode() + " will not be called (size == 0)");
            }
        } else if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("no body data handler assigned");
        }
    }

    final int getSize() {
        int size = this.nonBlockingStream.getSize();
        if (size == 0 && this.isComplete.get()) {
            return -1;
        }
        return size;
    }

    int getDataReceived() {
        return this.dataReceived;
    }

    private int getVersion() throws IOException {
        return this.nonBlockingStream.getReadBufferVersion();
    }

    public IBodyDataHandler getDataHandler() {
        this.callBodyAccessListener();
        return this.getDataHandlerSilence();
    }

    IBodyDataHandler getDataHandlerSilence() {
        return this.bodyDataHandlerAdapterRef.get().getDelegate();
    }

    public final void setBodyDataReceiveTimeoutMillis(long bodyDataReceiveTimeoutMillis) {
        this.callBodyAccessListener();
        this.setBodyDataReceiveTimeoutMillisSilence(bodyDataReceiveTimeoutMillis);
    }

    final void setBodyDataReceiveTimeoutMillisSilence(long bodyDataReceiveTimeoutMillis) {
        if (bodyDataReceiveTimeoutMillis <= 0L) {
            if (!this.isComplete.get()) {
                this.setException(new ReceiveTimeoutException(bodyDataReceiveTimeoutMillis));
            }
            return;
        }
        this.creationTimeMillis = System.currentTimeMillis();
        if (this.bodyDataReceiveTimeoutMillis != bodyDataReceiveTimeoutMillis) {
            this.bodyDataReceiveTimeoutMillis = bodyDataReceiveTimeoutMillis;
            if (bodyDataReceiveTimeoutMillis == Long.MAX_VALUE) {
                this.terminateWatchDog();
            } else {
                long watchdogPeriod = 100L;
                if (bodyDataReceiveTimeoutMillis > 1000L) {
                    watchdogPeriod = bodyDataReceiveTimeoutMillis / 10L;
                }
                if (watchdogPeriod > 10000L) {
                    watchdogPeriod = 10000L;
                }
                this.updateWatchDog(watchdogPeriod);
            }
        }
    }

    private synchronized void updateWatchDog(long watchDogPeriod) {
        this.terminateWatchDog();
        this.watchDogTask = new TimeoutWatchDogTask(this);
        AbstractHttpConnection.schedule(this.watchDogTask, watchDogPeriod, watchDogPeriod);
    }

    private synchronized void terminateWatchDog() {
        if (this.watchDogTask != null) {
            this.watchDogTask.cancel();
            this.watchDogTask = null;
        }
    }

    private void checkTimeouts() {
        if (this.isComplete.get() || this.isDestroyed.get()) {
            this.terminateWatchDog();
            return;
        }
        long currentTimeMillis = System.currentTimeMillis();
        if (currentTimeMillis > this.lastTimeDataReceivedMillis + this.bodyDataReceiveTimeoutMillis && currentTimeMillis > this.creationTimeMillis + this.bodyDataReceiveTimeoutMillis) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + this.getId() + "] receive timeout reached. set exception");
            }
            if (!this.isComplete.get()) {
                this.setException(new ReceiveTimeoutException());
            }
            this.destroy("receive timeout reached");
        }
    }

    public final int available() throws ProtocolException, IOException {
        this.callBodyAccessListener();
        return this.availableSilence();
    }

    final int availableSilence() throws ProtocolException, IOException {
        IOException ioe = this.exceptionRef.get();
        if (ioe != null && !(ioe instanceof ClosedChannelException)) {
            throw ioe;
        }
        int available = this.nonBlockingStream.getSize();
        if (available == 0) {
            if (this.isComplete.get()) {
                if (this.bodyDataHandlerAdapterRef.get().getPartParser() != null && this.bodyDataHandlerAdapterRef.get().getPartParser().availableParts() > 0) {
                    return 0;
                }
                return -1;
            }
            if (this.isDestroyed.get()) {
                this.close();
                throw new ClosedChannelException();
            }
            return 0;
        }
        return available;
    }

    final IOException getException() {
        IOException ioe = this.exceptionRef.get();
        if (ioe != null && !(ioe instanceof ClosedChannelException)) {
            return ioe;
        }
        return null;
    }

    int size() {
        int available = this.nonBlockingStream.getSize();
        if (available <= 0 && this.isComplete.get()) {
            return -1;
        }
        return available;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close() throws IOException {
        if (this.isOpen()) {
            try {
                AbstractListeners.CloseListeners closeListeners = this.closeListeners;
                synchronized (closeListeners) {
                    this.nonBlockingStream.close();
                    this.onClose();
                }
                this.closeListeners.callAndRemoveListeners(this.getExecutor());
            }
            catch (IOException ioe) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + this.getId() + "] error occured by closing connection. destroying it " + ioe.toString());
                }
                this.setException(ioe);
            }
        }
    }

    abstract void onClose() throws IOException;

    public final void closeQuitly() {
        block2: {
            try {
                this.close();
            }
            catch (IOException ioe) {
                if (!LOG.isLoggable(Level.FINE)) break block2;
                LOG.fine("[" + this.getId() + "] Error occured by closing connection " + ioe.toString());
            }
        }
    }

    public final boolean isOpen() {
        this.callBodyAccessListener();
        return this.nonBlockingStream.isOpen();
    }

    final void throwExceptionIfExist() throws IOException {
        IOException ioe = this.exceptionRef.get();
        if (ioe != null) {
            throw ioe;
        }
    }

    public final int read(ByteBuffer buffer) throws IOException {
        this.throwExceptionIfExist();
        int size = buffer.remaining();
        int available = this.available();
        if (available == -1) {
            this.close();
            return -1;
        }
        if (available == 0) {
            return 0;
        }
        if (available > 0) {
            if (available < size) {
                size = available;
            }
            if (size > 0) {
                ByteBuffer[] bufs = this.readByteBufferByLength(size);
                this.copyBuffers(bufs, buffer);
            }
        }
        this.isDataRead = true;
        return size;
    }

    private void copyBuffers(ByteBuffer[] source, ByteBuffer target) {
        for (ByteBuffer buf : source) {
            if (!buf.hasRemaining()) continue;
            target.put(buf);
        }
    }

    void forwardTo(BodyDataSink bodyDataSink) throws IOException {
        this.forwardTo(bodyDataSink, null);
    }

    void forwardTo(BodyDataSink bodyDataSink, IBodyCompleteListener completeListener) throws IOException {
        BodyForwarder bodyForwarder = bodyDataSink.getFlushmode() == IConnection.FlushMode.ASYNC ? new NonThreadedBodyForwarder(this.getHeader(), this, bodyDataSink, completeListener) : new BodyForwarder(this.getHeader(), this, bodyDataSink, completeListener);
        this.setDataHandlerSilence(bodyForwarder);
        if (HttpUtils.isContainExpect100ContinueHeader(this.header)) {
            bodyDataSink.flush();
        }
    }

    public long transferTo(BodyDataSink dataSink) throws ProtocolException, IOException, ClosedChannelException {
        return this.transferTo(dataSink, this.available());
    }

    public long transferTo(BodyDataSink dataSink, int length) throws ProtocolException, IOException, ClosedChannelException {
        return this.transferTo((WritableByteChannel)dataSink, length);
    }

    public final long transferTo(WritableByteChannel target, int length) throws IOException, ClosedChannelException {
        this.callBodyAccessListener();
        this.throwExceptionIfExist();
        this.isDataRead = true;
        if (length > 0) {
            ByteBuffer[] buffers;
            long written = 0L;
            for (ByteBuffer buffer : buffers = this.readByteBufferByLength(length)) {
                while (buffer.hasRemaining()) {
                    written += (long)target.write(buffer);
                }
            }
            return written;
        }
        return 0L;
    }

    public final void transferTo(File file, ITransferResultHandler resultHandler) throws IOException, FileNotFoundException, ClosedChannelException {
        this.callBodyAccessListener();
        this.throwExceptionIfExist();
        this.isDataRead = true;
        if (!file.exists()) {
            throw new FileNotFoundException("file " + file.getAbsolutePath() + " does not exist");
        }
        FileDataSink dataSink = new FileDataSink(this.getHeader(), this.executor, file);
        TransferResultHandlerAdapter adapter = new TransferResultHandlerAdapter(resultHandler);
        ((BodyDataSink)dataSink).addCloseListener(adapter);
        ((BodyDataSink)dataSink).addDestroyListener(adapter);
        ((BodyDataSink)dataSink).setFlushmode(IConnection.FlushMode.ASYNC);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("forwarding body to file " + file.getAbsolutePath());
        }
        this.forwardTo(dataSink);
    }

    abstract boolean suspend() throws IOException;

    abstract boolean resume() throws IOException;

    public final ByteBuffer[] readByteBufferByDelimiter(String delimiter, int maxLength) throws IOException, MaxReadSizeExceededException {
        this.callBodyAccessListener();
        this.throwExceptionIfExist();
        this.isDataRead = true;
        ByteBuffer[] buffers = this.nonBlockingStream.readByteBufferByDelimiter(delimiter, maxLength);
        this.onRead();
        return buffers;
    }

    public final ByteBuffer[] readByteBufferByLength(int length) throws IOException, BufferUnderflowException {
        this.callBodyAccessListener();
        return this.readByteBufferByLengthSilence(length);
    }

    final ByteBuffer[] readByteBufferByLengthSilence(int length) throws IOException, BufferUnderflowException {
        this.throwExceptionIfExist();
        this.isDataRead = true;
        ByteBuffer[] buffers = this.nonBlockingStream.readByteBufferByLength(length);
        this.onRead();
        return buffers;
    }

    protected void onRead() throws IOException {
    }

    String getEncoding() {
        return this.nonBlockingStream.getEncoding();
    }

    protected abstract boolean isNetworkendpoint();

    private ByteBuffer readSingleByteBufferByLength(int length) throws IOException {
        return DataConverter.toByteBuffer((ByteBuffer[])this.readByteBufferByLength(length));
    }

    public final ByteBuffer[] readByteBufferByDelimiter(String delimiter) throws IOException {
        return this.readByteBufferByDelimiter(delimiter, Integer.MAX_VALUE);
    }

    public final byte[] readBytesByDelimiter(String delimiter) throws IOException {
        return DataConverter.toBytes((ByteBuffer[])this.readByteBufferByDelimiter(delimiter));
    }

    public final byte[] readBytesByDelimiter(String delimiter, int maxLength) throws IOException, MaxReadSizeExceededException {
        return DataConverter.toBytes((ByteBuffer[])this.readByteBufferByDelimiter(delimiter, maxLength));
    }

    public final byte[] readBytesByLength(int length) throws IOException {
        return DataConverter.toBytes((ByteBuffer[])this.readByteBufferByLength(length));
    }

    public final String readStringByDelimiter(String delimiter) throws IOException, UnsupportedEncodingException {
        return this.readStringByDelimiter(delimiter, this.getEncoding());
    }

    public final String readStringByDelimiter(String delimiter, String encoding) throws IOException, UnsupportedEncodingException {
        this.removeLeadingBOM();
        return DataConverter.toString((ByteBuffer[])this.readByteBufferByDelimiter(delimiter), (String)encoding);
    }

    public final String readStringByDelimiter(String delimiter, int maxLength) throws IOException, UnsupportedEncodingException, MaxReadSizeExceededException {
        return this.readStringByDelimiter(delimiter, this.getEncoding(), maxLength);
    }

    public final String readStringByDelimiter(String delimiter, String encoding, int maxLength) throws IOException, UnsupportedEncodingException, MaxReadSizeExceededException {
        this.removeLeadingBOM();
        return DataConverter.toString((ByteBuffer[])this.readByteBufferByDelimiter(delimiter, maxLength), (String)encoding);
    }

    public final String readStringByLength(int length) throws IOException, BufferUnderflowException {
        return this.readStringByLength(length, this.getEncoding());
    }

    public final String readStringByLength(int length, String encoding) throws IOException, BufferUnderflowException {
        this.removeLeadingBOM();
        return DataConverter.toString((ByteBuffer[])this.readByteBufferByLength(length), (String)encoding);
    }

    final void removeLeadingBOM() throws IOException {
        if (!this.isDataRead) {
            ByteBuffer copy = HttpUtils.duplicateAndMerge(this.copyContent());
            if (this.getEncoding().equalsIgnoreCase("UTF-8")) {
                if (HttpUtils.startsWithUTF8BOM(copy)) {
                    this.readByteBufferByLength(3);
                }
            } else if (this.getEncoding().equalsIgnoreCase("UTF-16BE")) {
                if (HttpUtils.startsWithUTF16BEBOM(copy)) {
                    this.readByteBufferByLength(2);
                }
            } else if (this.getEncoding().equalsIgnoreCase("UTF-16LE")) {
                if (HttpUtils.startsWithUTF16LEBOM(copy)) {
                    this.readByteBufferByLength(2);
                }
            } else if (this.getEncoding().equalsIgnoreCase("UTF-32BE")) {
                if (HttpUtils.startsWithUTF32BEBOM(copy)) {
                    this.readByteBufferByLength(4);
                }
            } else if (this.getEncoding().equalsIgnoreCase("UTF-32LE") && HttpUtils.startsWithUTF32LEBOM(copy)) {
                this.readByteBufferByLength(4);
            }
        }
    }

    public final double readDouble() throws IOException {
        this.isDataRead = true;
        return this.readSingleByteBufferByLength(8).getDouble();
    }

    public final long readLong() throws IOException {
        this.isDataRead = true;
        return this.readSingleByteBufferByLength(8).getLong();
    }

    public final int readInt() throws IOException {
        this.isDataRead = true;
        return this.readSingleByteBufferByLength(4).getInt();
    }

    public final short readShort() throws IOException {
        this.isDataRead = true;
        return DataConverter.toByteBuffer((byte[])this.readBytesByLength(2)).getShort();
    }

    public final byte readByte() throws IOException {
        this.callBodyAccessListener();
        return DataConverter.toByteBuffer((byte[])this.readBytesByLength(1)).get();
    }

    public final void markReadPosition() {
        this.callBodyAccessListener();
        this.nonBlockingStream.markReadPosition();
    }

    public final boolean resetToReadMark() {
        this.callBodyAccessListener();
        return this.nonBlockingStream.resetToReadMark();
    }

    public final void removeReadMark() {
        this.callBodyAccessListener();
        this.nonBlockingStream.removeReadMark();
    }

    public final int indexOf(String str) throws IOException {
        this.callBodyAccessListener();
        this.throwExceptionIfExist();
        return this.nonBlockingStream.indexOf(str);
    }

    public final int indexOf(String str, String encoding) throws IOException, MaxReadSizeExceededException {
        this.callBodyAccessListener();
        this.throwExceptionIfExist();
        return this.nonBlockingStream.indexOf(str, encoding);
    }

    public int getReadBufferVersion() throws IOException {
        this.callBodyAccessListener();
        return this.getReadBufferVersionSilence();
    }

    final int getReadBufferVersionSilence() throws IOException {
        this.throwExceptionIfExist();
        return this.nonBlockingStream.getReadBufferVersion();
    }

    public long getBodyDataReceiveTimeoutMillis() {
        this.callBodyAccessListener();
        return this.getBodyDataReceiveTimeoutMillisSilence();
    }

    long getBodyDataReceiveTimeoutMillisSilence() {
        return this.bodyDataReceiveTimeoutMillis;
    }

    final ByteBuffer[] copyContent() {
        return this.nonBlockingStream.copyContent();
    }

    final AbstractHttpConnection.IMultimodeExecutor getExecutor() {
        return this.executor;
    }

    public String toString() {
        try {
            return this.nonBlockingStream.toString();
        }
        catch (Exception e) {
            return "[" + this.getId() + "] error occured by performing toString: " + DataConverter.toString((Throwable)e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class CompleteListeners
    extends AbstractListeners<IBodyCompleteListener> {
        private CompleteListeners() {
        }

        @Override
        void onCall(final IBodyCompleteListener listener) throws IOException {
            Integer executionMode = HttpUtils.getListenerExecutionMode(listener, "onComplete");
            if (executionMode == HttpUtils.EXECUTIONMODE_UNSYNCHRONIZED) {
                listener.onComplete();
            } else {
                Runnable task = new Runnable(){

                    public void run() {
                        try {
                            listener.onComplete();
                        }
                        catch (IOException ioe) {
                            if (LOG.isLoggable(Level.FINE)) {
                                LOG.fine("[" + NonBlockingBodyDataSource.this.getId() + "] Error occured by calling complete listener " + listener + " " + ioe.toString());
                            }
                            NonBlockingBodyDataSource.this.destroy(ioe.toString());
                        }
                    }
                };
                if (executionMode == 1) {
                    NonBlockingBodyDataSource.this.getExecutor().processMultithreaded(task);
                } else {
                    NonBlockingBodyDataSource.this.getExecutor().processNonthreaded(task);
                }
            }
        }
    }

    private static final class InvokeIOnMessagePartHandlerAdapter
    implements IPartHandler,
    IBodyCloseListener,
    IBodyCompleteListener {
        private final IPartHandler delegate;
        private NonBlockingBodyDataSource dataSource = null;

        public InvokeIOnMessagePartHandlerAdapter(IPartHandler delegate) {
            this.delegate = delegate;
        }

        public void onPart(NonBlockingBodyDataSource dataSource) throws IOException, BadMessageException {
            this.dataSource = dataSource;
            dataSource.addCloseListener(this);
            dataSource.addCompleteListener(this);
        }

        public void onComplete() throws IOException {
            this.delegate.onPart(this.dataSource);
        }

        public void onClose() throws IOException {
            this.delegate.onPart(this.dataSource);
        }
    }

    private final class PartHandlerAdapter
    implements IPartHandler {
        private final IPartHandler delegate;
        private final PartHandlerInfo partHandlerInfo;

        PartHandlerAdapter(IPartHandler partHandler) {
            assert (partHandler != null);
            this.partHandlerInfo = HttpUtils.getPartHandlerInfo(partHandler);
            this.delegate = this.partHandlerInfo.isHandlerInvokeOnMessageReceived() ? new InvokeIOnMessagePartHandlerAdapter(partHandler) : partHandler;
        }

        public void onPart(final NonBlockingBodyDataSource dataSource) throws IOException, BadMessageException {
            if (this.partHandlerInfo.isHandlerMultithreaded()) {
                Runnable task = new Runnable(){

                    public void run() {
                        PartHandlerAdapter.this.performOnPart(dataSource);
                    }
                };
                dataSource.getExecutor().processMultithreaded(task);
            } else {
                Runnable task = new Runnable(){

                    public void run() {
                        PartHandlerAdapter.this.performOnPart(dataSource);
                    }
                };
                dataSource.getExecutor().processNonthreaded(task);
            }
        }

        private void performOnPart(NonBlockingBodyDataSource dataSource) {
            try {
                this.delegate.onPart(dataSource);
            }
            catch (BufferUnderflowException bue) {
            }
            catch (IOException e) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + NonBlockingBodyDataSource.this.getId() + "] closing data source.  An io exception occured while performing onPart " + DataConverter.toString((Throwable)e));
                }
                NonBlockingBodyDataSource.this.closeQuitly();
            }
            catch (Throwable t) {
                LOG.warning("[" + NonBlockingBodyDataSource.this.getId() + "] closing data source. Error occured by performing onPart " + DataConverter.toString((Throwable)t));
                NonBlockingBodyDataSource.this.closeQuitly();
            }
        }
    }

    static final class WriteCompletionHolder
    implements Runnable {
        private final IWriteCompletionHandler handler;
        private final HttpUtils.CompletionHandlerInfo handlerInfo;
        private final AbstractHttpConnection.IMultimodeExecutor executor;
        private final int size;

        public WriteCompletionHolder(IWriteCompletionHandler handler, AbstractHttpConnection.IMultimodeExecutor executor, ByteBuffer[] bufs) {
            this.handler = handler;
            this.executor = executor;
            this.handlerInfo = HttpUtils.getCompletionHandlerInfo(handler);
            this.size = WriteCompletionHolder.computeSize(bufs);
        }

        private static int computeSize(ByteBuffer[] bufs) {
            if (bufs == null) {
                return 0;
            }
            int i = 0;
            for (ByteBuffer byteBuffer : bufs) {
                i += byteBuffer.remaining();
            }
            return i;
        }

        void performOnWritten(boolean isForceMultithreaded) {
            this.executor.processMultithreaded(this);
        }

        public void run() {
            this.callOnWritten();
        }

        private void callOnWritten() {
            try {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("data (size=" + this.size + " bytes) has been written. calling " + this.handler.getClass().getSimpleName() + "#" + this.handler.hashCode() + " onWritten method");
                }
                this.handler.onWritten(this.size);
            }
            catch (IOException ioe) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("error occured by calling onWritten " + ioe.toString() + " closing connection");
                }
                this.performOnException(ioe);
            }
        }

        void performOnException(final IOException ioe) {
            if (this.handlerInfo.isOnExceptionMutlithreaded()) {
                Runnable task = new Runnable(){

                    public void run() {
                        WriteCompletionHolder.this.callOnException(ioe);
                    }
                };
                this.executor.processMultithreaded(task);
            } else {
                Runnable task = new Runnable(){

                    public void run() {
                        WriteCompletionHolder.this.callOnException(ioe);
                    }
                };
                this.executor.processNonthreaded(task);
            }
        }

        private void callOnException(IOException ioe) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("calling " + this.handler.getClass().getSimpleName() + "#" + this.handler.hashCode() + " onException with " + ioe.toString());
            }
            this.handler.onException(ioe);
        }
    }

    private static final class TimeoutWatchDogTask
    extends TimerTask {
        private WeakReference<NonBlockingBodyDataSource> dataSourceRef = null;

        public TimeoutWatchDogTask(NonBlockingBodyDataSource dataSource) {
            this.dataSourceRef = new WeakReference<NonBlockingBodyDataSource>(dataSource);
        }

        public void run() {
            block4: {
                try {
                    NonBlockingBodyDataSource dataSource = (NonBlockingBodyDataSource)this.dataSourceRef.get();
                    if (dataSource == null) {
                        this.cancel();
                    } else {
                        dataSource.checkTimeouts();
                    }
                }
                catch (Exception e) {
                    if (!LOG.isLoggable(Level.FINE)) break block4;
                    LOG.fine("error occured by checking timeouts " + e.toString());
                }
            }
        }
    }

    private final class BodyDataHandlerAdapter
    implements IBodyDataHandler {
        private final IBodyDataHandler delegate;
        private final int executionMode;
        private final AtomicReference<PartParser> partParserRef = new AtomicReference();

        public BodyDataHandlerAdapter(PartParser partParser) {
            this.delegate = null;
            this.executionMode = -1;
            this.setPartParser(partParser);
        }

        BodyDataHandlerAdapter(PartParser partParser, IBodyDataHandler bodyDataHandler, int executionMode) {
            assert (bodyDataHandler != null);
            this.delegate = bodyDataHandler;
            this.executionMode = executionMode;
            this.setPartParser(partParser);
        }

        BodyDataHandlerAdapter newBodyDataHandlerAdapter(IBodyDataHandler bodyDataHandler) {
            BodyDataHandlerAdapter adapter;
            if (bodyDataHandler == null) {
                adapter = new BodyDataHandlerAdapter(this.getPartParser());
            } else {
                Integer executionMode = HttpUtils.getExecutionMode(bodyDataHandler);
                adapter = new BodyDataHandlerAdapter(this.getPartParser(), bodyDataHandler, executionMode);
            }
            return adapter;
        }

        void setPartParser(PartParser partParser) {
            this.partParserRef.set(partParser);
            if (partParser != null) {
                Runnable task = new Runnable(){

                    public void run() {
                        NonBlockingBodyDataSource.this.callBodyDataHandler(true);
                    }
                };
                NonBlockingBodyDataSource.this.getExecutor().processNonthreaded(task);
            }
        }

        PartParser getPartParser() {
            return this.partParserRef.get();
        }

        IBodyDataHandler getDelegate() {
            return this.delegate;
        }

        public synchronized boolean onData(final NonBlockingBodyDataSource bodyDataSource) throws BufferUnderflowException {
            Runnable task;
            final PartParser partParser = this.partParserRef.get();
            if (partParser != null) {
                task = new Runnable(){

                    public void run() {
                        partParser.onData(bodyDataSource);
                    }
                };
                bodyDataSource.getExecutor().processNonthreaded(task);
            }
            if (this.delegate != null) {
                if (this.executionMode == 1) {
                    task = new Runnable(){

                        public void run() {
                            BodyDataHandlerAdapter.this.performOnData(bodyDataSource);
                        }
                    };
                    bodyDataSource.getExecutor().processMultithreaded(task);
                } else if (this.executionMode == 0) {
                    task = new Runnable(){

                        public void run() {
                            BodyDataHandlerAdapter.this.performOnData(bodyDataSource);
                        }
                    };
                    bodyDataSource.getExecutor().processNonthreaded(task);
                } else {
                    this.performOnData(bodyDataSource);
                }
            }
            return true;
        }

        private boolean performOnData(NonBlockingBodyDataSource bodyDataSource) {
            try {
                int preVersion = NonBlockingBodyDataSource.this.getVersion();
                boolean success = this.delegate.onData(bodyDataSource);
                int postVersion = NonBlockingBodyDataSource.this.getVersion();
                if (success && preVersion != postVersion && NonBlockingBodyDataSource.this.getSize() != 0) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("[" + NonBlockingBodyDataSource.this.getId() + "] re-initiate calling body data handler (read queue size=" + NonBlockingBodyDataSource.this.getSize() + ")");
                    }
                    NonBlockingBodyDataSource.this.callBodyDataHandler(false);
                }
            }
            catch (BufferUnderflowException bue) {
            }
            catch (Exception e) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + bodyDataSource.getId() + "] error occured by calling onData of " + this.delegate.getClass().getName() + "#" + this.delegate.hashCode() + " " + e.toString() + " destroying body data source");
                }
                bodyDataSource.destroy(e.toString());
            }
            return true;
        }

        public String toString() {
            if (this.delegate == null) {
                return this.getClass().getName() + " -> null";
            }
            return this.getClass().getName() + " -> " + this.delegate;
        }
    }

    private final class NonBlockingStream
    extends AbstractNonBlockingStream {
        private NonBlockingStream() {
        }

        public void destroy() {
            this.drainReadQueue();
            NonBlockingBodyDataSource.this.callBodyDataHandler(true);
        }

        public void setComplete() {
            NonBlockingBodyDataSource.this.callBodyDataHandler(true);
        }

        protected boolean isDataWriteable() {
            return false;
        }

        int getSize() {
            return this.getReadQueueSize();
        }

        protected boolean isMoreInputDataExpected() {
            return NonBlockingBodyDataSource.this.isMoreInputDataExpected();
        }

        public boolean isOpen() {
            return super.available() != -1;
        }

        public int append(ByteBuffer buffer) {
            int size = 0;
            if (buffer != null) {
                size = buffer.remaining();
                this.appendDataToReadBuffer(new ByteBuffer[]{buffer}, size);
            }
            NonBlockingBodyDataSource.this.callBodyDataHandler(false);
            return size;
        }

        public int append(ByteBuffer[] buffer) {
            int size = 0;
            if (buffer != null) {
                for (ByteBuffer byteBuffer : buffer) {
                    size += byteBuffer.remaining();
                }
                this.appendDataToReadBuffer(buffer, size);
            }
            NonBlockingBodyDataSource.this.callBodyDataHandler(true);
            return size;
        }

        public int append(ByteBuffer[] buffers, IWriteCompletionHandler completionHandler, boolean force) {
            int size = 0;
            if (buffers != null) {
                size += this.append(buffers);
            }
            if (completionHandler != null) {
                new WriteCompletionHolder(completionHandler, NonBlockingBodyDataSource.this.executor, buffers).callOnWritten();
            }
            NonBlockingBodyDataSource.this.callBodyDataHandler(true);
            return size;
        }

        ByteBuffer[] copyContent() {
            return super.copyReadQueue();
        }

        public String toString() {
            return this.printReadBuffer(NonBlockingBodyDataSource.this.getEncoding());
        }
    }

    static interface ITransferResultHandler {
        public void onComplete() throws IOException;

        public void onException(IOException var1) throws IOException;
    }

    private final class TransferResultHandlerAdapter
    implements IBodyCloseListener,
    IBodyDestroyListener {
        private final ITransferResultHandler resultHandler;

        public TransferResultHandlerAdapter(ITransferResultHandler resultHandler) {
            this.resultHandler = resultHandler;
        }

        public void onClose() throws IOException {
            this.resultHandler.onComplete();
        }

        public void onDestroyed() throws IOException {
            IOException ioe = (IOException)NonBlockingBodyDataSource.this.exceptionRef.get();
            this.resultHandler.onException(ioe);
        }
    }

    @Execution(value=0)
    private static final class NonThreadedBodyForwarder
    extends BodyForwarder {
        public NonThreadedBodyForwarder(IHeader header, NonBlockingBodyDataSource bodyDataSource, BodyDataSink bodyDataSink, IBodyCompleteListener completeListener) {
            super(header, bodyDataSource, bodyDataSink, completeListener);
        }
    }

    private final class DestroyTask
    implements Runnable {
        private final String reason;

        public DestroyTask(String reason) {
            this.reason = reason;
        }

        public void run() {
            NonBlockingBodyDataSource.this.performDestroy(this.reason);
        }
    }
}

