/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xlightweb.AbstractHttpConnection;
import org.xlightweb.BlockingBodyDataSource;
import org.xlightweb.BodyDataSink;
import org.xlightweb.BodyDataSource;
import org.xlightweb.HeaderWrapper;
import org.xlightweb.IBodyCompleteListener;
import org.xlightweb.IForwardable;
import org.xlightweb.IHeader;
import org.xlightweb.IHttpMessageHeader;
import org.xlightweb.IPart;
import org.xlightweb.NonBlockingBodyDataSource;
import org.xsocket.DataConverter;
import org.xsocket.Execution;
import org.xsocket.connection.IConnection;
import org.xsocket.connection.IWriteCompletionHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MultipartDataSource
extends NonBlockingBodyDataSource
implements IForwardable {
    private static final Logger LOG = Logger.getLogger(MultipartDataSource.class.getName());
    private final List<ForwardablePart> parts = new ArrayList<ForwardablePart>();
    private final String dashBoundary;
    private final String closeDelimiter;

    MultipartDataSource(IHttpMessageHeader header, AbstractHttpConnection.IMultimodeExecutor executor, String dashBoundary) throws IOException {
        super(header, executor);
        this.dashBoundary = dashBoundary;
        this.closeDelimiter = "\r\n" + dashBoundary + "--";
    }

    @Override
    boolean isForwardable() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addPart(IPart part) {
        List<ForwardablePart> list = this.parts;
        synchronized (list) {
            this.parts.add(new ForwardablePart(part));
        }
    }

    List<IPart> getParts() {
        ArrayList<IPart> partList = new ArrayList<IPart>();
        for (ForwardablePart part : this.parts) {
            partList.add(part.delegate);
        }
        return partList;
    }

    @Override
    public void forwardTo(BodyDataSink bodyDataSink) throws IOException {
        bodyDataSink.setFlushmode(IConnection.FlushMode.ASYNC);
        ListIterator<ForwardablePart> it = this.parts.listIterator(this.parts.size());
        PartWriter pw = null;
        while (it.hasPrevious()) {
            ForwardablePart part = it.previous();
            pw = new PartWriter(pw, part, !it.hasPrevious());
        }
        pw.forwardTo(bodyDataSink);
    }

    boolean isFileDataSource() {
        return false;
    }

    @Override
    protected boolean isNetworkendpoint() {
        return false;
    }

    @Override
    String getId() {
        return Integer.toString(this.hashCode());
    }

    @Override
    boolean suspend() throws IOException {
        return false;
    }

    @Override
    boolean resume() throws IOException {
        return false;
    }

    @Override
    void onClose() {
    }

    @Override
    void onDestroy(String reason) {
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (ForwardablePart part : this.parts) {
            if (i > 0) {
                sb.append("\r\n");
            }
            ++i;
            sb.append(this.dashBoundary + "\r\n");
            sb.append(part);
        }
        sb.append(this.closeDelimiter + "\r\n");
        return sb.toString();
    }

    static final class ForwardablePart
    extends HeaderWrapper
    implements IPart {
        private final IPart delegate;

        public ForwardablePart(IPart delegate) {
            super(delegate.getPartHeader());
            this.delegate = delegate;
        }

        public BlockingBodyDataSource getBlockingBody() throws IOException {
            return this.delegate.getBlockingBody();
        }

        public BodyDataSource getBody() throws IOException {
            return this.delegate.getBody();
        }

        public NonBlockingBodyDataSource getNonBlockingBody() throws IOException {
            return this.delegate.getNonBlockingBody();
        }

        public IHeader getPartHeader() {
            return this.delegate.getPartHeader();
        }

        public boolean hasBody() {
            return this.delegate.hasBody();
        }

        public String toString() {
            return this.delegate.toString();
        }

        public void forwardTo(BodyDataSink bodyDataSink, IBodyCompleteListener completeListener) throws IOException {
            bodyDataSink.write(this.getPartHeader() + "\r\n");
            this.getNonBlockingBody().forwardTo(bodyDataSink, completeListener);
        }
    }

    @Execution(value=0)
    private final class PartWriter
    implements IForwardable {
        private final boolean isFirstPart;
        private final ForwardablePart part;
        private final PartWriter successor;

        public PartWriter(PartWriter successor, ForwardablePart part, boolean isFirstPart) {
            this.successor = successor;
            this.part = part;
            this.isFirstPart = isFirstPart;
        }

        public void forwardTo(final BodyDataSink dataSink) throws IOException {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + MultipartDataSource.this.getId() + "] writing part " + this.part);
            }
            IWriteCompletionHandler ch = new IWriteCompletionHandler(){

                @Execution(value=0)
                public void onWritten(int written) throws IOException {
                    IBodyCompleteListener cl = new IBodyCompleteListener(){

                        public void onComplete() throws IOException {
                            if (PartWriter.this.successor == null) {
                                if (LOG.isLoggable(Level.FINE)) {
                                    LOG.fine("[" + MultipartDataSource.this.getId() + "] writing close delimiter");
                                }
                                IWriteCompletionHandler ch2 = new IWriteCompletionHandler(){

                                    @Execution(value=0)
                                    public void onWritten(int written) throws IOException {
                                        dataSink.closeQuitly();
                                        MultipartDataSource.this.closeQuitly();
                                    }

                                    public void onException(IOException ioe) {
                                        MultipartDataSource.this.destroy(ioe.toString());
                                    }
                                };
                                PartWriter.this.writeLine(dataSink, MultipartDataSource.this.closeDelimiter, ch2);
                            } else {
                                PartWriter.this.successor.forwardTo(dataSink);
                            }
                        }
                    };
                    PartWriter.this.part.forwardTo(dataSink, cl);
                }

                public void onException(IOException ioe) {
                    MultipartDataSource.this.destroy(ioe.toString());
                }
            };
            if (this.isFirstPart) {
                this.writeLine(dataSink, MultipartDataSource.this.dashBoundary, ch);
            } else {
                this.writeLine(dataSink, "\r\n" + MultipartDataSource.this.dashBoundary, ch);
            }
        }

        private void writeLine(BodyDataSink dataSink, String txt, IWriteCompletionHandler completionHandler) throws IOException {
            dataSink.write(new ByteBuffer[]{DataConverter.toByteBuffer((String)(txt + "\r\n"), (String)"utf-8")}, completionHandler);
        }
    }
}

