/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.SocketTimeoutException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.xlightweb.AbstractHttpConnection;
import org.xlightweb.BadMessageException;
import org.xlightweb.BlockingBodyDataSource;
import org.xlightweb.BodyDataSource;
import org.xlightweb.HttpRequest;
import org.xlightweb.HttpRequestHeaderWrapper;
import org.xlightweb.HttpRequestWrapper;
import org.xlightweb.HttpResponse;
import org.xlightweb.IBodyDataHandler;
import org.xlightweb.IEventHandler;
import org.xlightweb.IEventHandlerInfo;
import org.xlightweb.IHeader;
import org.xlightweb.IHttpConnectHandler;
import org.xlightweb.IHttpConnection;
import org.xlightweb.IHttpConnectionHandler;
import org.xlightweb.IHttpDisconnectHandler;
import org.xlightweb.IHttpExchange;
import org.xlightweb.IHttpMessage;
import org.xlightweb.IHttpMessageHeader;
import org.xlightweb.IHttpRequest;
import org.xlightweb.IHttpRequestHandler;
import org.xlightweb.IHttpRequestHeader;
import org.xlightweb.IHttpRequestTimeoutHandler;
import org.xlightweb.IHttpResponse;
import org.xlightweb.IHttpResponseHandler;
import org.xlightweb.IHttpResponseHeader;
import org.xlightweb.IHttpSocketTimeoutHandler;
import org.xlightweb.IPartHandler;
import org.xlightweb.IUnsynchronized;
import org.xlightweb.IWebHandler;
import org.xlightweb.IWebSocketHandler;
import org.xlightweb.InMemoryBodyDataSource;
import org.xlightweb.InvokeOn;
import org.xlightweb.Mapping;
import org.xlightweb.NonBlockingBodyDataSource;
import org.xlightweb.PartHandlerInfo;
import org.xlightweb.Supports100Continue;
import org.xlightweb.SynchronizedOn;
import org.xlightweb.WebSocketHandlerInfo;
import org.xsocket.DataConverter;
import org.xsocket.Execution;
import org.xsocket.ILifeCycle;
import org.xsocket.MaxReadSizeExceededException;
import org.xsocket.Resource;
import org.xsocket.SerializedTaskQueue;
import org.xsocket.connection.ConnectionUtils;
import org.xsocket.connection.IConnection;
import org.xsocket.connection.IDataHandler;
import org.xsocket.connection.IDisconnectHandler;
import org.xsocket.connection.IHandler;
import org.xsocket.connection.INonBlockingConnection;
import org.xsocket.connection.IServer;
import org.xsocket.connection.IWriteCompletionHandler;
import org.xsocket.connection.NonBlockingConnection;
import org.xsocket.connection.NonBlockingConnectionPool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HttpUtils {
    static final int MAX_HEADER_SIZE = 8192;
    static final byte CR = 13;
    static final byte LF = 10;
    static final byte SPACE = 32;
    static final byte HTAB = 9;
    static final byte AND = 38;
    static final byte SLASH = 47;
    static final byte COLON = 58;
    static final byte EQUALS = 61;
    static final byte QUESTION_MARK = 63;
    private static final Logger LOG = Logger.getLogger(HttpUtils.class.getName());
    private static final Bom BOM_UTF_8 = new Bom("UTF-8", new byte[]{-17, -69, -65});
    private static final Bom BOM_UTF_32BE = new Bom("UTF-32BE", new byte[]{0, 0, -2, -1});
    private static final Bom BOM_UTF_32LE = new Bom("UTF-32LE", new byte[]{-1, -2, 0, 0});
    private static final Bom BOM_UTF_16BE = new Bom("UTF-16BE", new byte[]{-2, -1});
    private static final Bom BOM_UTF_16LE = new Bom("UTF-16LE", new byte[]{-1, -2});
    private static final int BOM_MAX_LENGTH = 4;
    private static final Bom[] BOMS = new Bom[]{BOM_UTF_8, BOM_UTF_32BE, BOM_UTF_32LE, BOM_UTF_16LE, BOM_UTF_16BE};
    private static final Timer TIMER = new Timer("xHttpTimer", true);
    private static final Executor DEFAULT_WORKERPOOL = Executors.newCachedThreadPool(new XLightwebThreadFactory());
    private static final String DATE_TIME_PATTERN_1 = "yyyy-MM-dd'T'HH:mm:ss";
    private static final String DATE_TIME_PATTERN_2 = "yyyyMMdd'T'HHmmssz";
    private static final String DATE_TIME_PATTERN_3 = "yyyy-MM-dd'T'HH:mm:ss.S";
    private static final String RFC1123_TIME_PATTERN = "EEE, dd MMM yyyy HH:mm:ss zzz";
    private static final String RFC1036_TIME_PATTERN = "EEEE, dd-MMM-yy HH:mm:ss zzz";
    private static final Map<Class, Boolean> bodyDataExecutionModeCache = ConnectionUtils.newMapCache((int)25);
    private static final Map<Class, Boolean> bodyCompleteListenerExecutionModeCache = ConnectionUtils.newMapCache((int)25);
    private static final Map<Class, Boolean> requestTimeoutHandlerExecutionModeCache = ConnectionUtils.newMapCache((int)25);
    private static final Map<Class, CompletionHandlerInfo> completionHandlerInfoCache = ConnectionUtils.newMapCache((int)25);
    private static final Map<Class, Boolean> bodyCloseListenerExecutionModeCache = ConnectionUtils.newMapCache((int)25);
    private static final Map<Class, String[]> mappingCache = ConnectionUtils.newMapCache((int)25);
    private static final Map<Class, Integer> bodyDataHandlerExecutionModeCache = ConnectionUtils.newMapCache((int)25);
    private static final Map<Class, Integer> listenerModeCache = ConnectionUtils.newMapCache((int)50);
    private static final Map<Class, RequestHandlerInfo> httpRequestHandlerInfoCache = ConnectionUtils.newMapCache((int)25);
    private static RequestHandlerInfo emptyHttpRequestHandlerInfo;
    private static final Map<Class, PartHandlerInfo> partHandlerInfoCache;
    private static PartHandlerInfo emptyPartHandlerInfo;
    private static final Map<Class, ResponseHandlerInfo> httpResponseHandlerInfoCache;
    private static ResponseHandlerInfo emptyResponseHandlerInfo;
    private static final Map<Class, HttpConnectionHandlerInfo> httpConnectionHandlerInfoCache;
    private static final HttpConnectionHandlerInfo EMPTY_HTTP_CONNECTION_HANDLER_INFO;
    private static final Map<Class, WebSocketHandlerInfo> webSocketHandlerInfoCache;
    private static final WebSocketHandlerInfo EMPTY_WEB_SOCKET_HANDLER_INFO;
    private static final Map<Class, IEventHandlerInfo> webEventHandlerInfoCache;
    private static final IEventHandlerInfo EMPTY_WEB_EVENT_HANDLER_INFO;
    private static String implementationVersion;
    private static String implementationDate;
    private static String xSocketImplementationVersion;
    private static Map<String, String> mimeTypeMap;
    private static boolean showDetailedError;
    private static Boolean isConnectHandlerWarningIsSuppressed;
    private static final char[] ISO_8859_1_Array;
    private static final byte[] base64;
    static final Integer EXECUTIONMODE_UNSYNCHRONIZED;

    private HttpUtils() {
    }

    static char[] getISO_8859_1_Array() {
        return ISO_8859_1_Array;
    }

    public static boolean isShowDetailedError() {
        return showDetailedError;
    }

    public static void clearCaches() {
        bodyDataExecutionModeCache.clear();
        mappingCache.clear();
        bodyCompleteListenerExecutionModeCache.clear();
        requestTimeoutHandlerExecutionModeCache.clear();
        completionHandlerInfoCache.clear();
        bodyCloseListenerExecutionModeCache.clear();
        httpRequestHandlerInfoCache.clear();
        partHandlerInfoCache.clear();
        httpResponseHandlerInfoCache.clear();
        httpConnectionHandlerInfoCache.clear();
    }

    public static String getReason(int statusCode) {
        switch (statusCode) {
            case 100: {
                return "Continue";
            }
            case 101: {
                return "Switching Protocols";
            }
            case 200: {
                return "OK";
            }
            case 201: {
                return "Created";
            }
            case 202: {
                return "Accepted";
            }
            case 203: {
                return "Non-Authoritative Information";
            }
            case 204: {
                return "No Content";
            }
            case 205: {
                return "Reset Content";
            }
            case 206: {
                return "Partial Content";
            }
            case 300: {
                return "Multiple Choices";
            }
            case 301: {
                return "Moved Permanently";
            }
            case 302: {
                return "Not Found";
            }
            case 303: {
                return "See other";
            }
            case 304: {
                return "Not Modifed";
            }
            case 305: {
                return "Use Proxy";
            }
            case 307: {
                return "Temporary Redirect";
            }
            case 400: {
                return "Bad Request";
            }
            case 401: {
                return "Unauthorized";
            }
            case 402: {
                return "Payment Required";
            }
            case 403: {
                return "Forbidden";
            }
            case 404: {
                return "Not found";
            }
            case 405: {
                return "Method Not Allowed";
            }
            case 406: {
                return "Not Acceptable";
            }
            case 407: {
                return "Proxy Authentication Required";
            }
            case 408: {
                return "Request Timeout";
            }
            case 409: {
                return "Conflict";
            }
            case 410: {
                return "Gone";
            }
            case 411: {
                return "Length Required";
            }
            case 412: {
                return "Precondition Failed";
            }
            case 413: {
                return "Request Entity Too Large";
            }
            case 414: {
                return "Request-URI Too Long";
            }
            case 415: {
                return "Unsupported Media Type";
            }
            case 416: {
                return "Requested Range Not Satisfiable";
            }
            case 417: {
                return "Expectation Failed";
            }
            case 500: {
                return "Internal Server Error";
            }
            case 501: {
                return "Not Implemented";
            }
            case 502: {
                return "Bad Gateway";
            }
            case 503: {
                return "Service Unavailable";
            }
            case 504: {
                return "Gateway Timeout";
            }
            case 505: {
                return "HTTP Version Not Supported";
            }
        }
        return " ";
    }

    public static byte[] encodeBase64(byte[] bytes) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int got = -1;
        int off = 0;
        int count = 0;
        while ((got = in.read(buffer, off, 1024 - off)) > 0) {
            if (got >= 3) {
                got += off;
                off = 0;
                while (off + 3 <= got) {
                    int c1 = (buffer[off] & 0xFC) >> 2;
                    int c2 = (buffer[off] & 3) << 4 | (buffer[off + 1] & 0xF0) >>> 4;
                    int c3 = (buffer[off + 1] & 0xF) << 2 | (buffer[off + 2] & 0xC0) >>> 6;
                    int c4 = buffer[off + 2] & 0x3F;
                    switch (count) {
                        case 73: {
                            out.write(base64[c1]);
                            out.write(base64[c2]);
                            out.write(base64[c3]);
                            out.write(10);
                            out.write(base64[c4]);
                            count = 1;
                            break;
                        }
                        case 74: {
                            out.write(base64[c1]);
                            out.write(base64[c2]);
                            out.write(10);
                            out.write(base64[c3]);
                            out.write(base64[c4]);
                            count = 2;
                            break;
                        }
                        case 75: {
                            out.write(base64[c1]);
                            out.write(10);
                            out.write(base64[c2]);
                            out.write(base64[c3]);
                            out.write(base64[c4]);
                            count = 3;
                            break;
                        }
                        case 76: {
                            out.write(10);
                            out.write(base64[c1]);
                            out.write(base64[c2]);
                            out.write(base64[c3]);
                            out.write(base64[c4]);
                            count = 4;
                            break;
                        }
                        default: {
                            out.write(base64[c1]);
                            out.write(base64[c2]);
                            out.write(base64[c3]);
                            out.write(base64[c4]);
                            count += 4;
                        }
                    }
                    off += 3;
                }
                for (int i = 0; i < 3; ++i) {
                    buffer[i] = i < got - off ? buffer[off + i] : (byte)0;
                }
                off = got - off;
                continue;
            }
            off += got;
        }
        switch (off) {
            case 1: {
                out.write(base64[(buffer[0] & 0xFC) >> 2]);
                out.write(base64[(buffer[0] & 3) << 4 | (buffer[1] & 0xF0) >>> 4]);
                out.write(61);
                out.write(61);
                break;
            }
            case 2: {
                out.write(base64[(buffer[0] & 0xFC) >> 2]);
                out.write(base64[(buffer[0] & 3) << 4 | (buffer[1] & 0xF0) >>> 4]);
                out.write(base64[(buffer[1] & 0xF) << 2 | (buffer[2] & 0xC0) >>> 6]);
                out.write(61);
            }
        }
        return out.toByteArray();
    }

    public static byte[] decodeBase64(byte[] bytes) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        byte[] chunk = new byte[4];
        int got = -1;
        int ready = 0;
        block5: while ((got = in.read(buffer)) > 0) {
            int skiped = 0;
            while (skiped < got) {
                while (ready < 4) {
                    int ch;
                    if (skiped >= got) continue block5;
                    if ((ch = buffer[skiped++]) >= 65 && ch <= 90) {
                        ch -= 65;
                    } else if (ch >= 97 && ch <= 122) {
                        ch = ch - 97 + 26;
                    } else if (ch >= 48 && ch <= 57) {
                        ch = ch - 48 + 52;
                    } else {
                        switch (ch) {
                            case 61: {
                                ch = 65;
                                break;
                            }
                            case 43: {
                                ch = 62;
                                break;
                            }
                            case 47: {
                                ch = 63;
                                break;
                            }
                            default: {
                                ch = -1;
                            }
                        }
                    }
                    if (ch < 0) continue;
                    chunk[ready++] = (byte)ch;
                }
                if (chunk[2] == 65) {
                    out.write((chunk[0] & 0x3F) << 2 | (chunk[1] & 0x30) >>> 4);
                    out.flush();
                    return out.toByteArray();
                }
                if (chunk[3] == 65) {
                    out.write((chunk[0] & 0x3F) << 2 | (chunk[1] & 0x30) >>> 4);
                    out.write((chunk[1] & 0xF) << 4 | (chunk[2] & 0x3C) >>> 2);
                    out.flush();
                    return out.toByteArray();
                }
                out.write((chunk[0] & 0x3F) << 2 | (chunk[1] & 0x30) >>> 4);
                out.write((chunk[1] & 0xF) << 4 | (chunk[2] & 0x3C) >>> 2);
                out.write((chunk[2] & 3) << 6 | chunk[3] & 0x3F);
                ready = 0;
            }
        }
        if (ready != 0) {
            throw new IOException("invalid length");
        }
        out.flush();
        return out.toByteArray();
    }

    public static int validateSufficientDatasizeByIntLengthField(NonBlockingBodyDataSource stream) throws IOException, BufferUnderflowException {
        return HttpUtils.validateSufficientDatasizeByIntLengthField(stream, true);
    }

    public static int validateSufficientDatasizeByIntLengthField(NonBlockingBodyDataSource stream, boolean removeLengthField) throws IOException, BufferUnderflowException {
        stream.resetToReadMark();
        stream.markReadPosition();
        int length = stream.readInt();
        if (stream.available() < length) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("insufficient data. require " + length + " got " + stream.available());
            }
            throw new BufferUnderflowException();
        }
        if (!removeLengthField) {
            stream.resetToReadMark();
        }
        stream.removeReadMark();
        return length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized Map<String, String> getMimeTypeMapping() {
        block18: {
            if (mimeTypeMap == null) {
                HashMap<String, String> map = new HashMap<String, String>();
                mimeTypeMap = Collections.unmodifiableMap(map);
                InputStreamReader isr = null;
                BufferedReader lnr = null;
                try {
                    isr = new InputStreamReader(HttpUtils.class.getResourceAsStream("/org/xlightweb/mime.types"));
                    if (isr == null) break block18;
                    lnr = new LineNumberReader(isr);
                    String line = null;
                    while ((line = ((LineNumberReader)lnr).readLine()) != null) {
                        if ((line = line.trim()).startsWith("#")) continue;
                        StringTokenizer st = new StringTokenizer(line);
                        if (st.hasMoreTokens()) {
                            String mimeType = st.nextToken();
                            while (st.hasMoreTokens()) {
                                String extension = st.nextToken();
                                map.put(extension, mimeType);
                                if (!LOG.isLoggable(Level.FINER)) continue;
                                LOG.finer("mapping " + extension + " -> " + mimeType + " added");
                            }
                            continue;
                        }
                        if (!LOG.isLoggable(Level.FINE)) continue;
                        LOG.fine("line " + line + "ignored");
                    }
                    lnr.close();
                }
                catch (Exception ioe) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("could not read mime.types. reason: " + ioe.toString());
                    }
                }
                finally {
                    block19: {
                        try {
                            if (lnr != null) {
                                lnr.close();
                            }
                            if (isr != null) {
                                isr.close();
                            }
                        }
                        catch (IOException ioe) {
                            if (!LOG.isLoggable(Level.FINE)) break block19;
                            LOG.fine("exception occured by closing mime.types file stream " + ioe.toString());
                        }
                    }
                }
            }
        }
        return mimeTypeMap;
    }

    static void injectServerField(Object handler, IServer server) {
        Field[] fields;
        for (Field field : fields = handler.getClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(Resource.class)) continue;
            Resource res = field.getAnnotation(Resource.class);
            if (field.getType() != IServer.class && res.type() != IServer.class) continue;
            field.setAccessible(true);
            try {
                field.set(handler, server);
            }
            catch (IllegalAccessException iae) {
                LOG.warning("could not set HandlerContext for attribute " + field.getName() + ". Reason " + DataConverter.toString((Throwable)iae));
            }
        }
    }

    static boolean hasFormUrlencodedContentType(IHttpMessage message) {
        if (!message.hasBody()) {
            return false;
        }
        return HttpUtils.hasContentType(message.getPartHeader(), "application/x-www-form-urlencoded");
    }

    public static boolean hasContentType(IHeader header, String contentType) {
        return header.getContentType() != null && HttpUtils.parseMediaType(header.getContentType()).equalsIgnoreCase(contentType);
    }

    static String getContentTypedFormUrlencodedEncodingType(IHttpMessage message) {
        String[] parts;
        String contentType = message.getContentType();
        if (contentType != null && contentType.startsWith("application/x-www-form-urlencoded") && (parts = contentType.split(";")).length > 1) {
            for (int i = 1; i < parts.length; ++i) {
                String[] kvp = parts[i].split("=");
                if (!kvp[0].trim().toUpperCase().equals("CHARSET")) continue;
                return kvp[1].trim();
            }
        }
        return IHttpMessage.DEFAULT_ENCODING;
    }

    static IHttpRequest newFormEncodedRequestWrapper(IHttpRequest request) throws IOException {
        if (request instanceof HttpRequestWrapper) {
            return request;
        }
        return new HttpRequestWrapper(new FormEncodedRequestHeaderWrapper(request), request);
    }

    static String[] retrieveMappings(IWebHandler handler) {
        Mapping mappingAnnotation;
        String[] mappings = mappingCache.get(handler.getClass());
        if (mappings == null && (mappingAnnotation = handler.getClass().getAnnotation(Mapping.class)) != null) {
            mappings = mappingAnnotation.value();
            mappingCache.put(handler.getClass(), mappings);
        }
        return mappings;
    }

    static CompletionHandlerInfo getCompletionHandlerInfo(IWriteCompletionHandler handler) {
        CompletionHandlerInfo completionHandlerInfo = completionHandlerInfoCache.get(handler.getClass());
        if (completionHandlerInfo == null) {
            completionHandlerInfo = new CompletionHandlerInfo(handler);
            completionHandlerInfoCache.put(handler.getClass(), completionHandlerInfo);
        }
        return completionHandlerInfo;
    }

    static PartHandlerInfo getPartHandlerInfo(IPartHandler partHandler) {
        if (partHandler == null) {
            if (emptyPartHandlerInfo == null) {
                emptyPartHandlerInfo = new PartHandlerInfo(null);
            }
            return emptyPartHandlerInfo;
        }
        PartHandlerInfo partHandlerInfo = partHandlerInfoCache.get(partHandler.getClass());
        if (partHandlerInfo == null) {
            partHandlerInfo = new PartHandlerInfo(partHandler.getClass());
            partHandlerInfoCache.put(partHandler.getClass(), partHandlerInfo);
        }
        return partHandlerInfo;
    }

    static String getRequestURLWithoutQueryParams(IHttpRequestHeader header) {
        String url = header.getRequestUrl().toString();
        int idx = url.indexOf("?");
        if (idx != -1) {
            url = url.substring(0, idx);
        }
        return url;
    }

    private static ResponseHandlerInfo getHttpResponseHandlerInfo(IHttpResponseHandler httpResponseHandler) {
        if (httpResponseHandler == null) {
            if (emptyResponseHandlerInfo == null) {
                emptyResponseHandlerInfo = new ResponseHandlerInfo(null);
            }
            return emptyResponseHandlerInfo;
        }
        ResponseHandlerInfo httpResponseHandlerInfo = httpResponseHandlerInfoCache.get(httpResponseHandler.getClass());
        if (httpResponseHandlerInfo == null) {
            httpResponseHandlerInfo = new ResponseHandlerInfo(httpResponseHandler.getClass());
            httpResponseHandlerInfoCache.put(httpResponseHandler.getClass(), httpResponseHandlerInfo);
        }
        return httpResponseHandlerInfo;
    }

    static HttpConnectionHandlerInfo getHttpConnectionHandlerInfo(IHttpConnectionHandler httpConnectionHandler) {
        if (httpConnectionHandler == null) {
            return EMPTY_HTTP_CONNECTION_HANDLER_INFO;
        }
        HttpConnectionHandlerInfo httpConnectionHandlerInfo = httpConnectionHandlerInfoCache.get(httpConnectionHandler.getClass());
        if (httpConnectionHandlerInfo == null) {
            httpConnectionHandlerInfo = new HttpConnectionHandlerInfo(httpConnectionHandler.getClass());
            httpConnectionHandlerInfoCache.put(httpConnectionHandler.getClass(), httpConnectionHandlerInfo);
        }
        return httpConnectionHandlerInfo;
    }

    public static boolean isBodylessStatus(int status) {
        return status == 304 || status == 204 || status == 205 || status == 100 || status == 101;
    }

    static void addConnectionAttribute(IHttpResponseHeader header, IHttpConnection con) {
        if (header.getAttribute("org.xlightweb.client.connection") == null && con != null) {
            header.setAttribute("org.xlightweb.client.connection", con);
        }
    }

    static IHttpConnection getConnectionFromAttribute(IHttpResponseHeader header) {
        return (IHttpConnection)header.getAttribute("org.xlightweb.client.connection");
    }

    static Integer getExecutionMode(IBodyDataHandler bodyDataHandler) {
        Integer executionMode = bodyDataHandlerExecutionModeCache.get(bodyDataHandler.getClass());
        if (executionMode == null) {
            block9: {
                if (IUnsynchronized.class.isAssignableFrom(bodyDataHandler.getClass())) {
                    executionMode = EXECUTIONMODE_UNSYNCHRONIZED;
                } else if (bodyDataHandler.getClass().getName().equals("org.xlightweb.client.DuplicatingBodyForwarder")) {
                    executionMode = EXECUTIONMODE_UNSYNCHRONIZED;
                } else {
                    executionMode = 1;
                    Execution execution = bodyDataHandler.getClass().getAnnotation(Execution.class);
                    if (execution != null) {
                        executionMode = execution.value();
                    }
                    try {
                        Method meth = bodyDataHandler.getClass().getMethod("onData", NonBlockingBodyDataSource.class);
                        execution = meth.getAnnotation(Execution.class);
                        if (execution != null) {
                            executionMode = execution.value();
                        }
                    }
                    catch (NoSuchMethodException nsme) {
                        if (!LOG.isLoggable(Level.FINE)) break block9;
                        LOG.fine("shouldn't occure because body handler has to have such a method " + nsme.toString());
                    }
                }
            }
            bodyDataHandlerExecutionModeCache.put(bodyDataHandler.getClass(), executionMode);
        }
        return executionMode;
    }

    static RequestHandlerInfo getRequestHandlerInfo(IHttpRequestHandler requestHandler) {
        if (requestHandler == null) {
            if (emptyHttpRequestHandlerInfo == null) {
                emptyHttpRequestHandlerInfo = new RequestHandlerInfo(null);
            }
            return emptyHttpRequestHandlerInfo;
        }
        RequestHandlerInfo requestHandlerInfo = httpRequestHandlerInfoCache.get(requestHandler.getClass());
        if (requestHandlerInfo != null) {
            return requestHandlerInfo;
        }
        requestHandlerInfo = new RequestHandlerInfo(requestHandler.getClass());
        httpRequestHandlerInfoCache.put(requestHandler.getClass(), requestHandlerInfo);
        return requestHandlerInfo;
    }

    static ResponseHandlerInfo getResponseHandlerInfo(IHttpResponseHandler responseHandler) {
        return HttpUtils.getHttpResponseHandlerInfo(responseHandler);
    }

    public static boolean isAfter(String dateString, long referenceTime) {
        referenceTime = referenceTime / 1000L * 1000L;
        return DataConverter.toDate((String)DataConverter.toFormatedRFC822Date((long)referenceTime)).after(DataConverter.toDate((String)dateString));
    }

    static boolean isContentTypeSupportsCharset(String contentType) {
        return (contentType = contentType.toLowerCase()).startsWith("text") || contentType.startsWith("message/rfc822");
    }

    public static String removeMediaTypeParameters(String mediaType) {
        int idx = mediaType.indexOf(";");
        if (idx != -1) {
            return mediaType.substring(0, idx).trim();
        }
        return mediaType;
    }

    static String parseMediaTypeParameter(String mediaType, String parameterName, boolean isRemoveSurroundingQuote, String dflt) {
        String[] parts;
        if (mediaType != null && (parts = mediaType.split(";")).length > 1) {
            for (String part : parts) {
                if (!(part = part.trim()).toLowerCase().startsWith(parameterName.toLowerCase() + "=")) continue;
                String value = part.substring((parameterName.toLowerCase() + "=").length(), part.length());
                value = value.trim();
                if (isRemoveSurroundingQuote && value.startsWith("\"") && value.endsWith("\"") && value.length() > 1) {
                    value = value.substring(1, value.length() - 1);
                    value = value.trim();
                }
                return value;
            }
        }
        return dflt;
    }

    static String parseMediaType(String mediaType) {
        if (mediaType == null) {
            return null;
        }
        String[] parts = mediaType.split(";");
        return parts[0].trim();
    }

    public static String parseEncoding(String contentType) {
        return HttpUtils.parseMediaTypeParameter(contentType, "charset", true, null);
    }

    public static String parseEncodingWithDefault(String contentType, String dflt) {
        if (contentType == null) {
            return dflt;
        }
        String encoding = HttpUtils.parseMediaTypeParameter(contentType, "charset", true, null);
        if (encoding == null) {
            String mediaType = HttpUtils.parseMediaType(contentType);
            encoding = mediaType.equalsIgnoreCase("text/xml") ? "us-ascii" : (mediaType.equalsIgnoreCase("application/json") || mediaType.equalsIgnoreCase("text/event-stream") ? "utf-8" : (dflt == null ? IHttpMessage.DEFAULT_ENCODING : dflt));
        }
        return encoding;
    }

    static String addEncodingIfNotPresent(String contentType) {
        if (contentType == null) {
            return null;
        }
        String encoding = HttpUtils.parseMediaTypeParameter(contentType, "charset", true, null);
        if (encoding == null) {
            String mediaType = HttpUtils.parseMediaType(contentType);
            if (mediaType.equalsIgnoreCase("text/xml")) {
                return contentType + "; charset=US-ASCII";
            }
            if (mediaType.equalsIgnoreCase("application/json") || mediaType.equalsIgnoreCase("text/event-stream")) {
                return contentType + "; charset=utf-8";
            }
            return contentType + "; charset=" + IHttpMessage.DEFAULT_ENCODING;
        }
        return contentType;
    }

    static Integer getListenerExecutionMode(Object listener, String callbackMethodname) {
        Class<?> clazz = listener.getClass();
        Integer executionMode = listenerModeCache.get(clazz);
        if (executionMode == null) {
            if (clazz == null) {
                executionMode = 1;
            } else if (IUnsynchronized.class.isAssignableFrom(clazz)) {
                executionMode = EXECUTIONMODE_UNSYNCHRONIZED;
            } else {
                boolean isMultiThreaded = HttpUtils.isHandlerMultithreaded(clazz, true);
                executionMode = (isMultiThreaded = HttpUtils.isMethodMultithreaded(clazz, callbackMethodname, isMultiThreaded, new Class[0])) ? Integer.valueOf(1) : Integer.valueOf(0);
            }
            listenerModeCache.put(clazz, executionMode);
        }
        return executionMode;
    }

    static WebSocketHandlerInfo getWebSocketHandlerInfo(IWebSocketHandler webSocketHandler) {
        if (webSocketHandler == null) {
            return EMPTY_WEB_SOCKET_HANDLER_INFO;
        }
        WebSocketHandlerInfo webSocketHandlerInfo = webSocketHandlerInfoCache.get(webSocketHandler.getClass());
        if (webSocketHandlerInfo == null) {
            webSocketHandlerInfo = new WebSocketHandlerInfo(webSocketHandler.getClass());
            webSocketHandlerInfoCache.put(webSocketHandler.getClass(), webSocketHandlerInfo);
        }
        return webSocketHandlerInfo;
    }

    static IEventHandlerInfo getWebEventHandlerInfo(IEventHandler webEventHandler) {
        if (webEventHandler == null) {
            return EMPTY_WEB_EVENT_HANDLER_INFO;
        }
        IEventHandlerInfo webEventHandlerInfo = webEventHandlerInfoCache.get(webEventHandler.getClass());
        if (webEventHandlerInfo == null) {
            webEventHandlerInfo = new IEventHandlerInfo(webEventHandler.getClass());
            webEventHandlerInfoCache.put(webEventHandler.getClass(), webEventHandlerInfo);
        }
        return webEventHandlerInfo;
    }

    public static IHttpRequest copy(IHttpRequest request) throws IOException {
        if (request.hasBody()) {
            if (!request.getNonBlockingBody().isCompleteReceived()) {
                throw new IOException("copy is only supported for complete received messages (hint: uses @InvokeOn(InvokeOn.MESSAGE_RECEIVED) annotation)");
            }
            return new HttpRequest(request.getRequestHeader().copy(), request.getNonBlockingBody().copyContent());
        }
        return new HttpRequest(request.getRequestHeader().copy());
    }

    public static IHttpResponse copy(IHttpResponse response) throws IOException {
        if (response.hasBody()) {
            if (!response.getNonBlockingBody().isCompleteReceived()) {
                throw new IOException("copy is only supported for complete received messages (hint: uses @InvokeOn(InvokeOn.MESSAGE_RECEIVED) annotation)");
            }
            return new HttpResponse(response.getResponseHeader().copy(), response.getNonBlockingBody().copyContent());
        }
        return new HttpResponse(response.getResponseHeader().copy());
    }

    static boolean isTextMimeType(String mimeType) {
        mimeType = mimeType.toLowerCase();
        if ((mimeType = mimeType.trim()).startsWith("text")) {
            return true;
        }
        return mimeType.startsWith("message/rfc822");
    }

    static int[] computeFromRangePosition(String range, int length) throws BadMessageException {
        int[] positions = new int[2];
        int idx = range.indexOf("-");
        if (idx == -1) {
            throw new BadMessageException("invalid range header entry " + range);
        }
        String from = range.substring(0, idx).trim();
        String to = range.substring(idx + 1, range.length()).trim();
        if (from.length() > 0) {
            positions[0] = Integer.parseInt(from);
            positions[1] = to.length() > 0 ? Integer.parseInt(to) : length - 1;
        } else if (to.length() > 0) {
            positions[0] = length - Integer.parseInt(to);
            positions[1] = length - 1;
        } else {
            throw new BadMessageException("invalid range header entry " + range);
        }
        if (positions[0] < 0 || positions[1] < 0 || positions[0] >= length || positions[1] >= length) {
            throw new BadMessageException("invalid range header entry " + range);
        }
        return positions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String detectEncoding(File file) {
        String string;
        block6: {
            FileInputStream fis = new FileInputStream(file);
            try {
                byte[] data = new byte[4];
                fis.read(data);
                string = HttpUtils.detectEncoding(data);
                if (fis == null) break block6;
            }
            catch (Throwable throwable) {
                try {
                    if (fis != null) {
                        fis.close();
                    }
                    throw throwable;
                }
                catch (IOException ioe) {
                    return null;
                }
            }
            fis.close();
        }
        return string;
    }

    static String detectEncoding(byte[] data) throws BufferUnderflowException {
        if (data != null && data.length > 0) {
            for (Bom bom : BOMS) {
                if (!bom.match(data)) continue;
                return bom.getEncoding();
            }
        }
        if (data == null || data.length < 4) {
            throw new BufferUnderflowException();
        }
        return null;
    }

    static boolean startsWithUTF8BOM(ByteBuffer buffer) throws BufferUnderflowException {
        return BOM_UTF_8.match(buffer);
    }

    static boolean startsWithUTF16BEBOM(ByteBuffer buffer) throws BufferUnderflowException {
        return BOM_UTF_16BE.match(buffer);
    }

    static boolean startsWithUTF16LEBOM(ByteBuffer buffer) throws BufferUnderflowException {
        return BOM_UTF_16LE.match(buffer);
    }

    static boolean startsWithUTF32BEBOM(ByteBuffer buffer) throws BufferUnderflowException {
        return BOM_UTF_32BE.match(buffer);
    }

    static boolean startsWithUTF32LEBOM(ByteBuffer buffer) throws BufferUnderflowException {
        return BOM_UTF_32LE.match(buffer);
    }

    static int computeRemaining(ByteBuffer[] bufs) {
        int remaining = 0;
        if (bufs == null) {
            return 0;
        }
        for (ByteBuffer byteBuffer : bufs) {
            if (byteBuffer == null) continue;
            remaining += byteBuffer.remaining();
        }
        return remaining;
    }

    static boolean isEmpty(ByteBuffer buffer) {
        if (buffer == null) {
            return true;
        }
        return buffer.remaining() < 1;
    }

    static boolean isEmpty(ByteBuffer[] buffer) {
        if (buffer == null) {
            return true;
        }
        for (ByteBuffer byteBuffer : buffer) {
            if (byteBuffer == null || !byteBuffer.hasRemaining()) continue;
            return false;
        }
        return true;
    }

    static ByteBuffer[] compact(ByteBuffer[] buffers) {
        if (buffers == null) {
            return null;
        }
        if (buffers.length == 1) {
            if (buffers[0] == null) {
                return null;
            }
            if (buffers[0].remaining() == 0) {
                return null;
            }
            return buffers;
        }
        ByteBuffer[] result = null;
        for (ByteBuffer buffer : buffers) {
            if (buffer == null) continue;
            result = HttpUtils.merge(result, buffer);
        }
        return result;
    }

    private static ByteBuffer[] merge(ByteBuffer[] buffers, ByteBuffer tailBuffer) {
        if (tailBuffer.remaining() == 0) {
            return buffers;
        }
        if (buffers == null || buffers.length == 0) {
            return new ByteBuffer[]{tailBuffer};
        }
        ByteBuffer[] result = new ByteBuffer[buffers.length + 1];
        System.arraycopy(buffers, 0, result, 0, buffers.length);
        result[buffers.length] = tailBuffer;
        return result;
    }

    static ByteBuffer[] merge(ByteBuffer[] buffers, ByteBuffer[] tailBuffers) {
        if (buffers == null || buffers.length == 0) {
            return tailBuffers;
        }
        ByteBuffer[] result = new ByteBuffer[buffers.length + tailBuffers.length];
        System.arraycopy(buffers, 0, result, 0, buffers.length);
        System.arraycopy(tailBuffers, 0, result, buffers.length, tailBuffers.length);
        return result;
    }

    static ByteBuffer duplicateAndMerge(ByteBuffer[] buffers) {
        if (buffers.length == 0) {
            return ByteBuffer.allocate(0);
        }
        if (buffers.length == 1) {
            return buffers[0].duplicate();
        }
        int size = 0;
        for (ByteBuffer byteBuffer : buffers) {
            if (byteBuffer == null) continue;
            size += byteBuffer.remaining();
        }
        ByteBuffer buffer = ByteBuffer.allocate(size);
        for (ByteBuffer byteBuffer : buffers) {
            if (byteBuffer == null) continue;
            int pos = byteBuffer.position();
            int limit = byteBuffer.limit();
            buffer.put(byteBuffer);
            byteBuffer.position(pos);
            byteBuffer.limit(limit);
        }
        buffer.flip();
        return buffer;
    }

    static ByteBuffer merge(ByteBuffer buffer, ByteBuffer[] tailBuffers) {
        if (buffer == null || buffer.remaining() == 0) {
            return HttpUtils.merge(tailBuffers);
        }
        int size = buffer.remaining();
        for (ByteBuffer byteBuffer : tailBuffers) {
            if (byteBuffer == null) continue;
            size += byteBuffer.remaining();
        }
        ByteBuffer result = ByteBuffer.allocate(size);
        result.put(buffer);
        for (ByteBuffer byteBuffer : tailBuffers) {
            if (byteBuffer == null) continue;
            int pos = byteBuffer.position();
            int limit = byteBuffer.limit();
            result.put(byteBuffer);
            byteBuffer.position(pos);
            byteBuffer.limit(limit);
        }
        result.flip();
        return result;
    }

    static ByteBuffer merge(ByteBuffer[] buffers) {
        if (buffers == null || buffers.length == 0) {
            return ByteBuffer.allocate(0);
        }
        if (buffers.length == 1) {
            return buffers[0];
        }
        int size = 0;
        for (ByteBuffer byteBuffer : buffers) {
            if (byteBuffer == null) continue;
            size += byteBuffer.remaining();
        }
        ByteBuffer buffer = ByteBuffer.allocate(size);
        for (ByteBuffer byteBuffer : buffers) {
            if (byteBuffer == null) continue;
            int pos = byteBuffer.position();
            int limit = byteBuffer.limit();
            buffer.put(byteBuffer);
            byteBuffer.position(pos);
            byteBuffer.limit(limit);
        }
        buffer.flip();
        return buffer;
    }

    static ByteBuffer merge(ByteBuffer buffer, ByteBuffer tailBuffer) {
        if (buffer == null || buffer.remaining() == 0) {
            return tailBuffer;
        }
        if (tailBuffer == null || tailBuffer.remaining() == 0) {
            return buffer;
        }
        ByteBuffer result = ByteBuffer.allocate(buffer.remaining() + tailBuffer.remaining());
        result.put(buffer);
        result.put(tailBuffer);
        result.flip();
        return result;
    }

    static byte[] merge(byte[] bytes, byte[] tailBytes) {
        byte[] b = new byte[bytes.length + tailBytes.length];
        System.arraycopy(bytes, 0, b, 0, bytes.length);
        System.arraycopy(tailBytes, 0, b, bytes.length, tailBytes.length);
        return b;
    }

    static ByteBuffer copy(ByteBuffer buffer) {
        if (buffer == null) {
            return null;
        }
        return ByteBuffer.wrap(DataConverter.toBytes((ByteBuffer)buffer));
    }

    public static IOException toIOException(Throwable t) {
        if (t instanceof IOException) {
            return (IOException)t;
        }
        IOException ioe = new IOException(t.getClass().getName() + ": " + t.toString());
        ioe.setStackTrace(t.getStackTrace());
        return ioe;
    }

    public static BlockingBodyDataSource compress(BlockingBodyDataSource dataSource) throws IOException {
        byte[] compressedData = HttpUtils.compress(dataSource.readBytes());
        InMemoryBodyDataSource compressedDataSource = new InMemoryBodyDataSource(dataSource.getHeader(), compressedData);
        return new BlockingBodyDataSource(compressedDataSource);
    }

    public static BodyDataSource compress(BodyDataSource dataSource) throws IOException {
        byte[] compressedData = HttpUtils.compress(dataSource.readBytes());
        InMemoryBodyDataSource compressedDataSource = new InMemoryBodyDataSource(dataSource.getHeader(), compressedData);
        return new BodyDataSource(compressedDataSource);
    }

    public static byte[] compress(byte[] data) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(data.length);
        GZIPOutputStream out = new GZIPOutputStream(bos);
        out.write(data);
        out.close();
        return bos.toByteArray();
    }

    static ByteBuffer[] readFile(File file) throws IOException {
        RandomAccessFile raf = new RandomAccessFile(file, "r");
        FileChannel fc = raf.getChannel();
        ByteBuffer buffer = ByteBuffer.allocate((int)fc.size());
        fc.read(buffer);
        fc.close();
        raf.close();
        buffer.flip();
        return new ByteBuffer[]{buffer};
    }

    public static BlockingBodyDataSource decompress(BlockingBodyDataSource dataSource) throws IOException {
        byte[] decompressedData = HttpUtils.decompress(dataSource.readBytes());
        InMemoryBodyDataSource decompressedDataSource = new InMemoryBodyDataSource(dataSource.getHeader(), decompressedData);
        return new BlockingBodyDataSource(decompressedDataSource);
    }

    public static BodyDataSource decompress(BodyDataSource dataSource) throws IOException {
        byte[] decompressedData = HttpUtils.decompress(dataSource.readBytes());
        InMemoryBodyDataSource decompressedDataSource = new InMemoryBodyDataSource(dataSource.getHeader(), decompressedData);
        return new BodyDataSource(decompressedDataSource);
    }

    public static byte[] decompress(byte[] compressedData) throws IOException {
        ByteArrayInputStream bis = new ByteArrayInputStream(compressedData);
        GZIPInputStream in = new GZIPInputStream(bis);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] transferBuffer = new byte[4096];
        int read = 0;
        do {
            if ((read = in.read(transferBuffer)) == -1) continue;
            bos.write(transferBuffer, 0, read);
        } while (read != -1);
        in.close();
        in.close();
        bos.close();
        return bos.toByteArray();
    }

    static boolean isCompressable(File file) {
        return HttpUtils.isCompressableMimeType(HttpUtils.resolveContentTypeByFileExtension(file));
    }

    public static boolean isCompressableMimeType(String mimeType) {
        if (mimeType == null) {
            return false;
        }
        if ((mimeType = HttpUtils.parseMediaType(mimeType.toLowerCase())).startsWith("text/") && !mimeType.startsWith("text/event-stream")) {
            return true;
        }
        if (mimeType.startsWith("application/")) {
            if (mimeType.startsWith("application/json") || mimeType.startsWith("application/x-www-form-urlencoded") || mimeType.startsWith("application/x-javascript")) {
                return true;
            }
            if (mimeType.endsWith("+xml")) {
                return true;
            }
        }
        return false;
    }

    static void schedule(TimerTask task, long delay, long period) {
        TIMER.schedule(task, delay, period);
    }

    static void schedule(TimerTask task, long delay) {
        TIMER.schedule(task, delay);
    }

    static long computeRemainingTime(long start, int receiveTimeoutSec) {
        return start + (long)receiveTimeoutSec * 1000L - System.currentTimeMillis();
    }

    static boolean isPrintable(IHttpMessage message) {
        if (!message.hasBody()) {
            return true;
        }
        String contentType = message.getContentType();
        if (contentType == null) {
            return true;
        }
        if ((contentType = contentType.toLowerCase()).startsWith("text/") || contentType.startsWith("application/json") || contentType.startsWith("application/x-www-form-urlencoded") || contentType.startsWith("application/x-javascript")) {
            return true;
        }
        return (contentType = contentType.split(",")[0].trim()).startsWith("application/") && contentType.endsWith("+xml");
    }

    public static void setExpireHeaders(IHttpResponseHeader header, int expireSec) {
        if (expireSec > 0) {
            header.setHeader("Expires", HttpUtils.toRFC1123DateString(new Date(System.currentTimeMillis() + (long)expireSec * 1000L)));
            header.setHeader("Cache-Control", "public, max-age=" + expireSec);
        } else {
            header.setHeader("Expires", "Fri, 01 Jan 1990 00:00:00 GMT");
            header.setHeader("Cache-Control", "no-cache, no-store, max-age=0, must-revalidate");
            header.setHeader("Pragma", "no-cache");
        }
    }

    public static void setLastModifiedHeader(IHttpResponseHeader header, long timeMillis) {
        header.setHeader("Last-Modified", DataConverter.toFormatedRFC822Date((long)timeMillis));
    }

    public static String toDateTimeString(Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat(DATE_TIME_PATTERN_1);
        formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        return formatter.format(date);
    }

    public static Date parseDateTimeString(String dateTimeString) throws ParseException {
        try {
            SimpleDateFormat formatter = new SimpleDateFormat(DATE_TIME_PATTERN_1);
            formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
            return formatter.parse(dateTimeString);
        }
        catch (ParseException pe) {
            try {
                SimpleDateFormat formatter = new SimpleDateFormat(DATE_TIME_PATTERN_2);
                formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
                return formatter.parse(dateTimeString);
            }
            catch (ParseException pe2) {
                SimpleDateFormat formatter = new SimpleDateFormat(DATE_TIME_PATTERN_3);
                formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
                return formatter.parse(dateTimeString);
            }
        }
    }

    static boolean isAcceptEncodingGzip(IHttpRequest request) {
        String acceptEncoding = request.getHeader("Accept-Encoding");
        if (acceptEncoding != null) {
            for (String part : acceptEncoding.split(",")) {
                if (!(part = part.toLowerCase().trim()).startsWith("gzip")) continue;
                return true;
            }
        }
        return false;
    }

    public static byte[] computeRFC2104HMAC(byte[] data, byte[] key) throws IOException {
        try {
            SecretKeySpec signingKey = new SecretKeySpec(key, "HmacSHA1");
            Mac mac = Mac.getInstance("HmacSHA1");
            mac.init(signingKey);
            byte[] rawHmac = mac.doFinal(data);
            return HttpUtils.encodeBase64(rawHmac);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new IOException("required algorithm HmacSHA1 is not supported by environment: " + nsae.toString());
        }
        catch (InvalidKeyException ke) {
            throw new IOException("error occured by initializing mac: " + ke.toString());
        }
    }

    public static String toRFC1123DateString(Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat(RFC1123_TIME_PATTERN, Locale.US);
        formatter.setTimeZone(TimeZone.getTimeZone("GMT"));
        String dateString = formatter.format(date);
        return dateString;
    }

    public static Date parseHttpDateString(String dateString) {
        try {
            SimpleDateFormat dateParser = new SimpleDateFormat(RFC1123_TIME_PATTERN, Locale.US);
            dateParser.setTimeZone(TimeZone.getTimeZone("GMT"));
            return dateParser.parse(dateString);
        }
        catch (ParseException pe) {
            try {
                SimpleDateFormat dateParser = new SimpleDateFormat(RFC1036_TIME_PATTERN, Locale.US);
                dateParser.setTimeZone(TimeZone.getTimeZone("GMT"));
                return dateParser.parse(dateString);
            }
            catch (ParseException pe2) {
                return null;
            }
        }
    }

    static ByteBuffer[] copy(ByteBuffer[] buffers) {
        if (buffers == null) {
            return null;
        }
        ByteBuffer[] copy = new ByteBuffer[buffers.length];
        for (int i = 0; i < copy.length; ++i) {
            copy[i] = HttpUtils.copy(buffers[i]);
        }
        return copy;
    }

    static Executor getDefaultWorkerPool() {
        return DEFAULT_WORKERPOOL;
    }

    static AbstractHttpConnection.IMultimodeExecutor newMultimodeExecutor() {
        return HttpUtils.newMultimodeExecutor(DEFAULT_WORKERPOOL);
    }

    static AbstractHttpConnection.IMultimodeExecutor newMultimodeExecutor(Executor workerpool) {
        return new MultimodeExecutor(workerpool);
    }

    public static boolean isContainExpect100ContinueHeader(IHttpMessageHeader header) {
        Boolean isExpectContinue = (Boolean)header.getAttribute("org.xlightweb.containsExpect-100-Continue-header");
        if (isExpectContinue == null) {
            isExpectContinue = HttpUtils.isContainExpect100ContinueHeader((IHeader)header);
            header.setAttribute("org.xlightweb.containsExpect-100-Continue-header", isExpectContinue);
        }
        return isExpectContinue;
    }

    static boolean isContainExpect100ContinueHeader(IHeader header) {
        return header.getHeader("Expect") != null && header.getHeader("Expect").equalsIgnoreCase("100-Continue");
    }

    public static boolean isContainsExpect100ContinueHeader(IHttpRequest request) {
        return HttpUtils.isContainExpect100ContinueHeader(request.getRequestHeader());
    }

    public static String removeSurroundingSlashes(String path) {
        if ((path = path.trim()).startsWith("/")) {
            path = path.substring(1, path.length());
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    static boolean isAbsoluteURL(String location) {
        String locationLowerCase = location.toLowerCase();
        return locationLowerCase.startsWith("http://") || locationLowerCase.startsWith("https://");
    }

    static boolean isRequestTimeoutHandlerMultithreaded(Class<IHttpRequestTimeoutHandler> clazz) {
        Boolean isMultithreaded = requestTimeoutHandlerExecutionModeCache.get(clazz);
        if (isMultithreaded == null) {
            int mode;
            block5: {
                mode = 1;
                Execution execution = clazz.getAnnotation(Execution.class);
                if (execution != null) {
                    mode = execution.value();
                }
                try {
                    Method meth = clazz.getMethod("onRequestTimeout", IHttpConnection.class);
                    execution = meth.getAnnotation(Execution.class);
                    if (execution != null) {
                        mode = execution.value();
                    }
                }
                catch (NoSuchMethodException nsme) {
                    if (!LOG.isLoggable(Level.FINE)) break block5;
                    LOG.fine("shouldn't occure because request timeout handlerr has to have such a method " + nsme.toString());
                }
            }
            isMultithreaded = mode == 1;
            bodyCompleteListenerExecutionModeCache.put(clazz, isMultithreaded);
        }
        return isMultithreaded;
    }

    static Map<String, List<String>> parseParamters(String txt, String encoding) {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        try {
            String[] params;
            for (String param : params = txt.split("&")) {
                String[] kv = param.split("=");
                if (kv.length <= 1) continue;
                String name = URLDecoder.decode(kv[0], encoding);
                ArrayList<String> values = (ArrayList<String>)result.get(name);
                if (values == null) {
                    values = new ArrayList<String>();
                    result.put(name, values);
                }
                values.add(URLDecoder.decode(kv[1], encoding));
            }
            return result;
        }
        catch (UnsupportedEncodingException use) {
            throw new RuntimeException(use.toString());
        }
    }

    static Map<String, List<String>> parseMatrixParamters(String uri, String encoding) {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        try {
            String[] parts;
            for (String part : parts = uri.split(";")) {
                String[] kv = part.split("=");
                if (kv.length <= 1) continue;
                String name = URLDecoder.decode(kv[0], encoding);
                ArrayList<String> values = (ArrayList<String>)result.get(name);
                if (values == null) {
                    values = new ArrayList<String>();
                    result.put(name, values);
                }
                values.add(URLDecoder.decode(kv[1], encoding));
            }
            return result;
        }
        catch (UnsupportedEncodingException use) {
            throw new RuntimeException(use.toString());
        }
    }

    static String removeMatrixParamter(String uri, String name) {
        if (uri == null) {
            return null;
        }
        int idx = uri.indexOf(";" + name);
        if (idx == -1) {
            return uri;
        }
        int end = uri.indexOf(";", idx + 1);
        if (end == -1) {
            return uri.substring(0, idx);
        }
        return uri.substring(0, idx) + uri.substring(end, uri.length());
    }

    static String addMatrixParamter(String uri, String name, String value, String encoding) {
        try {
            if (uri == null) {
                uri = "";
            }
            uri = uri + ";" + URLEncoder.encode(name, encoding) + "=" + URLEncoder.encode(value, encoding);
            return uri;
        }
        catch (UnsupportedEncodingException use) {
            throw new RuntimeException(use.toString());
        }
    }

    public static final String resolveContentTypeByFileExtension(File file) {
        String mimeType = null;
        String name = file.getName();
        int pos = name.lastIndexOf(".");
        if (pos != -1) {
            String encoding;
            String extension = name.substring(pos + 1, name.length());
            mimeType = HttpUtils.getMimeTypeMapping().get(extension);
            if (mimeType != null && HttpUtils.isTextMimeType(mimeType) && (encoding = HttpUtils.detectEncoding(file)) != null) {
                mimeType = mimeType + "; charset=" + encoding;
            }
        }
        return mimeType;
    }

    static int convertMillisToSec(long millis) {
        if (millis > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (millis >= 1000L) {
            return (int)millis / 1000;
        }
        if (millis == 0L) {
            return 0;
        }
        return 1;
    }

    public static String getImplementationVersion() {
        if (implementationVersion == null) {
            HttpUtils.readVersionFile();
        }
        return implementationVersion;
    }

    static String getXSocketImplementationVersion() {
        if (xSocketImplementationVersion == null) {
            HttpUtils.readVersionFile();
        }
        return xSocketImplementationVersion;
    }

    public static long parseLong(String longString, long dflt) {
        if (longString == null) {
            return dflt;
        }
        try {
            return Long.parseLong(longString);
        }
        catch (NumberFormatException nfe) {
            return dflt;
        }
    }

    public static String getImplementationDate() {
        if (implementationDate == null) {
            HttpUtils.readVersionFile();
        }
        return implementationDate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readVersionFile() {
        implementationVersion = "<unknown>";
        implementationDate = "<unknown>";
        InputStreamReader isr = null;
        BufferedReader lnr = null;
        try {
            isr = new InputStreamReader(HttpUtils.class.getResourceAsStream("/org/xlightweb/version.txt"));
            if (isr != null) {
                lnr = new LineNumberReader(isr);
                String line = null;
                do {
                    if ((line = ((LineNumberReader)lnr).readLine()) == null) continue;
                    if (line.startsWith("Implementation-Version=")) {
                        implementationVersion = line.substring("Implementation-Version=".length(), line.length()).trim();
                        continue;
                    }
                    if (line.startsWith("Implementation-Date=")) {
                        implementationDate = line.substring("Implementation-Date=".length(), line.length()).trim();
                        continue;
                    }
                    if (!line.startsWith("Dependency.xSocket.Implementation-Version=")) continue;
                    xSocketImplementationVersion = line.substring("Dependency.xSocket.Implementation-Version=".length(), line.length()).trim();
                } while (line != null);
                lnr.close();
            }
        }
        catch (Exception ioe) {
            implementationDate = "<unknown>";
            implementationVersion = "<unknown>";
            xSocketImplementationVersion = "<unknown>";
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("could not read version file. reason: " + ioe.toString());
            }
        }
        finally {
            block19: {
                try {
                    if (lnr != null) {
                        lnr.close();
                    }
                    if (isr != null) {
                        isr.close();
                    }
                }
                catch (IOException ioe) {
                    if (!LOG.isLoggable(Level.FINE)) break block19;
                    LOG.fine("exception occured by closing version.txt file stream " + ioe.toString());
                }
            }
        }
    }

    static boolean isHandlerMultithreaded(Class<? extends Object> clazz, boolean dflt) {
        Execution execution = clazz.getAnnotation(Execution.class);
        if (execution != null) {
            return execution.value() != 0;
        }
        return dflt;
    }

    public static boolean isMethodMultithreaded(Class clazz, String methodname, boolean dflt, Class ... paramClass) {
        try {
            Method meth = clazz.getMethod(methodname, paramClass);
            Execution execution = meth.getAnnotation(Execution.class);
            if (execution != null) {
                return execution.value() != 0;
            }
            return dflt;
        }
        catch (NoSuchMethodException nsme) {
            return dflt;
        }
    }

    static boolean isSynchronizedOnSession(Class<? extends Object> clazz, boolean dflt) {
        SynchronizedOn synchronizedOn = clazz.getAnnotation(SynchronizedOn.class);
        if (synchronizedOn != null) {
            return synchronizedOn.value() == 1;
        }
        return dflt;
    }

    public static boolean isConnectHandlerWarningIsSuppressed() {
        if (isConnectHandlerWarningIsSuppressed == null) {
            isConnectHandlerWarningIsSuppressed = Boolean.parseBoolean(System.getProperty("org.xlightweb.httpConnectHandler.suppresswarning", "false"));
        }
        return isConnectHandlerWarningIsSuppressed;
    }

    static boolean isSynchronizedOnSession(Class clazz, String methodname, boolean dflt, Class ... paramClass) {
        try {
            Method meth = clazz.getMethod(methodname, paramClass);
            SynchronizedOn synchronizedOn = meth.getAnnotation(SynchronizedOn.class);
            if (synchronizedOn != null) {
                return synchronizedOn.value() == 1;
            }
            return dflt;
        }
        catch (NoSuchMethodException nsme) {
            return dflt;
        }
    }

    static boolean isInvokeOnMessageReceived(Class<? extends Object> clazz, boolean dflt) {
        InvokeOn invokeOn = clazz.getAnnotation(InvokeOn.class);
        if (invokeOn != null) {
            return invokeOn.value() == 1;
        }
        return dflt;
    }

    static boolean isInvokeOnMessageReceived(Class clazz, String methodname, boolean dflt, Class ... paramClass) {
        try {
            Method meth = clazz.getMethod(methodname, paramClass);
            InvokeOn invokeOn = meth.getAnnotation(InvokeOn.class);
            if (invokeOn != null) {
                return invokeOn.value() == 1;
            }
            return dflt;
        }
        catch (NoSuchMethodException nsme) {
            return dflt;
        }
    }

    static boolean isContinueHandler(Class<? extends Object> clazz, String methodname, Class ... params) {
        try {
            Supports100Continue handles100Continue = clazz.getAnnotation(Supports100Continue.class);
            if (handles100Continue != null) {
                return true;
            }
            Method meth = clazz.getMethod(methodname, params);
            handles100Continue = meth.getAnnotation(Supports100Continue.class);
            if (handles100Continue != null) {
                return true;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return false;
    }

    static boolean isGzipEncoded(IHttpMessageHeader responseHeader) {
        return responseHeader.getHeader("Content-Encoding") != null && responseHeader.getHeader("Content-Encoding").toLowerCase().indexOf("gzip") != -1;
    }

    public static boolean isAcceptEncdoingGzip(IHttpRequestHeader requestHeader) {
        return requestHeader.getHeader("Accept-Encoding") != null && requestHeader.getHeader("Accept-Encoding").toLowerCase().indexOf("gzip") != -1;
    }

    public static void establishTcpTunnel(IHttpConnection httpConnection, String target) throws IOException {
        String targetHost = null;
        int targetPort = 443;
        int idx = target.lastIndexOf(":");
        if (idx == -1) {
            targetHost = target;
        } else {
            targetHost = target.substring(0, idx);
            targetPort = Integer.parseInt(target.substring(idx + 1, target.length()));
        }
        HttpUtils.establishTcpTunnel(httpConnection, targetHost, targetPort);
    }

    public static void establishTcpTunnel(IHttpConnection httpConnection, String targetHost, int targetPort) throws IOException {
        NonBlockingConnection forwardCon = new NonBlockingConnection(targetHost, targetPort);
        INonBlockingConnection tcpCon = httpConnection.getUnderlyingTcpConnection();
        forwardCon.setAttachment((Object)tcpCon);
        tcpCon.setAttachment((Object)forwardCon);
        forwardCon.setFlushmode(IConnection.FlushMode.ASYNC);
        forwardCon.setAutoflush(false);
        tcpCon.setFlushmode(IConnection.FlushMode.ASYNC);
        tcpCon.setAutoflush(false);
        forwardCon.setHandler((IHandler)new TcpProxyHandler());
        tcpCon.setHandler((IHandler)new TcpProxyHandler());
    }

    static {
        partHandlerInfoCache = ConnectionUtils.newMapCache((int)25);
        httpResponseHandlerInfoCache = ConnectionUtils.newMapCache((int)25);
        httpConnectionHandlerInfoCache = ConnectionUtils.newMapCache((int)25);
        EMPTY_HTTP_CONNECTION_HANDLER_INFO = new HttpConnectionHandlerInfo(null);
        webSocketHandlerInfoCache = ConnectionUtils.newMapCache((int)25);
        EMPTY_WEB_SOCKET_HANDLER_INFO = new WebSocketHandlerInfo(null);
        webEventHandlerInfoCache = ConnectionUtils.newMapCache((int)25);
        EMPTY_WEB_EVENT_HANDLER_INFO = new IEventHandlerInfo(null);
        isConnectHandlerWarningIsSuppressed = null;
        showDetailedError = Boolean.parseBoolean(System.getProperty("org.xlightweb.showDetailedError", "false"));
        ISO_8859_1_Array = new char[256];
        for (int i = 0; i < ISO_8859_1_Array.length; ++i) {
            try {
                HttpUtils.ISO_8859_1_Array[i] = new String(new byte[]{(byte)i}, "ISO-8859-1").charAt(0);
                continue;
            }
            catch (UnsupportedEncodingException use) {
                throw new RuntimeException(use);
            }
        }
        base64 = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47, 61};
        EXECUTIONMODE_UNSYNCHRONIZED = -1;
    }

    private static final class Bom {
        private String encoding;
        private byte[] bom;

        public Bom(String encoding, byte[] bom) {
            this.encoding = encoding;
            this.bom = bom;
        }

        public String getEncoding() {
            return this.encoding;
        }

        public boolean match(byte[] data) {
            for (int i = 0; i < this.bom.length; ++i) {
                if (this.bom[i] == data[i]) continue;
                return false;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean match(ByteBuffer buffer) {
            if (buffer.remaining() < this.bom.length) {
                return false;
            }
            int pos = buffer.position();
            try {
                for (int i = 0; i < this.bom.length; ++i) {
                    if (this.bom[i] == buffer.get()) continue;
                    boolean bl = false;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            finally {
                buffer.position(pos);
            }
        }
    }

    private static class XLightwebThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger poolNumber = new AtomicInteger(1);
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix = "xLightwebPool-" + poolNumber.getAndIncrement() + "-thread-";

        XLightwebThreadFactory() {
        }

        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, this.namePrefix + this.threadNumber.getAndIncrement());
            if (!t.isDaemon()) {
                t.setDaemon(true);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class RequestHandlerInfo {
        private static final Logger LOG = Logger.getLogger(RequestHandlerInfo.class.getName());
        private static final List<String> SYSTEM_HANDLERS = Arrays.asList("org.xlightweb.client.CookieHandler", "org.xlightweb.client.CacheHandler", "org.xlightweb.client.RedirectHandler", "org.xlightweb.client.ProxyHandler", "org.xlightweb.client.RetryHandler");
        private String clazzName;
        private boolean isUnsynchronized = false;
        private boolean isRequestHandlerSynchronizedOnSession = false;
        private boolean isRequestHandlerInvokeOnMessageReceived = false;
        private boolean isRequestHandlerMultithreaded = true;
        private boolean isLifeCycle = false;
        private boolean isRequestTimoutHandler = false;
        private boolean isRequestTimoutHandlerMultithreaded = true;
        private boolean isContinueHandler = true;

        RequestHandlerInfo(Class clazz) {
            if (clazz == null) {
                return;
            }
            this.clazzName = clazz.getName();
            this.isLifeCycle = ILifeCycle.class.isAssignableFrom(clazz);
            this.isContinueHandler = HttpUtils.isContinueHandler(clazz, "onRequest", IHttpExchange.class);
            if (IHttpRequestHandler.class.isAssignableFrom(clazz)) {
                this.isRequestHandlerMultithreaded = RequestHandlerInfo.isOnRequestMultithreaded(clazz);
                this.isRequestHandlerInvokeOnMessageReceived = RequestHandlerInfo.isOnRequestInvokeOnMessageReceived(clazz);
                this.isRequestHandlerSynchronizedOnSession = RequestHandlerInfo.isOnSession(clazz);
                if (this.isRequestHandlerSynchronizedOnSession && !this.isRequestHandlerMultithreaded) {
                    LOG.warning("request handler " + clazz.getName() + " is annotated as session scope and non-threaded. " + "Session scope have to be multi-threaded. Updating execution mode");
                    this.isRequestHandlerMultithreaded = true;
                }
            }
            if (IHttpRequestTimeoutHandler.class.isAssignableFrom(clazz)) {
                this.isRequestTimoutHandler = true;
                this.isRequestTimoutHandlerMultithreaded = HttpUtils.isRequestTimeoutHandlerMultithreaded(clazz);
            }
            this.isUnsynchronized = IUnsynchronized.class.isAssignableFrom(clazz) || SYSTEM_HANDLERS.contains(clazz.getName());
        }

        static boolean isOnRequestMultithreaded(Class<IHttpRequestHandler> serverHandlerClass) {
            boolean isMultithreaded = HttpUtils.isHandlerMultithreaded(serverHandlerClass, true);
            return HttpUtils.isMethodMultithreaded(serverHandlerClass, "onRequest", isMultithreaded, IHttpExchange.class);
        }

        static boolean isOnRequestInvokeOnMessageReceived(Class<IHttpRequestHandler> handlerClass) {
            boolean invokeOnMessageReceived = HttpUtils.isInvokeOnMessageReceived(handlerClass, false);
            return HttpUtils.isInvokeOnMessageReceived(handlerClass, "onRequest", invokeOnMessageReceived, IHttpExchange.class);
        }

        static boolean isOnSession(Class<IHttpRequestHandler> handlerClass) {
            boolean isSynchronizedOnSession = HttpUtils.isSynchronizedOnSession(handlerClass, false);
            return HttpUtils.isSynchronizedOnSession(handlerClass, "onRequest", isSynchronizedOnSession, IHttpExchange.class);
        }

        public boolean isLifeCycle() {
            return this.isLifeCycle;
        }

        public boolean isRequestHandlerInvokeOnMessageReceived() {
            return this.isRequestHandlerInvokeOnMessageReceived;
        }

        public boolean isRequestHandlerSynchronizedOnSession() {
            return this.isRequestHandlerSynchronizedOnSession;
        }

        public boolean isRequestHandlerMultithreaded() {
            return this.isRequestHandlerMultithreaded;
        }

        public boolean isRequestTimeoutHandler() {
            return this.isRequestTimoutHandler;
        }

        public boolean isRequestTimeoutHandlerMultithreaded() {
            return this.isRequestTimoutHandlerMultithreaded;
        }

        public boolean isContinueHandler() {
            return this.isContinueHandler;
        }

        public boolean isUnsynchronized() {
            return this.isUnsynchronized;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(super.toString() + " (");
            sb.append("classname=" + this.clazzName + " isLifeCycle=" + this.isLifeCycle + " " + "isUnsynchronized=" + this.isUnsynchronized + " " + "isContinueHandler=" + this.isContinueHandler + " " + "isRequestHandlerMultithreaded=" + this.isRequestHandlerMultithreaded + " " + "isRequestHandlerInvokeOnMessageReceived=" + this.isRequestHandlerInvokeOnMessageReceived + " " + "isRequestHandlerSynchronizedOnSession=" + this.isRequestHandlerSynchronizedOnSession + " " + "isRequestTimoutHandler=" + this.isRequestTimoutHandler + " " + "isRequestTimoutHandlerMultithreaded=" + this.isRequestTimoutHandlerMultithreaded + ")");
            return sb.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class ResponseHandlerInfo {
        private static final List<String> SYSTEM_HANDLERS = Arrays.asList("org.xlightweb.client.CookieHandler$ResponseHandler", "org.xlightweb.client.RedirectHandler$BodyRedirectResponseHandler", "org.xlightweb.client.RedirectHandler$BodylessRedirectResponseHandler", "org.xlightweb.client.RetryHandler$BodyRetryResponseHandler", "org.xlightweb.client.RetryHandler$BodylessRetryResponseHandler");
        private boolean isResponseHandler = false;
        private boolean isUnsynchronized = false;
        private boolean isResponseHandlerInvokeOnMessageReceived = false;
        private boolean isResponseHandlerMultithreaded = true;
        private boolean isResponseExeptionHandlerMultithreaded = true;
        private boolean isSocketTimeoutHandler = false;
        private boolean isSocketTimeoutHandlerMultithreaded = true;
        private boolean isContinueHandler = true;

        ResponseHandlerInfo(Class clazz) {
            if (clazz == null) {
                return;
            }
            this.isContinueHandler = HttpUtils.isContinueHandler(clazz, "onResponse", IHttpResponse.class);
            if (IHttpResponseHandler.class.isAssignableFrom(clazz)) {
                this.isResponseHandler = true;
                this.isResponseHandlerMultithreaded = ResponseHandlerInfo.isOnResponseMultithreaded(clazz);
                this.isResponseHandlerInvokeOnMessageReceived = ResponseHandlerInfo.isOnResponseInvokeOnMessageReceived(clazz);
                this.isResponseExeptionHandlerMultithreaded = ResponseHandlerInfo.isOnResponseExceptionMultithreaded(clazz);
            }
            this.isSocketTimeoutHandlerMultithreaded = this.isResponseExeptionHandlerMultithreaded;
            if (IHttpSocketTimeoutHandler.class.isAssignableFrom(clazz)) {
                this.isSocketTimeoutHandler = true;
                this.isSocketTimeoutHandlerMultithreaded = ResponseHandlerInfo.isOnResponseTimeoutMultithreaded(clazz);
            }
            this.isUnsynchronized = IUnsynchronized.class.isAssignableFrom(clazz) || SYSTEM_HANDLERS.contains(clazz.getName());
        }

        static boolean isOnResponseMultithreaded(Class<IHttpResponseHandler> handlerClass) {
            boolean isMultithreaded = HttpUtils.isHandlerMultithreaded(handlerClass, true);
            return HttpUtils.isMethodMultithreaded(handlerClass, "onResponse", isMultithreaded, IHttpResponse.class);
        }

        static boolean isOnResponseExceptionMultithreaded(Class<IHttpResponseHandler> handlerClass) {
            boolean isMultithreaded = HttpUtils.isHandlerMultithreaded(handlerClass, true);
            return HttpUtils.isMethodMultithreaded(handlerClass, "onException", isMultithreaded, IOException.class);
        }

        static boolean isOnResponseTimeoutMultithreaded(Class<IHttpResponseHandler> handlerClass) {
            boolean isMultithreaded = HttpUtils.isHandlerMultithreaded(handlerClass, true);
            return HttpUtils.isMethodMultithreaded(handlerClass, "onException", isMultithreaded, SocketTimeoutException.class);
        }

        static boolean isOnResponseInvokeOnMessageReceived(Class<IHttpResponseHandler> handlerClass) {
            boolean invokeOnMessageReceived = HttpUtils.isInvokeOnMessageReceived(handlerClass, false);
            return HttpUtils.isInvokeOnMessageReceived(handlerClass, "onResponse", invokeOnMessageReceived, IHttpResponse.class);
        }

        public boolean isResponseHandler() {
            return this.isResponseHandler;
        }

        public boolean isResponseHandlerInvokeOnMessageReceived() {
            return this.isResponseHandlerInvokeOnMessageReceived;
        }

        public boolean isResponseHandlerMultithreaded() {
            return this.isResponseHandlerMultithreaded;
        }

        public boolean isSocketTimeoutHandler() {
            return this.isSocketTimeoutHandler;
        }

        public boolean isResponseExeptionHandlerMultithreaded() {
            return this.isResponseExeptionHandlerMultithreaded;
        }

        public boolean isContinueHandler() {
            return this.isContinueHandler;
        }

        public boolean isSocketTimeoutHandlerMultithreaded() {
            return this.isSocketTimeoutHandlerMultithreaded;
        }

        public boolean isUnsynchronized() {
            return this.isUnsynchronized;
        }
    }

    static final class CompletionHandlerInfo {
        private boolean isUnsynchronized = false;
        private boolean isOnWrittenMultithreaded = false;
        private boolean isOnExceptionMultithreaded = false;

        public CompletionHandlerInfo(IWriteCompletionHandler handler) {
            boolean isHandlerMultithreaded = HttpUtils.isHandlerMultithreaded(handler.getClass(), true);
            this.isOnWrittenMultithreaded = HttpUtils.isMethodMultithreaded(handler.getClass(), "onWritten", isHandlerMultithreaded, Integer.TYPE);
            this.isOnExceptionMultithreaded = HttpUtils.isMethodMultithreaded(handler.getClass(), "onException", isHandlerMultithreaded, IOException.class);
            this.isUnsynchronized = handler instanceof IUnsynchronized;
        }

        public boolean isUnsynchronized() {
            return this.isUnsynchronized;
        }

        public boolean isOnWrittenMultithreaded() {
            return this.isOnWrittenMultithreaded;
        }

        public boolean isOnExceptionMutlithreaded() {
            return this.isOnExceptionMultithreaded;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FormEncodedRequestHeaderWrapper
    extends HttpRequestHeaderWrapper {
        private static final Boolean NULL_BOOLEAN = null;
        private final IHttpRequest request;
        private final Map<String, List<String>> bodyParamsMap = new HashMap<String, List<String>>();
        private boolean isBodyParsed = false;

        FormEncodedRequestHeaderWrapper(IHttpRequest request) throws IOException {
            super(request.getRequestHeader());
            this.request = request;
        }

        @Override
        public Integer getIntParameter(String name) {
            String s = this.getParameter(name);
            if (s != null) {
                return Integer.parseInt(s);
            }
            return null;
        }

        @Override
        public int getIntParameter(String name, int defaultVal) {
            String s = this.getParameter(name);
            if (s != null) {
                try {
                    return Integer.parseInt(s);
                }
                catch (Exception e) {
                    return defaultVal;
                }
            }
            return defaultVal;
        }

        @Override
        public Long getLongParameter(String name) {
            String s = this.getParameter(name);
            if (s != null) {
                return Long.parseLong(s);
            }
            return null;
        }

        @Override
        public long getLongParameter(String name, long defaultVal) {
            String s = this.getParameter(name);
            if (s != null) {
                try {
                    return Long.parseLong(s);
                }
                catch (Exception e) {
                    return defaultVal;
                }
            }
            return defaultVal;
        }

        @Override
        public Double getDoubleParameter(String name) {
            String s = this.getParameter(name);
            if (s != null) {
                return Double.parseDouble(s);
            }
            return null;
        }

        @Override
        public double getDoubleParameter(String name, double defaultVal) {
            String s = this.getParameter(name);
            if (s != null) {
                try {
                    return Double.parseDouble(s);
                }
                catch (Exception e) {
                    return defaultVal;
                }
            }
            return defaultVal;
        }

        @Override
        public Float getFloatParameter(String name) {
            String s = this.getParameter(name);
            if (s != null) {
                return Float.valueOf(Float.parseFloat(s));
            }
            return null;
        }

        @Override
        public float getFloatParameter(String name, float defaultVal) {
            String s = this.getParameter(name);
            if (s != null) {
                try {
                    return Float.parseFloat(s);
                }
                catch (Exception e) {
                    return defaultVal;
                }
            }
            return defaultVal;
        }

        @Override
        public Boolean getBooleanParameter(String name) {
            String s = this.getParameter(name);
            if (s != null) {
                return Boolean.parseBoolean(s);
            }
            return NULL_BOOLEAN;
        }

        @Override
        public boolean getBooleanParameter(String name, boolean defaultVal) {
            String s = this.getParameter(name);
            if (s != null) {
                try {
                    return Boolean.parseBoolean(s);
                }
                catch (Exception e) {
                    return defaultVal;
                }
            }
            return defaultVal;
        }

        private void parseBodyIfNecessary() {
            if (!this.isBodyParsed) {
                this.isBodyParsed = true;
                try {
                    if (HttpUtils.hasFormUrlencodedContentType(this.request) && this.request.hasBody()) {
                        this.bodyParamsMap.putAll(HttpUtils.parseParamters(this.request.getNonBlockingBody().toString(), HttpUtils.getContentTypedFormUrlencodedEncodingType(this.request)));
                    } else if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("warning request does not contain a FORM-URLENCODED body: " + this.request);
                    }
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
            }
        }

        @Override
        public String getParameter(String name) {
            this.parseBodyIfNecessary();
            if (this.bodyParamsMap.containsKey(name)) {
                return this.bodyParamsMap.get(name).get(0);
            }
            return this.getWrappedRequestHeader().getParameter(name);
        }

        @Override
        public String[] getParameterValues(String name) {
            this.parseBodyIfNecessary();
            ArrayList<String> result = new ArrayList<String>();
            if (this.bodyParamsMap.containsKey(name)) {
                result.addAll((Collection)this.bodyParamsMap.get(name));
            }
            String[] v = this.getWrappedRequestHeader().getParameterValues(name);
            result.addAll(Arrays.asList(v));
            return result.toArray(new String[result.size()]);
        }

        @Override
        public void setParameter(String parameterName, String parameterValue) {
            this.parseBodyIfNecessary();
            if (this.bodyParamsMap.containsKey(parameterName)) {
                throw new RuntimeException("parameter is contained in body and can not be modified");
            }
            this.getWrappedRequestHeader().setParameter(parameterName, parameterValue);
        }

        @Override
        public Set<String> getParameterNameSet() {
            this.parseBodyIfNecessary();
            HashSet<String> result = new HashSet<String>();
            result.addAll(this.getWrappedRequestHeader().getParameterNameSet());
            result.addAll(this.bodyParamsMap.keySet());
            return result;
        }

        @Override
        public Enumeration getParameterNames() {
            return Collections.enumeration(this.getParameterNameSet());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class HttpConnectionHandlerInfo {
        private boolean isConnectHandler = false;
        private boolean isConnectHandlerMultithreaded = true;
        private boolean isDisconnectHandler = false;
        private boolean isDisconnectHandlerMultithreaded = true;

        public HttpConnectionHandlerInfo(Class clazz) {
            if (clazz == null) {
                return;
            }
            if (IHttpConnectHandler.class.isAssignableFrom(clazz)) {
                this.isConnectHandler = true;
                this.isConnectHandlerMultithreaded = HttpConnectionHandlerInfo.isOnConnectMultithreaded(clazz);
            }
            if (IHttpDisconnectHandler.class.isAssignableFrom(clazz)) {
                this.isDisconnectHandler = true;
                this.isDisconnectHandlerMultithreaded = HttpConnectionHandlerInfo.isOnDisconnectMultithreaded(clazz);
            }
        }

        static boolean isOnConnectMultithreaded(Class<IHttpRequestHandler> serverHandlerClass) {
            int mode;
            block4: {
                mode = 1;
                Execution execution = serverHandlerClass.getAnnotation(Execution.class);
                if (execution != null) {
                    mode = execution.value();
                    return mode == 1;
                }
                try {
                    Method meth = serverHandlerClass.getMethod("onConnect", IHttpConnection.class);
                    execution = meth.getAnnotation(Execution.class);
                    if (execution != null) {
                        mode = execution.value();
                    }
                }
                catch (NoSuchMethodException nsme) {
                    if (!LOG.isLoggable(Level.FINE)) break block4;
                    LOG.fine("shouldn't occure because body handler has to have such a method " + nsme.toString());
                }
            }
            return mode == 1;
        }

        static boolean isOnDisconnectMultithreaded(Class<IHttpRequestHandler> serverHandlerClass) {
            int mode;
            block4: {
                mode = 1;
                Execution execution = serverHandlerClass.getAnnotation(Execution.class);
                if (execution != null) {
                    mode = execution.value();
                    return mode == 1;
                }
                try {
                    Method meth = serverHandlerClass.getMethod("onDisconnect", IHttpConnection.class);
                    execution = meth.getAnnotation(Execution.class);
                    if (execution != null) {
                        mode = execution.value();
                    }
                }
                catch (NoSuchMethodException nsme) {
                    if (!LOG.isLoggable(Level.FINE)) break block4;
                    LOG.fine("shouldn't occure because body handler has to have such a method " + nsme.toString());
                }
            }
            return mode == 1;
        }

        public boolean isConnectHandler() {
            return this.isConnectHandler;
        }

        public boolean isConnectHandlerMultithreaded() {
            return this.isConnectHandlerMultithreaded;
        }

        public boolean isDisconnectHandler() {
            return this.isDisconnectHandler;
        }

        public boolean isDisconnectHandlerMultithreaded() {
            return this.isDisconnectHandlerMultithreaded;
        }
    }

    private static class TcpProxyHandler
    implements IDataHandler,
    IDisconnectHandler {
        private TcpProxyHandler() {
        }

        public boolean onDisconnect(INonBlockingConnection connection) throws IOException {
            INonBlockingConnection reverseConnection = (INonBlockingConnection)connection.getAttachment();
            if (reverseConnection != null) {
                connection.setAttachment(null);
                NonBlockingConnectionPool.destroy((INonBlockingConnection)reverseConnection);
            }
            return true;
        }

        public boolean onData(INonBlockingConnection connection) throws IOException, BufferUnderflowException, MaxReadSizeExceededException {
            INonBlockingConnection forwardConnection = (INonBlockingConnection)connection.getAttachment();
            int available = connection.available();
            if (available > 0) {
                ByteBuffer[] data = connection.readByteBufferByLength(connection.available());
                forwardConnection.write(data);
                forwardConnection.flush();
            } else if (available == -1) {
                NonBlockingConnectionPool.destroy((INonBlockingConnection)connection);
            }
            return true;
        }
    }

    private static final class MultimodeExecutor
    implements AbstractHttpConnection.IMultimodeExecutor {
        private final SerializedTaskQueue taskQueue = new SerializedTaskQueue();
        private Executor workerpool = null;

        public MultimodeExecutor(Executor workerpool) {
            this.workerpool = workerpool;
        }

        public void processMultithreaded(Runnable task) {
            this.taskQueue.performMultiThreaded(task, this.workerpool);
        }

        public void processNonthreaded(Runnable task) {
            this.taskQueue.performNonThreaded(task, this.workerpool);
        }

        public Executor getWorkerpool() {
            return this.workerpool;
        }
    }
}

