/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.xlightweb.BadMessageException;
import org.xlightweb.HttpMessageHeader;
import org.xlightweb.HttpUtils;
import org.xlightweb.IHttpRequestHeader;
import org.xsocket.connection.INonBlockingConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpRequestHeader
extends HttpMessageHeader
implements IHttpRequestHeader {
    private static final Logger LOG = Logger.getLogger(HttpRequestHeader.class.getName());
    private static final Boolean NULL_BOOLEAN = null;
    private static final boolean IS_UPDATE_HOSTHEADER = Boolean.parseBoolean(System.getProperty("org.xlightweb.requestheader.autoupdatehost", "true"));
    private final INonBlockingConnection tcpConnection;
    private String method;
    private String path;
    private String queryString;
    private ArrayList<Parameter> queryParameters;
    private boolean isQueryParamMapModified = false;
    private boolean queryParameterResolveRequired = false;
    private ArrayList<Parameter> matrixParameters;
    private boolean matrixParameterResolveRequired = true;
    private boolean isSecure = false;
    private String requestHandlerPath = "";
    private String contextPath = "";
    private String servername;
    private Integer serverport;
    private String host;
    private String userAgent;

    HttpRequestHeader(INonBlockingConnection tcpConnection) {
        this.tcpConnection = tcpConnection;
        this.isSecure = tcpConnection.isSecure();
        this.setProtocolSchemeSilence("HTTP");
        this.setProtocolVersionSilence("0.9");
    }

    public HttpRequestHeader(String method, String url) {
        this(method, url, null, "1.1");
    }

    public HttpRequestHeader(String method, String url, String contentType) {
        this(method, url, contentType, "1.1");
    }

    HttpRequestHeader(String method, String url, String contentType, String protocolVersion) {
        this.tcpConnection = null;
        this.queryParameterResolveRequired = true;
        this.method = method;
        if (method.toLowerCase().startsWith("http")) {
            throw new RuntimeException("method " + method + " is not supported");
        }
        this.setProtocolSchemeSilence("HTTP");
        this.setProtocolVersionSilence(protocolVersion);
        if (contentType != null) {
            this.addHeader("Content-Type", contentType);
        }
        if (method.equalsIgnoreCase("CONNECT")) {
            this.path = url.trim();
        } else {
            String scheme;
            int port = -1;
            try {
                URI uri = new URI(url.trim());
                this.path = uri.getRawPath();
                this.queryString = uri.getRawQuery();
                scheme = uri.getScheme();
                this.servername = uri.getHost();
                port = uri.getPort();
            }
            catch (URISyntaxException ue) {
                try {
                    URL u = new URL(url.trim());
                    this.path = u.getPath();
                    this.queryString = u.getQuery();
                    scheme = u.getProtocol();
                    this.servername = u.getHost();
                    port = u.getPort();
                }
                catch (MalformedURLException urle) {
                    throw new RuntimeException(urle.toString());
                }
            }
            if (scheme != null && (scheme.equals("https") || scheme.equals("wss"))) {
                this.isSecure = true;
            }
            if (port != -1) {
                this.serverport = port;
                this.setHost(this.servername + ":" + this.serverport);
            } else {
                this.setHost(this.servername);
            }
            if (this.path.length() == 0) {
                this.path = "/";
            }
        }
    }

    @Override
    public String getRequestHandlerPath() {
        return this.requestHandlerPath;
    }

    @Override
    public void setRequestHandlerPath(String requestHandlerPath) {
        this.requestHandlerPath = requestHandlerPath;
    }

    @Override
    public String getContextPath() {
        return this.contextPath;
    }

    @Override
    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    final INonBlockingConnection getUnderylingConnection() {
        return this.tcpConnection;
    }

    final void setServernameSilence(String servername) {
        this.servername = servername;
    }

    final void setServerportPortSilence(int serverport) {
        this.serverport = serverport;
    }

    @Override
    protected final boolean onHeaderAdded(String headername, String headervalue) {
        if (headername.equalsIgnoreCase("Host")) {
            this.host = headervalue;
            return true;
        }
        return super.onHeaderAdded(headername, headervalue);
    }

    @Override
    protected final boolean onHeaderRemoved(String headername) {
        if (headername.equalsIgnoreCase("Host")) {
            this.host = null;
            return true;
        }
        if (headername.equalsIgnoreCase("User-Agent")) {
            this.userAgent = null;
            return true;
        }
        return super.onHeaderRemoved(headername);
    }

    @Override
    public final String getHost() {
        return this.host;
    }

    @Override
    public final String getPathInfo() {
        return this.getPathInfo(false);
    }

    @Override
    public final String getPathInfo(boolean removeSurroundingSlashs) {
        String uri = this.getRequestURI();
        uri = uri.substring(this.getContextPath().length(), uri.length());
        uri = uri.substring(this.getRequestHandlerPath().length(), uri.length()).trim();
        if (removeSurroundingSlashs) {
            if (uri.startsWith("/")) {
                uri = uri.substring(1, uri.length());
            }
            if (uri.endsWith("/")) {
                uri = uri.substring(0, uri.length() - 1).trim();
            }
        } else if (!uri.startsWith("/")) {
            uri = "/" + uri.substring(1, uri.length());
        }
        return uri;
    }

    @Override
    public final void setHost(String host) {
        if (host != null && host.endsWith(":-1")) {
            host = host.substring(0, host.length() - ":-1".length());
        }
        this.host = host;
    }

    @Override
    public final String getUserAgent() {
        if (this.userAgent != null) {
            return this.userAgent;
        }
        return this.getHeader("User-Agent");
    }

    @Override
    public final void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    @Override
    public void setUpgrade(String upgrade) {
        this.setHeader("Upgrade", upgrade);
    }

    @Override
    public String getUpgrade() {
        return this.getHeader("Upgrade");
    }

    @Override
    public void setKeepAlive(String keepAlive) {
        this.setHeader("Keep-Alive", keepAlive);
    }

    @Override
    public String getKeepAlive() {
        return this.getHeader("Keep-Alive");
    }

    @Override
    public final Set<String> getHeaderNameSet() {
        Set<String> headerNames = super.getHeaderNameSet();
        if (this.host != null) {
            headerNames.add("Host");
        }
        if (this.userAgent != null) {
            headerNames.add("User-Agent");
        }
        return headerNames;
    }

    @Override
    public final List<String> getHeaderList(String headername) {
        if (headername.equalsIgnoreCase("Host") && this.host != null) {
            ArrayList<String> result = new ArrayList<String>();
            result.add(this.host);
            return Collections.unmodifiableList(result);
        }
        return super.getHeaderList(headername);
    }

    @Override
    public final String getHeader(String headername) {
        if (headername.equalsIgnoreCase("Host") && this.host != null) {
            return this.host;
        }
        if (headername.equalsIgnoreCase("User-Agent") && this.userAgent != null) {
            return this.userAgent;
        }
        return super.getHeader(headername);
    }

    @Override
    public final boolean containsHeader(String headername) {
        if (headername.equalsIgnoreCase("Host") && this.host != null) {
            return true;
        }
        if (headername.equalsIgnoreCase("User-Agent") && this.userAgent != null) {
            return true;
        }
        return super.containsHeader(headername);
    }

    @Override
    public final String getRemoteHost() {
        if (this.tcpConnection != null) {
            return this.tcpConnection.getRemoteAddress().getHostName();
        }
        return null;
    }

    @Override
    public final int getRemotePort() {
        if (this.tcpConnection != null) {
            return this.tcpConnection.getRemotePort();
        }
        return -1;
    }

    @Override
    public final String getRemoteAddr() {
        if (this.tcpConnection != null) {
            return this.tcpConnection.getRemoteAddress().getHostAddress();
        }
        return null;
    }

    @Override
    public final String getQueryString() {
        if (this.queryString == null && this.queryParameters != null && this.queryParameters.size() > 0) {
            StringBuilder sb = new StringBuilder();
            for (Parameter parameter : this.queryParameters) {
                sb.append(parameter.getEncodedName() + "=" + parameter.getEncodedValue() + "&");
            }
            sb.setLength(sb.length() - 1);
            this.queryString = sb.toString();
        }
        return this.queryString;
    }

    @Override
    public final String getRequestURI() {
        return this.path;
    }

    @Override
    public final void setRequestURI(String requestUri) {
        this.path = requestUri;
    }

    final void setPathSilence(String path) {
        this.path = path;
    }

    @Override
    public final URL getRequestUrl() {
        try {
            String p = this.path;
            String queryString = this.getQueryString();
            if (queryString != null) {
                p = p + "?" + queryString;
            }
            String srvName = this.getServerName();
            if (this.isSecure) {
                if (this.serverport != null) {
                    return new URL("https", srvName, this.serverport, p);
                }
                return new URL("https", srvName, p);
            }
            if (this.serverport != null) {
                return new URL("http", srvName, this.serverport, p);
            }
            return new URL("http", srvName, p);
        }
        catch (MalformedURLException use) {
            throw new RuntimeException(use.toString());
        }
    }

    @Override
    public final void setRequestUrl(URL url) {
        String protocol = url.getProtocol();
        if (protocol != null) {
            this.isSecure = protocol.equalsIgnoreCase("https");
        }
        this.path = url.getPath();
        if (this.path.trim().length() == 0) {
            this.path = "/";
        }
        this.queryString = url.getQuery();
        if (this.queryParameters != null) {
            this.queryParameters.clear();
        }
        if (IS_UPDATE_HOSTHEADER && url.getHost() != null) {
            this.servername = url.getHost();
            int port = url.getPort();
            this.serverport = port != -1 ? Integer.valueOf(port) : null;
            this.host = this.serverport != null ? this.servername + ":" + this.serverport : this.servername;
            this.setHost(this.host);
        }
    }

    @Override
    public final boolean isSecure() {
        return this.isSecure;
    }

    @Override
    public final String getScheme() {
        if (this.isSecure()) {
            return "https";
        }
        return "http";
    }

    @Override
    public final String getMethod() {
        return this.method;
    }

    @Override
    public final void setMethod(String method) {
        this.setMethodSilence(method);
    }

    final void setMethodSilence(String method) {
        this.method = method;
    }

    @Override
    public final String getServerName() {
        if (this.servername == null) {
            this.resolveHostField();
            if (this.servername == null && this.tcpConnection != null) {
                return this.tcpConnection.getLocalAddress().getHostName();
            }
        }
        return this.servername;
    }

    @Override
    public final int getServerPort() {
        if (this.serverport == null) {
            this.resolveHostField();
            if (this.serverport == null) {
                if (this.servername != null) {
                    if (this.isSecure()) {
                        return 443;
                    }
                    return 80;
                }
                if (this.tcpConnection != null) {
                    return this.tcpConnection.getLocalPort();
                }
                this.serverport = -1;
            }
        }
        return this.serverport;
    }

    private void resolveHostField() {
        String host;
        if (this.servername == null && (host = this.getHeader("HOST")) != null) {
            int pos = host.lastIndexOf(":");
            if (pos == -1) {
                this.servername = host;
            } else {
                this.servername = host.substring(0, pos);
                this.serverport = Integer.parseInt(host.substring(pos + 1, host.length()).trim());
            }
        }
    }

    @Override
    public final void removeParameter(String parameterName) {
        if (this.getContentType() != null && this.getContentType().startsWith("application/x-www-form-urlencoded")) {
            LOG.warning("parameter will be removed from URI even though request is from url encoded (if prameter is contained in body this operation will be ignored");
        }
        this.isQueryParamMapModified = true;
        ArrayList<Parameter> paramsToRemove = new ArrayList<Parameter>();
        for (Parameter parameter : this.getQueryParamList()) {
            if (!parameter.isDecodedNameSame(parameterName)) continue;
            paramsToRemove.add(parameter);
        }
        this.queryParameters.removeAll(paramsToRemove);
    }

    @Override
    public final void setParameter(String parameterName, String parameterValue) {
        if (this.getContentType() != null && this.getContentType().startsWith("application/x-www-form-urlencoded")) {
            LOG.warning("parameter will be set in URI even though request is form url encoded (other parameter can be contained in body");
        }
        if (this.queryParameterResolveRequired) {
            this.queryParameterResolveRequired = false;
            this.resolveParameters();
        }
        this.removeParameter(parameterName);
        this.getQueryParamList().add(new Parameter(parameterName, parameterValue, true));
    }

    @Override
    public final void addParameter(String parameterName, String parameterValue) {
        if (this.getContentType() != null && this.getContentType().startsWith("application/x-www-form-urlencoded")) {
            LOG.warning("parameter will be added to URI even though request is form url encoded (other parameter can be contained in body)");
        }
        if (this.queryParameterResolveRequired) {
            this.queryParameterResolveRequired = false;
            this.resolveParameters();
        }
        this.getQueryParamList().add(new Parameter(parameterName, parameterValue, true));
        this.isQueryParamMapModified = true;
    }

    @Override
    public final Enumeration getParameterNames() {
        return Collections.enumeration(this.getParameterNameSet());
    }

    @Override
    public final Set<String> getParameterNameSet() {
        HashSet<String> result = new HashSet<String>();
        if (this.queryParameterResolveRequired) {
            this.queryParameterResolveRequired = false;
            this.resolveParameters();
        }
        for (Parameter param : this.getQueryParamList()) {
            result.add(param.getDecodedName());
        }
        return result;
    }

    @Override
    public final String getParameter(String name, String defaultVal) {
        String param = this.getParameter(name);
        if (param == null) {
            param = defaultVal;
        }
        return param;
    }

    @Override
    public final String getParameter(String name) {
        if (this.queryParameterResolveRequired) {
            this.queryParameterResolveRequired = false;
            this.resolveParameters();
        }
        for (Parameter param : this.getQueryParamList()) {
            if (!param.isDecodedNameSame(name)) continue;
            return param.getDecodedValue();
        }
        return null;
    }

    private void resolveParameters() {
        if (this.queryString != null) {
            Map<String, List<String>> p = HttpUtils.parseParamters(this.queryString, "ISO-8859-1");
            for (Map.Entry<String, List<String>> entry : p.entrySet()) {
                for (String value : entry.getValue()) {
                    this.getQueryParamList().add(new Parameter(entry.getKey(), value, true));
                }
            }
        }
    }

    @Override
    public final void setMatrixParameter(String parameterName, String parameterValue) {
        this.matrixParameterResolveRequired = true;
        this.getMatrixParamList().clear();
        this.removeMatrixParameter(parameterName);
        this.getMatrixParamList().add(new Parameter(parameterName, parameterValue, true));
        this.path = HttpUtils.addMatrixParamter(this.path, parameterName, parameterValue, "ISO-8859-1");
    }

    @Override
    public final void addMatrixParameter(String parameterName, String parameterValue) {
        this.matrixParameterResolveRequired = true;
        this.getMatrixParamList().clear();
        this.getMatrixParamList().add(new Parameter(parameterName, parameterValue, true));
        this.path = HttpUtils.addMatrixParamter(this.path, parameterName, parameterValue, "ISO-8859-1");
    }

    @Override
    public final void removeMatrixParameter(String parameterName) {
        if (this.matrixParameterResolveRequired) {
            this.matrixParameterResolveRequired = false;
            this.resolveMatrixParameters();
        }
        ArrayList<Parameter> paramsToRemove = new ArrayList<Parameter>();
        for (Parameter parameter : this.getMatrixParamList()) {
            if (!parameter.isDecodedNameSame(parameterName)) continue;
            paramsToRemove.add(parameter);
        }
        this.matrixParameters.removeAll(paramsToRemove);
        this.path = HttpUtils.removeMatrixParamter(this.path, parameterName);
    }

    @Override
    public final String[] getMatrixParameterValues(String name) {
        ArrayList<String> result = new ArrayList<String>();
        if (this.matrixParameterResolveRequired) {
            this.matrixParameterResolveRequired = false;
            this.resolveMatrixParameters();
        }
        for (Parameter param : this.getMatrixParamList()) {
            if (!param.isDecodedNameSame(name)) continue;
            result.add(param.getDecodedValue());
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public final Set<String> getMatrixParameterNameSet() {
        HashSet<String> result = new HashSet<String>();
        if (this.matrixParameterResolveRequired) {
            this.matrixParameterResolveRequired = false;
            this.resolveMatrixParameters();
        }
        for (Parameter param : this.getMatrixParamList()) {
            result.add(param.getDecodedName());
        }
        return result;
    }

    @Override
    public final String getMatrixParameter(String name) {
        if (this.matrixParameterResolveRequired) {
            this.matrixParameterResolveRequired = false;
            this.resolveMatrixParameters();
        }
        for (Parameter param : this.getMatrixParamList()) {
            if (!param.isDecodedNameSame(name)) continue;
            return param.getDecodedValue();
        }
        return null;
    }

    private void resolveMatrixParameters() {
        if (this.path != null) {
            Map<String, List<String>> p = HttpUtils.parseMatrixParamters(this.path, this.getCharacterEncoding());
            for (Map.Entry<String, List<String>> entry : p.entrySet()) {
                for (String value : entry.getValue()) {
                    this.getMatrixParamList().add(new Parameter(entry.getKey(), value, true));
                }
            }
        }
    }

    @Override
    public final String[] getParameterValues(String name) {
        ArrayList<String> result = new ArrayList<String>();
        if (this.queryParameterResolveRequired) {
            this.queryParameterResolveRequired = false;
            this.resolveParameters();
        }
        for (Parameter param : this.getQueryParamList()) {
            if (!param.isDecodedNameSame(name)) continue;
            result.add(param.getDecodedValue());
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public final String getRequiredStringParameter(String name) throws BadMessageException {
        String s = this.getParameter(name);
        if (s != null) {
            return s;
        }
        throw new BadMessageException("mandatory parameter '" + name + "' is not set");
    }

    @Override
    public final Integer getIntParameter(String name) throws BadMessageException {
        String s = this.getParameter(name);
        if (s != null) {
            try {
                return Integer.parseInt(s);
            }
            catch (NumberFormatException nfe) {
                throw new BadMessageException("parameter '" + name + "' is not a number");
            }
        }
        return null;
    }

    @Override
    public final int getRequiredIntParameter(String name) throws BadMessageException {
        return Integer.parseInt(this.getRequiredStringParameter(name));
    }

    @Override
    public final int getIntParameter(String name, int defaultVal) {
        String s = this.getParameter(name);
        if (s != null) {
            try {
                return Integer.parseInt(s);
            }
            catch (Exception e) {
                return defaultVal;
            }
        }
        return defaultVal;
    }

    @Override
    public final Long getLongParameter(String name) throws BadMessageException {
        String s = this.getParameter(name);
        if (s != null) {
            try {
                return Long.parseLong(s);
            }
            catch (NumberFormatException nfe) {
                throw new BadMessageException("parameter '" + name + "' is not a number");
            }
        }
        return null;
    }

    @Override
    public final long getRequiredLongParameter(String name) throws BadMessageException {
        return Long.parseLong(this.getRequiredStringParameter(name));
    }

    @Override
    public final long getLongParameter(String name, long defaultVal) {
        String s = this.getParameter(name);
        if (s != null) {
            try {
                return Long.parseLong(s);
            }
            catch (Exception e) {
                return defaultVal;
            }
        }
        return defaultVal;
    }

    @Override
    public final Double getDoubleParameter(String name) throws BadMessageException {
        String s = this.getParameter(name);
        if (s != null) {
            try {
                return Double.parseDouble(s);
            }
            catch (NumberFormatException nfe) {
                throw new BadMessageException("parameter '" + name + "' is not a number");
            }
        }
        return null;
    }

    @Override
    public final double getRequiredDoubleParameter(String name) throws BadMessageException {
        return Double.parseDouble(this.getRequiredStringParameter(name));
    }

    @Override
    public final double getDoubleParameter(String name, double defaultVal) {
        String s = this.getParameter(name);
        if (s != null) {
            try {
                return Double.parseDouble(s);
            }
            catch (Exception e) {
                return defaultVal;
            }
        }
        return defaultVal;
    }

    @Override
    public final Float getFloatParameter(String name) throws BadMessageException {
        String s = this.getParameter(name);
        if (s != null) {
            try {
                return Float.valueOf(Float.parseFloat(s));
            }
            catch (NumberFormatException nfe) {
                throw new BadMessageException("parameter '" + name + "' is not a number");
            }
        }
        return null;
    }

    @Override
    public final float getRequiredFloatParameter(String name) throws BadMessageException {
        return Float.parseFloat(this.getRequiredStringParameter(name));
    }

    @Override
    public final float getFloatParameter(String name, float defaultVal) {
        String s = this.getParameter(name);
        if (s != null) {
            try {
                return Float.parseFloat(s);
            }
            catch (Exception e) {
                return defaultVal;
            }
        }
        return defaultVal;
    }

    @Override
    public final Boolean getBooleanParameter(String name) {
        String s = this.getParameter(name);
        if (s != null) {
            return Boolean.parseBoolean(s);
        }
        return NULL_BOOLEAN;
    }

    @Override
    public final boolean getRequiredBooleanParameter(String name) throws BadMessageException {
        return Boolean.parseBoolean(this.getRequiredStringParameter(name));
    }

    @Override
    public final boolean getBooleanParameter(String name, boolean defaultVal) {
        String s = this.getParameter(name);
        if (s != null) {
            try {
                return Boolean.parseBoolean(s);
            }
            catch (Exception e) {
                return defaultVal;
            }
        }
        return defaultVal;
    }

    final void addRawQueryParameterSilence(String paramName, String paramValue) throws IOException {
        this.getQueryParamList().add(new Parameter(paramName, paramValue, false));
    }

    final void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    private List<Parameter> getQueryParamList() {
        if (this.queryParameters == null) {
            this.queryParameters = new ArrayList();
        }
        return this.queryParameters;
    }

    private List<Parameter> getMatrixParamList() {
        if (this.matrixParameters == null) {
            this.matrixParameters = new ArrayList();
        }
        return this.matrixParameters;
    }

    private void writeRequestLineTo(StringBuilder sb) {
        sb.append(this.getMethod() + " " + this.path);
        if (this.isQueryParamMapModified) {
            boolean isFirstEntry = true;
            for (Parameter param : this.getQueryParamList()) {
                if (isFirstEntry) {
                    isFirstEntry = false;
                    sb.append("?" + param.getEncodedName() + "=" + param.getEncodedValue());
                    continue;
                }
                sb.append("&" + param.getEncodedName() + "=" + param.getEncodedValue());
            }
        } else {
            String queryString = this.getQueryString();
            if (queryString != null) {
                sb.append("?");
                sb.append(queryString);
            }
        }
        if (this.getProtocolScheme() != null) {
            sb.append(" ");
            sb.append(this.getProtocolScheme());
        }
        if (this.getProtocolVersion() != null) {
            sb.append("/");
            sb.append(this.getProtocolVersion());
        }
        sb.append("\r\n");
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.writeRequestLineTo(sb);
        if (this.host != null) {
            sb.append("Host: ");
            sb.append(this.host);
            sb.append("\r\n");
        }
        if (this.userAgent != null) {
            sb.append("User-Agent: ");
            sb.append(this.userAgent);
            sb.append("\r\n");
        }
        this.writeHeadersTo(sb);
        return sb.toString();
    }

    @Override
    public final IHttpRequestHeader copy() {
        try {
            return (IHttpRequestHeader)this.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new RuntimeException(cnse.toString());
        }
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        HttpRequestHeader copy = (HttpRequestHeader)super.clone();
        if (this.queryParameters != null) {
            copy.queryParameters = (ArrayList)this.queryParameters.clone();
        }
        return copy;
    }

    private static class Parameter {
        private String encodedName = null;
        private String decodedName = null;
        private String encodedValue = null;
        private String decodedValue = null;

        public Parameter(String name, String value, boolean isDecoded) {
            if (isDecoded) {
                this.decodedName = name;
                this.decodedValue = value;
            } else {
                this.encodedName = name;
                this.encodedValue = value;
            }
        }

        String getDecodedName() {
            if (this.decodedName == null) {
                this.decodedName = Parameter.decode(this.encodedName);
            }
            return this.decodedName;
        }

        String getEncodedName() {
            if (this.encodedName == null) {
                this.encodedName = Parameter.encode(this.decodedName);
            }
            return this.encodedName;
        }

        String getDecodedValue() {
            if (this.decodedValue == null) {
                this.decodedValue = Parameter.decode(this.encodedValue);
            }
            return this.decodedValue;
        }

        String getEncodedValue() {
            if (this.encodedValue == null) {
                this.encodedValue = Parameter.encode(this.decodedValue);
            }
            return this.encodedValue;
        }

        boolean isDecodedNameSame(String decodedname) {
            return this.getDecodedName().equals(decodedname);
        }

        private static String decode(String encoded) {
            if (encoded == null) {
                return null;
            }
            try {
                return URLDecoder.decode(encoded, "UTF-8");
            }
            catch (UnsupportedEncodingException use) {
                throw new RuntimeException(use.toString());
            }
        }

        private static String encode(String decoded) {
            if (decoded == null) {
                return null;
            }
            try {
                return URLEncoder.encode(decoded, "UTF-8");
            }
            catch (UnsupportedEncodingException use) {
                throw new RuntimeException(use.toString());
            }
        }

        public String toString() {
            return this.getDecodedName() + "=" + this.getDecodedValue();
        }
    }
}

