/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.ConnectException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xlightweb.AbstractHttpConnection;
import org.xlightweb.BadMessageException;
import org.xlightweb.BodyDataSink;
import org.xlightweb.HttpResponse;
import org.xlightweb.IBodyCloseListener;
import org.xlightweb.IBodyCompleteListener;
import org.xlightweb.IBodyDestroyListener;
import org.xlightweb.IHttpConnection;
import org.xlightweb.IHttpExchange;
import org.xlightweb.IHttpRequest;
import org.xlightweb.IHttpRequestHandler;
import org.xlightweb.IHttpRequestHeader;
import org.xlightweb.IHttpResponse;
import org.xlightweb.IHttpResponseHandler;
import org.xlightweb.IHttpResponseHeader;
import org.xlightweb.IHttpSession;
import org.xlightweb.InvokeOn;
import org.xlightweb.NonBlockingBodyDataSource;
import org.xsocket.Execution;
import org.xsocket.connection.ConnectionUtils;

public class HttpRequestHandler
implements IHttpRequestHandler {
    private static final Logger LOG = Logger.getLogger(HttpRequestHandler.class.getName());
    private static final Map<Class, HandlerInfo> handlerInfoCache = ConnectionUtils.newMapCache((int)25);
    private final HandlerInfo handlerInfo = HttpRequestHandler.getHandlerInfo(this.getClass());

    private static HandlerInfo getHandlerInfo(Class clazz) {
        HandlerInfo handlerInfo = handlerInfoCache.get(clazz);
        if (handlerInfo == null) {
            handlerInfo = new HandlerInfo(clazz);
            handlerInfoCache.put(clazz, handlerInfo);
        }
        return handlerInfo;
    }

    @Execution(value=0)
    @InvokeOn(value=0)
    public final void onRequest(final IHttpExchange exchange) throws IOException {
        String method = exchange.getRequest().getMethod();
        if (method.equals("GET")) {
            if (this.handlerInfo.isDoGetInvokeOnMessage() && exchange.getRequest().hasBody()) {
                IBodyCompleteListener cl = new IBodyCompleteListener(){

                    public void onComplete() throws IOException {
                        HttpRequestHandler.this.callDoGet(exchange);
                    }
                };
                NonBlockingBodyDataSource ds = exchange.getRequest().getNonBlockingBody();
                ds.addCompleteListener(cl);
                ds.addDestroyListener(new DestroyListener(exchange));
            } else {
                this.callDoGet(exchange);
            }
        } else if (method.equals("POST")) {
            if (this.handlerInfo.isDoPostInvokeOnMessage() && exchange.getRequest().hasBody()) {
                IBodyCompleteListener cl = new IBodyCompleteListener(){

                    public void onComplete() throws IOException {
                        HttpRequestHandler.this.callDoPost(exchange);
                    }
                };
                NonBlockingBodyDataSource ds = exchange.getRequest().getNonBlockingBody();
                ds.addCompleteListener(cl);
                ds.addDestroyListener(new DestroyListener(exchange));
            } else {
                this.callDoPost(exchange);
            }
        } else if (method.equals("PUT")) {
            if (this.handlerInfo.isDoPutInvokeOnMessage() && exchange.getRequest().hasBody()) {
                IBodyCompleteListener cl = new IBodyCompleteListener(){

                    public void onComplete() throws IOException {
                        HttpRequestHandler.this.callDoPut(exchange);
                    }
                };
                NonBlockingBodyDataSource ds = exchange.getRequest().getNonBlockingBody();
                ds.addCompleteListener(cl);
                ds.addDestroyListener(new DestroyListener(exchange));
            } else {
                this.callDoPut(exchange);
            }
        } else if (method.equals("DELETE")) {
            if (this.handlerInfo.isDoDeleteInvokeOnMessage() && exchange.getRequest().hasBody()) {
                IBodyCompleteListener cl = new IBodyCompleteListener(){

                    public void onComplete() throws IOException {
                        HttpRequestHandler.this.callDoDelete(exchange);
                    }
                };
                NonBlockingBodyDataSource ds = exchange.getRequest().getNonBlockingBody();
                ds.addCompleteListener(cl);
                ds.addDestroyListener(new DestroyListener(exchange));
            } else {
                this.callDoDelete(exchange);
            }
        } else if (method.equals("HEAD")) {
            if (this.handlerInfo.isDoHeadInvokeOnMessage() && exchange.getRequest().hasBody()) {
                IBodyCompleteListener cl = new IBodyCompleteListener(){

                    public void onComplete() throws IOException {
                        HttpRequestHandler.this.callDoHead(exchange);
                    }
                };
                NonBlockingBodyDataSource ds = exchange.getRequest().getNonBlockingBody();
                ds.addCompleteListener(cl);
                ds.addDestroyListener(new DestroyListener(exchange));
            } else {
                this.callDoHead(exchange);
            }
        } else if (method.equals("OPTIONS")) {
            if (this.handlerInfo.isDoOptionsInvokeOnMessage() && exchange.getRequest().hasBody()) {
                IBodyCompleteListener cl = new IBodyCompleteListener(){

                    public void onComplete() throws IOException {
                        HttpRequestHandler.this.callDoOptions(exchange);
                    }
                };
                NonBlockingBodyDataSource ds = exchange.getRequest().getNonBlockingBody();
                ds.addCompleteListener(cl);
                ds.addDestroyListener(new DestroyListener(exchange));
            } else {
                this.callDoOptions(exchange);
            }
        } else if (method.equals("TRACE")) {
            if (this.handlerInfo.isDoTraceInvokeOnMessage() && exchange.getRequest().hasBody()) {
                IBodyCompleteListener cl = new IBodyCompleteListener(){

                    public void onComplete() throws IOException {
                        HttpRequestHandler.this.callDoTrace(exchange);
                    }
                };
                NonBlockingBodyDataSource ds = exchange.getRequest().getNonBlockingBody();
                ds.addCompleteListener(cl);
                ds.addDestroyListener(new DestroyListener(exchange));
            } else {
                this.callDoTrace(exchange);
            }
        } else {
            exchange.forward(exchange.getRequest());
        }
    }

    private void callDoGet(final IHttpExchange exchange) throws IOException {
        if (this.handlerInfo.isDoGetMultithreaded()) {
            Runnable task = new Runnable(){

                public void run() {
                    block3: {
                        try {
                            HttpRequestHandler.this.doGet(exchange);
                        }
                        catch (IOException ioe) {
                            if (LOG.isLoggable(Level.FINE)) {
                                LOG.fine("error occured by performing doGet()");
                            }
                            if (!exchange.getConnection().isOpen()) break block3;
                            exchange.sendError(ioe);
                        }
                    }
                }
            };
            ((AbstractHttpConnection)exchange.getConnection()).getExecutor().processMultithreaded(task);
        } else {
            this.doGet(exchange);
        }
    }

    private void callDoPost(final IHttpExchange exchange) throws IOException {
        if (this.handlerInfo.isDoPostMultithreaded()) {
            Runnable task = new Runnable(){

                public void run() {
                    block3: {
                        try {
                            HttpRequestHandler.this.doPost(exchange);
                        }
                        catch (IOException ioe) {
                            if (LOG.isLoggable(Level.FINE)) {
                                LOG.fine("error occured by performing doPost()");
                            }
                            if (!exchange.getConnection().isOpen()) break block3;
                            exchange.sendError(ioe);
                        }
                    }
                }
            };
            ((AbstractHttpConnection)exchange.getConnection()).getExecutor().processMultithreaded(task);
        } else {
            this.doPost(exchange);
        }
    }

    private void callDoPut(final IHttpExchange exchange) throws IOException {
        if (this.handlerInfo.isDoPutMultithreaded()) {
            Runnable task = new Runnable(){

                public void run() {
                    block3: {
                        try {
                            HttpRequestHandler.this.doPut(exchange);
                        }
                        catch (IOException ioe) {
                            if (LOG.isLoggable(Level.FINE)) {
                                LOG.fine("error occured by performing doPut()");
                            }
                            if (!exchange.getConnection().isOpen()) break block3;
                            exchange.sendError(ioe);
                        }
                    }
                }
            };
            ((AbstractHttpConnection)exchange.getConnection()).getExecutor().processMultithreaded(task);
        } else {
            this.doPut(exchange);
        }
    }

    private void callDoDelete(final IHttpExchange exchange) throws IOException {
        if (this.handlerInfo.isDoDeleteMultithreaded()) {
            Runnable task = new Runnable(){

                public void run() {
                    block3: {
                        try {
                            HttpRequestHandler.this.doDelete(exchange);
                        }
                        catch (IOException ioe) {
                            if (LOG.isLoggable(Level.FINE)) {
                                LOG.fine("error occured by performing doDelete()");
                            }
                            if (!exchange.getConnection().isOpen()) break block3;
                            exchange.sendError(ioe);
                        }
                    }
                }
            };
            ((AbstractHttpConnection)exchange.getConnection()).getExecutor().processMultithreaded(task);
        } else {
            this.doDelete(exchange);
        }
    }

    private void callDoHead(final IHttpExchange exchange) throws IOException {
        if (this.handlerInfo.isDoHeadMultithreaded()) {
            Runnable task = new Runnable(){

                public void run() {
                    block3: {
                        try {
                            HttpRequestHandler.this.doHead(exchange);
                        }
                        catch (IOException ioe) {
                            if (LOG.isLoggable(Level.FINE)) {
                                LOG.fine("error occured by performing doHead()");
                            }
                            if (!exchange.getConnection().isOpen()) break block3;
                            exchange.sendError(ioe);
                        }
                    }
                }
            };
            ((AbstractHttpConnection)exchange.getConnection()).getExecutor().processMultithreaded(task);
        } else {
            this.doHead(exchange);
        }
    }

    private void callDoOptions(final IHttpExchange exchange) throws IOException {
        if (this.handlerInfo.isDoOptionsMultithreaded()) {
            Runnable task = new Runnable(){

                public void run() {
                    block3: {
                        try {
                            HttpRequestHandler.this.doOptions(exchange);
                        }
                        catch (IOException ioe) {
                            if (LOG.isLoggable(Level.FINE)) {
                                LOG.fine("error occured by performing doOptions()");
                            }
                            if (!exchange.getConnection().isOpen()) break block3;
                            exchange.sendError(ioe);
                        }
                    }
                }
            };
            ((AbstractHttpConnection)exchange.getConnection()).getExecutor().processMultithreaded(task);
        } else {
            this.doOptions(exchange);
        }
    }

    private void callDoTrace(final IHttpExchange exchange) throws IOException {
        if (this.handlerInfo.isDoTraceMultithreaded()) {
            Runnable task = new Runnable(){

                public void run() {
                    block3: {
                        try {
                            HttpRequestHandler.this.doTrace(exchange);
                        }
                        catch (IOException ioe) {
                            if (LOG.isLoggable(Level.FINE)) {
                                LOG.fine("error occured by performing doTrace()");
                            }
                            if (!exchange.getConnection().isOpen()) break block3;
                            exchange.sendError(ioe);
                        }
                    }
                }
            };
            ((AbstractHttpConnection)exchange.getConnection()).getExecutor().processMultithreaded(task);
        } else {
            this.doTrace(exchange);
        }
    }

    public void doGet(IHttpExchange exchange) throws IOException, BadMessageException {
        exchange.forward(exchange.getRequest());
    }

    public void doPost(IHttpExchange exchange) throws IOException, BadMessageException {
        exchange.forward(exchange.getRequest());
    }

    public void doPut(IHttpExchange exchange) throws IOException, BadMessageException {
        exchange.forward(exchange.getRequest());
    }

    public void doDelete(IHttpExchange exchange) throws IOException, BadMessageException {
        exchange.forward(exchange.getRequest());
    }

    public void doHead(IHttpExchange exchange) throws IOException, BadMessageException {
        this.doGet(new HeadMethodHttpExchange(exchange));
    }

    public void doOptions(IHttpExchange exchange) throws IOException, BadMessageException {
        exchange.forward(exchange.getRequest());
    }

    public void doTrace(IHttpExchange exchange) throws IOException, BadMessageException {
        exchange.forward(exchange.getRequest());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class HandlerInfo {
        private boolean isDoGetMultithreaded = true;
        private boolean isDoGetInvokeOnMessage = false;
        private boolean isDoPostMultithreaded = true;
        private boolean isDoPostInvokeOnMessage = false;
        private boolean isDoPutMultithreaded = true;
        private boolean isDoPutInvokeOnMessage = false;
        private boolean isDoHeadMultithreaded = true;
        private boolean isDoHeadInvokeOnMessage = false;
        private boolean isDoOptionsMultithreaded = true;
        private boolean isDoOptionsInvokeOnMessage = false;
        private boolean isDoTraceMultithreaded = true;
        private boolean isDoTraceInvokeOnMessage = false;
        private boolean isDoDeleteMultithreaded = true;
        private boolean isDoDeleteInvokeOnMessage = false;

        public HandlerInfo(Class<HttpRequestHandler> clazz) {
            boolean isMultithtreadedDefault = true;
            boolean isInvokeOnMessageDefault = false;
            this.isDoDeleteMultithreaded = this.isMethodMultithreaded(clazz, "doDelete", isMultithtreadedDefault);
            this.isDoDeleteInvokeOnMessage = this.isOnRequestInvokeOnMessageReceived(clazz, "doDelete", isInvokeOnMessageDefault);
            this.isDoGetMultithreaded = this.isMethodMultithreaded(clazz, "doGet", isMultithtreadedDefault);
            this.isDoGetInvokeOnMessage = this.isOnRequestInvokeOnMessageReceived(clazz, "doGet", isInvokeOnMessageDefault);
            this.isDoPostMultithreaded = this.isMethodMultithreaded(clazz, "doPost", isMultithtreadedDefault);
            this.isDoPostInvokeOnMessage = this.isOnRequestInvokeOnMessageReceived(clazz, "doPost", isInvokeOnMessageDefault);
            this.isDoPutMultithreaded = this.isMethodMultithreaded(clazz, "doPut", isMultithtreadedDefault);
            this.isDoPutInvokeOnMessage = this.isOnRequestInvokeOnMessageReceived(clazz, "doPut", isInvokeOnMessageDefault);
            this.isDoTraceMultithreaded = this.isMethodMultithreaded(clazz, "doTrace", isMultithtreadedDefault);
            this.isDoTraceInvokeOnMessage = this.isOnRequestInvokeOnMessageReceived(clazz, "doTrace", isInvokeOnMessageDefault);
            this.isDoOptionsMultithreaded = this.isMethodMultithreaded(clazz, "doOptions", isMultithtreadedDefault);
            this.isDoOptionsInvokeOnMessage = this.isOnRequestInvokeOnMessageReceived(clazz, "doOptions", isInvokeOnMessageDefault);
            this.isDoHeadMultithreaded = this.isMethodMultithreaded(clazz, "doHead", isMultithtreadedDefault);
            this.isDoHeadInvokeOnMessage = this.isOnRequestInvokeOnMessageReceived(clazz, "doHead", isInvokeOnMessageDefault);
        }

        private boolean isMethodMultithreaded(Class<HttpRequestHandler> clazz, String methodname, boolean dflt) {
            block4: {
                Execution execution = clazz.getAnnotation(Execution.class);
                if (execution != null) {
                    return execution.value() == 1;
                }
                try {
                    Method meth = clazz.getMethod(methodname, IHttpExchange.class);
                    execution = meth.getAnnotation(Execution.class);
                    if (execution != null) {
                        return execution.value() == 1;
                    }
                }
                catch (NoSuchMethodException nsme) {
                    if (!LOG.isLoggable(Level.FINE)) break block4;
                    LOG.fine("shouldn't occure because body handler has to have such a method " + nsme.toString());
                }
            }
            return dflt;
        }

        private boolean isOnRequestInvokeOnMessageReceived(Class<HttpRequestHandler> clazz, String methodname, boolean dflt) {
            block4: {
                InvokeOn invokeOn = clazz.getAnnotation(InvokeOn.class);
                if (invokeOn != null) {
                    return invokeOn.value() == 1;
                }
                try {
                    Method meth = clazz.getMethod(methodname, IHttpExchange.class);
                    invokeOn = meth.getAnnotation(InvokeOn.class);
                    if (invokeOn != null) {
                        return invokeOn.value() == 1;
                    }
                }
                catch (NoSuchMethodException nsme) {
                    if (!LOG.isLoggable(Level.FINE)) break block4;
                    LOG.fine("shouldn't occure because response handler has to have such a method " + nsme.toString());
                }
            }
            return dflt;
        }

        public boolean isDoGetMultithreaded() {
            return this.isDoGetMultithreaded;
        }

        public boolean isDoGetInvokeOnMessage() {
            return this.isDoGetInvokeOnMessage;
        }

        public boolean isDoPostMultithreaded() {
            return this.isDoPostMultithreaded;
        }

        public boolean isDoPostInvokeOnMessage() {
            return this.isDoPostInvokeOnMessage;
        }

        public boolean isDoPutMultithreaded() {
            return this.isDoPutMultithreaded;
        }

        public boolean isDoPutInvokeOnMessage() {
            return this.isDoPutInvokeOnMessage;
        }

        public boolean isDoHeadMultithreaded() {
            return this.isDoHeadMultithreaded;
        }

        public boolean isDoHeadInvokeOnMessage() {
            return this.isDoHeadInvokeOnMessage;
        }

        public boolean isDoOptionsMultithreaded() {
            return this.isDoOptionsMultithreaded;
        }

        public boolean isDoOptionsInvokeOnMessage() {
            return this.isDoOptionsInvokeOnMessage;
        }

        public boolean isDoTraceMultithreaded() {
            return this.isDoTraceMultithreaded;
        }

        public boolean isDoTraceInvokeOnMessage() {
            return this.isDoTraceInvokeOnMessage;
        }

        public boolean isDoDeleteMultithreaded() {
            return this.isDoDeleteMultithreaded;
        }

        public boolean isDoDeleteInvokeOnMessage() {
            return this.isDoDeleteInvokeOnMessage;
        }
    }

    private static final class HeadMethodHttpExchange
    implements IHttpExchange {
        private IHttpExchange delegate = null;

        public HeadMethodHttpExchange(IHttpExchange delegate) {
            this.delegate = delegate;
        }

        public void destroy() {
            this.delegate.destroy();
        }

        public BodyDataSink forward(IHttpRequestHeader requestHeader, IHttpResponseHandler responseHandler) throws IOException, ConnectException, IllegalStateException {
            return this.delegate.forward(requestHeader, responseHandler);
        }

        public BodyDataSink forward(IHttpRequestHeader requestHeader) throws IOException, ConnectException, IllegalStateException {
            return this.delegate.forward(requestHeader);
        }

        public BodyDataSink forward(IHttpRequestHeader requestHeader, int contentLength) throws IOException, ConnectException, IllegalStateException {
            return this.delegate.forward(requestHeader, contentLength);
        }

        public BodyDataSink forward(IHttpRequestHeader requestHeader, int contentLength, IHttpResponseHandler responseHandler) throws IOException, ConnectException, IllegalStateException {
            return this.delegate.forward(requestHeader, contentLength, responseHandler);
        }

        public void forward(IHttpRequest request) throws IOException, ConnectException, IllegalStateException {
            this.delegate.forward(request);
        }

        public void forward(IHttpRequest request, IHttpResponseHandler responseHandler) throws IOException, ConnectException, IllegalStateException {
            this.delegate.forward(request, responseHandler);
        }

        public boolean sendContinue() throws IOException {
            return this.delegate.sendContinue();
        }

        public boolean sendContinueIfRequested() throws IOException {
            return this.delegate.sendContinueIfRequested();
        }

        public IHttpConnection getConnection() {
            return this.delegate.getConnection();
        }

        public IHttpRequest getRequest() {
            return this.delegate.getRequest();
        }

        public IHttpSession getSession(boolean create) {
            return this.delegate.getSession(create);
        }

        public String encodeURL(String url) {
            return this.delegate.encodeURL(url);
        }

        public BodyDataSink send(final IHttpResponseHeader header) throws IOException, IllegalStateException {
            BodyDataSink bodyDataSink = this.newEmtpyBodyDataSink();
            IBodyCloseListener closeListener = new IBodyCloseListener(){

                @Execution(value=0)
                public void onClose() throws IOException {
                    HeadMethodHttpExchange.this.delegate.send(new HttpResponse(header));
                }
            };
            bodyDataSink.addCloseListener(closeListener);
            return bodyDataSink;
        }

        public BodyDataSink send(IHttpResponseHeader header, int contentLength) throws IOException, IllegalStateException {
            return this.send(header);
        }

        public void sendRedirect(String location) throws IllegalStateException {
            this.delegate.sendRedirect(location);
        }

        public void send(IHttpResponse response) throws IOException, IllegalStateException {
            this.delegate.send(new HttpResponse(response.getResponseHeader()));
        }

        public void sendError(int errorCode, String msg) throws IllegalStateException {
            this.delegate.sendError(errorCode, msg);
        }

        public void sendError(int errorCode) throws IllegalStateException {
            this.delegate.sendError(errorCode);
        }

        public void sendError(Exception e) throws IllegalStateException {
            this.delegate.sendError(e);
        }

        private BodyDataSink newEmtpyBodyDataSink() throws IOException {
            return null;
        }
    }

    private static final class DestroyListener
    implements IBodyDestroyListener {
        private final IHttpExchange exchange;

        public DestroyListener(IHttpExchange exchange) {
            this.exchange = exchange;
        }

        public void onDestroyed() throws IOException {
            this.exchange.destroy();
        }
    }
}

