/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xlightweb.AbstractHttpConnection;
import org.xlightweb.AbstractHttpProtocolHandler;
import org.xlightweb.BadMessageException;
import org.xlightweb.FullMessageBodyDataSource;
import org.xlightweb.FullMessageChunkedBodyDataSource;
import org.xlightweb.HttpResponse;
import org.xlightweb.HttpResponseHeader;
import org.xlightweb.HttpUtils;
import org.xlightweb.IHttpRequestHeader;
import org.xlightweb.IHttpResponseHeader;
import org.xlightweb.MultipartByteRangeMessageBodyDataSource;
import org.xlightweb.NonBlockingBodyDataSource;
import org.xlightweb.ProtocolException;
import org.xlightweb.SimpleMessageBodyDataSource;
import org.xsocket.DataConverter;
import org.xsocket.connection.INonBlockingConnection;

final class HttpProtocolHandlerClientSide
extends AbstractHttpProtocolHandler {
    private static final Logger LOG = Logger.getLogger(HttpProtocolHandlerClientSide.class.getName());

    HttpProtocolHandlerClientSide() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ByteBuffer[] parseHeader(AbstractHttpConnection httpConnection, ByteBuffer[] rawData) throws BadMessageException, IOException {
        HttpResponseHeader responseHeader = null;
        responseHeader = HttpProtocolHandlerClientSide.parse(httpConnection.getUnderlyingTcpConnection(), rawData);
        if (responseHeader != null) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + httpConnection.getId() + "] request header parsed (rawData: " + HttpUtils.computeRemaining(rawData) + ")");
            }
            responseHeader.setBodyDefaultEncoding(httpConnection.getBodyDefaultEncoding());
            this.setState(10);
            httpConnection.setLastTimeHeaderReceivedMillis(System.currentTimeMillis());
            httpConnection.incCountMessageReceived();
            AbstractHttpConnection.IMessageHeaderHandler messageHeaderHandler = httpConnection.getMessageHeaderHandler();
            if (messageHeaderHandler == null) {
                throw new IOException("no message handler set");
            }
            int bodyType = HttpProtocolHandlerClientSide.getBodyType(httpConnection, responseHeader, (IHttpRequestHeader)messageHeaderHandler.getAssociatedHeader());
            switch (bodyType) {
                case 0: {
                    HttpResponse response = new HttpResponse(responseHeader);
                    AbstractHttpConnection.IMessageHandler messageHandler = messageHeaderHandler.onMessageHeaderReceived(response);
                    messageHandler.onHeaderProcessed();
                    httpConnection.onMessageCompleteReceived(responseHeader);
                    this.setMessageHandler(messageHandler);
                    this.reset();
                    if (rawData != null) {
                        return this.onData(httpConnection, rawData);
                    }
                    break;
                }
                case 1: {
                    FullMessageBodyDataSource dataSource = new FullMessageBodyDataSource(responseHeader, responseHeader.getContentLength(), httpConnection);
                    this.setBodyDataSource(dataSource);
                    HttpResponse response = new HttpResponse((IHttpResponseHeader)responseHeader, (NonBlockingBodyDataSource)dataSource);
                    AbstractHttpConnection.IMessageHandler messageHandler = messageHeaderHandler.onMessageHeaderReceived(response);
                    try {
                        this.setMessageHandler(messageHandler);
                        response.getNonBlockingBody().setBodyDataReceiveTimeoutMillis(httpConnection.getBodyDataReceiveTimeoutMillis());
                        rawData = this.parserBody(httpConnection, rawData);
                        break;
                    }
                    finally {
                        messageHandler.onHeaderProcessed();
                    }
                }
                case 5: {
                    FullMessageBodyDataSource dataSource = new FullMessageBodyDataSource(responseHeader, 16, httpConnection);
                    this.setBodyDataSource(dataSource);
                    HttpResponse response = new HttpResponse((IHttpResponseHeader)responseHeader, (NonBlockingBodyDataSource)dataSource);
                    response.removeHeader("Content-Length");
                    AbstractHttpConnection.IMessageHandler messageHandler = messageHeaderHandler.onMessageHeaderReceived(response);
                    try {
                        this.setMessageHandler(messageHandler);
                        response.getNonBlockingBody().setBodyDataReceiveTimeoutMillis(httpConnection.getBodyDataReceiveTimeoutMillis());
                        rawData = this.parserBody(httpConnection, rawData);
                        break;
                    }
                    finally {
                        messageHandler.onHeaderProcessed();
                    }
                }
                case 3: {
                    SimpleMessageBodyDataSource dataSource = new SimpleMessageBodyDataSource(responseHeader, httpConnection);
                    this.setBodyDataSource(dataSource);
                    HttpResponse response = new HttpResponse((IHttpResponseHeader)responseHeader, (NonBlockingBodyDataSource)dataSource);
                    AbstractHttpConnection.IMessageHandler messageHandler = messageHeaderHandler.onMessageHeaderReceived(response);
                    try {
                        this.setMessageHandler(messageHandler);
                        response.getNonBlockingBody().setBodyDataReceiveTimeoutMillis(httpConnection.getBodyDataReceiveTimeoutMillis());
                        rawData = this.parserBody(httpConnection, rawData);
                        break;
                    }
                    finally {
                        messageHandler.onHeaderProcessed();
                    }
                }
                case 4: {
                    MultipartByteRangeMessageBodyDataSource dataSource = new MultipartByteRangeMessageBodyDataSource(httpConnection, responseHeader);
                    this.setBodyDataSource(dataSource);
                    HttpResponse response = new HttpResponse((IHttpResponseHeader)responseHeader, (NonBlockingBodyDataSource)dataSource);
                    AbstractHttpConnection.IMessageHandler messageHandler = messageHeaderHandler.onMessageHeaderReceived(response);
                    try {
                        this.setMessageHandler(messageHandler);
                        response.getNonBlockingBody().setBodyDataReceiveTimeoutMillis(httpConnection.getBodyDataReceiveTimeoutMillis());
                        rawData = this.parserBody(httpConnection, rawData);
                        break;
                    }
                    finally {
                        messageHandler.onHeaderProcessed();
                    }
                }
                default: {
                    FullMessageChunkedBodyDataSource dataSource = new FullMessageChunkedBodyDataSource(httpConnection, responseHeader);
                    this.setBodyDataSource(dataSource);
                    HttpResponse response = new HttpResponse((IHttpResponseHeader)responseHeader, (NonBlockingBodyDataSource)dataSource);
                    AbstractHttpConnection.IMessageHandler messageHandler = messageHeaderHandler.onMessageHeaderReceived(response);
                    try {
                        this.setMessageHandler(messageHandler);
                        response.getNonBlockingBody().setBodyDataReceiveTimeoutMillis(httpConnection.getBodyDataReceiveTimeoutMillis());
                        rawData = this.parserBody(httpConnection, rawData);
                        break;
                    }
                    finally {
                        messageHandler.onHeaderProcessed();
                    }
                }
            }
        }
        return rawData;
    }

    void onDisconnectInHeader(AbstractHttpConnection httpConnection, ByteBuffer[] rawData) throws IOException {
        ByteBuffer buffer = HttpUtils.duplicateAndMerge(rawData);
        int maxReadSize = 8;
        if (buffer.remaining() < maxReadSize) {
            maxReadSize = buffer.remaining();
        }
        for (int i = 0; i < maxReadSize; ++i) {
            int posSlash;
            String protocolScheme;
            if (buffer.get() != 47 || !(protocolScheme = HttpProtocolHandlerClientSide.extractString((posSlash = buffer.position()) - 5, 4, buffer)).equalsIgnoreCase("HTTP")) continue;
            throw new ProtocolException("connection " + httpConnection.getId() + " has been disconnected while receiving header. Already received: " + DataConverter.toString((ByteBuffer[])HttpUtils.copy(rawData), (String)"ISO-8859-1"), null);
        }
        httpConnection.setLastTimeHeaderReceivedMillis(System.currentTimeMillis());
        httpConnection.incCountMessageReceived();
        HttpResponseHeader responseHeader = new HttpResponseHeader(200);
        responseHeader.setProtocolVersionSilence("0.9");
        responseHeader.setHeader("Connection", "close");
        SimpleMessageBodyDataSource dataSource = new SimpleMessageBodyDataSource(responseHeader, httpConnection);
        this.setBodyDataSource(dataSource);
        this.setState(10);
        HttpResponse response = new HttpResponse((IHttpResponseHeader)responseHeader, dataSource, true);
        AbstractHttpConnection.IMessageHeaderHandler messageHeaderHandler = httpConnection.getMessageHeaderHandler();
        if (messageHeaderHandler == null) {
            throw new IOException("no message handler set");
        }
        dataSource.parse(rawData);
        dataSource.onDisconnect();
        AbstractHttpConnection.IMessageHandler messageHandler = messageHeaderHandler.onMessageHeaderReceived(response);
        this.setMessageHandler(messageHandler);
        messageHandler.onHeaderProcessed();
    }

    void onDisconnectInHeaderNothingReceived(AbstractHttpConnection httpConnection, ByteBuffer[] rawData) {
        if (httpConnection.getNumOpenTransactions() == 0) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("no open transactions running. ignore disconnect");
            }
        } else {
            super.onDisconnectInHeaderNothingReceived(httpConnection, rawData);
        }
    }

    private static int getBodyType(AbstractHttpConnection httpConnection, HttpResponseHeader responseHeader, IHttpRequestHeader requestHeader) {
        int status = responseHeader.getStatus();
        if (status == 101 && responseHeader.getHeader("Sec-WebSocket-Origin") != null) {
            return 5;
        }
        if (HttpUtils.isBodylessStatus(status) || requestHeader.getMethod().equals("HEAD")) {
            return 0;
        }
        if (status / 100 == 2 && requestHeader.getMethod().equals("CONNECT")) {
            return 0;
        }
        if (responseHeader.getContentLength() != -1) {
            if (responseHeader.getContentLength() > 0) {
                return 1;
            }
            return 0;
        }
        String transferEncoding = responseHeader.getTransferEncoding();
        if (transferEncoding != null && transferEncoding.equalsIgnoreCase("chunked")) {
            return 2;
        }
        if (responseHeader.getHeader("Connection") != null && responseHeader.getHeader("Connection").equalsIgnoreCase("close")) {
            httpConnection.setPersistent(false);
            return 3;
        }
        if (responseHeader.getStatus() == 206 && responseHeader.getContentType() != null && responseHeader.getContentType().toLowerCase().startsWith("multipart/byteranges")) {
            return 4;
        }
        if (!responseHeader.getProtocolVersion().equalsIgnoreCase("0.9") && status >= 300) {
            httpConnection.setPersistent(false);
            return 0;
        }
        httpConnection.setPersistent(false);
        return 3;
    }

    private static HttpResponseHeader parse(INonBlockingConnection connection, ByteBuffer[] rawData) throws IOException {
        HttpResponseHeader responseHeader = new HttpResponseHeader();
        if (rawData == null) {
            return null;
        }
        ByteBuffer workBuffer = HttpUtils.duplicateAndMerge(rawData);
        int savePosition = workBuffer.position();
        try {
            while (workBuffer.get() != 47) {
            }
            int posSlash = workBuffer.position();
            if (LOG.isLoggable(Level.FINE) && posSlash != 5) {
                LOG.fine("leading data " + DataConverter.toString((ByteBuffer)HttpUtils.copy(workBuffer)));
            }
            String protocolScheme = HttpProtocolHandlerClientSide.extractString(posSlash - 5, 4, workBuffer);
            responseHeader.setProtocolSchemeSilence(protocolScheme);
            String protocolVersion = HttpProtocolHandlerClientSide.extractString(posSlash, 3, workBuffer);
            responseHeader.setProtocolVersionSilence(protocolVersion);
            workBuffer.position(posSlash + 4);
            while (workBuffer.get() <= 47) {
            }
            int posStatusCode = workBuffer.position();
            int statusCode = HttpProtocolHandlerClientSide.extractInt(posStatusCode - 1, 3, workBuffer);
            responseHeader.setStatus(statusCode);
            workBuffer.position(posStatusCode + 3);
            while (workBuffer.get() != 10) {
            }
            int posLF = workBuffer.position();
            String reason = HttpProtocolHandlerClientSide.extractStringWithoutTailingCR(posStatusCode + 3, posLF - (posStatusCode + 4), workBuffer);
            responseHeader.setReason(reason);
            workBuffer.position(posLF);
            HttpProtocolHandlerClientSide.parseHeaderLines(workBuffer, responseHeader);
            HttpProtocolHandlerClientSide.skipPositions(workBuffer.position() - savePosition, rawData);
            return responseHeader;
        }
        catch (Exception e) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("header parsing exception: " + e.toString());
            }
            if (workBuffer.position(savePosition).remaining() > 8192) {
                throw new BadMessageException("max header size reached");
            }
            return null;
        }
    }
}

