/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xlightweb.AbstractHttpConnection;
import org.xlightweb.HttpUtils;
import org.xlightweb.IHttpCache;
import org.xlightweb.IHttpExchange;
import org.xlightweb.IHttpRequest;
import org.xlightweb.IHttpResponse;
import org.xlightweb.IHttpResponseHandler;
import org.xlightweb.InvokeOn;
import org.xsocket.DataConverter;
import org.xsocket.Execution;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class HttpCache
implements IHttpCache {
    private static final Logger LOG = Logger.getLogger(HttpCache.class.getName());
    private static final long TIMERTASK_PERIOD_MILLIS = Long.parseLong(System.getProperty("org.xlightweb.httpchache.checkperiodMillis", "60000"));
    private final TimerTask timerTask;
    private final Cache cache = new Cache();
    private boolean isSharedCache = true;

    public HttpCache() {
        this.timerTask = new TimerTask(){

            public void run() {
                HttpCache.this.cache.periodicChecks();
            }
        };
        AbstractHttpConnection.schedule(this.timerTask, TIMERTASK_PERIOD_MILLIS, TIMERTASK_PERIOD_MILLIS);
    }

    @Override
    public void setSharedCache(boolean isSharedCache) {
        this.isSharedCache = isSharedCache;
        this.cache.clear();
    }

    @Override
    public boolean isSharedCache() {
        return this.isSharedCache;
    }

    @Override
    public void setMaxSizeKB(int sizeBytesKB) {
        this.cache.setMaxSizeBytes(sizeBytesKB * 1024);
    }

    @Override
    public int getMaxSizeKB() {
        int size = this.cache.getMaxSizeBytes();
        if (size > 0) {
            size /= 1024;
        }
        return size;
    }

    @Override
    public int getMaxSizeCacheEntry() {
        return this.cache.getMaxSizeCacheEntry();
    }

    @Override
    public int getCurrentSize() {
        return this.cache.getCurrentSize();
    }

    @Override
    public Collection<IHttpCache.ICacheEntry> getEntries() {
        return this.cache.getEntries();
    }

    @Override
    public void close() throws IOException {
        this.cache.close();
        this.timerTask.cancel();
    }

    public static boolean isCacheable(IHttpRequest request, boolean isSharedCache) {
        try {
            if (isSharedCache && request.isSecure()) {
                return false;
            }
            if (!request.getProtocolVersion().equals("1.1")) {
                return false;
            }
            if (isSharedCache && request.getHeader("Authorization") != null) {
                return false;
            }
            if (isSharedCache && request.getHeader("Cookie") != null) {
                return false;
            }
            if (!request.getMethod().equalsIgnoreCase("GET")) {
                return false;
            }
            return request.getHeader("If-None-Match") == null && request.getHeader("If-Modified-Since") == null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isCacheable(IHttpResponse response, boolean isSharedCache) {
        try {
            String cacheControl;
            if (!HttpCache.isCacheableSuccess(response.getStatus()) && !HttpCache.isCacheableRedirect(response.getStatus())) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("non-cacheable response received (status: " + response.getStatus() + ")");
                }
                return false;
            }
            if (!response.getProtocolVersion().equals("1.0") && !response.getProtocolVersion().equals("1.1")) {
                return false;
            }
            String pragmaHeader = response.getHeader("Pragma");
            if (pragmaHeader != null && pragmaHeader.equalsIgnoreCase("no-cache")) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("non-cacheable response received (Pragma: no-cache)");
                }
                return false;
            }
            if (response.getHeader("Set-Cookie") != null) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("non-cacheable response received (Set-Cookie)");
                }
                return false;
            }
            String expires = response.getHeader("Expires");
            if (expires != null) {
                Date date = HttpUtils.parseHttpDateString(expires);
                if (date == null) {
                    return false;
                }
                if (date.getTime() < System.currentTimeMillis()) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("non-cacheable response received (Expires: " + expires + ")");
                    }
                    return false;
                }
            }
            if ((cacheControl = response.getHeader("Cache-Control")) != null) {
                for (String directive : cacheControl.split(",")) {
                    if ((directive = directive.trim()).equalsIgnoreCase("no-cache") || directive.equalsIgnoreCase("no-store")) {
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.fine("non-cacheable response received (Cache-Control: " + cacheControl + ")");
                        }
                        return false;
                    }
                    if (!isSharedCache || !directive.equalsIgnoreCase("private")) continue;
                    return false;
                }
            }
            if (response.getHeader("Vary") != null) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("non-cacheable response received (includes Vary header)");
                }
                return false;
            }
            return !HttpUtils.hasContentType(response.getPartHeader(), "text/event-stream");
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean isCacheableSuccess(int statusCode) {
        return statusCode >= 200 && statusCode <= 201;
    }

    private static boolean isCacheableRedirect(int statusCode) {
        return statusCode >= 301 && statusCode <= 302;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IHttpCache.ICacheEntry get(IHttpRequest request, Date minFresh) throws IOException {
        IHttpCache.ICacheEntry ce = null;
        HttpCache httpCache = this;
        synchronized (httpCache) {
            ce = this.cache.getEntry(request);
        }
        if (ce != null) {
            if (ce.isExpired(minFresh)) {
                return null;
            }
            return ce;
        }
        return null;
    }

    private IHttpCache.ICacheEntry newCacheEntry(IHttpRequest request, long networkLatency, IHttpResponse response) {
        block9: {
            try {
                String cacheControl = response.getHeader("Cache-Control");
                if (cacheControl != null) {
                    CacheControlBasedCacheEntry cacheEntry = new CacheControlBasedCacheEntry(request, response, networkLatency, cacheControl, this.isSharedCache);
                    if (cacheEntry.isExpired(new Date())) {
                        return null;
                    }
                    return cacheEntry;
                }
                String expire = response.getHeader("Expires");
                if (expire != null) {
                    ExpiresBasedCacheEntry cacheEntry = new ExpiresBasedCacheEntry(request, response, networkLatency, expire);
                    if (cacheEntry.isExpired(new Date())) {
                        return null;
                    }
                    return cacheEntry;
                }
                String eTag = response.getHeader("ETag");
                String lastModified = response.getHeader("Last-Modified");
                if (eTag != null || lastModified != null) {
                    ValidationBasedCacheEntry cacheEntry = new ValidationBasedCacheEntry(request, response);
                    if (cacheEntry.isExpired(new Date())) {
                        return null;
                    }
                    return cacheEntry;
                }
                if (response.getStatus() == 301) {
                    return new ExpiresBasedCacheEntry(request, response, new Date(System.currentTimeMillis() + 2592000000L));
                }
            }
            catch (Exception e) {
                if (!LOG.isLoggable(Level.FINE)) break block9;
                LOG.fine("error occured by checking if cacheable" + e.toString());
            }
        }
        return null;
    }

    @Override
    public void register(IHttpRequest request, long networkLatency, IHttpResponse response) throws IOException {
        IHttpCache.ICacheEntry ce = this.newCacheEntry(request, networkLatency, response);
        this.register(ce);
    }

    private void register(IHttpCache.ICacheEntry ce) throws IOException {
        if (ce == null) {
            return;
        }
        this.cache.putEntry(ce);
    }

    @Override
    public void deregister(IHttpRequest request) throws IOException {
        this.cache.removeEntry(request);
    }

    public String toString() {
        return this.cache.toString();
    }

    private static Date computeExpireDate(String expire, long networkLatency) {
        if (HttpUtils.parseHttpDateString(expire).getTime() - networkLatency > 0L) {
            return new Date(HttpUtils.parseHttpDateString(expire).getTime() - networkLatency);
        }
        return new Date(0L);
    }

    private static final class DummyCacheEntry
    implements IHttpCache.ICacheEntry {
        private final int size;

        public DummyCacheEntry(int size) {
            this.size = size;
        }

        public int getSize() {
            return this.size;
        }

        public long getAgeMillis() {
            return 0L;
        }

        public IHttpRequest getRequest() {
            return null;
        }

        public IHttpResponse getResponse() {
            return null;
        }

        public String getType() {
            return null;
        }

        public boolean isAfter(Date data) {
            return false;
        }

        public boolean isExpired(Date currentDate) {
            return false;
        }

        public boolean mustRevalidate(Date currentDate) {
            return false;
        }

        public IHttpResponse newResponse() throws IOException {
            return null;
        }

        public void revalidate(IHttpExchange exchange, IValidationHandler hdl) throws IOException {
        }
    }

    private final class ValidationBasedCacheEntry
    extends AbstractCacheEntry {
        public ValidationBasedCacheEntry(IHttpRequest request, IHttpResponse response) throws IOException {
            super(request, response);
        }

        public String getType() {
            StringBuilder sb = new StringBuilder("ValidationBased -");
            if (this.getResponse().getHeader("Etag") != null) {
                sb.append(" Etag");
            }
            if (this.getResponse().getHeader("Last-Modified") != null) {
                sb.append(" Last-Modified");
            }
            return sb.toString();
        }

        public boolean isExpired(Date currentDate) {
            return false;
        }

        public boolean mustRevalidate(Date currentDate) {
            return true;
        }

        void enhanceCachedResponse(IHttpResponse response) {
        }

        public void revalidate(IHttpExchange exchange, final IValidationHandler hdl) throws IOException {
            IHttpRequest requestCopy = HttpUtils.copy(this.getRequest());
            if (this.getResponse().getHeader("Etag") != null) {
                requestCopy.setHeader("IF-None-Match", this.getResponse().getHeader("Etag"));
            } else {
                requestCopy.setHeader("If-Modified-Since", this.getResponse().getHeader("Last-Modified"));
            }
            requestCopy.setAttribute("org.xlighhtweb.client.cachehandler.skipcachehandling", "true");
            IHttpResponseHandler respHdl = new IHttpResponseHandler(){

                @Execution(value=0)
                @InvokeOn(value=1)
                public void onResponse(IHttpResponse resp) throws IOException {
                    if (resp.getStatus() == 304) {
                        resp.removeHopByHopHeaders();
                        resp.removeHeader("Transfer-Encoding");
                        resp.removeHeader("Content-Length");
                        resp.removeHeader("Content-Type");
                        for (String headername : resp.getHeaderNameSet()) {
                            ValidationBasedCacheEntry.this.getResponse().removeHeader(headername);
                            for (String headervalue : resp.getHeaderList(headername)) {
                                ValidationBasedCacheEntry.this.getResponse().addHeader(headername, headervalue);
                            }
                        }
                        hdl.onRevalidated(true, ValidationBasedCacheEntry.this);
                    } else {
                        if (HttpCache.isCacheableSuccess(resp.getStatus())) {
                            ValidationBasedCacheEntry.this.setHttpResponse(resp);
                        } else {
                            HttpCache.this.deregister(ValidationBasedCacheEntry.this.getRequest());
                        }
                        hdl.onRevalidated(false, ValidationBasedCacheEntry.this);
                    }
                }

                public void onException(IOException ioe) throws IOException {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("got exception by revalidating " + ioe.toString());
                    }
                    HttpCache.this.deregister(ValidationBasedCacheEntry.this.getRequest());
                    hdl.onException(ioe);
                }
            };
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("revalidating request " + requestCopy.getRequestUrl().toString());
            }
            exchange.forward(requestCopy, respHdl);
        }
    }

    private final class CacheControlBasedCacheEntry
    extends AbstractCacheEntry {
        private Date expireDate;
        private final boolean isShared;

        public CacheControlBasedCacheEntry(IHttpRequest request, IHttpResponse response, long networkLatency, String cacheControl, boolean isShared) throws IOException {
            super(request, response);
            this.expireDate = new Date(0L);
            this.isShared = isShared;
            for (String directive : cacheControl.split(",")) {
                if ((directive = directive.trim()).equalsIgnoreCase("no-cache") || directive.equalsIgnoreCase("no-store")) {
                    this.expireDate = new Date(0L);
                    return;
                }
                if (isShared && directive.equalsIgnoreCase("private")) {
                    this.expireDate = new Date(0L);
                    return;
                }
                if (directive.toLowerCase().startsWith("max-age=")) {
                    long maxAgeMillis = Long.parseLong(directive.substring("max-age=".length(), directive.length())) * 1000L;
                    this.expireDate = maxAgeMillis - networkLatency > 0L ? new Date(System.currentTimeMillis() + (maxAgeMillis - networkLatency)) : new Date(0L);
                }
                if (!directive.equalsIgnoreCase("must-revalidate") && !directive.equalsIgnoreCase("proxy-revalidate")) continue;
                this.expireDate = new Date(0L);
            }
        }

        public String getType() {
            return "CacheControl - " + DataConverter.toFormatedDuration((long)(this.expireDate.getTime() - this.getCacheDate().getTime()));
        }

        void enhanceCachedResponse(IHttpResponse response) {
            String cacheControl = response.getHeader("Cache-Control");
            if (cacheControl != null) {
                StringBuilder sb = new StringBuilder();
                for (String entry : cacheControl.split(",")) {
                    entry = entry.trim();
                    if (this.isShared) {
                        if (entry.toLowerCase().startsWith("max-age=")) {
                            entry = "max-age=" + (this.expireDate.getTime() - System.currentTimeMillis()) / 1000L;
                        }
                    } else if (entry.toLowerCase().startsWith("s-maxage=")) {
                        entry = "s-maxage=" + (this.expireDate.getTime() - System.currentTimeMillis()) / 1000L;
                    }
                    sb.append(entry + ", ");
                }
                if (sb.length() > 0) {
                    sb.setLength(sb.length() - 2);
                }
                response.setHeader("Cache-Control", sb.toString());
            }
        }

        public boolean isExpired(Date currentDate) {
            return currentDate.after(this.expireDate);
        }

        public boolean mustRevalidate(Date currentDate) {
            return false;
        }

        public void revalidate(IHttpExchange exchange, IValidationHandler hdl) throws IOException {
            throw new IOException("illegal state");
        }
    }

    private final class ExpiresBasedCacheEntry
    extends AbstractCacheEntry {
        private final Date expireDate;

        public ExpiresBasedCacheEntry(IHttpRequest request, IHttpResponse response, long networkLatency, String expire) throws IOException {
            this(request, response, HttpCache.computeExpireDate(expire, networkLatency));
        }

        public ExpiresBasedCacheEntry(IHttpRequest request, IHttpResponse response, Date expireDate) throws IOException {
            super(request, response);
            this.expireDate = expireDate;
        }

        public String getType() {
            return "ExpiredBased - " + DataConverter.toFormatedDuration((long)(this.expireDate.getTime() - this.getCacheDate().getTime()));
        }

        void enhanceCachedResponse(IHttpResponse response) {
        }

        public boolean isExpired(Date currentDate) {
            return currentDate.after(this.expireDate);
        }

        public boolean mustRevalidate(Date currentDate) {
            return false;
        }

        public void revalidate(IHttpExchange exchange, IValidationHandler hdl) throws IOException {
            throw new IOException("illegal state");
        }
    }

    abstract class AbstractCacheEntry
    implements IHttpCache.ICacheEntry {
        private final Date cacheDate = new Date();
        private final IHttpRequest request;
        private final int sizeRequest;
        private IHttpResponse response;
        private int sizeResponse;

        public AbstractCacheEntry(IHttpRequest request, IHttpResponse response) throws IOException {
            this.request = request;
            int i = request.getRequestHeader().toString().length();
            if (request.hasBody()) {
                i += request.getNonBlockingBody().available();
            }
            this.sizeRequest = i;
            this.setHttpResponse(response);
        }

        public final IHttpRequest getRequest() {
            return this.request;
        }

        public final IHttpResponse getResponse() {
            return this.response;
        }

        public final void setHttpResponse(IHttpResponse response) throws IOException {
            this.response = response;
            int i = response.getResponseHeader().toString().length();
            if (response.hasBody()) {
                i += response.getNonBlockingBody().available();
            }
            this.sizeResponse = i;
        }

        public final int getSize() {
            return this.sizeRequest + this.sizeResponse;
        }

        public final Date getCacheDate() {
            return this.cacheDate;
        }

        public final long getAgeMillis() {
            return System.currentTimeMillis() - this.getCacheDate().getTime();
        }

        public final boolean isAfter(Date date) {
            if (date == null) {
                return false;
            }
            return date.after(this.cacheDate);
        }

        public final IHttpResponse newResponse() throws IOException {
            IHttpResponse response = HttpUtils.copy(this.getResponse());
            this.enhanceCachedResponse(response);
            return response;
        }

        public String toString() {
            return this.getRequest().getRequestUrl().toString() + " - " + this.getResponse().getStatus() + " (" + this.getType() + ", size: " + DataConverter.toFormatedBytesSize((long)this.getSize()) + ", age: " + DataConverter.toFormatedDuration((long)this.getAgeMillis()) + ")";
        }

        abstract void enhanceCachedResponse(IHttpResponse var1);
    }

    static interface IValidationHandler {
        public void onRevalidated(boolean var1, AbstractCacheEntry var2);

        public void onException(IOException var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Cache
    extends LinkedHashMap<String, IHttpCache.ICacheEntry> {
        private static final long serialVersionUID = -4920963130585126603L;
        private static final IHttpCache.ICacheEntry DUMMY_CACHE_ENTRY = new DummyCacheEntry(5000);
        private static final String SEPARATOR = "*";
        private static final int DEFAULT_ENTRY_SIZE_THRESHOLD_PERCENT = 10;
        private int entrySizeThresholdPercent = 10;
        private int currentSize = 0;
        private int maxSize = 0;

        private Cache() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized IHttpCache.ICacheEntry putEntry(IHttpCache.ICacheEntry entry) throws IOException {
            assert (entry.getRequest().getMethod().equalsIgnoreCase("GET"));
            int size = entry.getSize();
            if (size > this.getMaxSizeCacheEntry()) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("entry " + entry.getRequest().getRequestUrl().toString() + " will not be cached (is to large: " + entry.getSize() + " bytes; supproted max entry size: " + this.getMaxSizeCacheEntry() + " bytes)");
                }
                return null;
            }
            IHttpCache.ICacheEntry removed = super.put(this.computeFingerprint(entry.getRequest()), entry);
            this.currentSize += size;
            while (this.currentSize > this.maxSize) {
                try {
                    IHttpCache.ICacheEntry rem = super.put("DUMMY_ENTRY", DUMMY_CACHE_ENTRY);
                    if (rem == null) continue;
                    break;
                }
                finally {
                    super.remove("DUMMY_ENTRY");
                }
            }
            return removed;
        }

        public synchronized IHttpCache.ICacheEntry getEntry(IHttpRequest request) throws IOException {
            return (IHttpCache.ICacheEntry)super.get(this.computeFingerprint(request));
        }

        public synchronized IHttpCache.ICacheEntry removeEntry(IHttpRequest request) throws IOException {
            IHttpCache.ICacheEntry removed = (IHttpCache.ICacheEntry)super.remove(this.computeFingerprint(request));
            if (removed != null) {
                this.currentSize -= removed.getSize();
            }
            return removed;
        }

        public void setMaxSizeBytes(int sizeBytes) {
            this.maxSize = sizeBytes;
        }

        public int getMaxSizeBytes() {
            return this.maxSize;
        }

        int getMaxSizeCacheEntry() {
            return this.maxSize / this.entrySizeThresholdPercent;
        }

        public synchronized int getCurrentSize() {
            return this.currentSize;
        }

        private synchronized void setCurrentSize(int currentSize) {
            this.currentSize = currentSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, IHttpCache.ICacheEntry> eldest) {
            if (this.currentSize > this.maxSize) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("removing eldest entry (current size " + this.currentSize + " is larger than max size " + this.maxSize + ")");
                }
                this.currentSize -= eldest.getValue().getSize();
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Collection<IHttpCache.ICacheEntry> getEntries() {
            LinkedHashMap copy;
            Cache cache = this;
            synchronized (cache) {
                copy = (LinkedHashMap)super.clone();
            }
            return copy.values();
        }

        public synchronized void close() throws IOException {
            this.clear();
        }

        private String computeFingerprint(IHttpRequest request) throws IOException {
            StringBuilder sb = new StringBuilder(request.getRequestUrl().toString());
            ArrayList<String> headers = new ArrayList<String>(request.getHeaderNameSet());
            Collections.sort(headers);
            for (String header : headers) {
                if (header.equalsIgnoreCase("User-Agent") || header.equalsIgnoreCase("Referer") || header.equalsIgnoreCase("Cache-Control") || header.equalsIgnoreCase("Connection") || header.equalsIgnoreCase("Keep-Alive") || header.equalsIgnoreCase("Proxy-Authenticate") || header.equalsIgnoreCase("Proxy-Authorization") || header.equalsIgnoreCase("TE")) continue;
                sb.append(header + SEPARATOR);
                for (String value : request.getHeaderList(header)) {
                    sb.append(value + SEPARATOR);
                }
            }
            if (request.hasBody()) {
                sb.append(request.getNonBlockingBody().toString());
            }
            return sb.toString();
        }

        void periodicChecks() {
            Date currentDate = new Date();
            int size = 0;
            for (IHttpCache.ICacheEntry cacheEntry : this.getEntries()) {
                try {
                    if (cacheEntry.isExpired(currentDate)) {
                        this.removeEntry(cacheEntry.getRequest());
                        continue;
                    }
                    size += cacheEntry.getSize();
                }
                catch (IOException ioe) {
                    if (!LOG.isLoggable(Level.FINE)) continue;
                    LOG.fine("could not vaildate/remove cache entry " + cacheEntry.getRequest().getRequestUrl().toString() + " " + ioe.toString());
                }
            }
            this.setCurrentSize(size);
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (IHttpCache.ICacheEntry entry : this.getEntries()) {
                sb.append(entry.toString() + "\r\n");
            }
            return sb.toString();
        }
    }
}

