/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb;

import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xlightweb.IFutureResponse;
import org.xlightweb.IHttpResponse;
import org.xlightweb.IHttpResponseHandler;
import org.xlightweb.IHttpSocketTimeoutHandler;
import org.xlightweb.IUnsynchronized;
import org.xlightweb.InvokeOn;
import org.xsocket.DataConverter;

@InvokeOn(value=0)
public class FutureResponseHandler
implements IFutureResponse,
IHttpResponseHandler,
IHttpSocketTimeoutHandler,
IUnsynchronized {
    private static final Logger LOG = Logger.getLogger(FutureResponseHandler.class.getName());
    private final Object readLock = new Object();
    private boolean isDone = false;
    private boolean isCancelled = false;
    private IHttpResponse response;
    private IOException ioException;
    private SocketTimeoutException stException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onResponse(IHttpResponse response) throws IOException {
        Object object = this.readLock;
        synchronized (object) {
            this.isDone = true;
            this.response = response;
            this.readLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onException(IOException ioe) throws IOException {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Exception occured. notify witing reader. " + ioe.toString());
        }
        Object object = this.readLock;
        synchronized (object) {
            this.isDone = true;
            this.ioException = ioe;
            this.readLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onException(SocketTimeoutException stoe) {
        Object object = this.readLock;
        synchronized (object) {
            this.isDone = true;
            this.stException = stoe;
            this.readLock.notifyAll();
        }
    }

    public IHttpResponse getResponse() throws IOException, InterruptedException, SocketTimeoutException {
        return this.getResponse(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
    }

    public IHttpResponse getResponse(long timeout, TimeUnit unit) throws IOException, SocketTimeoutException {
        long waittime = unit.toMillis(timeout);
        long maxTime = System.currentTimeMillis() + waittime;
        Object object = this.readLock;
        synchronized (object) {
            do {
                if (!this.isDone) {
                    try {
                        this.readLock.wait(waittime);
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                    }
                }
                if (this.isCancelled) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("request is cancelled. throwing io exception");
                    }
                    throw new IOException("receiving the response is interrupted");
                }
                if (this.stException != null) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("throwing socket timeout exception " + this.stException.toString());
                    }
                    throw this.stException;
                }
                if (this.ioException != null) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("throwing io exception " + this.ioException.toString());
                    }
                    throw this.ioException;
                }
                if (this.response == null) continue;
                return this.response;
            } while ((waittime = maxTime - System.currentTimeMillis()) > 0L);
            this.isDone = true;
            throw new SocketTimeoutException("receive timeout " + DataConverter.toFormatedDuration((long)unit.toMillis(timeout)) + " reached");
        }
    }

    public IHttpResponse get() throws InterruptedException, ExecutionException {
        try {
            return this.getResponse();
        }
        catch (IOException ioe) {
            throw new ExecutionException(ioe.toString(), ioe);
        }
    }

    public IHttpResponse get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        try {
            return this.getResponse(timeout, unit);
        }
        catch (SocketTimeoutException stoe) {
            throw new TimeoutException(stoe.toString());
        }
        catch (IOException ioe) {
            throw new ExecutionException(ioe.toString(), ioe);
        }
    }

    public boolean isDone() {
        return this.isDone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancel(boolean mayInterruptIfRunning) {
        Object object = this.readLock;
        synchronized (object) {
            if (!this.isDone) {
                this.isCancelled = true;
                this.isDone = true;
                this.readLock.notifyAll();
                return true;
            }
            return false;
        }
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }
}

