/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xlightweb.AbstractHttpConnection;
import org.xlightweb.AbstractNetworkBodyDataSink;
import org.xlightweb.HttpUtils;
import org.xlightweb.IHttpMessageHeader;
import org.xlightweb.ProtocolException;
import org.xsocket.DataConverter;
import org.xsocket.MaxWriteSizeExceededException;
import org.xsocket.connection.IWriteCompletionHandler;

final class FullMessageBodyDataSink
extends AbstractNetworkBodyDataSink {
    private static final Logger LOG = Logger.getLogger(FullMessageBodyDataSink.class.getName());
    private final int contentLength;
    private int remaining = 0;
    private boolean isHeaderWritten = false;

    public FullMessageBodyDataSink(AbstractHttpConnection httpConnection, IHttpMessageHeader header, int contentLength) throws IOException {
        super(header, httpConnection);
        this.contentLength = contentLength;
        this.remaining = contentLength;
    }

    int getSizeWritten() {
        return this.contentLength - this.remaining;
    }

    int onWriteNetworkData(ByteBuffer[] dataToWrite, IWriteCompletionHandler completionHandler) throws IOException {
        if (this.remaining <= 0) {
            return 0;
        }
        int bodyWritten = 0;
        AbstractHttpConnection con = this.getConnection();
        if (con != null) {
            try {
                int dataWritten = 0;
                if (!this.isHeaderWritten) {
                    this.isHeaderWritten = true;
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("[" + this.getId() + "] writing header and body");
                    }
                    dataWritten = con.write(this.getHeader().toString() + "\r\n");
                    bodyWritten = this.writeBody(con, dataToWrite, completionHandler);
                    dataWritten += bodyWritten;
                    con.incCountMessageSent();
                } else {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("[" + this.getId() + "] writing body (header is already written)");
                    }
                    dataWritten = bodyWritten = this.writeBody(con, dataToWrite, completionHandler);
                }
                if (dataWritten > 0) {
                    con.flush();
                }
            }
            catch (IOException ioe) {
                if (this.isIgnoreWriteError()) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("[" + this.getId() + "] error occured by flushing bound data sink. Ignoring error (ignoreWriteError=true) " + DataConverter.toString((Throwable)ioe));
                    }
                    if (completionHandler != null) {
                        completionHandler.onWritten(dataToWrite.length);
                    }
                }
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + this.getId() + "] error occured by flushing bound data sink (data: " + DataConverter.toString((ByteBuffer[])dataToWrite) + "). Destroying connection. reason " + DataConverter.toString((Throwable)ioe));
                }
                this.destroy();
                throw ioe;
            }
        }
        return bodyWritten;
    }

    private int writeBody(AbstractHttpConnection con, ByteBuffer[] bodyData, IWriteCompletionHandler completionHandler) throws IOException {
        int written = 0;
        if (HttpUtils.isEmpty(bodyData)) {
            if (completionHandler != null) {
                completionHandler.onWritten(0);
            }
        } else {
            written = (int)con.write(bodyData, completionHandler);
        }
        this.remaining -= written;
        if (this.remaining == 0) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + this.getId() + "] full size written. Closing data sink");
            }
            this.close();
        } else if (this.remaining < 0) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("ERROR: try to write more data " + written + " than declared (" + this.contentLength + ") throwing exception");
            }
            throw new MaxWriteSizeExceededException();
        }
        return written;
    }

    void performDestroy() throws ProtocolException {
        if (this.remaining > 0) {
            throw new ProtocolException("destroying data sink. Not all data (FullMessage) is written. only " + (this.contentLength - this.remaining) + " bytes of " + this.contentLength + " have been send", this.getHeader());
        }
    }

    void performClose() throws ProtocolException {
        if (this.remaining > 0) {
            throw new ProtocolException("illegal close of (FullMessage) data sink. only " + (this.contentLength - this.remaining) + " bytes of " + this.contentLength + " have been send. connection will be destroyed", this.getHeader());
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("[" + this.getId() + "] " + DataConverter.toFormatedBytesSize((long)this.getSizeWritten()) + " body data written");
        }
    }

    public String toString() {
        return super.toString() + " (contentLength=" + this.contentLength + ", written=" + this.getSizeWritten() + ")";
    }
}

