/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xlightweb.AbstractHttpConnection;
import org.xlightweb.BodyDataSink;
import org.xlightweb.HttpUtils;
import org.xlightweb.IBodyCompleteListener;
import org.xlightweb.IForwardable;
import org.xlightweb.IHeader;
import org.xlightweb.NonBlockingBodyDataSource;
import org.xsocket.DataConverter;
import org.xsocket.Execution;
import org.xsocket.connection.IConnection;
import org.xsocket.connection.IWriteCompletionHandler;

final class FileDataSource
extends NonBlockingBodyDataSource
implements IForwardable {
    private final File file;
    private final long length;
    private final String range;

    FileDataSource(IHeader header, AbstractHttpConnection.IMultimodeExecutor executor, File file) throws IOException {
        this(header, executor, file, null);
    }

    FileDataSource(IHeader header, AbstractHttpConnection.IMultimodeExecutor executor, File file, String range) throws IOException {
        super(header, executor);
        this.file = file;
        this.range = range;
        this.length = file.length();
    }

    long getLength() {
        return this.length;
    }

    public void forwardTo(BodyDataSink bodyDataSink) throws IOException {
        this.forwardTo(bodyDataSink, null);
    }

    public void forwardTo(BodyDataSink bodyDataSink, IBodyCompleteListener completeListener) throws IOException {
        FileSender sendFile = new FileSender(bodyDataSink.getId(), bodyDataSink, this.file, this.range, completeListener);
        sendFile.run();
    }

    File getFile() {
        return this.file;
    }

    boolean isForwardable() {
        return true;
    }

    protected boolean isNetworkendpoint() {
        return false;
    }

    String getId() {
        return Integer.toString(this.hashCode());
    }

    boolean suspend() throws IOException {
        return false;
    }

    boolean resume() throws IOException {
        return false;
    }

    void onClose() {
    }

    void onDestroy(String reason) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder sb = new StringBuilder();
        FileInputStream is = null;
        try {
            is = new FileInputStream(this.file);
            byte[] data = new byte[(int)this.getLength()];
            int read = ((InputStream)is).read(data);
            sb.append(DataConverter.toString((ByteBuffer)DataConverter.toByteBuffer((byte[])data, (int)0, (int)read), (String)this.getEncoding()));
        }
        catch (IOException ignore) {
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException ignore) {}
            }
        }
        return sb.toString();
    }

    @Execution(value=1)
    static class FileSender
    implements Runnable,
    IWriteCompletionHandler {
        private static final Logger LOG = Logger.getLogger(FileSender.class.getName());
        static final int TRANSFER_BYTE_BUFFER_MAX_MAP_SIZE = Integer.parseInt(System.getProperty("org.xsocket.connection.transfer.mappedbytebuffer.maxsize", "65536"));
        private final String id;
        private final File file;
        private final RandomAccessFile raf;
        private final FileChannel fc;
        private final BodyDataSink dataSink;
        private final IBodyCompleteListener completeListener;
        private boolean isOpen = true;
        private long length = 0L;
        private final AtomicLong remaining = new AtomicLong(0L);
        private final AtomicLong offset = new AtomicLong(0L);

        public FileSender(String id, BodyDataSink dataSink, File file, String range, IBodyCompleteListener completeListener) throws IOException {
            if (!file.exists()) {
                throw new IOException("file " + file.getAbsolutePath() + " does not exist");
            }
            this.id = id;
            this.file = file;
            this.completeListener = completeListener;
            this.raf = new RandomAccessFile(file, "r");
            this.fc = this.raf.getChannel();
            this.dataSink = dataSink;
            dataSink.setFlushmode(IConnection.FlushMode.ASYNC);
            if (range != null) {
                int[] positions = HttpUtils.computeFromRangePosition(range, (int)file.length());
                this.offset.set(positions[0]);
                this.remaining.set(positions[1] - positions[0] + 1);
            } else {
                this.offset.set(0L);
                this.remaining.set(file.length());
            }
        }

        final String getAbsolutePath() {
            return this.file.getAbsolutePath();
        }

        public final void run() {
            try {
                this.write();
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }

        public final void onWritten(int written) throws IOException {
            if (LOG.isLoggable(Level.FINE)) {
                if (this.remaining.get() > 0L) {
                    LOG.fine("[" + this.id + "] data (size=" + written + " bytes) has been written. Writing next chunk");
                } else {
                    LOG.fine("[" + this.id + "] data (size=" + written + " bytes) has been written.");
                }
            }
            this.write();
        }

        private void write() throws IOException {
            if (this.remaining.get() > 0L) {
                this.length = this.remaining.get() > (long)TRANSFER_BYTE_BUFFER_MAX_MAP_SIZE ? (long)TRANSFER_BYTE_BUFFER_MAX_MAP_SIZE : this.remaining.get();
                MappedByteBuffer buffer = this.fc.map(FileChannel.MapMode.READ_ONLY, this.offset.get(), this.length);
                ByteBuffer[] bufs = new ByteBuffer[]{buffer};
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + this.id + "] writing data (size=" + this.length + " bytes)");
                }
                this.offset.addAndGet(this.length);
                this.remaining.set(this.remaining.get() - this.length);
                this.doWrite(bufs);
            } else if (this.isOpen) {
                this.isOpen = false;
                this.closeFile();
                if (this.completeListener == null) {
                    this.dataSink.close();
                } else {
                    this.completeListener.onComplete();
                }
            }
        }

        void doWrite(ByteBuffer[] bufs) throws IOException {
            this.dataSink.write(bufs, this);
        }

        public final void onException(IOException ioe) {
            if (this.isOpen) {
                this.isOpen = false;
                this.closeFile();
            }
            this.dataSink.destroy();
        }

        void closeFile() {
            block2: {
                try {
                    this.fc.close();
                    this.raf.close();
                }
                catch (IOException ioe) {
                    if (!LOG.isLoggable(Level.FINE)) break block2;
                    LOG.fine("error occured by closing file channel " + this.getAbsolutePath() + " " + ioe.toString());
                }
            }
        }
    }
}

