/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb;

import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ContentType {
    private String contentTypeString = null;
    private String primaryType = "";
    private String subType = "";
    private String parameterString = null;
    private Map<String, String> parameters = null;

    public ContentType(String contentTypeString) {
        int idx;
        contentTypeString = contentTypeString.trim();
        if (contentTypeString.endsWith(";")) {
            contentTypeString = contentTypeString.substring(0, contentTypeString.length() - 1);
        }
        if ((idx = contentTypeString.indexOf(";")) == -1) {
            this.parseType(contentTypeString);
        } else {
            this.parseType(contentTypeString.substring(0, idx));
            this.parameterString = contentTypeString.substring(idx + 1, contentTypeString.length());
        }
    }

    public ContentType(String primaryType, String subType) {
        this.primaryType = primaryType;
        this.subType = subType;
    }

    public ContentType(String primaryType, String subType, String parameterName, String parameterValue) {
        this(primaryType, subType);
        this.setParameter(parameterName, parameterValue);
    }

    private void parseType(String type) {
        int idx = type.indexOf("/");
        if (idx == -1) {
            this.primaryType = type.trim();
        } else {
            this.primaryType = type.substring(0, idx).trim();
            this.subType = type.substring(idx + 1, type.length()).trim();
        }
    }

    public String getPrimaryType() {
        return this.primaryType;
    }

    public void setPrimaryType(String primaryType) {
        this.primaryType = primaryType;
        this.contentTypeString = null;
    }

    public String getSubType() {
        return this.subType;
    }

    public void setSubType(String subType) {
        this.subType = subType;
        this.contentTypeString = null;
    }

    public String getParameter(String name) {
        return this.getParameterMap().get(name);
    }

    public void setParameter(String name, String value) {
        this.getParameterMap().put(name, value);
        this.contentTypeString = null;
    }

    private synchronized Map<String, String> getParameterMap() {
        if (this.parameters == null) {
            this.parameters = new HashMap<String, String>();
            if (this.parameterString != null) {
                String[] ps;
                for (String p : ps = this.parameterString.split(";")) {
                    String[] kvp = p.split("=");
                    if (kvp.length == 2) {
                        this.parameters.put(kvp[0], kvp[1]);
                        continue;
                    }
                    this.parameters.put(kvp[0], "");
                }
            }
        }
        return this.parameters;
    }

    public boolean equalsIgnoreParameters(Object other) {
        if (other instanceof ContentType) {
            ContentType otherContentType = (ContentType)other;
            return otherContentType.getPrimaryType().equals(this.getPrimaryType()) && otherContentType.getSubType().equals(this.getSubType());
        }
        return false;
    }

    public boolean equals(Object other) {
        if (other instanceof ContentType) {
            ContentType otherContentType = (ContentType)other;
            return otherContentType.toString().equals(this.toString());
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        if (this.contentTypeString == null) {
            this.contentTypeString = this.getPrimaryType() + "/" + this.getSubType();
            for (Map.Entry<String, String> entry : this.getParameterMap().entrySet()) {
                this.contentTypeString = this.contentTypeString + ";" + entry.getKey() + "=" + entry.getValue() + " ";
            }
        }
        return this.contentTypeString;
    }
}

