/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.xlightweb.IWriteCompleteHandler;
import org.xlightweb.WebSocketConnection;
import org.xlightweb.WebSocketMessage;
import org.xlightweb.WebSocketMessageCompleteHandlerAdapter;
import org.xsocket.connection.ConnectionUtils;
import org.xsocket.connection.IConnection;
import org.xsocket.connection.IWriteCompletionHandler;

final class CloseMessage
extends WebSocketMessage {
    private static final byte START_BYTE_CLOSEFRAME = -1;
    private static final byte END_BYTE = 0;
    private static final byte[] CLOSE_FRAME = new byte[]{-1, 0};

    public CloseMessage() {
        super(null, null);
    }

    boolean isCloseMessage() {
        return true;
    }

    int writeTo(WebSocketConnection connection, IWriteCompleteHandler completeHandler) throws IOException {
        if (completeHandler == null && !ConnectionUtils.isDispatcherThread()) {
            connection.getUnderlyingTcpConnection().setFlushmode(IConnection.FlushMode.SYNC);
        } else {
            connection.getUnderlyingTcpConnection().setFlushmode(IConnection.FlushMode.ASYNC);
        }
        if (completeHandler == null) {
            connection.getUnderlyingTcpConnection().write(CLOSE_FRAME);
        } else {
            connection.getUnderlyingTcpConnection().write(CLOSE_FRAME, (IWriteCompletionHandler)new WebSocketMessageCompleteHandlerAdapter(connection, completeHandler));
        }
        connection.getUnderlyingTcpConnection().flush();
        return 2;
    }

    static CloseMessage parse(ByteBuffer buffer) throws IOException {
        int savePos = buffer.position();
        int saveLimit = buffer.limit();
        while (buffer.hasRemaining()) {
            byte b = buffer.get();
            if ((b & 0) != 0) continue;
            int pos = buffer.position();
            buffer.limit(buffer.position() - 1);
            buffer.position(savePos);
            buffer.slice();
            buffer.limit(saveLimit);
            buffer.position(pos);
            return new CloseMessage();
        }
        buffer.position(savePos);
        buffer.limit(saveLimit);
        return null;
    }

    static boolean isCloseMessage(byte startByte) {
        return startByte == -1;
    }
}

