/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xlightweb.AbstractHttpConnection;
import org.xlightweb.AbstractNetworkBodyDataSink;
import org.xlightweb.IHttpMessageHeader;
import org.xsocket.DataConverter;
import org.xsocket.connection.IWriteCompletionHandler;

final class BodylessBodyDataSink
extends AbstractNetworkBodyDataSink {
    private static final Logger LOG = Logger.getLogger(BodylessBodyDataSink.class.getName());
    private boolean isHeaderWritten = false;

    public BodylessBodyDataSink(AbstractHttpConnection httpConnection, IHttpMessageHeader header) throws IOException {
        super(header, httpConnection);
    }

    int onWriteNetworkData(ByteBuffer[] dataToWrite, IWriteCompletionHandler completionHandler) throws IOException {
        if (completionHandler != null) {
            completionHandler.onWritten(0);
        }
        return 0;
    }

    void performClose() throws IOException {
        AbstractHttpConnection con = this.getConnection();
        if (con != null) {
            try {
                if (!this.isHeaderWritten) {
                    this.isHeaderWritten = true;
                    con.write(this.getHeader().toString() + "\r\n");
                    con.flush();
                    con.incCountMessageSent();
                }
            }
            catch (IOException ioe) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + this.getId() + "] error occured by flushing bodyless message writer. Destroying connection. reason " + DataConverter.toString((Throwable)ioe));
                }
                this.destroy();
                throw ioe;
            }
        }
    }

    void performDestroy() throws IOException {
    }
}

