/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import org.xlightweb.AbstractHttpConnection;
import org.xlightweb.BodyDataSinkImplBase;
import org.xlightweb.BodyDataSource;
import org.xlightweb.HttpUtils;
import org.xlightweb.IBodyCloseListener;
import org.xlightweb.IBodyCompleteListener;
import org.xlightweb.IBodyDestroyListener;
import org.xlightweb.IHeader;
import org.xlightweb.IPart;
import org.xlightweb.NonBlockingBodyDataSource;
import org.xsocket.DataConverter;
import org.xsocket.IDataSink;
import org.xsocket.IDestroyable;
import org.xsocket.connection.IConnection;
import org.xsocket.connection.IWriteCompletionHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BodyDataSink
implements IDataSink,
IDestroyable,
Flushable,
Closeable,
WritableByteChannel,
GatheringByteChannel {
    private static final int TRANSFER_CHUNK_SIZE = 65536;
    private final IHeader header;
    private Multipart multipart;

    BodyDataSink(IHeader header) {
        this.header = header;
    }

    public boolean isMultipart() {
        return this.header.getContentType() != null && this.header.getContentType().toLowerCase(Locale.US).startsWith("multipart");
    }

    final IHeader getHeader() {
        return this.header;
    }

    public abstract void setSendTimeoutMillis(long var1);

    @Override
    public abstract void flush() throws IOException;

    @Override
    public final void close() throws IOException {
        if (this.multipart != null) {
            this.multipart.close();
        } else {
            this.doClose();
        }
    }

    abstract void doClose() throws IOException;

    public abstract void closeQuitly();

    public abstract void write(ByteBuffer[] var1, IWriteCompletionHandler var2) throws IOException;

    @Override
    public abstract int write(ByteBuffer var1) throws IOException, BufferOverflowException;

    @Override
    public abstract long write(ByteBuffer[] var1) throws IOException, BufferOverflowException;

    public abstract long transferFrom(ReadableByteChannel var1, int var2) throws IOException, BufferOverflowException;

    public abstract long transferFrom(FileChannel var1) throws IOException, BufferOverflowException;

    public abstract long transferFrom(NonBlockingBodyDataSource var1) throws IOException;

    public abstract long transferFrom(NonBlockingBodyDataSource var1, int var2) throws IOException;

    public abstract long transferFrom(BodyDataSource var1) throws IOException;

    public abstract long transferFrom(BodyDataSource var1, int var2) throws IOException;

    public final long transferFrom(InputStream is) throws IOException {
        return this.transferFrom(Channels.newChannel(is));
    }

    public final long transferFrom(ReadableByteChannel source) throws IOException, BufferOverflowException {
        return this.transferFrom(source, 65536);
    }

    public final int write(byte b) throws IOException, BufferOverflowException {
        return this.write(new byte[]{b});
    }

    public final int write(byte ... bytes) throws IOException, BufferOverflowException {
        return this.write(ByteBuffer.wrap(bytes));
    }

    public final int write(byte[] bytes, int offset, int length) throws IOException, BufferOverflowException {
        return this.write(DataConverter.toByteBuffer((byte[])bytes, (int)offset, (int)length));
    }

    @Override
    public final long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        return this.write(DataConverter.toByteBuffers((ByteBuffer[])srcs, (int)offset, (int)length));
    }

    public final long write(List<ByteBuffer> buffers) throws IOException, BufferOverflowException {
        return this.write(buffers.toArray(new ByteBuffer[buffers.size()]));
    }

    public final int write(int i) throws IOException, BufferOverflowException {
        return this.write(DataConverter.toByteBuffer((int)i));
    }

    public final int write(short s) throws IOException, BufferOverflowException {
        return this.write(DataConverter.toByteBuffer((short)s));
    }

    public final int write(long l) throws IOException, BufferOverflowException {
        return this.write(DataConverter.toByteBuffer((long)l));
    }

    public final int write(double d) throws IOException, BufferOverflowException {
        return this.write(DataConverter.toByteBuffer((double)d));
    }

    public final int write(String message) throws IOException, BufferOverflowException {
        return this.write(DataConverter.toByteBuffer((String)message, (String)this.getEncoding()));
    }

    public final BodyDataSink writePart(IHeader partHeader) throws IOException, BufferOverflowException {
        if (this.multipart == null) {
            this.multipart = new Multipart();
        }
        return this.multipart.addPart(partHeader);
    }

    public final void writePart(IPart part) throws IOException, BufferOverflowException {
        NonBlockingBodyDataSource dataSource = part.getNonBlockingBody();
        BodyDataSink dataSink = this.writePart(part.getPartHeader());
        dataSource.forwardTo(dataSink, new BodyCompleteListener(dataSource, dataSink));
    }

    public abstract void setEncoding(String var1);

    public abstract String getEncoding();

    public abstract void setFlushmode(IConnection.FlushMode var1);

    public abstract IConnection.FlushMode getFlushmode();

    public abstract void setAutoflush(boolean var1);

    public abstract boolean isAutoflush();

    public abstract void markWritePosition();

    public abstract boolean resetToWriteMark();

    public abstract void removeWriteMark();

    public abstract void setAttachment(Object var1);

    public abstract Object getAttachment();

    @Override
    public abstract boolean isOpen();

    public abstract String getId();

    public abstract void destroy();

    public abstract void addDestroyListener(IBodyDestroyListener var1);

    abstract int getPendingWriteDataSize();

    abstract int getSizeWritten();

    abstract AbstractHttpConnection.IMultimodeExecutor getExecutor();

    abstract boolean isNetworkendpoint();

    abstract boolean isIgnoreWriteError();

    abstract void addCloseListener(IBodyCloseListener var1);

    void setAutocompressThreshold(int autocompressThreshold) {
    }

    private static final class PendingWrite {
        private ByteBuffer[] dataToWrite;
        private IWriteCompletionHandler completionHandler;

        public PendingWrite(ByteBuffer[] dataToWrite, IWriteCompletionHandler completionHandler) {
            this.dataToWrite = dataToWrite;
            this.completionHandler = completionHandler;
        }

        public ByteBuffer[] getDataToWrite() {
            return this.dataToWrite;
        }

        public IWriteCompletionHandler getCompletionHandler() {
            return this.completionHandler;
        }
    }

    private static final class BufferingPartBodyDataSink
    extends PartBodyDataSink {
        private boolean isActivated = false;
        private boolean isPendingClose = false;
        private final List<PendingWrite> pendingWrites = new ArrayList<PendingWrite>();

        public BufferingPartBodyDataSink(IHeader header, String boundary, Multipart multipart, AbstractHttpConnection.IMultimodeExecutor executor) throws IOException {
            super(header, boundary, multipart, executor);
        }

        synchronized void activate() throws IOException {
            this.isActivated = true;
            super.activate();
            if (!this.pendingWrites.isEmpty()) {
                for (PendingWrite pendingWrite : this.pendingWrites) {
                    this.onWriteData(pendingWrite.getDataToWrite(), pendingWrite.getCompletionHandler());
                }
                this.pendingWrites.clear();
            }
            if (this.isPendingClose) {
                this.onClose();
            }
        }

        synchronized void doClose() throws IOException {
            if (this.isActivated) {
                this.isPendingClose = false;
                super.onClose();
            } else {
                this.isPendingClose = true;
            }
        }

        synchronized void onClose() throws IOException {
        }

        synchronized int onWriteData(ByteBuffer[] dataToWrite, IWriteCompletionHandler completionHandler) throws IOException {
            if (this.isActivated) {
                return super.onWriteData(dataToWrite, completionHandler);
            }
            int size = HttpUtils.computeRemaining(dataToWrite);
            this.pendingWrites.add(new PendingWrite(dataToWrite, completionHandler));
            return size;
        }
    }

    private static class PartBodyDataSink
    extends BodyDataSinkImplBase {
        private final Multipart multipart;
        private final String boundary;

        public PartBodyDataSink(IHeader header, String boundary, Multipart multipart, AbstractHttpConnection.IMultimodeExecutor executor) throws IOException {
            super(header, executor);
            this.multipart = multipart;
            this.boundary = boundary;
        }

        void activate() throws IOException {
            this.multipart.getDataSink().write("\r\n" + this.getHeader().toString() + "\r\n");
        }

        void onClose() throws IOException {
            this.multipart.getDataSink().write("\r\n--" + this.boundary);
            this.multipart.removePart(this);
        }

        void onDestroy(String reason) {
        }

        int onWriteData(ByteBuffer[] dataToWrite, IWriteCompletionHandler completionHandler) throws IOException {
            int size = HttpUtils.computeRemaining(dataToWrite);
            this.multipart.getDataSink().write(dataToWrite, completionHandler);
            return size;
        }

        final int getPendingWriteDataSize() {
            return this.multipart.getDataSink().getPendingWriteDataSize();
        }

        final boolean isNetworkendpoint() {
            return false;
        }
    }

    private final class Multipart
    implements Closeable {
        private final List<PartBodyDataSink> pendingParts = new ArrayList<PartBodyDataSink>();
        private final String boundary;
        private final AtomicBoolean isPendingClose = new AtomicBoolean(false);

        public Multipart() throws IOException {
            String contentType = BodyDataSink.this.header.getContentType();
            if (contentType == null) {
                this.boundary = UUID.randomUUID().toString();
                BodyDataSink.this.header.setContentType("multipart/mixed; boundary=" + this.boundary);
            } else {
                if (!HttpUtils.parseMediaType(contentType).toLowerCase(Locale.US).startsWith("multipart")) {
                    throw new RuntimeException("could not add part. Content-Type " + contentType + " is not a multipart content type");
                }
                String bound = HttpUtils.parseMediaTypeParameter(contentType, "boundary", true, null);
                if (bound == null) {
                    this.boundary = UUID.randomUUID().toString();
                    BodyDataSink.this.header.setContentType(BodyDataSink.this.header.getContentType() + "; boundary=" + this.boundary);
                } else {
                    this.boundary = bound;
                }
            }
            BodyDataSink.this.write("--" + this.boundary);
        }

        public synchronized void close() throws IOException {
            if (this.pendingParts.isEmpty()) {
                this.performClose();
            } else if (!this.isPendingClose.getAndSet(true)) {
                for (PartBodyDataSink part : this.pendingParts) {
                    IBodyCloseListener cl = new IBodyCloseListener(){

                        public void onClose() throws IOException {
                            Multipart.this.close();
                        }
                    };
                    part.addCloseListener(cl);
                }
            }
        }

        private void performClose() throws IOException {
            BodyDataSink.this.write("--\r\n");
            BodyDataSink.this.doClose();
        }

        synchronized BodyDataSink addPart(IHeader partHeader) throws IOException {
            PartBodyDataSink sink;
            if (this.pendingParts.isEmpty()) {
                sink = new PartBodyDataSink(partHeader, this.boundary, this, BodyDataSink.this.getExecutor());
                this.pendingParts.add(sink);
                sink.activate();
            } else {
                sink = new BufferingPartBodyDataSink(partHeader, this.boundary, this, BodyDataSink.this.getExecutor());
                this.pendingParts.add(sink);
            }
            return sink;
        }

        synchronized void removePart(PartBodyDataSink sink) throws IOException {
            if (this.pendingParts != null) {
                this.pendingParts.remove(sink);
                if (this.pendingParts.isEmpty()) {
                    if (this.isPendingClose.get()) {
                        this.close();
                    }
                } else {
                    this.pendingParts.get(0).activate();
                }
            }
        }

        BodyDataSink getDataSink() {
            return BodyDataSink.this;
        }
    }

    private static final class BodyCompleteListener
    implements IBodyCompleteListener {
        private final NonBlockingBodyDataSource dataSource;
        private final BodyDataSink dataSink;

        public BodyCompleteListener(NonBlockingBodyDataSource dataSource, BodyDataSink dataSink) {
            this.dataSource = dataSource;
            this.dataSink = dataSink;
        }

        public void onComplete() throws IOException {
            this.dataSource.closeQuitly();
            this.dataSink.closeQuitly();
        }
    }
}

