/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.xlightweb.IWriteCompleteHandler;
import org.xlightweb.WebSocketConnection;
import org.xlightweb.WebSocketMessage;
import org.xlightweb.WebSocketMessageCompleteHandlerAdapter;
import org.xsocket.DataConverter;
import org.xsocket.connection.IConnection;
import org.xsocket.connection.IWriteCompletionHandler;

final class BinaryMessage
extends WebSocketMessage {
    private static final byte START_BYTE_BINARYFRAME = -128;

    public BinaryMessage(byte[] bytes) {
        this(DataConverter.toByteBuffer((byte[])bytes));
    }

    BinaryMessage(ByteBuffer msg) {
        super(msg, null);
    }

    public boolean isBinaryMessage() {
        return true;
    }

    int writeTo(WebSocketConnection connection, IWriteCompleteHandler completeHandler) throws IOException {
        byte[] header;
        if (completeHandler == null) {
            connection.getUnderlyingTcpConnection().setFlushmode(IConnection.FlushMode.SYNC);
        } else {
            connection.getUnderlyingTcpConnection().setFlushmode(IConnection.FlushMode.ASYNC);
        }
        ByteBuffer msgData = this.getData().getByteBuffer();
        int length = msgData.remaining();
        if (length <= 128) {
            header = new byte[2];
            header[1] = (byte)(0x7F & length);
        } else if (length <= 16384) {
            header = new byte[3];
            header[1] = (byte)(0x80 | 0x7F & length >> 7);
            header[2] = (byte)(0x7F & length);
        } else {
            header = new byte[4];
            header[1] = (byte)(0x80 | length >> 14);
            header[2] = (byte)(0x80 | 0x7F & length >> 7);
            header[3] = (byte)(0x7F & length);
        }
        header[0] = -128;
        int written = connection.getUnderlyingTcpConnection().write(header);
        if (completeHandler == null) {
            written += connection.getUnderlyingTcpConnection().write(msgData);
        } else {
            written += msgData.remaining();
            connection.getUnderlyingTcpConnection().write(msgData, (IWriteCompletionHandler)new WebSocketMessageCompleteHandlerAdapter(connection, completeHandler));
        }
        connection.getUnderlyingTcpConnection().flush();
        return written;
    }

    static BinaryMessage parse(ByteBuffer buffer) throws IOException {
        int savePos = buffer.position();
        int saveLimit = buffer.limit();
        int length = 0;
        while (buffer.hasRemaining()) {
            byte b = buffer.get();
            length <<= 7;
            length |= 0x7F & b;
            if (b < 0) continue;
            break;
        }
        if (buffer.remaining() >= length) {
            ByteBuffer msgBuffer = buffer.slice();
            buffer.position(buffer.position() + length);
            return new BinaryMessage(msgBuffer);
        }
        buffer.position(savePos);
        buffer.limit(saveLimit);
        return null;
    }

    static boolean isBinaryMessage(byte startByte) {
        return startByte == -128;
    }
}

