/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.merging;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.EntityUpdate;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.Guid;
import com.paterva.maltego.core.LinkEntityIDs;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.core.MaltegoPart;
import com.paterva.maltego.core.TypedPropertyBag;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.LinkRegistry;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphDataStoreReader;
import com.paterva.maltego.graph.store.data.GraphDataStoreWriter;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.query.part.EntitiesDataQuery;
import com.paterva.maltego.graph.store.query.part.EntityDataQuery;
import com.paterva.maltego.graph.store.query.part.LinksDataQuery;
import com.paterva.maltego.graph.store.query.part.PartDataQuery;
import com.paterva.maltego.graph.store.structure.GraphStructureReader;
import com.paterva.maltego.graph.store.structure.GraphStructureWriter;
import com.paterva.maltego.graph.wrapper.GraphStoreHelper;
import com.paterva.maltego.graph.wrapper.GraphStoreWriter;
import com.paterva.maltego.licensing.A;
import com.paterva.maltego.licensing.LicenseManager;
import com.paterva.maltego.matching.MatchingRule;
import com.paterva.maltego.matching.MatchingRuleFactory;
import com.paterva.maltego.matching.api.GraphMatchStrategy;
import com.paterva.maltego.matching.api.MatchingRuleDescriptor;
import com.paterva.maltego.merging.EntityFilter;
import com.paterva.maltego.merging.GraphMergeCallback;
import com.paterva.maltego.merging.GraphMergeStrategy;
import com.paterva.maltego.merging.GraphMerger;
import com.paterva.maltego.merging.PartMergeStrategy;
import com.paterva.maltego.typing.descriptor.SpecRegistry;
import com.paterva.maltego.util.EntityLimitNotifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public class StrategicGraphMerger
implements GraphMerger {
    private static final Logger LOG = Logger.getLogger(StrategicGraphMerger.class.getName());
    private GraphID _destGraphID;
    private GraphID _srcGraphID;
    private GraphStore _srcGraphStore;
    private EntityRegistry _destEntityRegistry;
    private final GraphMatchStrategy _graphMatchStrat;
    private final GraphMergeStrategy _graphMergeStrat;
    private final GraphMergeCallback _cb;
    private final boolean _useGraphStoreMatching;
    private final boolean _cloneParts;
    private Map<MaltegoEntity, MaltegoEntity> _entityMatches;
    private Map<MaltegoEntity, MaltegoEntity> _entityMap;
    private Map<MaltegoEntity, MaltegoEntity> _newEntityMap;
    private Map<MaltegoLink, MaltegoLink> _linkMap;
    private Map<MaltegoLink, MaltegoLink> _newLinkMap;
    private EntityFilter _filter;

    protected StrategicGraphMerger(GraphMatchStrategy graphMatchStrat, GraphMergeStrategy graphMergeStrat, GraphMergeCallback cb, boolean useGraphStoreMatching, boolean cloneParts) {
        this._graphMatchStrat = graphMatchStrat;
        this._graphMergeStrat = graphMergeStrat;
        this._cb = cb;
        this._useGraphStoreMatching = useGraphStoreMatching;
        this._cloneParts = cloneParts;
    }

    @Override
    public void setGraphs(GraphID destGraphID, GraphID srcGraphID, EntityFilter filter) {
        this._destGraphID = destGraphID;
        this._srcGraphID = srcGraphID;
        this._entityMatches = null;
        this._entityMap = null;
        this._newEntityMap = null;
        this._linkMap = null;
        this._newLinkMap = null;
        this._filter = filter;
        try {
            this._srcGraphStore = GraphStoreRegistry.getDefault().forGraphID(this._srcGraphID);
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this._destEntityRegistry = EntityRegistry.forGraphID((GraphID)this._destGraphID);
    }

    public GraphID getDestGraphID() {
        return this._destGraphID;
    }

    public GraphID getSrcGraphID() {
        return this._srcGraphID;
    }

    @Override
    public Map<MaltegoEntity, MaltegoEntity> getMatches() {
        if (this._entityMatches == null) {
            MatchingRuleDescriptor ruleDescriptor = this._graphMatchStrat.getEntityMatchingRule();
            Set entities = GraphStoreHelper.getMaltegoEntities((GraphID)this._srcGraphID);
            this._entityMatches = new HashMap<MaltegoEntity, MaltegoEntity>();
            if (this._useGraphStoreMatching) {
                LOG.fine("Matching in graph store");
                try {
                    GraphID graphID = this._destGraphID;
                    GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
                    GraphDataStoreReader reader = graphStore.getGraphDataStore().getDataStoreReader();
                    Map entityIDMatches = Collections.EMPTY_MAP;
                    try {
                        entityIDMatches = reader.getEntityMatches((Collection)entities, ruleDescriptor);
                    }
                    catch (Exception ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    EntitiesDataQuery query = new EntitiesDataQuery();
                    query.setIDs(new HashSet(entityIDMatches.values()));
                    EntityDataQuery dataQuery = new EntityDataQuery();
                    dataQuery.setAllProperties(true);
                    dataQuery.setAllSections(true);
                    query.setPartDataQuery((PartDataQuery)dataQuery);
                    Map graphStoreEntities = reader.getEntities(query);
                    for (Map.Entry entry : entityIDMatches.entrySet()) {
                        MaltegoEntity srcEntity = (MaltegoEntity)entry.getKey();
                        EntityID destEntityID = (EntityID)entry.getValue();
                        MaltegoEntity destEntity = (MaltegoEntity)graphStoreEntities.get(destEntityID);
                        this._entityMatches.put(srcEntity, destEntity);
                    }
                }
                catch (GraphStoreException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            } else {
                LOG.fine("Matching in memory");
                MatchingRule rule = MatchingRuleFactory.createFrom((MatchingRuleDescriptor)ruleDescriptor);
                for (MaltegoEntity srcEntity : entities) {
                    MaltegoEntity destEntity = this.findEntity(rule, srcEntity);
                    if (destEntity == null) continue;
                    this._entityMatches.put(srcEntity, destEntity);
                }
            }
            if (LOG.isLoggable(Level.FINEST)) {
                if (this._entityMatches.isEmpty()) {
                    LOG.finest("No entity matches");
                } else {
                    LOG.finest("Entity matches: ");
                    for (Map.Entry<MaltegoEntity, MaltegoEntity> entry : this._entityMatches.entrySet()) {
                        MaltegoEntity src = entry.getKey();
                        MaltegoEntity dest = entry.getValue();
                        LOG.log(Level.FINE, "{0}->{1}", new Object[]{src, dest});
                    }
                }
            }
        }
        return this._entityMatches;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean append() {
        LOG.log(Level.FINE, "Merging graph {0} with {1}", new Object[]{this._srcGraphID, this._destGraphID});
        boolean appended = true;
        GraphStore destGraphStore = null;
        try {
            if (!GraphStoreRegistry.getDefault().isExistingAndOpen(this._destGraphID) || !GraphStoreRegistry.getDefault().isExistingAndOpen(this._srcGraphID)) {
                appended = false;
            } else {
                destGraphStore = GraphStoreRegistry.getDefault().forGraphID(this._destGraphID);
                destGraphStore.beginUpdate();
                com.paterva.maltego.licensing.mode.A licenseMode = LicenseManager.A().A(false);
                if (!licenseMode.B() || !licenseMode.N()) {
                    int srcEntityCount;
                    GraphStore srcGraphStore = GraphStoreRegistry.getDefault().forGraphID(this._srcGraphID);
                    int destEntityCount = this.getEntityCount(destGraphStore);
                    if (destEntityCount + (srcEntityCount = this.getEntityCount(srcGraphStore)) > A.C()) {
                        for (EntityLimitNotifier notifier : Lookup.getDefault().lookupAll(EntityLimitNotifier.class)) {
                            notifier.notifyLimitExceeded();
                        }
                        appended = false;
                    }
                }
            }
            if (appended) {
                this.appendEntities();
                this.appendLinks();
            }
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            if (destGraphStore != null) {
                destGraphStore.endUpdate(null);
            }
        }
        return appended;
    }

    @Override
    public Map<MaltegoEntity, MaltegoEntity> getEntityMapping() {
        return this._entityMap;
    }

    @Override
    public Map<MaltegoLink, MaltegoLink> getLinkMapping() {
        return this._linkMap;
    }

    private void appendEntities() throws GraphStoreException {
        ArrayList<MaltegoEntity> outputEntities = new ArrayList<MaltegoEntity>();
        Set entities = GraphStoreHelper.getMaltegoEntities((GraphID)this._srcGraphID);
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Entities to merge: ");
            for (MaltegoEntity entity : entities) {
                LOG.finest(entity.toString());
            }
        }
        this._entityMap = new HashMap<MaltegoEntity, MaltegoEntity>(entities.size());
        this._newEntityMap = new HashMap<MaltegoEntity, MaltegoEntity>();
        for (MaltegoEntity srcEntity : entities) {
            if (this.isInputEntity(srcEntity)) {
                this.addEntity(srcEntity);
                continue;
            }
            outputEntities.add(srcEntity);
        }
        for (MaltegoEntity srcEntity : outputEntities) {
            this.addEntity(srcEntity);
        }
        GraphStoreWriter.addEntities((GraphID)this._destGraphID, this._newEntityMap.keySet());
        GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(this._destGraphID);
        GraphDataStoreWriter destDataWriter = graphStore.getGraphDataStore().getDataStoreWriter();
        List<MaltegoEntity> toUpdate = this.getModifiedEntities();
        destDataWriter.updateEntities(toUpdate);
        this.transferPinned();
        for (Map.Entry<MaltegoEntity, MaltegoEntity> entry : this._newEntityMap.entrySet()) {
            MaltegoEntity destEntity = entry.getKey();
            MaltegoEntity srcEntity = entry.getValue();
            this.onEntityAdded(destEntity, srcEntity);
        }
    }

    private List<MaltegoEntity> getModifiedEntities() {
        ArrayList<MaltegoEntity> toUpdate = new ArrayList<MaltegoEntity>();
        for (Map.Entry<MaltegoEntity, MaltegoEntity> entry : this._entityMap.entrySet()) {
            MaltegoEntity srcEntity = entry.getKey();
            MaltegoEntity mergedEntity = entry.getValue();
            MaltegoEntity oldEntity = this._entityMatches.get(srcEntity);
            if (oldEntity == null || oldEntity.isCopy((MaltegoPart)mergedEntity)) continue;
            toUpdate.add(mergedEntity);
        }
        return toUpdate;
    }

    private void transferPinned() throws GraphStoreException {
        HashSet<Guid> srcEntityIDs = new HashSet<Guid>();
        for (Map.Entry<MaltegoEntity, MaltegoEntity> entry : this._newEntityMap.entrySet()) {
            MaltegoEntity src = entry.getValue();
            srcEntityIDs.add(src.getID());
        }
        Map srcPinned = GraphStoreHelper.isPinned((GraphID)this._srcGraphID, srcEntityIDs);
        HashMap destPinned = new HashMap();
        for (Map.Entry entry : this._newEntityMap.entrySet()) {
            MaltegoEntity dest = (MaltegoEntity)entry.getKey();
            MaltegoEntity src = (MaltegoEntity)entry.getValue();
            destPinned.put(dest.getID(), srcPinned.get(src.getID()));
        }
        GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(this._destGraphID);
        GraphStructureWriter graphStructureWriter = graphStore.getGraphStructureStore().getStructureWriter();
        graphStructureWriter.setPinned(destPinned);
    }

    private void addEntity(MaltegoEntity srcEntity) {
        if (this._filter == null || this._filter.accept(srcEntity)) {
            PartMergeStrategy mergeStrat;
            MaltegoEntity matchEntity = this.getMatches().get(srcEntity);
            MaltegoEntity destEntity = null;
            if (matchEntity != null && (mergeStrat = this._graphMergeStrat.getEntityMergeStrategy(matchEntity, srcEntity)) != null) {
                destEntity = this.tryMergeEntities(matchEntity, srcEntity, mergeStrat);
            }
            if (destEntity == null && srcEntity.getTypeName() != null) {
                destEntity = this._cloneParts ? srcEntity.createClone() : srcEntity.createCopy();
                this._newEntityMap.put(destEntity, srcEntity);
            }
            if (destEntity != null) {
                this._entityMap.put(srcEntity, destEntity);
            }
        }
    }

    private boolean isInputEntity(MaltegoEntity srcEntity) throws GraphStoreException {
        EntityID id;
        GraphStructureReader structureReader = this._srcGraphStore.getGraphStructureStore().getStructureReader();
        return structureReader.getIncoming(id = (EntityID)srcEntity.getID()).isEmpty() && structureReader.getOutgoing(id).size() > 0;
    }

    private void appendLinks() throws GraphStoreException {
        MaltegoLink srcLink;
        MaltegoLink destLink;
        GraphStructureReader structureReader = this._srcGraphStore.getGraphStructureStore().getStructureReader();
        this._linkMap = new HashMap<MaltegoLink, MaltegoLink>(structureReader.getLinkCount());
        this._newLinkMap = new HashMap<MaltegoLink, MaltegoLink>();
        MatchingRuleDescriptor ruleDescriptor = this._graphMatchStrat.getLinkMatchingRule();
        MatchingRule rule = ruleDescriptor != null ? MatchingRuleFactory.createFrom((MatchingRuleDescriptor)ruleDescriptor) : null;
        GraphDataStoreReader dataReader = this._srcGraphStore.getGraphDataStore().getDataStoreReader();
        Map links = dataReader.getLinks(new LinksDataQuery());
        for (Map.Entry entry : links.entrySet()) {
            MaltegoLink maltegoLink = (MaltegoLink)entry.getValue();
            MaltegoLink maltegoLink2 = destLink = rule != null ? this.tryMergeLink(rule, maltegoLink) : null;
            if (destLink == null && maltegoLink.getTypeName() != null) {
                destLink = this._cloneParts ? maltegoLink.createClone() : maltegoLink.createCopy();
                this._newLinkMap.put(destLink, maltegoLink);
            }
            if (destLink == null) continue;
            this._linkMap.put(maltegoLink, destLink);
        }
        HashMap<MaltegoLink, LinkEntityIDs> linkMap = new HashMap<MaltegoLink, LinkEntityIDs>(this._newLinkMap.size());
        for (Map.Entry<MaltegoLink, MaltegoLink> entry : this._newLinkMap.entrySet()) {
            destLink = entry.getKey();
            srcLink = entry.getValue();
            MaltegoEntity destSourceEntity = this.getDestEntityForSrcID(this._entityMap, structureReader.getSource((LinkID)srcLink.getID()));
            MaltegoEntity destTargetEntity = this.getDestEntityForSrcID(this._entityMap, structureReader.getTarget((LinkID)srcLink.getID()));
            if (destSourceEntity == null || destTargetEntity == null || destSourceEntity.equals(destTargetEntity)) continue;
            linkMap.put(destLink, new LinkEntityIDs((EntityID)destSourceEntity.getID(), (EntityID)destTargetEntity.getID()));
        }
        if (LOG.isLoggable(Level.FINEST)) {
            for (Map.Entry<Object, Object> entry : linkMap.entrySet()) {
                MaltegoLink link = (MaltegoLink)entry.getKey();
                LinkEntityIDs entityIDs = (LinkEntityIDs)entry.getValue();
                LOG.log(Level.FINEST, "Adding link {0}: {1}->{2}", new Object[]{link.getID(), entityIDs.getSourceID(), entityIDs.getTargetID()});
            }
        }
        GraphStoreWriter.addLinks((GraphID)this._destGraphID, linkMap);
        Iterator<Map.Entry<Object, Object>> iterator = linkMap.keySet().iterator();
        while (iterator.hasNext()) {
            MaltegoLink maltegoLink;
            destLink = maltegoLink = (MaltegoLink)iterator.next();
            srcLink = this._newLinkMap.get(destLink);
            this.onLinkAdded(destLink, srcLink);
        }
    }

    private MaltegoEntity getDestEntityForSrcID(Map<MaltegoEntity, MaltegoEntity> entityMap, EntityID entityID) {
        EntityUpdate fakeEntity = new EntityUpdate(entityID);
        return entityMap.get(fakeEntity);
    }

    MaltegoEntity tryMergeEntities(MaltegoEntity destEntity, MaltegoEntity srcEntity, PartMergeStrategy mergeStrat) {
        MaltegoEntity destBefore = destEntity.createClone();
        MaltegoEntity destAfter = destEntity.createClone();
        mergeStrat.merge((MaltegoPart)destAfter, (MaltegoPart)srcEntity);
        this.onEntitiesMerged(destBefore, destAfter, srcEntity);
        return destAfter;
    }

    private MaltegoLink tryMergeLink(MatchingRule rule, MaltegoLink srcLink) {
        PartMergeStrategy mergeStrat;
        MaltegoLink destLink = this.findLink(rule, srcLink);
        if (destLink != null && (mergeStrat = this._graphMergeStrat.getLinkMergeStrategy(destLink, srcLink)) != null) {
            MaltegoLink destBefore = destLink.createClone();
            mergeStrat.merge((MaltegoPart)destLink, (MaltegoPart)srcLink);
            this.onLinksMerged(destBefore, destLink, srcLink);
            return destLink;
        }
        return null;
    }

    private MaltegoEntity findEntity(MatchingRule rule, MaltegoEntity srcEntity) {
        try {
            GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(this._destGraphID);
            GraphStructureReader structureReader = graphStore.getGraphStructureStore().getStructureReader();
            EntityID srcEntityID = (EntityID)srcEntity.getID();
            GraphDataStoreReader dataReader = graphStore.getGraphDataStore().getDataStoreReader();
            if (structureReader.exists(srcEntityID)) {
                GraphDataStoreReader dataStoreReader = dataReader;
                return dataStoreReader.getEntity(srcEntityID);
            }
            Map entities = dataReader.getEntities(new EntitiesDataQuery());
            for (Map.Entry entry : entities.entrySet()) {
                MaltegoEntity destEntity = (MaltegoEntity)entry.getValue();
                if (!this.isMatch((MaltegoPart)destEntity, (MaltegoPart)srcEntity, rule)) continue;
                return destEntity;
            }
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return null;
    }

    private MaltegoLink findLink(MatchingRule rule, MaltegoLink srcLink) {
        try {
            GraphStore srcGraphStore = GraphStoreRegistry.getDefault().forGraphID(this._srcGraphID);
            GraphStructureReader srcStructureReader = srcGraphStore.getGraphStructureStore().getStructureReader();
            GraphStore destGraphStore = GraphStoreRegistry.getDefault().forGraphID(this._destGraphID);
            GraphDataStoreReader destDataReader = destGraphStore.getGraphDataStore().getDataStoreReader();
            GraphStructureReader destStructureReader = destGraphStore.getGraphStructureStore().getStructureReader();
            MaltegoEntity destSourceEntity = this.getDestEntityForSrcID(this._entityMap, srcStructureReader.getSource((LinkID)srcLink.getID()));
            MaltegoEntity destTargetEntity = this.getDestEntityForSrcID(this._entityMap, srcStructureReader.getTarget((LinkID)srcLink.getID()));
            if (destSourceEntity != null && destTargetEntity != null) {
                Set outgoingLinks = destStructureReader.getOutgoing((EntityID)destSourceEntity.getID());
                Set incomingLinks = null;
                for (LinkID l1 : outgoingLinks) {
                    if (incomingLinks == null) {
                        incomingLinks = destStructureReader.getIncoming((EntityID)destTargetEntity.getID());
                    }
                    for (LinkID l2 : incomingLinks) {
                        MaltegoLink link1;
                        if (!l1.equals((Object)l2) || !this.isMatch((MaltegoPart)(link1 = destDataReader.getLink(l1)), (MaltegoPart)srcLink, rule)) continue;
                        return link1;
                    }
                }
            }
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return null;
    }

    private boolean isMatch(MaltegoPart part1, MaltegoPart part2, MatchingRule rule) {
        SpecRegistry registry;
        int result;
        return rule != null && (result = rule.getMatch(registry = this.getRegistry(part1), (TypedPropertyBag)part1, (TypedPropertyBag)part2)) == 1;
    }

    private SpecRegistry getRegistry(MaltegoPart part) {
        EntityRegistry registry = null;
        if (part instanceof MaltegoEntity) {
            registry = this._destEntityRegistry;
        } else if (part instanceof MaltegoLink) {
            registry = LinkRegistry.getDefault();
        }
        return registry;
    }

    protected void onEntityAdded(MaltegoEntity dest, MaltegoEntity src) {
        if (this._cb != null) {
            this._cb.onEntityTransferred(dest, src);
        }
    }

    protected void onEntitiesMerged(MaltegoEntity destBefore, MaltegoEntity destAfter, MaltegoEntity src) {
        if (this._cb != null) {
            this._cb.onEntitiesMerged(destAfter, src);
        }
    }

    protected void onLinkAdded(MaltegoLink dest, MaltegoLink src) {
        if (this._cb != null) {
            this._cb.onLinkTransferred(dest, src);
        }
    }

    protected void onLinksMerged(MaltegoLink destBefore, MaltegoLink destAfter, MaltegoLink src) {
        if (this._cb != null) {
            this._cb.onLinksMerged(destAfter, src);
        }
    }

    private int getEntityCount(GraphStore graphStore) throws GraphStoreException {
        return graphStore.getGraphStructureStore().getStructureReader().getEntityCount();
    }
}

