/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.merging;

import com.paterva.maltego.core.DisplayInformation;
import com.paterva.maltego.core.DisplayInformationCollection;
import com.paterva.maltego.core.EntityUpdate;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.core.MaltegoPart;
import com.paterva.maltego.core.OverlayDescriptorSet;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.TypeDescriptor;
import com.paterva.maltego.typing.TypeRegistry;
import com.paterva.maltego.typing.types.Attachment;
import com.paterva.maltego.typing.types.Attachments;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.openide.util.Utilities;

public class MergeUtils {
    private static final Logger LOG = Logger.getLogger(MergeUtils.class.getName());

    private MergeUtils() {
    }

    public static void addMissingProperties(MaltegoPart dest, MaltegoPart src) {
        for (PropertyDescriptor pd : src.getProperties()) {
            if (dest.getProperties().contains(pd)) continue;
            dest.addProperty(pd);
        }
    }

    public static void removeExtraProperties(MaltegoPart dest, MaltegoPart src) {
        ArrayList<PropertyDescriptor> toRemove = new ArrayList<PropertyDescriptor>();
        for (PropertyDescriptor pd : dest.getProperties()) {
            if (src.getProperties().contains(pd)) continue;
            toRemove.add(pd);
        }
        MergeUtils.removeProperties(dest, toRemove);
    }

    public static void removeProperties(MaltegoPart dest, MaltegoPart src) {
        ArrayList<PropertyDescriptor> toRemove = new ArrayList<PropertyDescriptor>();
        for (PropertyDescriptor pd : dest.getProperties()) {
            if (!src.getProperties().contains(pd)) continue;
            toRemove.add(pd);
        }
        MergeUtils.removeProperties(dest, toRemove);
    }

    public static void removeProperties(MaltegoPart part, List<PropertyDescriptor> properties) {
        for (PropertyDescriptor pd : properties) {
            part.removeProperty(pd.getName());
        }
    }

    public static void replaceProperties(MaltegoPart dest, MaltegoPart src) {
        dest.getProperties().clear();
        dest.getProperties().addAll(src.getProperties());
    }

    public static void replaceOverlays(MaltegoPart dest, MaltegoPart src) {
        if (!(dest instanceof MaltegoEntity) || !(src instanceof MaltegoEntity)) {
            return;
        }
        MaltegoEntity destEntity = (MaltegoEntity)dest;
        OverlayDescriptorSet overlays = destEntity.getOverlaySet();
        if (overlays != null) {
            overlays.clear();
        }
        MaltegoEntity srcEntity = (MaltegoEntity)src;
        if (overlays == null || overlays.isEmpty()) {
            return;
        }
        overlays = srcEntity.getOverlaySet();
        overlays.forEach(overlay -> destEntity.addOverlay(overlay));
    }

    public static void mergePropertyValues(MaltegoPart dest, MaltegoPart src, boolean preferSource) {
        MergeUtils.copyCalculatedPropertyValues(dest, src, preferSource, false);
        MergeUtils.copyNonCalculatedPropertyValues(dest, src, preferSource, false);
    }

    public static void replacePropertyValues(MaltegoPart dest, MaltegoPart src, boolean refreshProperties) {
        if (refreshProperties) {
            MergeUtils.copyCalculatedPropertyValues(dest, src, true, true);
            MergeUtils.copyNonCalculatedPropertyValues(dest, src, true, true);
        } else {
            MergeUtils.copyPropertyValuesNoRefresh(dest, src);
        }
    }

    public static void copyCalculatedPropertyValues(MaltegoPart dest, MaltegoPart src, boolean preferSource, boolean replace) {
        for (PropertyDescriptor pd : src.getProperties()) {
            PropertyDescriptor destPd = dest.getProperties().get(pd.getName());
            if (!MergeUtils.isCalculated(destPd)) continue;
            Object srcValue = src.getValue(pd);
            Object destValue = dest.getValue(destPd);
            srcValue = MergeUtils.convert(srcValue, pd, destPd);
            if (!replace && MergeUtils.destIsBetter(srcValue, destValue) || !preferSource && !MergeUtils.isNullOrEmpty(destValue)) continue;
            dest.setValue(destPd, srcValue);
        }
    }

    public static void copyNonCalculatedPropertyValues(MaltegoPart dest, MaltegoPart src, boolean preferSource, boolean replace) {
        for (PropertyDescriptor pd : src.getProperties()) {
            PropertyDescriptor destPd = dest.getProperties().get(pd.getName());
            if (MergeUtils.isCalculated(destPd)) continue;
            Object srcValue = src.getValue(pd);
            Object destValue = dest.getValue(destPd);
            srcValue = MergeUtils.convert(srcValue, pd, destPd);
            if (!replace && MergeUtils.destIsBetter(srcValue, destValue)) continue;
            if (!replace && Attachments.class.equals((Object)destPd.getType()) && destValue != null) {
                MergeUtils.mergeAttachments((Attachments)destValue, (Attachments)srcValue, preferSource);
                continue;
            }
            if (!preferSource && !MergeUtils.isNullOrEmpty(destValue)) continue;
            dest.setValue(destPd, srcValue);
        }
    }

    public static void copyPropertyValuesNoRefresh(MaltegoPart dest, MaltegoPart src) {
        for (PropertyDescriptor pd : src.getProperties()) {
            PropertyDescriptor destPd = dest.getProperties().get(pd.getName());
            Object srcValue = src.getValue(pd);
            Object destValue = dest.getValue(destPd);
            srcValue = MergeUtils.convert(srcValue, pd, destPd);
            if (Attachments.class.equals((Object)destPd.getType()) && destValue != null && !(src instanceof EntityUpdate)) {
                MergeUtils.mergeAttachments((Attachments)destValue, (Attachments)srcValue, true);
                continue;
            }
            dest.setValue(destPd, srcValue, false, false);
        }
    }

    private static Object convert(Object srcValue, PropertyDescriptor srcPd, PropertyDescriptor destPd) throws IllegalArgumentException {
        if (srcValue != null && !destPd.getType().equals(srcPd.getType())) {
            TypeDescriptor destType = TypeRegistry.getDefault().getType(destPd.getType());
            if (!(srcValue instanceof String)) {
                TypeDescriptor srcType = TypeRegistry.getDefault().getType(srcPd.getType());
                srcValue = srcType.convert(srcValue);
            }
            if (srcValue instanceof String) {
                srcValue = destType.convert((String)srcValue);
            }
        }
        return srcValue;
    }

    private static void mergeAttachments(Attachments destAtts, Attachments srcAtts, boolean preferSource) {
        for (Attachment att : srcAtts) {
            if (destAtts.contains((Object)att)) continue;
            destAtts.add((Object)att);
        }
        if (preferSource) {
            destAtts.setPrimaryImage(srcAtts.getPrimaryImage());
        }
    }

    public static void mergeSpecialPropertyMapping(MaltegoPart dest, MaltegoPart src, boolean preferSource) {
        dest.setDisplayValueExpression(MergeUtils.getDisplayExpression(dest, src, preferSource));
        dest.setValueProperty(MergeUtils.nonNull(dest.getValueProperty(), src.getValueProperty(), preferSource));
        if (dest instanceof MaltegoEntity) {
            MaltegoEntity destEntity = (MaltegoEntity)dest;
            MaltegoEntity srcEntity = (MaltegoEntity)src;
            destEntity.setImageExpression(MergeUtils.getImageExpression(destEntity, srcEntity, preferSource));
        }
    }

    public static void copySpecialPropertyMapping(MaltegoPart dest, MaltegoPart src, boolean preferSource) {
        dest.setDisplayValueExpression((String)src.getDisplayValueExpression().orElse(null));
        dest.setValueProperty(src.getValueProperty());
        if (dest instanceof MaltegoEntity) {
            MaltegoEntity destEntity = (MaltegoEntity)dest;
            MaltegoEntity srcEntity = (MaltegoEntity)src;
            destEntity.setImageExpression((String)srcEntity.getNonBlankImageExpression().orElse(null));
        }
    }

    public static void updateSpecialPropertyMapping(MaltegoPart dest, MaltegoPart src) {
        src.getDisplayValueExpression().ifPresent(dispExpr -> dest.setDisplayValueExpression(dispExpr));
        String valuePropertyName = src.getValuePropertyName();
        if (valuePropertyName != null) {
            dest.setValueProperty(dest.getProperties().get(valuePropertyName));
        }
        if (dest instanceof MaltegoEntity) {
            MaltegoEntity srcEntity = (MaltegoEntity)src;
            srcEntity.getImageExpression().ifPresent(imgExpr -> {
                MaltegoEntity destEntity = (MaltegoEntity)dest;
                if (StringUtils.isBlank((String)imgExpr)) {
                    imgExpr = null;
                }
                destEntity.setImageExpression(imgExpr);
            });
        }
    }

    public static void replaceDisplayInformation(MaltegoPart dest, MaltegoPart src) {
        DisplayInformationCollection displayInfo;
        DisplayInformationCollection srcDisplayInfo = src.getDisplayInformation();
        if (srcDisplayInfo == null) {
            displayInfo = null;
        } else {
            displayInfo = dest.getOrCreateDisplayInformation();
            displayInfo.clear();
            displayInfo.addAll((Collection)srcDisplayInfo);
        }
        dest.setDisplayInformation(displayInfo);
    }

    public static void mergeDisplayInformation(MaltegoPart dest, MaltegoPart src, boolean preferSource) {
        DisplayInformationCollection srcInfos = src.getDisplayInformation();
        if (srcInfos != null) {
            DisplayInformationCollection destInfos = dest.getOrCreateDisplayInformation();
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "Display Info Before: {0}", destInfos.toString());
            }
            DisplayInformationCollection newInfos = preferSource ? srcInfos : destInfos;
            DisplayInformationCollection otherInfos = preferSource ? destInfos : srcInfos;
            for (DisplayInformation otherInfo : otherInfos) {
                boolean found = false;
                for (DisplayInformation newInfo : newInfos) {
                    if (!otherInfo.getName().equals(newInfo.getName()) || !Utilities.compareObjects((Object)otherInfo.getValue(), (Object)newInfo.getValue())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                newInfos.add(otherInfo);
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "Display Info After: {0}", newInfos.toString());
            }
            dest.setDisplayInformation(newInfos);
        }
    }

    public static void mergeNotes(MaltegoPart dest, MaltegoPart src, boolean preferSource) {
        String secondNotes;
        String firstNotes = preferSource ? dest.getNotes() : src.getNotes();
        String string = secondNotes = preferSource ? src.getNotes() : dest.getNotes();
        if (Utilities.compareObjects((Object)firstNotes, (Object)secondNotes)) {
            return;
        }
        String newNotes = "";
        if (!MergeUtils.isNullOrEmpty(firstNotes)) {
            newNotes = firstNotes;
        }
        if (!MergeUtils.isNullOrEmpty(secondNotes)) {
            newNotes = !MergeUtils.isNullOrEmpty(newNotes) ? newNotes + "\n" + secondNotes : secondNotes;
        }
        if (!MergeUtils.isNullOrEmpty(newNotes) && (dest.isShowNotes() || src.isShowNotes())) {
            dest.setShowNotes(Boolean.valueOf(true));
        }
        dest.setNotes(newNotes);
    }

    public static void mergeWeight(MaltegoPart dest, MaltegoPart src) {
        if (dest instanceof MaltegoEntity) {
            MaltegoEntity destEntity = (MaltegoEntity)dest;
            MaltegoEntity srcEntity = (MaltegoEntity)src;
            int weight = (destEntity.getWeight() + srcEntity.getWeight()) / 2;
            destEntity.setWeight(Integer.valueOf(weight));
        }
    }

    public static void mergeOverlays(MaltegoPart dest, MaltegoPart src) {
        if (!(dest instanceof MaltegoEntity) || !(src instanceof MaltegoEntity)) {
            return;
        }
        MaltegoEntity destEntity = (MaltegoEntity)dest;
        MaltegoEntity srcEntity = (MaltegoEntity)src;
        OverlayDescriptorSet overlays = srcEntity.getOverlaySet();
        if (overlays == null || overlays.isEmpty()) {
            return;
        }
        overlays.forEach(overlay -> destEntity.addOverlay(overlay));
    }

    public static void mergeReversed(MaltegoPart dest, MaltegoPart src, boolean preferSource) {
        if (preferSource && dest instanceof MaltegoLink) {
            MaltegoLink destLink = (MaltegoLink)dest;
            MaltegoLink srcLink = (MaltegoLink)src;
            destLink.setReversed(srcLink.isReversed());
        }
    }

    public static boolean isCalculated(PropertyDescriptor pd) {
        return pd.getLinkedProperties().size() > 0;
    }

    public static PropertyDescriptor nonNull(PropertyDescriptor dest, PropertyDescriptor src, boolean preferSource) {
        PropertyDescriptor preferred = preferSource ? src : dest;
        PropertyDescriptor other = preferSource ? dest : src;
        return preferred != null ? preferred : other;
    }

    public static String getDisplayExpression(MaltegoPart dest, MaltegoPart src, boolean preferSource) {
        MaltegoPart preferred = preferSource ? src : dest;
        MaltegoPart other = preferSource ? dest : src;
        return preferred.getDisplayValueExpression().orElseGet(() -> other.getDisplayValueExpression().orElse(null));
    }

    public static String getImageExpression(MaltegoEntity destEntity, MaltegoEntity srcEntity, boolean preferSource) {
        MaltegoEntity preferred = preferSource ? srcEntity : destEntity;
        MaltegoEntity other = preferSource ? destEntity : srcEntity;
        return preferred.getNonBlankImageExpression().orElseGet(() -> other.getNonBlankImageExpression().orElse(null));
    }

    public static boolean destIsBetter(Object src, Object dest) {
        return src == null || MergeUtils.isEmpty(src) && dest != null;
    }

    public static boolean isNullOrEmpty(Object value) {
        return value == null || MergeUtils.isEmpty(value);
    }

    public static boolean isEmpty(Object value) {
        if (value instanceof String) {
            return ((String)value).isEmpty();
        }
        return false;
    }
}

