/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.excel.io;

import com.paterva.maltego.graph.table.io.TabularGraphFileImporter;
import com.paterva.maltego.graph.table.io.TabularGraphIterator;
import com.paterva.maltego.typing.TypeDescriptor;
import com.paterva.maltego.typing.types.DateTime;
import com.paterva.maltego.util.ArrayUtilities;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class ExcelImporter
extends TabularGraphFileImporter {
    public ExcelImporter(File file) {
        super(file);
    }

    public TabularGraphIterator open() throws IOException {
        Workbook workbook = WorkbookFactory.create((InputStream)new FileInputStream(this.getFile()));
        return new RowIterator(workbook);
    }

    private static class RowIterator
    implements TabularGraphIterator {
        private final Workbook _workbook;
        private final int[] _rowsWithData;
        private int _rowIndex;
        private short _firstCellNum;
        private short _lastCellNum;

        public RowIterator(Workbook workbook) throws FileNotFoundException {
            this._workbook = workbook;
            this._rowsWithData = this.getRowsWithData(workbook.getSheetAt(0));
            this._rowIndex = 0;
        }

        public boolean hasNext() {
            return this._rowIndex < this._rowsWithData.length;
        }

        public void next() {
            ++this._rowIndex;
        }

        public List<Object> getRow(Map<Integer, TypeDescriptor> desiredColumnTypes) throws IOException {
            ArrayList<Object> row = new ArrayList<Object>();
            Row sheetRow = this._workbook.getSheetAt(0).getRow(this._rowsWithData[this._rowIndex]);
            for (int column = this._firstCellNum; column < this._lastCellNum; ++column) {
                Cell cell = sheetRow.getCell(column);
                Object value = null;
                if (cell != null) {
                    CellType cellType = cell.getCellType();
                    TypeDescriptor type = null;
                    if (desiredColumnTypes != null) {
                        type = desiredColumnTypes.get(column);
                    }
                    if (cellType == CellType.FORMULA) {
                        cellType = cell.getCachedFormulaResultType();
                    }
                    switch (cellType) {
                        case ERROR: 
                        case BLANK: {
                            break;
                        }
                        case NUMERIC: {
                            value = this.convertFromNumericValue(type, cell);
                            break;
                        }
                        case BOOLEAN: {
                            value = this.convertFromBooleanValue(type, cell);
                            break;
                        }
                        case STRING: {
                            value = cell.getStringCellValue();
                            break;
                        }
                        default: {
                            value = null;
                        }
                    }
                }
                row.add(value);
            }
            return row;
        }

        private Object convertFromNumericValue(TypeDescriptor type, Cell cell) {
            Object value = null;
            double doubleValue = cell.getNumericCellValue();
            if (type != null) {
                if (Date.class.equals((Object)type.getType())) {
                    value = cell.getDateCellValue();
                } else if (DateTime.class.equals((Object)type.getType())) {
                    value = new DateTime(cell.getDateCellValue());
                } else if (String.class.equals((Object)type.getType())) {
                    if (HSSFDateUtil.isCellDateFormatted((Cell)cell)) {
                        value = new DataFormatter().formatCellValue(cell);
                    }
                    if (value == null) {
                        cell.setCellType(CellType.STRING);
                        value = cell.getStringCellValue();
                    }
                } else {
                    value = this.castNumeric(type, doubleValue);
                }
                if (value == null) {
                    cell.setCellType(CellType.STRING);
                    value = cell.getStringCellValue();
                }
            } else if (HSSFDateUtil.isCellDateFormatted((Cell)cell)) {
                value = new DataFormatter().formatCellValue(cell);
            } else {
                cell.setCellType(CellType.STRING);
                value = cell.getStringCellValue();
            }
            return value;
        }

        private Object convertFromBooleanValue(TypeDescriptor type, Cell cell) {
            Object value;
            boolean boolValue = cell.getBooleanCellValue();
            if (type != null) {
                value = Boolean.TYPE.equals(type.getType()) ? Boolean.valueOf(boolValue) : this.castNumeric(type, boolValue ? 1.0 : 0.0);
                if (value == null) {
                    value = Boolean.toString(boolValue);
                }
            } else {
                value = boolValue;
            }
            return value;
        }

        private Object castNumeric(TypeDescriptor type, double doubleValue) {
            Number rowValue = null;
            if (Byte.TYPE.equals(type.getType())) {
                rowValue = (byte)doubleValue;
            } else if (Integer.TYPE.equals(type.getType())) {
                rowValue = (int)doubleValue;
            } else if (Float.TYPE.equals(type.getType())) {
                rowValue = Float.valueOf((float)doubleValue);
            } else if (Double.TYPE.equals(type.getType())) {
                rowValue = doubleValue;
            } else if (Long.TYPE.equals(type.getType())) {
                rowValue = (long)doubleValue;
            }
            return rowValue;
        }

        private int[] getRowsWithData(Sheet sheet) {
            this._firstCellNum = Short.MAX_VALUE;
            this._lastCellNum = 0;
            ArrayList<Integer> rows = new ArrayList<Integer>();
            for (int row = sheet.getFirstRowNum(); row <= sheet.getLastRowNum(); ++row) {
                Row sheetRow = this._workbook.getSheetAt(0).getRow(row);
                if (sheetRow == null) continue;
                short firstCell = sheetRow.getFirstCellNum();
                short lastCell = sheetRow.getLastCellNum();
                if (lastCell <= firstCell) continue;
                this._firstCellNum = this._firstCellNum > firstCell ? firstCell : this._firstCellNum;
                this._lastCellNum = this._lastCellNum < lastCell ? lastCell : this._lastCellNum;
                rows.add(row);
            }
            Integer[] rowsArray = rows.toArray(new Integer[rows.size()]);
            return ArrayUtilities.toPrimitiveArray((Integer[])rowsArray);
        }

        public void close() {
        }
    }
}

