/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util;

import com.paterva.maltego.util.Base64;
import com.paterva.maltego.util.IconSize;
import com.paterva.maltego.util.StringUtilities;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ConvolveOp;
import java.awt.image.IndexColorModel;
import java.awt.image.Kernel;
import java.awt.image.PixelGrabber;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ImageUtilities;
import org.openide.util.Utilities;
import sun.awt.image.BufferedImageGraphicsConfig;

public class ImageUtils {
    private static final String TWELVEMONKEYS_BMPIMAGEREADER = "com.twelvemonkeys.imageio.plugins.bmp.bmpimagereader";
    private static final Map<IconSize, Optional<Image>> BROKEN_IMAGE_SIZES = new EnumMap<IconSize, Optional<Image>>(IconSize.class);
    public static final int DO_NOT_SCALE = 0;
    public static final int G2D_SCALE_IF_NEEDED = 1;
    public static final int NEW_IMAGE_SIZE_IF_NEEDED = 2;

    private ImageUtils() {
    }

    public static String base64Encode(Image image, String format) throws IOException {
        return ImageUtils.base64Encode(image, format, true);
    }

    public static String base64Encode(Image image, String format, boolean doPadding) throws IOException {
        try (ByteArrayOutputStream stream = new ByteArrayOutputStream();){
            ImageUtils.base64Encode(image, format, stream);
            String base64String = stream.toString();
            if (doPadding) {
                String string = base64String;
                return string;
            }
            String newBase64String = base64String;
            Pattern pattern = Pattern.compile("([^=]*)(=+)(.*)");
            Matcher matcher = pattern.matcher(newBase64String);
            if (matcher.find()) {
                newBase64String = matcher.group(1) + matcher.group(3) + matcher.group(2);
            }
            String string = newBase64String;
            return string;
        }
    }

    public static void base64Encode(Image image, String format, OutputStream stream) throws IOException {
        try (Base64.OutputStream os = new Base64.OutputStream(stream);){
            BufferedImage buffered = ImageUtils.createBufferedImage(image);
            ImageIO.write((RenderedImage)buffered, format, os);
        }
    }

    public static BufferedImage base64Decode(InputStream stream) throws IOException {
        try (Base64.InputStream is = new Base64.InputStream(stream);){
            BufferedImage bufferedImage = ImageIO.read(is);
            return bufferedImage;
        }
    }

    public static BufferedImage base64Decode(String data) throws IOException {
        try (ByteArrayInputStream stream = new ByteArrayInputStream(data.getBytes());){
            BufferedImage bufferedImage = ImageUtils.base64Decode(stream);
            return bufferedImage;
        }
    }

    public static boolean isSVGImage(String imageBase64) throws IOException {
        boolean svgImage = false;
        if (!StringUtilities.isNullOrEmpty(imageBase64) && imageBase64.length() >= 8) {
            String imgString = new String(Base64.decode(imageBase64.substring(0, 8)));
            svgImage = imgString.trim().toUpperCase().replace("<", "").startsWith("SVG");
        }
        return svgImage;
    }

    public static boolean isSVGFile(FileObject fo) {
        boolean svg = false;
        if (fo != null) {
            File file = FileUtil.toFile((FileObject)fo);
            svg = file == null ? ImageUtils.isSVGFile(fo.getNameExt()) : ImageUtils.isSVGFile(file);
        }
        return svg;
    }

    public static boolean isSVGFile(File file) {
        return ImageUtils.isSVGFile(file.getName());
    }

    public static boolean isSVGFile(String fileName) {
        return fileName.toUpperCase().endsWith("SVG");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] imageToBytes(Image image, String format) {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream(2048);){
            BufferedImage buffered = ImageUtils.createBufferedImage(image);
            ImageIO.write((RenderedImage)buffered, format, baos);
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static BufferedImage bytesToImage(byte[] bytes) {
        try (ByteArrayInputStream bais = new ByteArrayInputStream(bytes);){
            BufferedImage bufferedImage = ImageIO.read(bais);
            return bufferedImage;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return null;
        }
    }

    public static ImageIcon getSystemImageIcon(File file, boolean largeIcon) {
        JFileChooser chooser = new JFileChooser();
        Icon icon = chooser.getIcon(file);
        return ImageUtils.toImageIcon(icon);
    }

    public static ImageIcon toImageIcon(Icon icon) {
        if (icon == null) {
            return null;
        }
        if (icon instanceof ImageIcon) {
            return (ImageIcon)icon;
        }
        return new ImageIcon(ImageUtils.toImage(icon));
    }

    public static Image toImage(Icon icon) {
        if (icon == null) {
            return null;
        }
        if (icon instanceof ImageIcon) {
            return ((ImageIcon)icon).getImage();
        }
        int w = icon.getIconWidth();
        int h = icon.getIconHeight();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        GraphicsConfiguration gc = gd.getDefaultConfiguration();
        BufferedImage image = gc.createCompatibleImage(w, h);
        Graphics2D g = image.createGraphics();
        icon.paintIcon(null, g, 0, 0);
        g.dispose();
        return image;
    }

    public static ImageIcon toIcon(Image image) {
        return image == null ? null : new ImageIcon(image);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage createBufferedImage(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        image = new ImageIcon(image).getImage();
        boolean hasAlpha = ImageUtils.hasAlpha(image);
        BufferedImage bimage = null;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        try {
            int transparency = 1;
            if (hasAlpha) {
                transparency = 2;
            }
            GraphicsDevice gs = ge.getDefaultScreenDevice();
            GraphicsConfiguration gc = gs.getDefaultConfiguration();
            bimage = gc.createCompatibleImage(image.getWidth(null), image.getHeight(null), transparency);
        }
        catch (HeadlessException e) {
            e.printStackTrace();
        }
        if (bimage == null) {
            int type = 1;
            if (hasAlpha) {
                type = 2;
            }
            bimage = new BufferedImage(image.getWidth(null), image.getHeight(null), type);
        }
        Graphics2D g = null;
        try {
            g = bimage.createGraphics();
            g.drawImage(image, 0, 0, null);
        }
        finally {
            if (g != null) {
                g.dispose();
            }
        }
        return bimage;
    }

    private static boolean hasAlpha(Image image) {
        if (image instanceof BufferedImage) {
            return ((BufferedImage)image).getColorModel().hasAlpha();
        }
        PixelGrabber pg = new PixelGrabber(image, 0, 0, 1, 1, false);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return pg.getColorModel().hasAlpha();
    }

    public static Image setAlpha(Image image, float alpha) {
        BufferedImage tmpImg = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics2D g2d = (Graphics2D)tmpImg.getGraphics();
        g2d.setComposite(AlphaComposite.SrcOver.derive(alpha));
        g2d.drawImage(image, 0, 0, null);
        return tmpImg;
    }

    public static BufferedImage loadThumb(Object source, int size) throws IOException {
        ImageInputStream is = ImageIO.createImageInputStream(source);
        BufferedImage img = null;
        if (source instanceof File && ImageUtils.isSVGFile((File)source)) {
            img = ImageIO.read((File)source);
            if (Utilities.isMac()) {
                return ImageUtils.smartSizeFast(img, size);
            }
        }
        if ((img = ImageUtils.subsampleImage(is, size, img)) != null && (img.getWidth(null) > size || img.getHeight(null) > size)) {
            img = ImageUtils.smartSize(img, size);
        }
        return img;
    }

    public static Image loadAndSize(File file, double width, double height) throws IOException {
        BufferedImage image = ImageIO.read(file);
        return ImageUtils.smartSize(image, width, height);
    }

    public static Image loadAndSize(File file, double size) throws IOException {
        BufferedImage image = ImageIO.read(file);
        return ImageUtils.smartSize(image, size);
    }

    private static BufferedImage resize(BufferedImage image, double width, double height) {
        return ImageUtils.resize(image, 0.0, 0.0, width, height, true);
    }

    private static BufferedImage resize(BufferedImage image, double xOrigin, double yOrigin, double width, double height, boolean pretty) {
        int type = image.getType() == 0 ? 2 : image.getType();
        BufferedImage resizedImage = new BufferedImage((int)(width + xOrigin * 2.0), (int)(height + yOrigin * 2.0), type);
        Graphics2D g = resizedImage.createGraphics();
        g.setComposite(AlphaComposite.Src);
        if (pretty) {
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        g.drawImage(image, (int)xOrigin, (int)yOrigin, (int)width, (int)height, null);
        g.dispose();
        return resizedImage;
    }

    public static Image resize(Image img, int width, int height) {
        if (img != null) {
            int requestedWidth = width;
            int requestedHeight = height;
            if (requestedWidth == -1 && requestedHeight == -1) {
                requestedWidth = img.getWidth(null);
                requestedHeight = img.getHeight(null);
            } else if (requestedWidth == -1) {
                requestedWidth = ImageUtils.calculateRelativeX(img.getWidth(null), img.getHeight(null), requestedHeight);
            } else if (requestedHeight == -1) {
                requestedHeight = ImageUtils.calculateRelativeY(img.getWidth(null), img.getHeight(null), requestedWidth);
            }
            BufferedImage newImage = ImageUtils.smartSize((BufferedImage)img, (double)requestedWidth, requestedHeight);
            return newImage;
        }
        return null;
    }

    private static int calculateRelativeY(float x, float y, float newX) {
        float newY = y / x * newX;
        return Math.round(newY);
    }

    private static int calculateRelativeX(float x, float y, float newY) {
        float newX = x / y * newY;
        return Math.round(newX);
    }

    public static BufferedImage smartClip(BufferedImage bi, double maxSize) {
        if ((double)bi.getWidth() > maxSize || (double)bi.getHeight() > maxSize) {
            return ImageUtils.smartSize(bi, maxSize);
        }
        return bi;
    }

    public static BufferedImage smartClip(BufferedImage bi, double maxWidth, double maxHeight) {
        if ((double)bi.getWidth() > maxWidth || (double)bi.getHeight() > maxHeight) {
            return ImageUtils.smartSize(bi, maxWidth, maxHeight);
        }
        return bi;
    }

    public static BufferedImage smartSizeFast(BufferedImage image, double size) {
        return ImageUtils.smartSize(image, size, false);
    }

    public static BufferedImage smartSize(BufferedImage image, double size) {
        return ImageUtils.smartSize(image, size, true);
    }

    private static BufferedImage smartSize(BufferedImage image, double size, boolean pretty) {
        double yOrigin;
        double height;
        double xOrigin;
        double width;
        int imageHeight;
        int imageWidth = image.getWidth();
        if (imageWidth > (imageHeight = image.getHeight())) {
            width = size;
            xOrigin = 0.0;
            double ratio = size / (double)imageWidth;
            height = (double)imageHeight * ratio;
            yOrigin = (size - height) / 2.0;
        } else {
            height = size;
            yOrigin = 0.0;
            double ratio = size / (double)imageHeight;
            width = (double)imageWidth * ratio;
            xOrigin = (size - width) / 2.0;
        }
        return ImageUtils.smartSize(image, xOrigin, yOrigin, width, height, pretty);
    }

    public static BufferedImage smartSize(BufferedImage image, double fitWidth, double fitHeight, boolean pretty) {
        int imageWidth = image.getWidth();
        int imageHeight = image.getHeight();
        boolean tooLarge = false;
        double ratio1 = 1.0;
        if ((double)imageWidth > fitWidth) {
            tooLarge = true;
            ratio1 = fitWidth / (double)imageWidth;
        }
        double ratio2 = 1.0;
        if ((double)imageHeight > fitHeight) {
            tooLarge = true;
            ratio2 = fitHeight / (double)imageHeight;
        }
        if (!tooLarge) {
            return ImageUtils.centreOnLargerSize(image, fitWidth, fitHeight, pretty);
        }
        double ratio = Math.min(ratio1, ratio2);
        double height = (double)imageHeight * ratio;
        height = Math.min(height, fitHeight);
        double yOrigin = (fitHeight - height) / 2.0;
        double width = (double)imageWidth * ratio;
        width = Math.min(width, fitWidth);
        double xOrigin = (fitWidth - width) / 2.0;
        return ImageUtils.smartSize(image, xOrigin, yOrigin, width, height, pretty);
    }

    public static BufferedImage centreOnLargerSize(BufferedImage image, double size, boolean pretty) {
        return ImageUtils.centreOnLargerSize(image, size, size, pretty);
    }

    public static BufferedImage centreOnLargerSize(BufferedImage image, double width, double height, boolean pretty) {
        BufferedImage resizedImage = image;
        int imageWidth = image.getWidth();
        int imageHeight = image.getHeight();
        if ((int)width >= imageWidth && (int)height >= imageHeight) {
            int type = (image = ImageUtils.createCompatibleImage(image)).getType() == 0 ? 2 : image.getType();
            resizedImage = new BufferedImage((int)width, (int)height, type);
            Graphics2D g = resizedImage.createGraphics();
            g.setComposite(AlphaComposite.Src);
            if (pretty) {
                g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            g.drawImage(image, (int)(width - (double)imageWidth) / 2, (int)(height - (double)imageHeight) / 2, imageWidth, imageHeight, null);
            g.dispose();
        }
        return resizedImage;
    }

    public static BufferedImage smartSize(BufferedImage image, double width, double height) {
        return ImageUtils.smartSize(image, 0.0, 0.0, width, height, true);
    }

    public static BufferedImage smartSize(BufferedImage image, double xOrigin, double yOrigin, double width, double height, boolean pretty) {
        image = ImageUtils.createCompatibleImage(image);
        if (pretty) {
            image = ImageUtils.resize(image, width * 4.0, height * 4.0);
            image = ImageUtils.blurImage(image);
        }
        return ImageUtils.resize(image, xOrigin, yOrigin, width, height, pretty);
    }

    public static BufferedImage blurImage(BufferedImage image) {
        float ninth = 0.11111111f;
        float[] blurKernel = new float[]{ninth, ninth, ninth, ninth, ninth, ninth, ninth, ninth, ninth};
        HashMap<RenderingHints.Key, Object> map = new HashMap<RenderingHints.Key, Object>();
        map.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        map.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        map.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        RenderingHints hints = new RenderingHints(map);
        ConvolveOp op = new ConvolveOp(new Kernel(3, 3, blurKernel), 1, hints);
        BufferedImage destImage = ImageUtils.createCompatibleDestImage(image, null);
        return op.filter(image, destImage);
    }

    public static BufferedImage createCompatibleDestImage(BufferedImage src, ColorModel destCM) {
        int w = src.getWidth();
        int h = src.getHeight();
        WritableRaster wr = null;
        if (destCM == null) {
            destCM = src.getColorModel();
            if (destCM instanceof IndexColorModel) {
                destCM = ColorModel.getRGBdefault();
            } else {
                wr = src.getData().createCompatibleWritableRaster(w, h);
            }
        }
        if (wr == null) {
            wr = destCM.createCompatibleWritableRaster(w, h);
        }
        BufferedImage image = new BufferedImage(destCM, wr, destCM.isAlphaPremultiplied(), null);
        return image;
    }

    private static BufferedImage createCompatibleImage(BufferedImage image) {
        BufferedImageGraphicsConfig gc = BufferedImageGraphicsConfig.getConfig(image);
        int w = image.getWidth();
        int h = image.getHeight();
        return ImageUtils.createCompatibleImage(image, gc, w, h);
    }

    private static BufferedImage createCompatibleImage(BufferedImage image, GraphicsConfiguration gc, int width, int height) {
        BufferedImage result = gc.createCompatibleImage(width, height, 3);
        Graphics2D g2 = result.createGraphics();
        g2.drawRenderedImage(image, null);
        g2.dispose();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getImageFormatName(Object o) {
        ImageInputStream iis = null;
        try {
            iis = ImageIO.createImageInputStream(o);
            Iterator<ImageReader> readers = ImageIO.getImageReaders(iis);
            ImageReader reader = ImageUtils.skipTwelveMonkeysBMPImageReader(readers, false);
            String string = reader.getFormatName();
            return string;
        }
        catch (IOException iOException) {
        }
        finally {
            if (iis != null) {
                try {
                    iis.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    private static ImageReader skipTwelveMonkeysBMPImageReader(Iterator<ImageReader> readers, boolean throwException) throws IOException {
        if (!readers.hasNext()) {
            if (throwException) {
                throw new IOException("No reader available for supplied image stream.");
            }
            return null;
        }
        ImageReader reader = readers.next();
        String readerString = reader.toString().toLowerCase();
        if (readerString.contains(TWELVEMONKEYS_BMPIMAGEREADER)) {
            reader = ImageUtils.skipTwelveMonkeysBMPImageReader(readers, throwException);
        }
        return reader;
    }

    public static boolean equals(BufferedImage b1, BufferedImage b2) {
        if (b1 == b2) {
            return true;
        }
        if (b1 == null || b2 == null) {
            return false;
        }
        if (b1.getWidth() != b2.getWidth()) {
            return false;
        }
        if (b1.getHeight() != b2.getHeight()) {
            return false;
        }
        for (int i = 0; i < b1.getWidth(); ++i) {
            for (int j = 0; j < b1.getHeight(); ++j) {
                if (b1.getRGB(i, j) == b2.getRGB(i, j)) continue;
                return false;
            }
        }
        return true;
    }

    public static void write(Image image, String format, FileObject fileObject) throws IOException {
        try (BufferedOutputStream os = new BufferedOutputStream(fileObject.getOutputStream());){
            ImageIO.write((RenderedImage)ImageUtils.createBufferedImage(image), format, os);
        }
    }

    public static BufferedImage subsampleImage(ImageInputStream inputStream, int size, BufferedImage image) throws IOException {
        Dimension d1;
        Iterator<ImageReader> readers = ImageIO.getImageReaders(inputStream);
        ImageReader reader = ImageUtils.skipTwelveMonkeysBMPImageReader(readers, true);
        ImageReadParam imageReaderParams = reader.getDefaultReadParam();
        reader.setInput(inputStream);
        if (image == null) {
            d1 = new Dimension(reader.getWidth(0), reader.getHeight(0));
        } else {
            Rectangle bounds = BufferedImageGraphicsConfig.getConfig(image).getBounds();
            int w1 = bounds.width;
            int h1 = bounds.height;
            d1 = new Dimension(w1, h1);
        }
        Dimension d2 = new Dimension(size, size);
        int subsampling = (int)ImageUtils.scaleSubsamplingMaintainAspectRatio(d1, d2);
        imageReaderParams.setSourceSubsampling(subsampling, subsampling, 0, 0);
        return reader.read(0, imageReaderParams);
    }

    public static long scaleSubsamplingMaintainAspectRatio(Dimension d1, Dimension d2) {
        int subsampling = 1;
        if (d1.getWidth() > d2.getWidth()) {
            subsampling = (int)Math.ceil(d1.getWidth() / d2.getWidth());
        } else if (d1.getHeight() > d2.getHeight()) {
            subsampling = (int)Math.ceil(d1.getHeight() / d2.getHeight());
        }
        return subsampling;
    }

    public static Color getDominantColor(BufferedImage source) {
        return ImageUtils.getDominantColor(source, true);
    }

    public static Color getDominantColor(BufferedImage source, boolean applyThreshold) {
        if (source == null) {
            return new Color(255, 255, 255, 255);
        }
        int[] colorBins = new int[36];
        int maxBin = -1;
        float[] sumHue = new float[36];
        float[] sumSat = new float[36];
        float[] sumVal = new float[36];
        float[] hsv = new float[3];
        int height = source.getHeight();
        int width = source.getWidth();
        for (int row = 0; row < height; ++row) {
            for (int col = 0; col < width; ++col) {
                int c = source.getRGB(col, row);
                if ((c >> 24 & 0xFF) < 128) continue;
                Color.RGBtoHSB(c >> 16 & 0xFF, c >> 8 & 0xFF, c & 0xFF, hsv);
                if (applyThreshold && (hsv[1] <= 0.35f || hsv[2] <= 0.35f)) continue;
                int bin = (int)Math.floor(hsv[0] / 10.0f);
                sumHue[bin] = sumHue[bin] + hsv[0];
                sumSat[bin] = sumSat[bin] + hsv[1];
                sumVal[bin] = sumVal[bin] + hsv[2];
                int n = bin;
                colorBins[n] = colorBins[n] + 1;
                if (maxBin >= 0 && colorBins[bin] <= colorBins[maxBin]) continue;
                maxBin = bin;
            }
        }
        if (maxBin < 0) {
            return new Color(255, 255, 255, 255);
        }
        hsv[0] = sumHue[maxBin] / (float)colorBins[maxBin];
        hsv[1] = sumSat[maxBin] / (float)colorBins[maxBin];
        hsv[2] = sumVal[maxBin] / (float)colorBins[maxBin];
        return new Color(Color.HSBtoRGB(hsv[0], hsv[1], hsv[2]));
    }

    public static Dimension calcScaledSize(Image image, double scaleTo) {
        int imgWidth = image.getWidth(null);
        int imgHeight = image.getHeight(null);
        Dimension d = new Dimension();
        d.setSize(scaleTo, scaleTo);
        double ratio = (double)imgWidth / (double)imgHeight;
        if (ratio > 1.0) {
            d.setSize(scaleTo, scaleTo / ratio);
        } else if (ratio < 1.0) {
            d.setSize(scaleTo * ratio, scaleTo);
        }
        return d;
    }

    public static void drawImageDouble(Graphics2D g, Image image, double x, double y, double width, double height, int scaleType) {
        AffineTransform originalTransform = g.getTransform();
        g.translate(x, y);
        switch (scaleType) {
            case 0: {
                break;
            }
            case 1: {
                if (!ImageUtils.mustScale(width, image.getWidth(null)) && !ImageUtils.mustScale(height, image.getHeight(null))) break;
                g.scale(width / (double)image.getWidth(null), height / (double)image.getHeight(null));
                break;
            }
            case 2: {
                if (!ImageUtils.mustScale(width, image.getWidth(null)) && !ImageUtils.mustScale(height, image.getHeight(null))) break;
                image = ImageUtils.resize(ImageUtils.createBufferedImage(image), width, height);
            }
        }
        g.drawImage(image, 0, 0, null);
        g.setTransform(originalTransform);
    }

    private static boolean mustScale(double l1, double l2) {
        return Math.abs(l1 - l2) > 0.1;
    }

    public static BufferedImage pixelate(Icon inputImage, int pixelSize) {
        Image img = ImageUtils.toImage(inputImage);
        return ImageUtils.pixelate(img, pixelSize);
    }

    public static BufferedImage pixelate(ImageIcon inputImage, int pixelSize) {
        Image img = ImageUtils.toImage(inputImage);
        return ImageUtils.pixelate(img, pixelSize);
    }

    public static BufferedImage pixelate(Image inputImage, int pixelSize) {
        BufferedImage bi = ImageUtils.createBufferedImage(inputImage);
        return ImageUtils.pixelate(bi, pixelSize);
    }

    public static BufferedImage pixelate(BufferedImage inputImage, int pixelSize) {
        int type = inputImage.getType();
        if (type == 0) {
            type = 2;
        }
        BufferedImage pixelated = new BufferedImage(inputImage.getWidth(), inputImage.getHeight(), type);
        pixelated = ImageUtils.blurImage(pixelated);
        for (int y = 0; y < inputImage.getHeight(); y += pixelSize) {
            for (int x = 0; x < inputImage.getWidth(); x += pixelSize) {
                BufferedImage cropped = ImageUtils.cropImage(inputImage, x, y, pixelSize, pixelSize);
                int color = cropped.getRGB(0, 0);
                for (int yd = y; yd < y + pixelSize && yd < pixelated.getHeight(); ++yd) {
                    for (int xd = x; xd < x + pixelSize && xd < pixelated.getWidth(); ++xd) {
                        pixelated.setRGB(xd, yd, color);
                    }
                }
            }
        }
        pixelated = ImageUtils.blurImage(pixelated);
        return pixelated;
    }

    private static BufferedImage cropImage(BufferedImage image, int x, int y, int width, int height) {
        int n = x < 0 ? 0 : (x = x > image.getWidth() ? image.getWidth() : x);
        int n2 = y < 0 ? 0 : (y = y > image.getHeight() ? image.getHeight() : y);
        int n3 = width < 1 ? 1 : (width = x + width > image.getWidth() ? image.getWidth() - x : width);
        height = height < 1 ? 1 : (y + height > image.getHeight() ? image.getHeight() - y : height);
        return image.getSubimage(x, y, width, height);
    }

    public static synchronized Image getBrokenImage(int width, int height) {
        String baseResource = "com/paterva/maltego/util/resources/BrokenImage.png";
        IconSize size = IconSize.getSize(width, height);
        Optional<Image> image = BROKEN_IMAGE_SIZES.get((Object)size);
        if (image == null) {
            String resource = size.addPostfix(baseResource);
            image = Optional.ofNullable(ImageUtilities.loadImage((String)resource));
            BROKEN_IMAGE_SIZES.put(size, image);
        }
        return image.isPresent() ? image.get() : null;
    }
}

