/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util;

import com.paterva.maltego.util.ColorUtilities;
import com.paterva.maltego.util.StringUtilities;
import java.awt.Color;
import java.awt.Desktop;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JTextPane;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;

public class HtmlUtils {
    private static final JTextPane TEXT_PANE = new JTextPane();

    public static String addSkeleton(String text) {
        return "<html>" + text + "</html>";
    }

    public static String addColor(String text, Color color) {
        return "<font color=\"" + ColorUtilities.encode(color) + "\">" + text + "</font>";
    }

    public static Color getColor(String text) {
        String textTemp = text.replaceAll("\\s+", " ").toLowerCase();
        int index = textTemp.indexOf("font color");
        if ((index = textTemp.indexOf("#", index)) != -1) {
            try {
                String colorString = textTemp.substring(index, index + 7);
                return Color.decode(colorString);
            }
            catch (IndexOutOfBoundsException | NumberFormatException runtimeException) {
                // empty catch block
            }
        }
        return null;
    }

    public static String makeBold(String text) {
        return "<b>" + text + "</b>";
    }

    public static String removeSkeleton(String text) {
        text = text.replaceFirst("(?msi)^.*<html>(.*)</html>.*$", "$1");
        text = text.replaceFirst("(?msi)^.*<body>(.*)</body>.*$", "$1");
        return text.trim();
    }

    public static String addHrefs(String text) {
        text = text.replaceAll("(?mi)\\b((\\w+://|www[.])[-A-Za-z0-9+&@#/%?=~_()|!:,.;]*[-A-Za-z0-9+&@#/%=~_(|])", "<a href=\"$1\">$1</a>");
        return text;
    }

    public static String removeHrefs(String text) {
        text = text.replaceAll("(?msi)<a href[^>]+>(.*?)</a>", "$1");
        return text;
    }

    public static boolean containsHtmlLink(String text) {
        return text != null && text.toLowerCase().contains("</a>") && !text.toLowerCase().contains("</a>]]>");
    }

    public static String escapeXmlInHtml(String xmlText) {
        int start = 0;
        String patternText = "</a>";
        String escapedOpenBracket = "&lt;";
        String escapedCloseBracket = "&gt;";
        String escapedPattern = patternText.replace("<", escapedOpenBracket).replace(">", escapedCloseBracket);
        Pattern pattern = Pattern.compile(patternText);
        Matcher matcher = pattern.matcher(xmlText);
        StringBuilder sb = new StringBuilder();
        while (matcher.find()) {
            String pre = xmlText.substring(start, matcher.start());
            int open = pre.lastIndexOf("<a");
            int close = pre.lastIndexOf(">");
            if (open > 0 && close > 0 && close > open) {
                StringBuilder temp = new StringBuilder(pre);
                temp.replace(close, close + 1, escapedCloseBracket).replace(open, open + 2, escapedOpenBracket + "a");
                sb.append(temp.toString());
                sb.append(escapedPattern);
            } else {
                sb.append(pre).append(patternText);
            }
            start = matcher.end();
        }
        String post = xmlText.substring(start, xmlText.length());
        sb.append(post);
        return sb.toString();
    }

    public static String getPlainText(String htmlText) {
        htmlText = "<html><body>" + htmlText + "</body></html>";
        try {
            Document doc = TEXT_PANE.getDocument();
            doc.remove(0, doc.getLength());
            if (htmlText == null || htmlText.equals("")) {
                return htmlText;
            }
            StringReader r = new StringReader(htmlText);
            EditorKit kit = TEXT_PANE.getEditorKit();
            kit.read(r, doc, 0);
            return doc.getText(0, doc.getLength());
        }
        catch (Exception ex) {
            return htmlText;
        }
    }

    public static String getClickableText(String text, FontMetrics fm, Insets insets, int prefWidth, boolean wrapLink) {
        StringBuilder sb = new StringBuilder("");
        Pattern pattern = Pattern.compile("(?<=^|\\s+)((?:http[s]?://|www\\.)[-\\w\\.\\:/]+(?:/[^\\s]*)*)(?=\\s+|$)");
        Matcher matcher = pattern.matcher(text);
        int pos = 0;
        while (matcher.find()) {
            URL browseUrl;
            String normal = text.substring(pos, matcher.start());
            String urlStr = matcher.group(1);
            URL url = null;
            try {
                String properUrlStr = urlStr;
                if (properUrlStr.startsWith("www.")) {
                    properUrlStr = "http://" + properUrlStr;
                }
                url = new URL(properUrlStr);
            }
            catch (MalformedURLException properUrlStr) {
                // empty catch block
            }
            if (url == null) {
                normal = normal + urlStr;
            }
            if (!normal.isEmpty()) {
                sb.append(normal);
            }
            if ((browseUrl = url) != null) {
                String displayUrlString;
                String browseUrlString = browseUrl.toString();
                int index = 0;
                int query = browseUrlString.indexOf("?");
                int scroll = browseUrlString.indexOf("#");
                if (query > 0 && scroll > 0) {
                    index = Math.min(query, scroll);
                } else if (query > 0) {
                    index = query;
                } else if (scroll > 0) {
                    index = scroll;
                }
                String string = displayUrlString = index > 0 ? browseUrlString.substring(0, index) : browseUrlString;
                if (wrapLink) {
                    displayUrlString = StringUtilities.getWrappedText(displayUrlString, fm, insets, prefWidth);
                }
                sb.append("<a href=\"" + browseUrlString + "\">" + displayUrlString + "</a>");
            }
            pos = matcher.end();
        }
        String rest = text.substring(pos);
        if (!rest.isEmpty()) {
            sb.append(rest);
        }
        return sb.toString();
    }

    public static String mailTo(String email, String displayValue, boolean showIfSupported) {
        Desktop desktop;
        String mailToString = email;
        String emailUri = email;
        if (Desktop.isDesktopSupported() && (desktop = Desktop.getDesktop()).isSupported(Desktop.Action.MAIL)) {
            if (displayValue != null) {
                String subject = "Maltego - " + displayValue + " enquiry";
                try {
                    subject = HtmlUtils.encode(subject);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                emailUri = "mailto:" + email + "?subject=" + subject;
            }
            try {
                URI mailto = new URI(emailUri);
                mailToString = "<a href=\"" + emailUri + "\">" + email + "</a>";
                if (showIfSupported) {
                    desktop.mail(mailto);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return mailToString;
    }

    private static String encode(String text) throws UnsupportedEncodingException {
        return URLEncoder.encode(text, StandardCharsets.UTF_8.name()).replace("+", "%20");
    }

    static {
        TEXT_PANE.setContentType("text/html");
    }
}

