/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.wrapper;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphEntity;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.GraphLink;
import com.paterva.maltego.core.GraphPart;
import com.paterva.maltego.core.Guid;
import com.paterva.maltego.core.LinkEntityIDs;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.core.MaltegoPart;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphDataStore;
import com.paterva.maltego.graph.store.data.GraphDataStoreReader;
import com.paterva.maltego.graph.store.data.GraphDataStoreWriter;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.query.part.EntitiesDataQuery;
import com.paterva.maltego.graph.store.query.part.EntityDataQuery;
import com.paterva.maltego.graph.store.query.part.EntitySectionsQuery;
import com.paterva.maltego.graph.store.query.part.LinkDataQuery;
import com.paterva.maltego.graph.store.query.part.LinkSectionsQuery;
import com.paterva.maltego.graph.store.query.part.LinksDataQuery;
import com.paterva.maltego.graph.store.query.part.PartDataQuery;
import com.paterva.maltego.graph.store.query.part.PartSectionsQuery;
import com.paterva.maltego.graph.store.structure.GraphStructureReader;
import com.paterva.maltego.graph.wrapper.GraphIDProvider;
import com.paterva.maltego.graph.wrapper.GraphWrapper;
import com.paterva.maltego.graph.wrapper.MaltegoGraphManager;
import com.paterva.maltego.typing.DataSource;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openide.util.Exceptions;
import yguard.A.A.D;
import yguard.A.A.E;
import yguard.A.A.Z;
import yguard.A.J.SA;

public class GraphStoreHelper {
    private GraphStoreHelper() {
    }

    public static GraphPart getPart(DataSource dataSource) {
        return null;
    }

    public static Set<EntityID> getEntityIDs(GraphID graphID) {
        return GraphStoreHelper.getEntities(graphID).keySet();
    }

    public static Set<EntityID> getEntityIDs(D graph) {
        return GraphStoreHelper.getEntities(graph).keySet();
    }

    public static Set<LinkID> getLinkIDs(GraphID graphID) {
        return GraphStoreHelper.getLinks(graphID).keySet();
    }

    public static Set<LinkID> getLinkIDs(D graph) {
        return GraphStoreHelper.getLinks(graph).keySet();
    }

    public static MaltegoEntity getEntity(GraphEntity entity) {
        return GraphStoreHelper.getEntity(GraphStoreHelper.getDataStoreReader(entity.getGraphID()), (EntityID)entity.getID());
    }

    public static MaltegoEntity getEntity(GraphID graphID, EntityID entityID) {
        return GraphStoreHelper.getEntity(GraphStoreHelper.getDataStoreReader(graphID), entityID);
    }

    public static MaltegoEntity getEntity(D graph, EntityID entityID) {
        return GraphStoreHelper.getEntity(GraphStoreHelper.getDataStoreReader(graph), entityID);
    }

    public static MaltegoEntity getEntity(GraphDataStoreReader reader, EntityID entityID) {
        try {
            return reader.getEntity(entityID);
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    public static Map<EntityID, MaltegoEntity> getEntities(GraphID graphID) {
        EntitiesDataQuery query = new EntitiesDataQuery();
        query.setAllIDs(true);
        return GraphStoreHelper.getEntities(GraphStoreHelper.getDataStoreReader(graphID), query);
    }

    public static Map<EntityID, MaltegoEntity> getEntities(D graph) {
        EntitiesDataQuery query = new EntitiesDataQuery();
        query.setAllIDs(true);
        return GraphStoreHelper.getEntities(GraphStoreHelper.getDataStoreReader(graph), query);
    }

    public static Map<EntityID, MaltegoEntity> getEntities(GraphID graphID, Collection<EntityID> ids) {
        if (ids.size() == 1) {
            EntityID id = ids.iterator().next();
            MaltegoEntity entity = GraphStoreHelper.getEntity(graphID, id);
            return Collections.singletonMap(id, entity);
        }
        EntitiesDataQuery query = new EntitiesDataQuery();
        query.setIDs(GraphStoreHelper.getIdSet(ids));
        return GraphStoreHelper.getEntities(GraphStoreHelper.getDataStoreReader(graphID), query);
    }

    public static Map<EntityID, MaltegoEntity> getEntities(D graph, Collection<EntityID> ids) {
        EntitiesDataQuery query = new EntitiesDataQuery();
        query.setIDs(GraphStoreHelper.getIdSet(ids));
        return GraphStoreHelper.getEntities(GraphStoreHelper.getDataStoreReader(graph), query);
    }

    public static Map<EntityID, MaltegoEntity> getEntities(GraphDataStoreReader reader, EntitiesDataQuery query) {
        try {
            return reader.getEntities(query);
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return Collections.EMPTY_MAP;
        }
    }

    public static Set<MaltegoEntity> getMaltegoEntityClones(Collection<GraphEntity> graphEntities) {
        HashSet<MaltegoEntity> entities = new HashSet<MaltegoEntity>();
        for (GraphEntity graphEntity : graphEntities) {
            entities.add(GraphStoreHelper.getEntity(graphEntity).createClone());
        }
        return entities;
    }

    public static Set<MaltegoEntity> getMaltegoEntities(GraphID graphID) {
        return new HashSet<MaltegoEntity>(GraphStoreHelper.getEntities(graphID).values());
    }

    public static Set<MaltegoEntity> getMaltegoEntities(D graph) {
        return new HashSet<MaltegoEntity>(GraphStoreHelper.getEntities(graph).values());
    }

    public static Set<MaltegoEntity> getMaltegoEntities(GraphID graphID, Collection<EntityID> ids) {
        return new HashSet<MaltegoEntity>(GraphStoreHelper.getEntities(graphID, ids).values());
    }

    public static Set<MaltegoEntity> getMaltegoEntities(D graph, Collection<EntityID> ids) {
        return new HashSet<MaltegoEntity>(GraphStoreHelper.getEntities(graph, ids).values());
    }

    public static MaltegoLink getLink(GraphLink link) {
        return GraphStoreHelper.getLink(GraphStoreHelper.getDataStoreReader(link.getGraphID()), (LinkID)link.getID());
    }

    public static MaltegoLink getLink(GraphID graphID, LinkID linkID) {
        return GraphStoreHelper.getLink(GraphStoreHelper.getDataStoreReader(graphID), linkID);
    }

    public static MaltegoLink getLink(D graph, LinkID linkID) {
        return GraphStoreHelper.getLink(GraphStoreHelper.getDataStoreReader(graph), linkID);
    }

    public static MaltegoLink getLink(GraphDataStoreReader reader, LinkID linkID) {
        try {
            return reader.getLink(linkID);
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    public static Map<LinkID, MaltegoLink> getLinks(GraphID graphID) {
        LinksDataQuery query = new LinksDataQuery();
        query.setAllIDs(true);
        return GraphStoreHelper.getLinks(GraphStoreHelper.getDataStoreReader(graphID), query);
    }

    public static Map<LinkID, MaltegoLink> getLinks(D graph) {
        LinksDataQuery query = new LinksDataQuery();
        query.setAllIDs(true);
        return GraphStoreHelper.getLinks(GraphStoreHelper.getDataStoreReader(graph), query);
    }

    public static Map<LinkID, MaltegoLink> getLinks(GraphID graphID, Collection<LinkID> ids) {
        LinksDataQuery query = new LinksDataQuery();
        query.setIDs(GraphStoreHelper.getIdSet(ids));
        return GraphStoreHelper.getLinks(GraphStoreHelper.getDataStoreReader(graphID), query);
    }

    public static Map<LinkID, MaltegoLink> getLinks(D graph, Collection<LinkID> ids) {
        LinksDataQuery query = new LinksDataQuery();
        query.setIDs(GraphStoreHelper.getIdSet(ids));
        return GraphStoreHelper.getLinks(GraphStoreHelper.getDataStoreReader(graph), query);
    }

    public static Map<LinkID, MaltegoLink> getLinks(GraphDataStoreReader reader, LinksDataQuery query) {
        try {
            return reader.getLinks(query);
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return Collections.EMPTY_MAP;
        }
    }

    public static Set<MaltegoLink> getMaltegoLinks(GraphID graphID) {
        return new HashSet<MaltegoLink>(GraphStoreHelper.getLinks(graphID).values());
    }

    public static Set<MaltegoLink> getMaltegoLinks(D graph) {
        return new HashSet<MaltegoLink>(GraphStoreHelper.getLinks(graph).values());
    }

    public static Set<MaltegoLink> getMaltegoLinks(GraphID graphID, Collection<LinkID> ids) {
        return new HashSet<MaltegoLink>(GraphStoreHelper.getLinks(graphID, ids).values());
    }

    public static Set<MaltegoLink> getMaltegoLinks(D graph, Collection<LinkID> ids) {
        return new HashSet<MaltegoLink>(GraphStoreHelper.getLinks(graph, ids).values());
    }

    public static MaltegoPart getPart(GraphPart part) {
        if (part instanceof GraphEntity) {
            return GraphStoreHelper.getEntity((GraphEntity)part);
        }
        return GraphStoreHelper.getLink((GraphLink)part);
    }

    public static GraphDataStore getDataStore(GraphPart part) {
        return GraphStoreHelper.getGraphStore(part.getGraphID()).getGraphDataStore();
    }

    public static GraphDataStoreReader getDataStoreReader(D graph) {
        return GraphStoreHelper.getGraphStore(GraphIDProvider.forGraph(graph)).getGraphDataStore().getDataStoreReader();
    }

    public static GraphDataStoreReader getDataStoreReader(GraphPart part) {
        return GraphStoreHelper.getDataStoreReader(part.getGraphID());
    }

    public static GraphDataStoreReader getDataStoreReader(GraphID graphID) {
        return GraphStoreHelper.getGraphStore(graphID).getGraphDataStore().getDataStoreReader();
    }

    public static GraphDataStoreWriter getDataStoreWriter(GraphPart part) {
        return GraphStoreHelper.getGraphStore(part.getGraphID()).getGraphDataStore().getDataStoreWriter();
    }

    public static GraphStore getGraphStore(GraphID graphID) {
        try {
            return GraphStoreRegistry.getDefault().forGraphID(graphID);
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    public static <ID extends Guid> Set<ID> getIdSet(Collection<ID> ids) {
        return ids instanceof Set ? (Set<Object>)ids : new HashSet<ID>(ids);
    }

    public static <ID extends Guid> Set<ID> getIds(Collection<? extends MaltegoPart<ID>> parts) {
        HashSet<Guid> ids = new HashSet<Guid>(parts.size());
        for (MaltegoPart<ID> part : parts) {
            ids.add(part.getID());
        }
        return ids;
    }

    public static <ID extends Guid> Set<ID> getIdsFor(Collection<? extends GraphPart<ID>> parts) {
        HashSet<Guid> ids = new HashSet<Guid>(parts.size());
        for (GraphPart<ID> part : parts) {
            ids.add(part.getID());
        }
        return ids;
    }

    public static Set<GraphEntity> createTempGraphFor(Collection<MaltegoEntity> entities) {
        HashSet<GraphEntity> graphEntities = new HashSet<GraphEntity>();
        SA tempGraph = new SA();
        GraphID graphID = GraphIDProvider.forGraph(tempGraph);
        GraphStore tempGraphStore = GraphStoreHelper.getGraphStore(graphID);
        try {
            tempGraphStore.getGraphDataStore().getDataStoreWriter().putEntities(entities);
            for (MaltegoEntity entity : entities) {
                graphEntities.add(new GraphEntity(graphID, (EntityID)entity.getID()));
            }
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return graphEntities;
    }

    public static <T> Map<MaltegoLink, T> mapLinkIDsToLinks(D graph, Map<LinkID, T> connections) {
        HashMap<MaltegoLink, T> parts = new HashMap<MaltegoLink, T>(connections.size());
        for (Map.Entry<LinkID, T> entry : connections.entrySet()) {
            LinkID linkID = entry.getKey();
            MaltegoLink link = GraphStoreHelper.getLink(graph, linkID);
            parts.put(link, entry.getValue());
        }
        return parts;
    }

    public static Map<MaltegoLink, LinkEntityIDs> getConnectionLinks(GraphID graphID, Set<EntityID> entityIDs, Set<LinkID> linkIDs) {
        Map<LinkID, LinkEntityIDs> connections = GraphStoreHelper.getConnectionsForIDs(graphID, entityIDs, linkIDs);
        return GraphStoreHelper.getConnectionLinks(graphID, connections);
    }

    public static Map<MaltegoLink, LinkEntityIDs> getConnectionLinks(GraphID graphID, Map<LinkID, LinkEntityIDs> connections) {
        HashMap<MaltegoLink, LinkEntityIDs> clonedConnections = new HashMap<MaltegoLink, LinkEntityIDs>(connections.size());
        GraphDataStoreReader dataStoreReader = GraphStoreHelper.getDataStoreReader(graphID);
        try {
            LinksDataQuery linksDataQuery = new LinksDataQuery();
            linksDataQuery.setIDs(connections.keySet());
            LinkDataQuery linkDataQuery = new LinkDataQuery();
            linkDataQuery.setAllProperties(true);
            linkDataQuery.setAllSections(true);
            linksDataQuery.setPartDataQuery((PartDataQuery)linkDataQuery);
            Map links = dataStoreReader.getLinks(linksDataQuery);
            for (Map.Entry entry : links.entrySet()) {
                LinkID linkID = (LinkID)entry.getKey();
                MaltegoLink link = (MaltegoLink)entry.getValue();
                clonedConnections.put(link, connections.get(linkID));
            }
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return clonedConnections;
    }

    public static Map<MaltegoLink, LinkEntityIDs> getModelConnections(GraphID graphID, Collection<MaltegoLink> links) {
        HashMap<MaltegoLink, LinkEntityIDs> connections = new HashMap<MaltegoLink, LinkEntityIDs>();
        Map<LinkID, LinkEntityIDs> linksMap = GraphStoreHelper.getConnections(graphID, links);
        for (MaltegoLink link : links) {
            connections.put(link, linksMap.get(link.getID()));
        }
        return connections;
    }

    public static Map<LinkID, LinkEntityIDs> getConnections(GraphID graphID, Collection<MaltegoLink> links) {
        Map connections = Collections.EMPTY_MAP;
        try {
            GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
            GraphStructureReader structureReader = graphStore.getGraphStructureStore().getStructureReader();
            connections = structureReader.getEntities(GraphStoreHelper.getIds(links));
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return connections;
    }

    public static Map<LinkID, LinkEntityIDs> getConnectionsForIDs(GraphID graphID, Set<EntityID> entityIDs, Set<LinkID> linkIDs) {
        Map connections = null;
        try {
            HashSet<LinkID> allLinkIDs = new HashSet<LinkID>(linkIDs);
            GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
            GraphStructureReader structureReader = graphStore.getGraphStructureStore().getStructureReader();
            allLinkIDs.addAll(structureReader.getLinks(entityIDs));
            connections = structureReader.getEntities(allLinkIDs);
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return connections;
    }

    public static Set<MaltegoEntity> cloneEntities(D graph, Set<EntityID> entityIDs) {
        HashSet<MaltegoEntity> clonedEntities = new HashSet<MaltegoEntity>();
        for (EntityID entityID : entityIDs) {
            clonedEntities.add(GraphStoreHelper.getEntity(graph, entityID).createClone());
        }
        return clonedEntities;
    }

    public static Set<MaltegoLink> cloneLinks(D graph, Set<LinkID> linkIDs) {
        HashSet<MaltegoLink> clonedLinks = new HashSet<MaltegoLink>();
        for (LinkID linkID : linkIDs) {
            clonedLinks.add(GraphStoreHelper.getLink(graph, linkID).createClone());
        }
        return clonedLinks;
    }

    public static Set<EntityID> getEntityIDs(D graph, E nodes) {
        HashSet<EntityID> entityIDs = new HashSet<EntityID>();
        GraphWrapper wrapper = MaltegoGraphManager.getWrapper(graph);
        nodes.toFirst();
        while (nodes.ok()) {
            entityIDs.add(wrapper.entityID(nodes.B()));
            nodes.next();
        }
        return entityIDs;
    }

    public static Set<LinkID> getLinkIDs(D graph, Z edges) {
        HashSet<LinkID> linkIDs = new HashSet<LinkID>();
        GraphWrapper wrapper = MaltegoGraphManager.getWrapper(graph);
        edges.toFirst();
        while (edges.ok()) {
            linkIDs.add(wrapper.linkID(edges.D()));
            edges.next();
        }
        return linkIDs;
    }

    public static Map<EntityID, Boolean> isPinned(GraphID graphID, Set<EntityID> entityIDs) {
        Map pinned = null;
        try {
            GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
            GraphStructureReader structureReader = graphStore.getGraphStructureStore().getStructureReader();
            pinned = structureReader.getPinned(entityIDs);
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return pinned;
    }

    public static Collection<MaltegoEntity> getMaltegoEntitiesWithAttachments(GraphID graphID) {
        Collection<Object> entities = Collections.EMPTY_SET;
        try {
            GraphDataStoreReader reader = GraphStoreHelper.getDataStoreReader(graphID);
            EntitiesDataQuery entitiesQuery = new EntitiesDataQuery();
            EntityDataQuery entityQuery = new EntityDataQuery();
            entityQuery.setPropertyNames(Collections.singleton("atts"));
            entityQuery.setMatchProperties(Collections.singletonMap("hasAttachments", true));
            entityQuery.setSections((PartSectionsQuery)new EntitySectionsQuery());
            entitiesQuery.setPartDataQuery((PartDataQuery)entityQuery);
            entities = reader.getEntities(entitiesQuery).values();
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return entities;
    }

    public static Collection<MaltegoLink> getMaltegoLinksWithAttachments(GraphID graphID) {
        Collection<Object> links = Collections.EMPTY_SET;
        try {
            GraphDataStoreReader reader = GraphStoreHelper.getDataStoreReader(graphID);
            LinksDataQuery linksQuery = new LinksDataQuery();
            LinkDataQuery linkQuery = new LinkDataQuery();
            linkQuery.setPropertyNames(Collections.singleton("atts"));
            linkQuery.setMatchProperties(Collections.singletonMap("hasAttachments", true));
            linkQuery.setSections((PartSectionsQuery)new LinkSectionsQuery());
            linksQuery.setPartDataQuery((PartDataQuery)linkQuery);
            links = reader.getLinks(linksQuery).values();
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return links;
    }
}

