/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transforms.tabular.ui.details.files;

import com.paterva.maltego.transforms.tabular.TabularTransformSourceRepository;
import com.paterva.maltego.transforms.tabular.data.TabularTransformSource;
import com.paterva.maltego.util.Args;
import com.paterva.maltego.util.ui.table.RowTableModel;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class TabularFilesTableModel
extends RowTableModel<String> {
    public static final String[] COLUMNS = new String[]{"Source File(s)"};
    private final TabularTransformSource transformSource;

    public TabularFilesTableModel(TabularTransformSource transformSource) {
        super(COLUMNS, transformSource.getSourceFiles());
        this.transformSource = transformSource;
    }

    public boolean isCellEditable(int row, int column) {
        return column == 0;
    }

    public Object getValueFor(String row, int column) {
        return row;
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        String strValue;
        if (aValue != null && StringUtils.isNotBlank((String)(strValue = aValue.toString()))) {
            ArrayList<String> files = new ArrayList<String>(this.transformSource.getSourceFiles());
            files.set(rowIndex, strValue);
            TabularTransformSourceRepository.getInstance().update((Object)this.transformSource.setSourceFiles(files));
        }
    }

    public void removeRow(int index) {
        this.removeRows(new int[]{index});
    }

    public void removeRows(int[] indices) {
        List files = this.getRows(indices);
        this.remove(files);
    }

    private void remove(List<String> files) {
        Args.notNull(files, (String)"files");
        TabularTransformSourceRepository.getInstance().update((Object)this.transformSource.removeSourceFiles(files));
    }
}

