/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.table.ui.imex;

import com.paterva.maltego.archive.mtz.MaltegoArchiveReader;
import com.paterva.maltego.archive.mtz.discover.DiscoveryContext;
import com.paterva.maltego.archive.mtz.discover.MtzDiscoveryItems;
import com.paterva.maltego.archive.mtz.discover.MtzDiscoveryProvider;
import com.paterva.maltego.graph.table.MappingRegistry;
import com.paterva.maltego.graph.table.TabularGraph;
import com.paterva.maltego.graph.table.ui.imex.MappingImporter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class MappingDiscoveryProvider
extends MtzDiscoveryProvider<MtzMappings> {
    public MtzMappings read(DiscoveryContext ctx, MaltegoArchiveReader reader) throws IOException {
        MappingImporter importer = new MappingImporter();
        return new MtzMappings(importer.read(reader), ctx);
    }

    public void apply(MtzMappings mappings) {
        for (TabularGraph mapping : mappings.getMappings()) {
            mapping.setReadOnly(true);
        }
        MappingImporter importer = new MappingImporter();
        importer.apply(mappings.getMappings());
    }

    public MtzMappings getNewAndMerged(MtzMappings items) {
        List<TabularGraph> mappings = items.getMappings();
        ArrayList<TabularGraph> newMappings = new ArrayList<TabularGraph>();
        MappingRegistry registry = MappingRegistry.getDefault();
        for (TabularGraph newMapping : mappings) {
            TabularGraph oldMapping = registry.get(newMapping.getName());
            if (oldMapping != null && oldMapping.isCopyOf(newMapping)) continue;
            newMappings.add(newMapping);
        }
        return new MtzMappings(newMappings, items.getContext());
    }

    public class MtzMappings
    extends MtzDiscoveryItems {
        private final List<TabularGraph> _mappings;

        private MtzMappings(List<TabularGraph> mappings, DiscoveryContext context) {
            super((MtzDiscoveryProvider)MappingDiscoveryProvider.this, context);
            this._mappings = mappings;
        }

        public String getDescription() {
            return "Mappings";
        }

        public List<TabularGraph> getMappings() {
            return this._mappings;
        }

        public int size() {
            return this._mappings.size();
        }
    }
}

