/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.manager.sets;

import com.paterva.maltego.transform.descriptor.TransformRepositoryRegistry;
import com.paterva.maltego.transform.descriptor.TransformSet;
import com.paterva.maltego.transform.descriptor.TransformSetRepository;
import com.paterva.maltego.transform.manager.nodes.AllSetTransformsChildFactory;
import com.paterva.maltego.transform.manager.nodes.AllSetsChildFactory;
import com.paterva.maltego.transform.manager.nodes.TransformProperties;
import com.paterva.maltego.transform.manager.sets.NewTransformSetAction;
import com.paterva.maltego.transform.manager.sets.TransformSetQuickFilter;
import com.paterva.maltego.util.StringUtilities;
import com.paterva.maltego.util.ui.AbstractNodeSelector;
import com.paterva.maltego.util.ui.outline.OutlineViewPanel;
import com.paterva.maltego.util.ui.outline.TextQuickFilter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyVetoException;
import javax.swing.ActionMap;
import javax.swing.DropMode;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeListener;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.windows.TopComponent;

public class TransformSetManagerTopComponent
extends TopComponent {
    private OutlineViewPanel _all = new OutlineViewPanel("Name");
    private OutlineViewPanel _sets = new OutlineViewPanel("Name");
    private ExplorerManager _allExplorer;
    private ExplorerManager _setExplorer;
    private JSplitPane _leftRightSplit;

    public TransformSetManagerTopComponent() {
        this(null);
    }

    public TransformSetManagerTopComponent(String selectSet) {
        this.initComponents();
        AbstractNode allTransforms = this.loadAllTransformsRoot();
        ExplorerViewWrapper allView = new ExplorerViewWrapper((Component)this._all, (Node)allTransforms);
        this._allExplorer = allView.getExplorerManager();
        this._leftRightSplit.setTopComponent(allView);
        this._all.getView().setProperties(new Node.Property[]{TransformProperties.inputConstraint(), TransformProperties.output(), TransformProperties.description()});
        this._all.getView().getOutline().setAutoResizeMode(3);
        this._all.getView().getOutline().getColumnModel().getColumn(0).setPreferredWidth(150);
        this._all.getView().getOutline().getColumnModel().getColumn(1).setPreferredWidth(60);
        this._all.getView().getOutline().getColumnModel().getColumn(2).setPreferredWidth(60);
        this._all.getView().getOutline().getColumnModel().getColumn(3).setPreferredWidth(60);
        this._all.getView().getOutline().setRootVisible(true);
        this._all.getView().getOutline().setDragEnabled(true);
        this._all.getView().getOutline().setDropMode(DropMode.ON);
        AbstractNode setRoot = new AbstractNode(Children.create((ChildFactory)new AllSetsChildFactory(), (boolean)false));
        setRoot.addNodeListener((NodeListener)new NodeSelector(selectSet));
        ExplorerViewWrapper setView = new ExplorerViewWrapper((Component)this._sets, (Node)setRoot);
        this._setExplorer = setView.getExplorerManager();
        this._leftRightSplit.setBottomComponent(setView);
        this._sets.getView().setProperties(new Node.Property[]{TransformProperties.inputConstraint(), TransformProperties.description()});
        this._sets.getView().getOutline().setAutoResizeMode(3);
        this._sets.getView().getOutline().getColumnModel().getColumn(0).setPreferredWidth(150);
        this._sets.getView().getOutline().getColumnModel().getColumn(1).setPreferredWidth(60);
        this._sets.getView().getOutline().getColumnModel().getColumn(2).setPreferredWidth(80);
        this._sets.setFilter((TextQuickFilter)new TransformSetQuickFilter());
        this._sets.getView().getOutline().setDragEnabled(true);
        this._sets.getView().getOutline().setDropMode(DropMode.ON);
        this._sets.addToToolbarLeft(NewTransformSetAction.instance());
        if (selectSet != null) {
            this.doSelectSet(selectSet);
        }
    }

    private AbstractNode loadAllTransformsRoot() {
        AbstractNode allTransforms = new AbstractNode(Children.create((ChildFactory)new AllSetTransformsChildFactory(TransformRepositoryRegistry.PERSISTED), (boolean)false));
        allTransforms.setIconBaseWithExtension("com/paterva/maltego/transform/manager/sets/TransformSet.png");
        allTransforms.setDisplayName("All Transforms");
        return allTransforms;
    }

    private void saveTransformSets(Node[] items) {
        for (Node item : items) {
            this.saveTransformSet(item);
        }
    }

    public void saveTransformSets() {
        Node[] allNodes = this._setExplorer.getRootContext().getChildren().getNodes();
        this.saveTransformSets(allNodes);
    }

    private void saveTransformSet(Node item) {
        TransformSet set = (TransformSet)item.getLookup().lookup(TransformSet.class);
        if (set != null) {
            TransformSetRepository.getDefault().put(set);
        }
    }

    private void doSelectSet(String setName) {
        try {
            if (!StringUtilities.isNullOrEmpty((String)setName)) {
                Node[] allNodes;
                for (Node node : allNodes = this._setExplorer.getRootContext().getChildren().getNodes()) {
                    TransformSet set = (TransformSet)node.getLookup().lookup(TransformSet.class);
                    if (set == null || !set.getName().equals(setName)) continue;
                    this._setExplorer.setSelectedNodes(new Node[]{node});
                    return;
                }
            }
        }
        catch (PropertyVetoException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public void refresh(String selectSet) {
        AbstractNode allTransforms = this.loadAllTransformsRoot();
        this._allExplorer.setRootContext((Node)allTransforms);
        AbstractNode setRoot = new AbstractNode(Children.create((ChildFactory)new AllSetsChildFactory(), (boolean)false));
        if (selectSet != null) {
            setRoot.addNodeListener((NodeListener)new NodeSelector(selectSet));
        }
        this._setExplorer.setRootContext((Node)setRoot);
    }

    public void refresh() {
        TransformSet set;
        String selectSet = null;
        Node[] node = this._setExplorer.getSelectedNodes();
        if (node.length > 0 && (set = (TransformSet)node[0].getLookup().lookup(TransformSet.class)) != null) {
            selectSet = set.getName();
        }
        this.refresh(selectSet);
    }

    private void initComponents() {
        this._leftRightSplit = new JSplitPane();
        this.setPreferredSize(new Dimension(700, 600));
        this.setLayout(new BorderLayout());
        this._leftRightSplit.setDividerLocation(450);
        this.add(this._leftRightSplit, "Center");
    }

    private static class ExplorerViewWrapper
    extends JPanel
    implements ExplorerManager.Provider,
    Lookup.Provider {
        private ExplorerManager _explorer = new ExplorerManager();
        private Lookup _lookup;

        public ExplorerViewWrapper(Component component, Node root) {
            this.setLayout(new BorderLayout());
            this.add(component, "Center");
            this._explorer.setRootContext(root);
            ActionMap map = this.getActionMap();
            map.put("delete", ExplorerUtils.actionDelete((ExplorerManager)this._explorer, (boolean)true));
            this.associateLookup(ExplorerUtils.createLookup((ExplorerManager)this._explorer, (ActionMap)map));
        }

        public ExplorerManager getExplorerManager() {
            return this._explorer;
        }

        private void associateLookup(Lookup lookup) {
            if (this._lookup != null) {
                throw new IllegalArgumentException("associateLookup can only be called once");
            }
            this._lookup = lookup;
        }

        public Lookup getLookup() {
            return this._lookup;
        }
    }

    private class NodeSelector
    extends AbstractNodeSelector {
        public NodeSelector(String defaultSelection) {
            super(defaultSelection);
        }

        public void doSelection(String nodeName) {
            TransformSetManagerTopComponent.this.doSelectSet(nodeName);
        }
    }
}

