/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.manager.nodes;

import com.paterva.maltego.transform.descriptor.Popup;
import com.paterva.maltego.transform.descriptor.TransformPropertyDescriptor;
import com.paterva.maltego.transform.descriptor.TransformSettings;
import com.paterva.maltego.transform.descriptor.Visibility;
import com.paterva.maltego.transform.manager.nodes.ManagedProperty;
import com.paterva.maltego.typing.PropertyDescriptor;

public class TransformPropertyProxy
extends TransformPropertyDescriptor
implements ManagedProperty {
    private TransformSettings _settings;

    public TransformPropertyProxy(TransformPropertyDescriptor descriptor, TransformSettings settings) {
        super(descriptor);
        this._settings = settings;
    }

    @Override
    public boolean isPopup() {
        return this._settings.getPopup((PropertyDescriptor)this) == Popup.Yes;
    }

    @Override
    public void setPopup(boolean popup) {
        if (this.canChangePopup()) {
            if (popup) {
                this._settings.setPopup((PropertyDescriptor)this, Popup.Yes);
            } else {
                this._settings.setPopup((PropertyDescriptor)this, Popup.No);
            }
        }
    }

    public Visibility getVisibility() {
        Visibility descriptorVisibility = super.getVisibility();
        Visibility settingsVisibility = this._settings.getVisibility((PropertyDescriptor)this);
        if (descriptorVisibility == Visibility.Public) {
            return settingsVisibility;
        }
        return descriptorVisibility;
    }

    public void setVisibility(Visibility visibility) {
        if (this.canChangeVisibility() && (visibility == Visibility.Public || visibility == Visibility.Internal)) {
            this._settings.setVisibility((PropertyDescriptor)this, visibility);
        }
    }

    @Override
    public void setInternal(boolean internal) {
        this.setVisibility(internal ? Visibility.Internal : Visibility.Public);
    }

    @Override
    public boolean canChangeVisibility() {
        return super.getVisibility() == Visibility.Public;
    }

    @Override
    public boolean canChangeReadonly() {
        return true;
    }

    @Override
    public boolean canChangePopup() {
        return true;
    }

    @Override
    public boolean isReadonly() {
        return super.isReadonly();
    }

    public boolean isHidden() {
        return this.getVisibility() == Visibility.Hidden;
    }

    public String getImage() {
        if (this.isInternal()) {
            return "com/paterva/maltego/transform/manager/resources/Internal.gif";
        }
        if (this.isPopup()) {
            return "com/paterva/maltego/transform/manager/resources/Popup.gif";
        }
        return super.getImage();
    }

    public String getHtmlDisplayName() {
        if (this.isAbstract()) {
            return "[" + this.getDisplayName() + "]";
        }
        return super.getHtmlDisplayName();
    }
}

