/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.manager.localv2;

import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.licensing.UserInfo;
import com.paterva.maltego.transform.descriptor.TransformDefinition;
import com.paterva.maltego.transform.descriptor.TransformFilter;
import com.paterva.maltego.transform.descriptor.TransformRepository;
import com.paterva.maltego.transform.descriptor.TransformSet;
import com.paterva.maltego.transform.manager.localv2.TransformDetailsControl;
import com.paterva.maltego.typing.TypeNameValidator;
import com.paterva.maltego.util.StringUtilities;
import com.paterva.maltego.util.ui.dialog.ValidatingController;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Collection;
import org.openide.WizardDescriptor;

class TransformDetailsController
extends ValidatingController<TransformDetailsControl> {
    private static TransformSet EMPTY_SET = new TransformSet("(none)");

    TransformDetailsController() {
    }

    protected TransformDetailsControl createComponent() {
        final TransformDetailsControl c = new TransformDetailsControl();
        c.addChangeListener(this.changeListener());
        c.addDisplayNameFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                String id;
                if (!TransformDetailsController.this.isEditMode() && (id = c.getTransformID()).trim().length() == 0) {
                    c.setTransformID(TransformDetailsController.this.createID(c.getTransformDisplayName()));
                }
            }
        });
        return c;
    }

    private boolean isEditMode() {
        return false;
    }

    private String createID(String displayName) {
        UserInfo userInfo = new UserInfo();
        String prefix = userInfo.getNamespace();
        if (StringUtilities.isNullOrEmpty((String)prefix)) {
            prefix = userInfo.getFullName();
        }
        if (StringUtilities.isNullOrEmpty((String)prefix)) {
            prefix = "yourorganization";
        }
        return (prefix.toLowerCase() + "." + displayName).replaceAll(" ", "");
    }

    protected String getFirstError(TransformDetailsControl component) {
        TransformRepository registry;
        String name = component.getTransformDisplayName();
        if (name.trim().length() == 0) {
            return "Display name is required";
        }
        String id = component.getTransformID();
        if ((id = id.trim()).length() == 0) {
            return "Transform ID is required";
        }
        String error = TypeNameValidator.checkName((String)id);
        if (error != null) {
            return error;
        }
        if (!this.isEditMode() && !(registry = (TransformRepository)this.getDescriptor().getProperty("TransformRepository")).find(this.getCaseInsensitiveFilter(id)).isEmpty()) {
            return "A transform with ID '" + id + "' is already registered";
        }
        if (component.getSelectedEntity() == null) {
            return "Select an entity type";
        }
        return null;
    }

    private TransformFilter getCaseInsensitiveFilter(final String transformId) {
        return new TransformFilter(){

            public boolean matches(TransformDefinition def) {
                return def.getName().equalsIgnoreCase(transformId);
            }
        };
    }

    protected void readSettings(WizardDescriptor descriptor) {
        String name = (String)descriptor.getProperty("DisplayName");
        String description = (String)descriptor.getProperty("Description");
        String author = (String)descriptor.getProperty("Author");
        MaltegoEntitySpec[] entities = (MaltegoEntitySpec[])descriptor.getProperty("Entities");
        MaltegoEntitySpec entity = (MaltegoEntitySpec)descriptor.getProperty("InputEntity");
        Collection allSets = (Collection)descriptor.getProperty("AllSets");
        TransformSet[] sets = new TransformSet[allSets.size() + 1];
        sets[0] = EMPTY_SET;
        System.arraycopy(allSets.toArray(new TransformSet[allSets.size()]), 0, sets, 1, allSets.size());
        ((TransformDetailsControl)this.component()).setSets(sets);
        ((TransformDetailsControl)this.component()).setEntities(entities);
        ((TransformDetailsControl)this.component()).setSelectedEntity(entity);
        ((TransformDetailsControl)this.component()).setTransformDisplayName(name);
        ((TransformDetailsControl)this.component()).setTransformDescription(description);
        ((TransformDetailsControl)this.component()).setTransformAuthor(author);
    }

    protected void storeSettings(WizardDescriptor descriptor) {
        descriptor.putProperty("ID", (Object)((TransformDetailsControl)this.component()).getTransformID());
        descriptor.putProperty("DisplayName", (Object)((TransformDetailsControl)this.component()).getTransformDisplayName());
        descriptor.putProperty("Description", (Object)((TransformDetailsControl)this.component()).getTransformDescription());
        descriptor.putProperty("InputEntity", (Object)((TransformDetailsControl)this.component()).getSelectedEntity());
        descriptor.putProperty("Author", (Object)((TransformDetailsControl)this.component()).getTransformAuthor());
        TransformSet set = ((TransformDetailsControl)this.component()).getTransformSet();
        if (set == EMPTY_SET) {
            set = null;
        }
        descriptor.putProperty("SelectedSet", (Object)set);
    }
}

