/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.manager.localv2;

import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.transform.descriptor.TransformDefinition;
import com.paterva.maltego.transform.descriptor.TransformRepositoryRegistry;
import com.paterva.maltego.transform.descriptor.TransformSetRepository;
import com.paterva.maltego.transform.manager.localv2.LocalTransformFactory;
import com.paterva.maltego.transform.manager.localv2.TransformDetailsController;
import com.paterva.maltego.transform.manager.localv2.TransformLocationController;
import com.paterva.maltego.transform.manager.localv2.TransformTypeController;
import com.paterva.maltego.typing.descriptor.TypeSpecDisplayNameComparator;
import com.paterva.maltego.util.StringUtilities;
import com.paterva.maltego.util.ui.dialog.ArrayWizardIterator;
import com.paterva.maltego.util.ui.dialog.ValidatingController;
import com.paterva.maltego.util.ui.dialog.WizardUtilities;
import java.awt.Dialog;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.prefs.Preferences;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbPreferences;
import org.openide.util.actions.CallableSystemAction;

public final class NewLocalTransformAction
extends CallableSystemAction {
    private static final String BROWSE_DIR_KEY = "defaultBrowseDir";

    public void performAction() {
        this.newTransform();
    }

    public TransformDefinition newTransform(String entityType) {
        boolean cancelled;
        ArrayList<ValidatingController> panels = new ArrayList<ValidatingController>();
        TransformTypeController type = new TransformTypeController();
        type.setName("Transform type");
        TransformDetailsController details = new TransformDetailsController();
        details.setName("Configure details");
        details.setDescription("Enter the details of the new transform in the fields below.");
        details.setImage(ImageUtilities.loadImage((String)"com/paterva/maltego/transform/manager/resources/AddTransform.png".replace(".png", "48.png")));
        TransformLocationController location = new TransformLocationController();
        location.setName("Command line");
        location.setDescription("Select the external program implementing the transform logic using the fields below.");
        details.setImage(ImageUtilities.loadImage((String)"com/paterva/maltego/transform/manager/resources/AddTransform.png".replace(".png", "48.png")));
        panels.add(details);
        panels.add(location);
        WizardDescriptor.Panel[] panelArray = panels.toArray(new WizardDescriptor.Panel[panels.size()]);
        WizardUtilities.updatePanels((WizardDescriptor.Panel[])panelArray);
        WizardDescriptor wizardDescriptor = new WizardDescriptor((WizardDescriptor.Iterator)new ArrayWizardIterator(panelArray));
        wizardDescriptor.setTitle("Local Transform");
        wizardDescriptor.setTitleFormat(new MessageFormat("Transform wizard - {0} ({1})"));
        wizardDescriptor.putProperty("WizardPanel_helpDisplayed", (Object)Boolean.FALSE);
        wizardDescriptor.putProperty("TransformRepository", (Object)TransformRepositoryRegistry.getDefault().getRepository("Local"));
        wizardDescriptor.putProperty("AllSets", (Object)TransformSetRepository.getDefault().allSets());
        wizardDescriptor.putProperty("SelectedSet", null);
        wizardDescriptor.putProperty("DefaultDirectory", (Object)this.getDefaultBrowseDir());
        wizardDescriptor.putProperty("InputEntity", (Object)EntityRegistry.getDefault().get(entityType));
        wizardDescriptor.putProperty("Entities", (Object)this.getEntities());
        wizardDescriptor.putProperty("WorkingDirectory", (Object)System.getProperty("user.home"));
        wizardDescriptor.setTitleFormat(new MessageFormat("New Transform - {0}"));
        wizardDescriptor.setTitle("Local Transform Wizard");
        Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)wizardDescriptor);
        dialog.setVisible(true);
        dialog.toFront();
        boolean bl = cancelled = wizardDescriptor.getValue() != WizardDescriptor.FINISH_OPTION;
        if (!cancelled) {
            LocalTransformFactory factory = new LocalTransformFactory();
            return factory.putTransform(wizardDescriptor);
        }
        return null;
    }

    public TransformDefinition newTransform() {
        return this.newTransform(null);
    }

    private MaltegoEntitySpec[] getEntities() {
        EntityRegistry registry = EntityRegistry.getDefault();
        Collection c = registry.getAll();
        MaltegoEntitySpec[] entities = c.toArray(new MaltegoEntitySpec[c.size()]);
        Arrays.sort(entities, new TypeSpecDisplayNameComparator());
        return entities;
    }

    public String getName() {
        return "New Local Transform...";
    }

    public String iconResource() {
        return null;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    private String getDefaultBrowseDir() {
        Preferences prefs = NbPreferences.forModule(NewLocalTransformAction.class);
        return prefs.get(BROWSE_DIR_KEY, System.getProperty("user.home"));
    }

    private void setDefaultBrowseDir(String dir) {
        if (dir != null && !StringUtilities.areEqual((String)dir, (String)System.getProperty("user.home"))) {
            Preferences prefs = NbPreferences.forModule(NewLocalTransformAction.class);
            prefs.put(BROWSE_DIR_KEY, dir);
        }
    }
}

