/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.manager.localv2;

import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.transform.descriptor.Constraint;
import com.paterva.maltego.transform.descriptor.EntityConstraint;
import com.paterva.maltego.transform.descriptor.TransformDefinition;
import com.paterva.maltego.transform.descriptor.TransformDescriptor;
import com.paterva.maltego.transform.descriptor.TransformPropertyDescriptor;
import com.paterva.maltego.transform.descriptor.TransformRepository;
import com.paterva.maltego.transform.descriptor.TransformSet;
import com.paterva.maltego.transform.descriptor.TransformSetRepository;
import com.paterva.maltego.transform.descriptor.TransformSettings;
import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.DisplayDescriptorCollection;
import com.paterva.maltego.typing.DisplayDescriptorList;
import com.paterva.maltego.typing.PropertyDescriptor;
import org.openide.WizardDescriptor;

class LocalTransformFactory {
    private static TransformPropertyDescriptor COMMAND;
    private static TransformPropertyDescriptor PARAMS;
    private static TransformPropertyDescriptor WORKING_DIR;
    private static TransformPropertyDescriptor DEBUG;

    LocalTransformFactory() {
    }

    private TransformDescriptor createTransform(WizardDescriptor bag) {
        TransformDescriptor transform = new TransformDescriptor("com.paterva.maltego.transform.protocol.v2api.LocalTransformAdapterV2", (String)bag.getProperty("ID"), null, this.createProperties());
        transform.setDisplayName((String)bag.getProperty("DisplayName"));
        transform.setAuthor((String)bag.getProperty("Author"));
        transform.setDescription((String)bag.getProperty("Description"));
        MaltegoEntitySpec entity = (MaltegoEntitySpec)bag.getProperty("InputEntity");
        transform.setInputConstraint((Constraint)new EntityConstraint(entity.getTypeName()));
        return transform;
    }

    public TransformDefinition putTransform(WizardDescriptor descriptor) {
        TransformDescriptor transform = this.createTransform(descriptor);
        TransformRepository repo = (TransformRepository)descriptor.getProperty("TransformRepository");
        TransformSet set = (TransformSet)descriptor.getProperty("SelectedSet");
        if (set != null) {
            transform.setDefaultSets(new String[]{set.getName()});
        }
        repo.put(transform);
        TransformDefinition definition = repo.get(transform.getName());
        this.updateProperties((TransformSettings)definition, descriptor);
        repo.updateSettings(definition);
        if (set != null) {
            set.addTransform(transform.getName());
            TransformSetRepository.getDefault().put(set);
        }
        return definition;
    }

    private void updateProperties(TransformSettings settings, WizardDescriptor bag) {
        String commandLine = LocalTransformFactory.trim((String)bag.getProperty("Command"));
        String parameters = LocalTransformFactory.trim((String)bag.getProperty("Parameters"));
        String workingDir = LocalTransformFactory.trim((String)bag.getProperty("WorkingDirectory"));
        settings.setValue((PropertyDescriptor)COMMAND, (Object)commandLine);
        settings.setValue((PropertyDescriptor)PARAMS, (Object)parameters);
        settings.setValue((PropertyDescriptor)WORKING_DIR, (Object)workingDir);
        settings.setValue((PropertyDescriptor)DEBUG, (Object)true);
    }

    private static String trim(String s) {
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).isEmpty()) {
            return null;
        }
        return s;
    }

    private DisplayDescriptorCollection createProperties() {
        DisplayDescriptorList descriptors = new DisplayDescriptorList();
        descriptors.add((DisplayDescriptor)COMMAND);
        descriptors.add((DisplayDescriptor)PARAMS);
        descriptors.add((DisplayDescriptor)WORKING_DIR);
        descriptors.add((DisplayDescriptor)DEBUG);
        return descriptors;
    }

    static {
        DEBUG = new TransformPropertyDescriptor(Boolean.TYPE, "transform.local.debug", "Show debug info");
        DEBUG.setDescription("When this is set, the transform's text output will be printed to the output window");
        COMMAND = new TransformPropertyDescriptor(String.class, "transform.local.command", "Command line");
        COMMAND.setDescription("The command to execute for this transform");
        COMMAND.setNullable(false);
        PARAMS = new TransformPropertyDescriptor(String.class, "transform.local.parameters", "Command parameters");
        PARAMS.setDescription("The parameters to pass to the transform command");
        WORKING_DIR = new TransformPropertyDescriptor(String.class, "transform.local.working-directory", "Working directory");
        WORKING_DIR.setDescription("The working directory used when invoking the executable");
        WORKING_DIR.setDefaultValue((Object)System.getProperty("user.dir"));
    }
}

