/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.manager.imex.localtx;

import com.paterva.maltego.archive.mtz.MaltegoArchiveReader;
import com.paterva.maltego.importexport.Config;
import com.paterva.maltego.importexport.ConfigImporter;
import com.paterva.maltego.transform.descriptor.TransformDescriptor;
import com.paterva.maltego.transform.descriptor.TransformServerInfo;
import com.paterva.maltego.transform.manager.imex.localtx.LocalTransformConfig;
import com.paterva.maltego.transform.manager.imex.localtx.LocalTransformExporter;
import com.paterva.maltego.transform.manager.imex.transforms.TransformConfig;
import com.paterva.maltego.transform.manager.imex.transforms.TransformExistInfo;
import com.paterva.maltego.transform.manager.imex.transforms.TransformImporter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.openide.filesystems.FileObject;

public class LocalTransformImporter
extends ConfigImporter {
    public Config loadConfig(MaltegoArchiveReader reader) throws IOException {
        TransformConfig config = (TransformConfig)new TransformImporter().loadConfig(reader);
        return config != null ? this.createConfig(config) : null;
    }

    public Config loadPreviousConfig(FileObject configRoot) throws IOException {
        TransformConfig config = (TransformConfig)new TransformImporter().loadPreviousConfig(configRoot);
        return config != null ? this.createConfig(config) : null;
    }

    private Config createConfig(TransformConfig config) {
        List<TransformDescriptor> localTransforms;
        TransformServerInfo localServer = this.getLocalServer(config.getServers());
        if (localServer != null && !(localTransforms = this.getLocalTransforms((TransformDescriptor[])config.getAll(), localServer)).isEmpty()) {
            return this.createConfig(localTransforms, localServer);
        }
        return null;
    }

    private TransformServerInfo getLocalServer(TransformServerInfo[] servers) {
        TransformServerInfo localServer = LocalTransformExporter.getLocalTransformServerInfo();
        for (TransformServerInfo server : servers) {
            if (!localServer.equals(server)) continue;
            return server;
        }
        return null;
    }

    private List<TransformDescriptor> getLocalTransforms(TransformDescriptor[] transforms, TransformServerInfo localServer) {
        ArrayList<TransformDescriptor> localTransforms = new ArrayList<TransformDescriptor>();
        for (TransformDescriptor transform : transforms) {
            for (String transformName : localServer.getTransforms()) {
                if (!transformName.equals(transform.getName())) continue;
                localTransforms.add(transform);
            }
        }
        return localTransforms;
    }

    private Config createConfig(List<TransformDescriptor> transforms, TransformServerInfo server) {
        ArrayList<TransformDescriptor> selected = new ArrayList<TransformDescriptor>();
        TransformExistInfo existInfo = new TransformExistInfo();
        for (TransformDescriptor transform : transforms) {
            if (existInfo.exist(transform)) continue;
            selected.add(transform);
        }
        if (!transforms.isEmpty()) {
            return new LocalTransformConfig(server, transforms, selected);
        }
        return null;
    }

    public int applyConfig(Config config) {
        LocalTransformConfig localTransformConfig = (LocalTransformConfig)config;
        TransformImporter transformImporter = new TransformImporter();
        TransformDescriptor[] selectedTransforms = (TransformDescriptor[])localTransformConfig.getSelected();
        transformImporter.updateTransforms(selectedTransforms);
        return selectedTransforms.length;
    }
}

