/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.manager;

import com.paterva.maltego.transform.descriptor.TransformDefinition;
import com.paterva.maltego.transform.descriptor.TransformRepository;
import com.paterva.maltego.transform.descriptor.TransformRepositoryRegistry;
import com.paterva.maltego.transform.manager.NewTransformAction;
import com.paterva.maltego.transform.manager.detail.TransformDetailView;
import com.paterva.maltego.transform.manager.nodes.AllTransformsChildFactory;
import com.paterva.maltego.transform.manager.nodes.TransformProperties;
import com.paterva.maltego.transform.manager.propertysheet.PropertySheetPanel;
import com.paterva.maltego.util.StringUtilities;
import com.paterva.maltego.util.ui.AbstractNodeSelector;
import com.paterva.maltego.util.ui.outline.OutlineViewPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.beans.PropertyVetoException;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JSplitPane;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeListener;
import org.openide.util.Exceptions;
import org.openide.windows.TopComponent;

public class TransformManagerTopComponent
extends TopComponent
implements ExplorerManager.Provider {
    private final ExplorerManager _explorer = new ExplorerManager();
    private OutlineViewPanel _view;
    private PropertySheetPanel _properties;
    private TransformDetailView _detail;
    private static NewActionWrapper _newAction;
    private JSplitPane _leftRightSplit;
    private JSplitPane _topBottomSplit;

    public TransformManagerTopComponent() {
        this(null);
    }

    public TransformManagerTopComponent(String defaultTransform) {
        this.initComponents();
        this._view = new OutlineViewPanel("Transform");
        this._properties = new PropertySheetPanel();
        this._detail = new TransformDetailView(this);
        this._view.addToToolbarLeft((Action)((Object)this.getNewActionWrapperInstance()));
        this._leftRightSplit.setRightComponent(this._properties);
        this._leftRightSplit.setLeftComponent(this._detail);
        this._topBottomSplit.setTopComponent((Component)this._view);
        String[] repos = new String[]{"Local", "Remote"};
        AbstractNode root = new AbstractNode(Children.create((ChildFactory)new AllTransformsChildFactory(repos, true), (boolean)false));
        root.addNodeListener((NodeListener)new NodeSelector(defaultTransform));
        this._explorer.setRootContext((Node)root);
        this._explorer.addPropertyChangeListener(evt -> {
            if ("selectedNodes".equals(evt.getPropertyName())) {
                Node[] oldSelection = (Node[])evt.getOldValue();
                TransformManagerTopComponent.saveTransformSettings(oldSelection);
            }
        });
        this._view.getView().setProperties(new Node.Property[]{TransformProperties.status(), TransformProperties.location(), TransformProperties.defaultSet(), TransformProperties.inputConstraint(), TransformProperties.output()});
        this._view.getView().getOutline().getColumnModel().getColumn(0).setPreferredWidth(350);
        this._view.getView().getOutline().getColumnModel().getColumn(1).setPreferredWidth(60);
        this._view.getView().getOutline().getColumnModel().getColumn(2).setPreferredWidth(100);
        this._view.getView().getOutline().getColumnModel().getColumn(3).setPreferredWidth(120);
        this._view.getView().getOutline().getColumnModel().getColumn(4).setPreferredWidth(180);
        this._view.getView().getOutline().getColumnModel().getColumn(5).setPreferredWidth(180);
        ActionMap map = this.getActionMap();
        map.put("copy-to-clipboard", ExplorerUtils.actionCopy((ExplorerManager)this._explorer));
        map.put("paste-from-clipboard", ExplorerUtils.actionPaste((ExplorerManager)this._explorer));
        map.put("delete", ExplorerUtils.actionDelete((ExplorerManager)this._explorer, (boolean)true));
        this.associateLookup(ExplorerUtils.createLookup((ExplorerManager)this._explorer, (ActionMap)map));
        this.doSelectTransform(defaultTransform);
    }

    private NewActionWrapper getNewActionWrapperInstance() {
        if (_newAction == null) {
            _newAction = new NewActionWrapper();
        }
        return _newAction;
    }

    public void refresh(String selectTransform) {
        AbstractNode root = new AbstractNode(Children.create((ChildFactory)new AllTransformsChildFactory(TransformRepositoryRegistry.PERSISTED, true), (boolean)false));
        if (selectTransform != null) {
            root.addNodeListener((NodeListener)new NodeSelector(selectTransform));
        }
        this._explorer.setRootContext((Node)root);
    }

    public void refresh() {
        TransformDefinition def;
        String selectedTransform = null;
        Node[] node = this._explorer.getSelectedNodes();
        if (node.length > 0 && (def = (TransformDefinition)node[0].getLookup().lookup(TransformDefinition.class)) != null) {
            selectedTransform = def.getName();
        }
        this.refresh(selectedTransform);
    }

    public ExplorerManager getExplorerManager() {
        return this._explorer;
    }

    protected void saveTransformSettings() {
        Node[] allNodes = this._explorer.getRootContext().getChildren().getNodes();
        TransformManagerTopComponent.saveTransformSettings(allNodes);
    }

    private static void saveTransformSettings(Node[] items) {
        for (Node item : items) {
            TransformManagerTopComponent.saveTransformSetting(item);
        }
    }

    private static void saveTransformSetting(Node item) {
        TransformDefinition def = (TransformDefinition)item.getLookup().lookup(TransformDefinition.class);
        if (def != null) {
            TransformRepositoryRegistry registry = TransformRepositoryRegistry.getDefault();
            TransformRepository repository = registry.getRepository(def.getRepositoryName());
            repository.updateSettings(def);
        }
    }

    private void initComponents() {
        this._topBottomSplit = new JSplitPane();
        this._leftRightSplit = new JSplitPane();
        this.setMinimumSize(new Dimension(400, 400));
        this.setPreferredSize(new Dimension(700, 600));
        this.setLayout(new BorderLayout());
        this._topBottomSplit.setDividerLocation(320);
        this._topBottomSplit.setOrientation(0);
        this._topBottomSplit.setMinimumSize(new Dimension(500, 500));
        this._topBottomSplit.setPreferredSize(new Dimension(800, 600));
        this._leftRightSplit.setDividerLocation(500);
        this._leftRightSplit.setPreferredSize(new Dimension(550, 400));
        this._topBottomSplit.setBottomComponent(this._leftRightSplit);
        this.add(this._topBottomSplit, "Center");
    }

    private void doSelectTransform(String transformName) {
        try {
            if (!StringUtilities.isNullOrEmpty((String)transformName)) {
                Node[] allNodes;
                for (Node node : allNodes = this._explorer.getRootContext().getChildren().getNodes()) {
                    TransformDefinition def = (TransformDefinition)node.getLookup().lookup(TransformDefinition.class);
                    if (def == null || !def.getName().equals(transformName)) continue;
                    this._explorer.setSelectedNodes(new Node[]{node});
                    return;
                }
            }
        }
        catch (PropertyVetoException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private class NodeSelector
    extends AbstractNodeSelector {
        public NodeSelector(String defaultSelection) {
            super(defaultSelection);
        }

        public void doSelection(String nodeName) {
            TransformManagerTopComponent.this.doSelectTransform(nodeName);
        }
    }

    private class NewActionWrapper
    extends NewTransformAction {
        private NewActionWrapper() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            TransformDefinition def = NewTransformAction.instance().newTransform();
            if (def != null) {
                TransformManagerTopComponent.this.refresh(def.getName());
            }
        }
    }
}

