/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.welcome.startpage;

import com.paterva.maltego.util.FileUtilities;
import com.paterva.maltego.welcome.startpage.HtmlRenderListener;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.lobobrowser.html.FormInput;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.html.domimpl.HTMLLinkElementImpl;
import org.lobobrowser.html.gui.HtmlPanel;
import org.lobobrowser.html.test.SimpleHtmlRendererContext;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.StatusDisplayer;
import org.w3c.dom.html2.HTMLElement;
import org.xml.sax.SAXException;

public class StartPageRenderContext
extends SimpleHtmlRendererContext {
    private boolean _externalNavigate = false;
    private boolean _overLink = false;
    private final List<HtmlRenderListener> _listeners = new ArrayList<HtmlRenderListener>();

    public StartPageRenderContext(HtmlPanel contextComponent, UserAgentContext ucontext) {
        super(contextComponent, ucontext);
    }

    public void showURL(String fullURL) throws MalformedURLException {
        this._externalNavigate = true;
        this.navigate(fullURL);
        this._externalNavigate = false;
    }

    public void navigate(URL href, String target) {
        if (href != null && !this._externalNavigate) {
            if (!FileUtilities.isRemoteFileURL((URL)href)) {
                HtmlBrowser.URLDisplayer.getDefault().showURL(href);
            }
        } else {
            super.navigate(href, target);
        }
    }

    public void onMouseOver(HTMLElement element, MouseEvent event) {
        super.onMouseOver(element, event);
        if (!this._overLink && element instanceof HTMLLinkElementImpl) {
            this._overLink = true;
            this.getHtmlPanel().setCursor(Cursor.getPredefinedCursor(12));
            StatusDisplayer.getDefault().setStatusText(((HTMLLinkElementImpl)element).getHref());
        }
    }

    public void onMouseOut(HTMLElement element, MouseEvent event) {
        super.onMouseOut(element, event);
        if (this._overLink && element instanceof HTMLLinkElementImpl) {
            this.getHtmlPanel().setCursor(Cursor.getDefaultCursor());
            this._overLink = false;
            StatusDisplayer.getDefault().setStatusText("");
        }
    }

    public void submitForm(String method, URL action, String target, String enctype, FormInput[] formInputs) {
        try {
            super.submitForm(method, action, target, enctype, formInputs);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void submitFormSync(String method, URL action, String target, String enctype, FormInput[] formInputs) throws IOException, SAXException {
        try {
            super.submitFormSync(method, action, target, enctype, formInputs);
            this.fireSuccess();
        }
        catch (Exception ex) {
            this.fireError(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(HtmlRenderListener listener) {
        List<HtmlRenderListener> list = this._listeners;
        synchronized (list) {
            this._listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(HtmlRenderListener listener) {
        List<HtmlRenderListener> list = this._listeners;
        synchronized (list) {
            this._listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireError(Exception ex) {
        ArrayList<HtmlRenderListener> listeners;
        List<HtmlRenderListener> list = this._listeners;
        synchronized (list) {
            listeners = new ArrayList<HtmlRenderListener>(this._listeners);
        }
        listeners.forEach(listener -> listener.onError(ex));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireSuccess() {
        ArrayList<HtmlRenderListener> listeners;
        List<HtmlRenderListener> list = this._listeners;
        synchronized (list) {
            listeners = new ArrayList<HtmlRenderListener>(this._listeners);
        }
        listeners.forEach(listener -> listener.onSuccess());
    }
}

