/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.tx.inputs.global.ui;

import com.paterva.maltego.seeds.api.HubSeedDescriptor;
import com.paterva.maltego.seeds.api.HubSeeds;
import com.paterva.maltego.seeds.api.registry.HubSeedRegistry;
import com.paterva.maltego.transform.descriptor.TransformDefinition;
import com.paterva.maltego.transform.descriptor.TransformRepository;
import com.paterva.maltego.transform.descriptor.TransformRepositoryRegistry;
import com.paterva.maltego.transform.repository.TransformRepositoriesLock;
import com.paterva.maltego.tx.inputs.global.GlobalTransformInputDescriptor;
import com.paterva.maltego.tx.inputs.global.GlobalTransformInputGroup;
import com.paterva.maltego.tx.inputs.global.GlobalTransformInputProvider;
import com.paterva.maltego.tx.inputs.global.GlobalTransformInputSource;
import com.paterva.maltego.tx.inputs.global.GlobalTransformInputSources;
import com.paterva.maltego.tx.inputs.global.GlobalTransformInputs;
import com.paterva.maltego.tx.inputs.global.ui.HubSeedSource;
import com.paterva.maltego.tx.inputs.global.ui.LocalTransformsSource;
import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.DisplayDescriptorCollection;
import com.paterva.maltego.util.repository.RepositoryEvent;
import com.paterva.maltego.util.repository.RepositoryListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;

public class DefaultGlobalTransformInputProvider
extends GlobalTransformInputProvider {
    private static final Logger LOG = Logger.getLogger(DefaultGlobalTransformInputProvider.class.getName());
    private static final String GLOBAL_INPUT_PREFIX = "global#";
    private final ChangeSupport _changeSupport = new ChangeSupport((Object)this);
    private GlobalTransformInputs _inputs;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GlobalTransformInputs getGlobalInputs() {
        Object object = TransformRepositoriesLock.LOCK;
        synchronized (object) {
            if (this._inputs == null) {
                this._inputs = this.gatherGlobalInputs();
                try {
                    TransformRepository repo = TransformRepositoryRegistry.getDefault().getOrCreateRepository("Remote");
                    repo.addRepositoryListener((RepositoryListener)new TransformListener());
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            return this._inputs;
        }
    }

    private GlobalTransformInputs gatherGlobalInputs() {
        SourcesPerInput sourcesPerInput = new SourcesPerInput();
        this.addHubSeedGlobalInputs(sourcesPerInput);
        List<GlobalTransformInputGroup> groups = this.group(sourcesPerInput);
        GlobalTransformInputs inputs = new GlobalTransformInputs(groups);
        LOG.log(Level.FINE, "Global inputs: {0}", inputs);
        return inputs;
    }

    private void addHubSeedGlobalInputs(SourcesPerInput sourcesPerInput) {
        HubSeedRegistry registry = HubSeedRegistry.getDefault();
        HubSeeds seeds = registry.getSeeds(false);
        for (HubSeedDescriptor seed : seeds.getSeeds()) {
            HubSeedSource source = new HubSeedSource(seed);
            Set transforms = registry.getTransforms(seed);
            List<GlobalTransformInputDescriptor> inputs = this.getGlobalTransformInputs(transforms);
            this.addSourceForInputs(sourcesPerInput, source, inputs);
        }
    }

    private void addLocalTransformGlobalInputs(SourcesPerInput sourcesPerInput) {
        LocalTransformsSource source = LocalTransformsSource.getInstance();
        TransformRepository repo = TransformRepositoryRegistry.getDefault().getRepository("Local");
        Set transforms = repo.getAll();
        List<GlobalTransformInputDescriptor> inputs = this.getGlobalTransformInputs(transforms);
        this.addSourceForInputs(sourcesPerInput, source, inputs);
    }

    private List<GlobalTransformInputDescriptor> getGlobalTransformInputs(Set<TransformDefinition> transforms) {
        ArrayList<GlobalTransformInputDescriptor> inputs = new ArrayList<GlobalTransformInputDescriptor>();
        for (TransformDefinition transform : transforms) {
            DisplayDescriptorCollection properties = transform.getProperties();
            for (DisplayDescriptor property : properties) {
                String propName = property.getName();
                if (!propName.toLowerCase().startsWith(GLOBAL_INPUT_PREFIX)) continue;
                GlobalTransformInputDescriptor input = new GlobalTransformInputDescriptor(property);
                inputs.add(input);
            }
        }
        return inputs;
    }

    private void addSourceForInputs(SourcesPerInput sourcesPerInput, GlobalTransformInputSource source, List<GlobalTransformInputDescriptor> inputs) {
        for (GlobalTransformInputDescriptor input : inputs) {
            LinkedHashSet<GlobalTransformInputSource> sources = (LinkedHashSet<GlobalTransformInputSource>)sourcesPerInput.get(input);
            if (sources == null) {
                sources = new LinkedHashSet<GlobalTransformInputSource>();
                sourcesPerInput.put(input, sources);
            }
            sources.add(source);
        }
    }

    private List<GlobalTransformInputGroup> group(SourcesPerInput sourcesPerInput) {
        InputsForSources inputsForSources = new InputsForSources();
        for (Map.Entry entry : sourcesPerInput.entrySet()) {
            GlobalTransformInputDescriptor input = (GlobalTransformInputDescriptor)entry.getKey();
            Set value = (Set)entry.getValue();
            GlobalTransformInputSources sources = new GlobalTransformInputSources(value);
            LinkedHashSet<GlobalTransformInputDescriptor> inputs = (LinkedHashSet<GlobalTransformInputDescriptor>)inputsForSources.get(sources);
            if (inputs == null) {
                inputs = new LinkedHashSet<GlobalTransformInputDescriptor>();
                inputsForSources.put(sources, inputs);
            }
            inputs.add(input);
        }
        List<GlobalTransformInputGroup> groups = this.toGroups(inputsForSources);
        return groups;
    }

    private List<GlobalTransformInputGroup> toGroups(InputsForSources inputsForSources) {
        ArrayList<GlobalTransformInputGroup> groups = new ArrayList<GlobalTransformInputGroup>();
        for (Map.Entry entry : inputsForSources.entrySet()) {
            GlobalTransformInputSources key = (GlobalTransformInputSources)entry.getKey();
            Set value = (Set)entry.getValue();
            groups.add(new GlobalTransformInputGroup(key, value));
        }
        return groups;
    }

    private void updateInputs() {
        GlobalTransformInputs inputs;
        if (this._inputs != null && !this._inputs.equals((Object)(inputs = this.gatherGlobalInputs()))) {
            this._inputs = inputs;
            this._changeSupport.fireChange();
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this._changeSupport.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this._changeSupport.removeChangeListener(changeListener);
    }

    private class TransformListener
    implements RepositoryListener {
        private TransformListener() {
        }

        public void onItemAdded(RepositoryEvent evt) {
            DefaultGlobalTransformInputProvider.this.updateInputs();
        }

        public void onItemChanged(RepositoryEvent evt) {
            DefaultGlobalTransformInputProvider.this.updateInputs();
        }

        public void onItemRemoved(RepositoryEvent evt) {
            DefaultGlobalTransformInputProvider.this.updateInputs();
        }
    }

    private static class InputsForSources
    extends LinkedHashMap<GlobalTransformInputSources, Set<GlobalTransformInputDescriptor>> {
        private InputsForSources() {
        }
    }

    private static class SourcesPerInput
    extends LinkedHashMap<GlobalTransformInputDescriptor, Set<GlobalTransformInputSource>> {
        private SourcesPerInput() {
        }
    }
}

