/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.components;

import com.bulenkov.iconloader.util.GraphicsConfig;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicButtonUI;

public class ArrowIcon
implements Icon {
    private final int _width;
    private int _height;
    private Color _arrowColor;

    public ArrowIcon(int width, int height, Color arrowColor) {
        this._width = width;
        this._height = height;
        this._arrowColor = arrowColor;
    }

    @Override
    public void paintIcon(Component c, Graphics g2, int x, int y) {
        Graphics2D g = (Graphics2D)g2;
        GraphicsConfig config = new GraphicsConfig((Graphics)g);
        int w = c.getWidth();
        int h = c.getHeight();
        g.setColor(this._arrowColor);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        int height = 6 < h ? 6 : h;
        int width = 10 < w ? 10 : w;
        int offsetY = (h - height) / 2;
        int offsetX = (w - width) / 2;
        g.setStroke(new BasicStroke(2.0f));
        g.translate(offsetX, offsetY);
        g.drawLine(0, 0, 5, height);
        g.drawLine(5, height, width, 0);
        g.translate(-offsetX, -offsetY);
        config.restore();
    }

    public void setArrowForeground(Color color) {
        this._arrowColor = color;
    }

    public Color getArrowForeground() {
        return this._arrowColor;
    }

    public void setIconHeight(int height) {
        this._height = height;
    }

    @Override
    public int getIconWidth() {
        return this._width;
    }

    @Override
    public int getIconHeight() {
        return this._height;
    }

    public static void setupPopupButton(final JButton popupButton, Color bg) {
        final Color defaultColor = UIManager.getLookAndFeelDefaults().getColor("ComboBox.darculaMod.arrowButtonForeground");
        final ArrowIcon icon = new ArrowIcon(25, popupButton.getPreferredSize().height, defaultColor);
        final Color disabledArrowColor = UIManager.getLookAndFeelDefaults().getColor("ComboBox.darculaMod.arrowButtonDisabledForeground");
        if (!popupButton.isEnabled()) {
            icon.setArrowForeground(disabledArrowColor);
        }
        popupButton.setUI(new BasicButtonUI(){

            @Override
            public void update(Graphics g, JComponent c) {
                Color arrowColor = icon.getArrowForeground();
                if (popupButton.isEnabled()) {
                    if (arrowColor.getRGB() == disabledArrowColor.getRGB()) {
                        icon.setArrowForeground(defaultColor);
                    }
                } else if (arrowColor.getRGB() != disabledArrowColor.getRGB()) {
                    icon.setArrowForeground(disabledArrowColor);
                }
                super.update(g, c);
            }
        });
        popupButton.setBackground(bg);
        popupButton.setBorderPainted(false);
        popupButton.setRolloverEnabled(true);
        popupButton.setIcon(icon);
        popupButton.setBorder(BorderFactory.createEmptyBorder());
        popupButton.getModel().addChangeListener(new ChangeListener(){
            private boolean _hovered = false;

            @Override
            public void stateChanged(ChangeEvent e) {
                ButtonModel model;
                if (popupButton.isEnabled() && (model = (ButtonModel)e.getSource()).isRollover() != this._hovered) {
                    this._hovered = model.isRollover();
                    if (this._hovered) {
                        icon.setArrowForeground(UIManager.getLookAndFeelDefaults().getColor("7-focus-color"));
                    } else {
                        icon.setArrowForeground(defaultColor);
                    }
                }
            }
        });
    }
}

