/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui;

import com.paterva.maltego.util.ColorUtilities;
import com.paterva.maltego.util.ui.fonts.FontSizeRegistry;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.UIManager;
import org.apache.commons.lang.StringEscapeUtils;
import org.lobobrowser.html.HtmlRendererContext;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.html.gui.HtmlPanel;
import org.lobobrowser.html.test.SimpleHtmlRendererContext;
import org.lobobrowser.html.test.SimpleUserAgentContext;

public abstract class LogPane
extends JPanel {
    private static final int MAX_UPDATE_FREQUENCY = 1000;
    private LinkedList<Message> _messages = new LinkedList();
    private SimpleHtmlRendererContext context;
    private HtmlPanel _htmlPanel;
    private AtomicBoolean _updateScheduled = new AtomicBoolean(false);
    private long _lastUpdate = 0L;
    private PropertyChangeListener _pcl = null;
    private final Color _bgColor = UIManager.getLookAndFeelDefaults().getColor("machine-runtime-login-panel-bg");

    public LogPane() {
        this.setLayout(new BorderLayout());
        this._htmlPanel = new HtmlPanel();
        this.add((Component)this._htmlPanel);
        this.context = new SimpleHtmlRendererContext(this._htmlPanel, (UserAgentContext)new SimpleUserAgentContext());
    }

    public abstract int getFontSize();

    @Override
    public void addNotify() {
        super.addNotify();
        this._pcl = new UpdateFontSizePropertyChangeListner();
        FontSizeRegistry.getDefault().addPropertyChangeListener(this._pcl);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        FontSizeRegistry.getDefault().removePropertyChangeListener(this._pcl);
        this._pcl = null;
    }

    public void logDebug(String message) {
        this.addLogMessage(message, ColorUtilities.encode((Color)UIManager.getLookAndFeelDefaults().getColor("machine-runtime-log-debug-fg")));
    }

    public void logInfo(String message) {
        this.addLogMessage(message, ColorUtilities.encode((Color)UIManager.getLookAndFeelDefaults().getColor("machine-runtime-log-info-fg")));
    }

    public void logNotification(String message) {
        this.addLogMessage(message, ColorUtilities.encode((Color)UIManager.getLookAndFeelDefaults().getColor("machine-runtime-log-notification-fg")));
    }

    public void logWarning(String message) {
        this.addLogMessage(message, ColorUtilities.encode((Color)UIManager.getLookAndFeelDefaults().getColor("machine-runtime-log-warning-fg")));
    }

    public void logError(String message) {
        this.addLogMessage(message, ColorUtilities.encode((Color)UIManager.getLookAndFeelDefaults().getColor("machine-runtime-log-error-fg")));
    }

    private void addMessage(String text) {
        boolean addMessage = true;
        if (!this._messages.isEmpty()) {
            Message lastMessage = this._messages.getLast();
            if (lastMessage.text.equals(text)) {
                ++lastMessage.count;
                addMessage = false;
            }
        }
        if (addMessage) {
            Message message = new Message();
            message.text = text;
            this._messages.add(message);
            if (this._messages.size() >= 1100) {
                this._messages.subList(0, 100).clear();
            }
        }
    }

    public void clear() {
        this._messages.clear();
        this.setText(this.buildOutput());
    }

    private void addLogMessage(String message, String color) {
        String[] lines;
        for (String line : lines = message.split("\n")) {
            StringBuilder sb = new StringBuilder("<font color=\"");
            sb.append(color);
            sb.append("\">");
            sb.append(StringEscapeUtils.escapeHtml((String)line));
            sb.append("</font>");
            this.addMessage(sb.toString());
        }
        if (this._updateScheduled.compareAndSet(false, true)) {
            long waitTime = 1000L - (System.currentTimeMillis() - this._lastUpdate);
            if (waitTime < 0L) {
                this.updateText();
            } else {
                Timer timer = new Timer((int)waitTime, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        LogPane.this.updateText();
                    }
                });
                timer.setRepeats(false);
                timer.start();
            }
        }
    }

    private void updateText() {
        this._lastUpdate = System.currentTimeMillis();
        this._updateScheduled.set(false);
        this.setText(this.buildOutput());
    }

    private String buildOutput() {
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        sb.append("<head><style type=\"text/css\">\n");
        sb.append("BODY\n");
        sb.append("{\n");
        sb.append("    font-size: ");
        sb.append(this.getFontSize());
        sb.append("px;\n");
        sb.append("    font-family: Arial, Helvetica, sans-serif;\n");
        sb.append("    background-color: ");
        sb.append(ColorUtilities.encode((Color)this._bgColor));
        sb.append(";\n");
        sb.append("}\n");
        sb.append("</style></head>");
        sb.append("<body><table border=\"0\" cellpadding=\"0\" cellspacing=\"0\">");
        for (Message msg : this._messages) {
            sb.append("<tr><td nowrap=\"nowrap\">");
            if (msg.count > 1) {
                sb.append("<font color=\"");
                sb.append(ColorUtilities.encode((Color)UIManager.getLookAndFeelDefaults().getColor("machine-user-filter-flash-colour")));
                sb.append("\">");
                sb.append("(");
                sb.append(msg.count);
                sb.append("x) ");
                sb.append("</font>");
            }
            sb.append(msg.text);
            sb.append("</td></tr>");
        }
        sb.append("<tr></tr>");
        sb.append("</table></body></html>");
        return sb.toString();
    }

    private void setText(String buildOutput) {
        this._htmlPanel.setHtml(buildOutput, "", (HtmlRendererContext)this.context);
        this._htmlPanel.scroll(0, Integer.MAX_VALUE);
        this._htmlPanel.revalidate();
    }

    private class UpdateFontSizePropertyChangeListner
    implements PropertyChangeListener {
        private UpdateFontSizePropertyChangeListner() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            LogPane.this.updateText();
        }
    }

    private static class Message {
        String text;
        int count = 1;

        private Message() {
        }
    }
}

