/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.descriptor;

import com.paterva.maltego.matching.api.MatchingRuleDescriptor;
import com.paterva.maltego.transform.descriptor.CompoundConstraint;
import com.paterva.maltego.transform.descriptor.Constraint;
import com.paterva.maltego.transform.descriptor.EntityConstraint;
import com.paterva.maltego.transform.descriptor.IntegerStealthLevel;
import com.paterva.maltego.transform.descriptor.StealthLevel;
import com.paterva.maltego.transform.descriptor.Visibility;
import com.paterva.maltego.typing.DisplayDescriptorCollection;
import com.paterva.maltego.typing.DisplayDescriptorList;
import com.paterva.maltego.util.ListSet;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;

public class TransformDescriptor
implements Comparable<TransformDescriptor> {
    private String _name;
    private String _base;
    private boolean _abstract = false;
    private boolean _template = false;
    private Visibility _visibility = Visibility.Public;
    private String _displayName;
    private String _description;
    private String _helpUrl;
    private String _helpText;
    private String _author;
    private String _owner;
    private String _disclaimer;
    private String _locationRelevance;
    private String _version;
    private String[] _defaultSets;
    private boolean _requireDisplayInfo;
    private StealthLevel _stealthLevel;
    private DisplayDescriptorCollection _inputs;
    private Set<String> _outputEntities;
    private Constraint _inputConstraint;
    private String _transformAdapterClass;
    private MatchingRuleDescriptor _matchingRule;
    private String _authenticator;

    protected TransformDescriptor(TransformDescriptor descriptor) {
        this(descriptor.getTransformAdapterClass(), descriptor.getName(), descriptor.getBaseName(), descriptor.getProperties());
        this._abstract = descriptor._abstract;
        this._template = descriptor._template;
        this._visibility = descriptor._visibility;
        this._displayName = descriptor._displayName;
        this._description = descriptor._description;
        this._helpUrl = descriptor._helpUrl;
        this._helpText = descriptor._helpText;
        this._author = descriptor._author;
        this._disclaimer = descriptor._disclaimer;
        this._owner = descriptor._owner;
        this._locationRelevance = descriptor._locationRelevance;
        this._version = descriptor._version;
        this._defaultSets = descriptor._defaultSets;
        this._requireDisplayInfo = descriptor._requireDisplayInfo;
        this._stealthLevel = descriptor._stealthLevel;
        this._outputEntities = new ListSet(descriptor.getOutputEntities());
        this._inputConstraint = descriptor._inputConstraint;
        this._matchingRule = descriptor._matchingRule;
        this._authenticator = descriptor._authenticator;
    }

    public TransformDescriptor(String transformAdapter, String name, String baseName) {
        this(transformAdapter, name, baseName, null);
    }

    public TransformDescriptor(String transformAdapter, String name, String baseName, DisplayDescriptorCollection properties) {
        this._name = name;
        this._inputs = properties;
        this._base = baseName;
        this._transformAdapterClass = transformAdapter;
    }

    public String getName() {
        return this._name;
    }

    public String toString() {
        return this._name;
    }

    public DisplayDescriptorCollection getProperties() {
        if (this._inputs == null) {
            this._inputs = new DisplayDescriptorList();
        }
        return this._inputs;
    }

    public String getBaseName() {
        return this._base;
    }

    public void setBaseName(String uniqueName) {
        this._base = uniqueName;
    }

    public Constraint getInputConstraint() {
        return this._inputConstraint;
    }

    public void setInputConstraint(Constraint c) {
        this._inputConstraint = c;
    }

    public Set<String> getOutputEntities() {
        if (this._outputEntities == null) {
            this._outputEntities = new ListSet();
        }
        return this._outputEntities;
    }

    public boolean isAbstract() {
        return this._abstract;
    }

    public void setAbstract(boolean value) {
        this._abstract = value;
    }

    public String getDisplayName() {
        return this._displayName;
    }

    public void setDisplayName(String displayName) {
        this._displayName = displayName;
    }

    public String getDescription() {
        return this._description;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public String getHelpUrl() {
        return this._helpUrl;
    }

    public void setHelpUrl(String helpUrl) {
        this._helpUrl = helpUrl;
    }

    public String getHelpText() {
        return this._helpText;
    }

    public void setHelpText(String helpText) {
        this._helpText = helpText;
    }

    public String getAuthor() {
        return this._author;
    }

    public void setAuthor(String author) {
        this._author = author;
    }

    public String getOwner() {
        return this._owner;
    }

    public void setOwner(String owner) {
        this._owner = owner;
    }

    public String getDisclaimer() {
        return this._disclaimer;
    }

    public void setDisclaimer(String disclaimer) {
        this._disclaimer = disclaimer;
    }

    public String getLocationRelevance() {
        return this._locationRelevance;
    }

    public void setLocationRelevance(String locationRelevance) {
        this._locationRelevance = locationRelevance;
    }

    public String getVersion() {
        return this._version;
    }

    public void setVersion(String version) {
        this._version = version;
    }

    public String[] getDefaultSets() {
        return this._defaultSets;
    }

    public void setDefaultSets(String[] defaultSets) {
        this._defaultSets = defaultSets;
    }

    public boolean isRequireDisplayInfo() {
        return this._requireDisplayInfo;
    }

    public void setRequireDisplayInfo(boolean requireDisplayInfo) {
        this._requireDisplayInfo = requireDisplayInfo;
    }

    public StealthLevel getStealthLevel() {
        return this._stealthLevel;
    }

    public void setStealthLevel(StealthLevel stealthLevel) {
        this._stealthLevel = stealthLevel;
    }

    public boolean isTemplate() {
        return this._template;
    }

    public void setTemplate(boolean template) {
        this._template = template;
    }

    public Visibility getVisibility() {
        if (this._visibility == null) {
            return Visibility.Public;
        }
        return this._visibility;
    }

    public void setVisibility(Visibility visibility) {
        this._visibility = visibility;
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + (this._name != null ? this._name.hashCode() : 0);
        return hash;
    }

    public boolean equals(TransformDescriptor td) {
        if (td == null) {
            return false;
        }
        return td._name.equals(this._name);
    }

    public boolean equals(Object obj) {
        if (obj instanceof TransformDescriptor) {
            return this.equals((TransformDescriptor)obj);
        }
        return false;
    }

    public String getTransformAdapterClass() {
        return this._transformAdapterClass;
    }

    @Override
    public int compareTo(TransformDescriptor o) {
        if (o == null) {
            return 1;
        }
        return this.getName().compareTo(o.getName());
    }

    public MatchingRuleDescriptor getMatchingRule() {
        return this._matchingRule;
    }

    public void setMatchingRule(MatchingRuleDescriptor rule) {
        this._matchingRule = rule;
    }

    public String getAuthenticator() {
        return this._authenticator;
    }

    public void setAuthenticator(String authenticator) {
        this._authenticator = authenticator;
    }

    public boolean isCopy(TransformDescriptor descriptor) {
        if (descriptor == null) {
            return false;
        }
        if (!TransformDescriptor.compareStr(this._name, descriptor._name)) {
            return false;
        }
        if (this._inputs == null ? descriptor._inputs != null : !this._inputs.equals(descriptor._inputs)) {
            return false;
        }
        if (this._outputEntities == null ? descriptor._outputEntities != null : !this._outputEntities.equals(descriptor._outputEntities)) {
            return false;
        }
        if (this._stealthLevel != null && descriptor._stealthLevel != null ? !this._stealthLevel.equals(descriptor._stealthLevel) : (this._stealthLevel == null && descriptor._stealthLevel != null ? ((IntegerStealthLevel)descriptor._stealthLevel).getLevelNumber() != 0 : this._stealthLevel != null && descriptor._stealthLevel == null && ((IntegerStealthLevel)this._stealthLevel).getLevelNumber() != 0)) {
            return false;
        }
        if (this._inputConstraint != null && descriptor._inputConstraint != null) {
            CompoundConstraint compoundConstraint = null;
            EntityConstraint entityConstraint = null;
            if (this._inputConstraint.getClass().equals(descriptor._inputConstraint.getClass())) {
                if (this._inputConstraint == null ? descriptor._inputConstraint != null : !this._inputConstraint.equals(descriptor._inputConstraint)) {
                    return false;
                }
            } else if (this._inputConstraint instanceof CompoundConstraint && descriptor._inputConstraint instanceof EntityConstraint) {
                compoundConstraint = (CompoundConstraint)this._inputConstraint;
                entityConstraint = (EntityConstraint)descriptor._inputConstraint;
            } else if (this._inputConstraint instanceof EntityConstraint && descriptor._inputConstraint instanceof CompoundConstraint) {
                compoundConstraint = (CompoundConstraint)descriptor._inputConstraint;
                entityConstraint = (EntityConstraint)this._inputConstraint;
            } else {
                return false;
            }
            if (compoundConstraint != null) {
                Iterator iter = compoundConstraint.iterator();
                if (!iter.hasNext()) {
                    return false;
                }
                if (!((EntityConstraint)iter.next()).equals(entityConstraint)) {
                    return false;
                }
                if (iter.hasNext()) {
                    return false;
                }
            }
        } else if (this._inputConstraint != descriptor._inputConstraint) {
            return false;
        }
        return this._abstract == descriptor._abstract && this._template == descriptor._template && this._requireDisplayInfo == descriptor._requireDisplayInfo && TransformDescriptor.compareStr(this._name, descriptor._name) && TransformDescriptor.compareStr(this._base, descriptor._base) && TransformDescriptor.compareStr(this._displayName, descriptor._displayName) && TransformDescriptor.compareStr(this._description, descriptor._description) && TransformDescriptor.compareStr(this._helpUrl, descriptor._helpUrl) && TransformDescriptor.compareStr(this._helpText, descriptor._helpText) && TransformDescriptor.compareStr(this._author, descriptor._author) && TransformDescriptor.compareStr(this._owner, descriptor._owner) && TransformDescriptor.compareStr(this._disclaimer, descriptor._disclaimer) && TransformDescriptor.compareStr(this._locationRelevance, descriptor._locationRelevance) && TransformDescriptor.compareStr(this._version, descriptor._version) && TransformDescriptor.compareStr(this._transformAdapterClass, descriptor._transformAdapterClass) && TransformDescriptor.compareStr(this._authenticator, descriptor._authenticator) && Arrays.equals(this._defaultSets, descriptor._defaultSets);
    }

    private static boolean compareStr(String str1, String str2) {
        if (str1 == null ? str2 == null || str2.isEmpty() : str2 == null && str1.isEmpty()) {
            return true;
        }
        return Objects.equals(str1, str2);
    }
}

