/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.descriptor;

public final class ProtocolVersion
implements Comparable<ProtocolVersion> {
    public static final ProtocolVersion V2_0 = new ProtocolVersion(2, 0);
    private int _major;
    private int _minor;

    public ProtocolVersion(int major, int minor) {
        this._major = major;
        this._minor = minor;
    }

    public static ProtocolVersion get(String version) throws NumberFormatException {
        String[] split = (version = version.trim()).split("\\.");
        if (split.length == 0 || split.length == 1) {
            return new ProtocolVersion(Integer.valueOf(version), 0);
        }
        if (split.length == 2) {
            return new ProtocolVersion(Integer.valueOf(split[0]), Integer.valueOf(split[1]));
        }
        throw new NumberFormatException("Illegal version: " + version);
    }

    public String toString() {
        return this._major + "." + this._minor;
    }

    public int hashCode() {
        int hash = 5;
        hash = 23 * hash + this._major;
        hash = 23 * hash + this._minor;
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProtocolVersion other = (ProtocolVersion)obj;
        if (this._major != other._major) {
            return false;
        }
        return this._minor == other._minor;
    }

    @Override
    public int compareTo(ProtocolVersion o) {
        if (this._major == o._major) {
            return ProtocolVersion.compare(this._minor, o._minor);
        }
        return ProtocolVersion.compare(this._major, o._major);
    }

    private static int compare(int a, int b) {
        if (a > b) {
            return 1;
        }
        if (a < b) {
            return -1;
        }
        return 0;
    }
}

