/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.ui.options.general;

import java.io.IOException;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.netbeans.core.ProxySettings;
import org.netbeans.core.ui.options.general.GeneralOptionsPanel;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;

class GeneralOptionsModel {
    private static final Logger LOGGER = Logger.getLogger(GeneralOptionsModel.class.getName());
    private static final String NON_PROXY_HOSTS_DELIMITER = "|";
    private static final RequestProcessor rp = new RequestProcessor(GeneralOptionsModel.class);

    GeneralOptionsModel() {
    }

    private static Preferences getProxyPreferences() {
        return NbPreferences.root().node("org/netbeans/core");
    }

    boolean getUsageStatistics() {
        String key = System.getProperty("nb.show.statistics.ui");
        if (key != null) {
            return GeneralOptionsModel.getProxyPreferences().getBoolean(key, Boolean.FALSE);
        }
        return false;
    }

    void setUsageStatistics(boolean use) {
        String key = System.getProperty("nb.show.statistics.ui");
        if (key != null && use != this.getUsageStatistics()) {
            GeneralOptionsModel.getProxyPreferences().putBoolean(key, use);
        }
    }

    int getProxyType() {
        return GeneralOptionsModel.getProxyPreferences().getInt("proxyType", 1);
    }

    void setProxyType(int proxyType) {
        if (proxyType != this.getProxyType()) {
            if (1 == proxyType) {
                GeneralOptionsModel.getProxyPreferences().putInt("proxyType", GeneralOptionsModel.usePAC() ? 3 : 1);
            } else {
                GeneralOptionsModel.getProxyPreferences().putInt("proxyType", proxyType);
            }
        }
    }

    String getHttpProxyHost() {
        return ProxySettings.getHttpHost();
    }

    void setHttpProxyHost(String proxyHost) {
        if (!proxyHost.equals(this.getHttpProxyHost())) {
            GeneralOptionsModel.getProxyPreferences().put("proxyHttpHost", proxyHost);
        }
    }

    String getHttpProxyPort() {
        return ProxySettings.getHttpPort();
    }

    void setHttpProxyPort(String proxyPort) {
        if (!proxyPort.equals(this.getHttpProxyPort())) {
            GeneralOptionsModel.getProxyPreferences().put("proxyHttpPort", GeneralOptionsModel.validatePort(proxyPort) ? proxyPort : "");
        }
    }

    String getHttpsProxyHost() {
        return ProxySettings.getHttpsHost();
    }

    void setHttpsProxyHost(String proxyHost) {
        if (!proxyHost.equals(this.getHttpsProxyHost())) {
            GeneralOptionsModel.getProxyPreferences().put("proxyHttpsHost", proxyHost);
        }
    }

    String getHttpsProxyPort() {
        return ProxySettings.getHttpsPort();
    }

    void setHttpsProxyPort(String proxyPort) {
        if (!proxyPort.equals(this.getHttpsProxyPort())) {
            GeneralOptionsModel.getProxyPreferences().put("proxyHttpsPort", GeneralOptionsModel.validatePort(proxyPort) ? proxyPort : "");
        }
    }

    String getSocksHost() {
        return ProxySettings.getSocksHost();
    }

    void setSocksHost(String socksHost) {
        if (!socksHost.equals(this.getSocksHost())) {
            GeneralOptionsModel.getProxyPreferences().put("proxySocksHost", socksHost);
        }
    }

    String getSocksPort() {
        return ProxySettings.getSocksPort();
    }

    void setSocksPort(String socksPort) {
        if (!socksPort.equals(this.getSocksPort())) {
            GeneralOptionsModel.getProxyPreferences().put("proxySocksPort", GeneralOptionsModel.validatePort(socksPort) ? socksPort : "");
        }
    }

    String getOriginalHttpsHost() {
        return GeneralOptionsModel.getProxyPreferences().get("proxyHttpsHost", "");
    }

    String getOriginalHttpsPort() {
        return GeneralOptionsModel.getProxyPreferences().get("proxyHttpsPort", "");
    }

    String getOriginalSocksHost() {
        return GeneralOptionsModel.getProxyPreferences().get("proxySocksHost", "");
    }

    String getOriginalSocksPort() {
        return GeneralOptionsModel.getProxyPreferences().get("proxySocksPort", "");
    }

    String getNonProxyHosts() {
        return GeneralOptionsModel.code2view(ProxySettings.getNonProxyHosts());
    }

    void setNonProxyHosts(String nonProxy) {
        if (!nonProxy.equals(this.getNonProxyHosts())) {
            GeneralOptionsModel.getProxyPreferences().put("proxyNonProxyHosts", GeneralOptionsModel.view2code(nonProxy));
        }
    }

    boolean useProxyAuthentication() {
        return ProxySettings.useAuthentication();
    }

    void setUseProxyAuthentication(boolean use) {
        if (use != this.useProxyAuthentication()) {
            GeneralOptionsModel.getProxyPreferences().putBoolean("useProxyAuthentication", use);
        }
    }

    boolean useProxyAllProtocols() {
        return ProxySettings.useProxyAllProtocols();
    }

    void setUseProxyAllProtocols(boolean use) {
        if (use != this.useProxyAllProtocols()) {
            GeneralOptionsModel.getProxyPreferences().putBoolean("useProxyAllProtocols", use);
        }
    }

    boolean forceBasicAuthTunneling() {
        return ProxySettings.forceBasicAuthTunneling();
    }

    void setForceBasicAuthTunneling(boolean force) {
        if (force != this.forceBasicAuthTunneling()) {
            if (force) {
                System.setProperty("jdk.http.auth.tunneling.disabledSchemes", "");
                GeneralOptionsModel.getProxyPreferences().put("jdk.http.auth.tunneling.disabledSchemes", "");
            } else {
                System.clearProperty("jdk.http.auth.tunneling.disabledSchemes");
                GeneralOptionsModel.getProxyPreferences().remove("jdk.http.auth.tunneling.disabledSchemes");
            }
        }
    }

    String getProxyAuthenticationUsername() {
        return ProxySettings.getAuthenticationUsername();
    }

    void setAuthenticationUsername(String username) {
        System.setProperty("http.proxyUser", username);
        GeneralOptionsModel.getProxyPreferences().put("proxyAuthenticationUsername", username);
    }

    char[] getProxyAuthenticationPassword() {
        return ProxySettings.getAuthenticationPassword();
    }

    void setAuthenticationPassword(char[] password) {
        String pass = password == null ? null : new String(password);
        System.setProperty("http.proxyPassword", pass);
        ProxySettings.setAuthenticationPassword((char[])password);
    }

    static boolean usePAC() {
        String pacUrl = GeneralOptionsModel.getProxyPreferences().get("systemPAC", "");
        return pacUrl != null && pacUrl.length() > 0;
    }

    static void testConnection(final GeneralOptionsPanel panel, final int proxyType) {
        rp.post(new Runnable(){

            @Override
            public void run() {
                GeneralOptionsModel.testProxy(panel, proxyType);
            }
        });
    }

    private static void testProxy(GeneralOptionsPanel panel, int proxyType) {
        String message;
        TestingStatus status;
        block18: {
            Proxy testingProxy;
            String testingUrlHost;
            URL testingUrl;
            panel.updateTestConnectionStatus(TestingStatus.WAITING, null);
            status = TestingStatus.FAILED;
            message = null;
            try {
                testingUrl = new URL("https://www.maltego.com/");
                testingUrlHost = testingUrl.getHost();
            }
            catch (MalformedURLException ex) {
                LOGGER.log(Level.SEVERE, "Cannot create url from string.", ex);
                panel.updateTestConnectionStatus(status, message);
                return;
            }
            String proxyHost = null;
            String proxyPortString = null;
            String nonProxyHosts = null;
            if (proxyType == 2) {
                boolean isHttps = testingUrl.getProtocol().equals("https");
                proxyHost = isHttps ? ProxySettings.getHttpsHost() : ProxySettings.getHttpHost();
                proxyPortString = isHttps ? ProxySettings.getHttpsPort() : ProxySettings.getHttpPort();
                nonProxyHosts = ProxySettings.getSystemNonProxyHosts();
            }
            switch (proxyType) {
                case 0: {
                    testingProxy = Proxy.NO_PROXY;
                    break;
                }
                case 1: 
                case 3: {
                    if (GeneralOptionsModel.isNonProxy(testingUrlHost, nonProxyHosts)) {
                        testingProxy = Proxy.NO_PROXY;
                        break;
                    }
                    String host = ProxySettings.getTestSystemHttpHost();
                    if (host == null || host.isEmpty()) {
                        testingProxy = Proxy.NO_PROXY;
                        break;
                    }
                    int port = 0;
                    try {
                        port = Integer.valueOf(ProxySettings.getTestSystemHttpPort());
                    }
                    catch (NumberFormatException ex) {
                        LOGGER.log(Level.INFO, "Cannot parse port number", ex);
                    }
                    testingProxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(host, port));
                    break;
                }
                case 2: {
                    nonProxyHosts = GeneralOptionsModel.view2code(nonProxyHosts);
                    if (GeneralOptionsModel.isNonProxy(testingUrl.getHost(), nonProxyHosts)) {
                        testingProxy = Proxy.NO_PROXY;
                        break;
                    }
                    try {
                        int proxyPort = Integer.valueOf(proxyPortString);
                        testingProxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, proxyPort));
                        break;
                    }
                    catch (NumberFormatException ex) {
                        LOGGER.log(Level.INFO, "Cannot parse port number", ex);
                        status = TestingStatus.FAILED;
                        message = NbBundle.getMessage(GeneralOptionsModel.class, (String)"LBL_GeneralOptionsPanel_PortError");
                        panel.updateTestConnectionStatus(status, message);
                        return;
                    }
                }
                default: {
                    testingProxy = Proxy.NO_PROXY;
                }
            }
            if (testingProxy == Proxy.NO_PROXY) {
                proxyHost = null;
                proxyPortString = null;
            }
            try {
                status = GeneralOptionsModel.testHttpConnection(testingUrl, proxyHost, proxyPortString, proxyType, testingProxy) ? TestingStatus.OK : TestingStatus.FAILED;
            }
            catch (Exception ex) {
                LOGGER.log(Level.INFO, "Connection test failed for URL " + testingUrl, ex);
                message = ex.getLocalizedMessage();
                if (message == null || !message.contains("ValidatorException") || !message.contains("PKIX")) break block18;
                message = "Certificate chain is not trusted.";
            }
        }
        panel.updateTestConnectionStatus(status, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean testHttpConnection(URL url, String proxyHost, String proxyPort, int proxyType, Proxy proxy) throws IOException {
        boolean result = false;
        Preferences prefs = GeneralOptionsModel.getProxyPreferences();
        String oldHost = System.getProperty("http.proxyHost");
        String oldPort = System.getProperty("http.proxyPort");
        String oldDisabledSchemesList = System.getProperty("jdk.http.auth.tunneling.disabledSchemes");
        String oldUser = System.getProperty("http.proxyUser");
        String oldPass = System.getProperty("http.proxyPassword");
        String oldHttpsHost = System.getProperty("https.proxyHost");
        String oldHttpsPort = System.getProperty("https.proxyPort");
        int oldProxyType = prefs.getInt("proxyType", 0);
        try {
            prefs.putInt("proxyType", proxyType);
            GeneralOptionsModel.setProperty("http.proxyHost", proxyHost);
            GeneralOptionsModel.setProperty("http.proxyPort", proxyPort);
            GeneralOptionsModel.setProperty("https.proxyHost", ProxySettings.getHttpsHost());
            GeneralOptionsModel.setProperty("https.proxyPort", ProxySettings.getHttpsPort());
            if (proxyHost != null) {
                GeneralOptionsModel.setProperty("jdk.http.auth.tunneling.disabledSchemes", ProxySettings.useAuthentication() ? ProxySettings.getDisabledSchemes() : null);
                GeneralOptionsModel.setProperty("http.proxyUser", ProxySettings.useAuthentication() ? ProxySettings.getAuthenticationUsername() : null);
                GeneralOptionsModel.setProperty("http.proxyPassword", ProxySettings.useAuthentication() ? new String(ProxySettings.getAuthenticationPassword()) : null);
                Authenticator.setDefault(new Authenticator(){

                    @Override
                    protected PasswordAuthentication getPasswordAuthentication() {
                        if (this.getRequestorType() == Authenticator.RequestorType.PROXY) {
                            String prot = this.getRequestingProtocol().toLowerCase();
                            String user = System.getProperty(prot + ".proxyUser", "");
                            String password = System.getProperty(prot + ".proxyPassword", "");
                            return new PasswordAuthentication(user, password.toCharArray());
                        }
                        return null;
                    }
                });
            }
            HttpURLConnection httpConnection = (HttpURLConnection)url.openConnection(proxy);
            httpConnection.setReadTimeout(5000);
            httpConnection.setConnectTimeout(5000);
            try {
                httpConnection.connect();
            }
            catch (Exception ex) {
                LOGGER.log(Level.INFO, "Failed http connection: ", ex.toString());
            }
            int responseCode = Integer.MAX_VALUE;
            try {
                responseCode = httpConnection.getResponseCode();
            }
            catch (IOException ex) {
                LOGGER.log(Level.INFO, "Failed to get a response from the http connection: ", ex.toString());
                throw ex;
            }
            if (responseCode != 200 && responseCode != 302) {
                if (responseCode == 407) {
                    throw new IOException("Proxy authentication settings wrong or missing");
                }
                if (responseCode == -1) {
                    throw new IOException("The request was malformed (-1)");
                }
                throw new IOException("HTTP response " + responseCode);
            }
            result = true;
            httpConnection.disconnect();
        }
        finally {
            GeneralOptionsModel.setProperty("http.proxyHost", oldHost);
            GeneralOptionsModel.setProperty("http.proxyPort", oldPort);
            GeneralOptionsModel.setProperty("jdk.http.auth.tunneling.disabledSchemes", oldDisabledSchemesList);
            GeneralOptionsModel.setProperty("http.proxyUser", oldUser);
            GeneralOptionsModel.setProperty("http.proxyPassword", oldPass);
            GeneralOptionsModel.setProperty("https.proxyHost", oldHttpsHost);
            GeneralOptionsModel.setProperty("https.proxyPort", oldHttpsPort);
            prefs.putInt("proxyType", oldProxyType);
            Authenticator.setDefault(null);
        }
        return result;
    }

    private static void setProperty(String key, String value) {
        if (value != null) {
            System.setProperty(key, value);
        } else {
            System.clearProperty(key);
        }
    }

    private static boolean isNonProxy(String host, String nonProxyHosts) {
        boolean isNonProxy = false;
        if (host != null && nonProxyHosts != null) {
            StringTokenizer st = new StringTokenizer(nonProxyHosts, NON_PROXY_HOSTS_DELIMITER, false);
            while (st.hasMoreTokens()) {
                if (!st.nextToken().equals(host)) continue;
                isNonProxy = true;
                break;
            }
        }
        return isNonProxy;
    }

    private static boolean validatePort(String port) {
        boolean ok;
        block3: {
            if (port.trim().length() == 0) {
                return true;
            }
            ok = false;
            try {
                Integer.parseInt(port);
                ok = true;
            }
            catch (NumberFormatException nfe) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError((Object)nfe);
            }
        }
        return ok;
    }

    private static String code2view(String code) {
        return code == null ? code : code.replace(NON_PROXY_HOSTS_DELIMITER, ", ");
    }

    private static String view2code(String view) {
        return view == null ? view : view.replace(", ", NON_PROXY_HOSTS_DELIMITER);
    }

    static enum TestingStatus {
        OK,
        FAILED,
        WAITING,
        NOT_TESTED;

    }
}

