/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.csv.io;

import com.opencsv.CSVReader;
import com.paterva.maltego.graph.table.io.TabularGraphFileImporter;
import com.paterva.maltego.graph.table.io.TabularGraphIterator;
import com.paterva.maltego.typing.TypeDescriptor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.ByteOrderMark;
import org.apache.commons.io.input.BOMInputStream;
import org.openide.util.Exceptions;

public class CSVImporter
extends TabularGraphFileImporter {
    public CSVImporter(File file) {
        super(file);
    }

    public TabularGraphIterator open() throws IOException {
        BOMInputStream bos = new BOMInputStream((InputStream)new FileInputStream(this.getFile()), false, new ByteOrderMark[]{ByteOrderMark.UTF_8, ByteOrderMark.UTF_16LE, ByteOrderMark.UTF_16BE, ByteOrderMark.UTF_32LE, ByteOrderMark.UTF_32BE});
        String charset = "utf-8";
        if (bos.hasBOM()) {
            charset = bos.getBOMCharsetName();
        }
        CSVReader reader = new CSVReader((Reader)new InputStreamReader((InputStream)bos, charset));
        return new RowIterator(reader);
    }

    private static class RowIterator
    implements TabularGraphIterator {
        private final CSVReader _reader;
        private String[] _nextLine;
        private boolean _hasReadNextLine;

        public RowIterator(CSVReader reader) throws FileNotFoundException {
            this._reader = reader;
            this._hasReadNextLine = false;
        }

        public boolean hasNext() {
            try {
                return this.peekNext() != null;
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return false;
            }
        }

        public void next() {
            this._hasReadNextLine = false;
        }

        public List<Object> getRow(Map<Integer, TypeDescriptor> desiredColumnTypes) throws IOException {
            return new ArrayList<Object>(Arrays.asList(this.peekNext()));
        }

        private String[] peekNext() throws IOException {
            if (!this._hasReadNextLine) {
                do {
                    this._nextLine = this._reader.readNext();
                    if (this._nextLine == null || this._nextLine.length != 1 || !this._nextLine[0].isEmpty()) continue;
                    this._nextLine = new String[0];
                } while (this._nextLine != null && this._nextLine.length == 0);
                this._hasReadNextLine = true;
            }
            return this._nextLine;
        }

        public void close() throws Exception {
            if (this._reader != null) {
                this._reader.close();
            }
        }
    }
}

