/*
 * Decompiled with CFR 0.152.
 */
package com.pinkmatter.pandora.lucene;

import com.pinkmatter.pandora.PandoraException;
import com.pinkmatter.pandora.PandoraProperty;
import com.pinkmatter.pandora.lucene.LuceneSchema;
import com.pinkmatter.pandora.lucene.PandoraQueryImpl;
import com.pinkmatter.pandora.lucene.PropertyFieldVisitor;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.lucene.document.DocumentStoredFieldVisitor;

class PropertyFieldVisitorFactory {
    private final boolean _inclusionList;
    private final Set<String> _fields = new HashSet<String>();

    public PropertyFieldVisitorFactory(LuceneSchema schema, PandoraQueryImpl.IncludeProperty[] includeProperties) throws PandoraException {
        boolean bl = this._inclusionList = includeProperties != null && includeProperties.length > 0 && includeProperties[0].isIncluded();
        if (includeProperties != null) {
            for (PandoraQueryImpl.IncludeProperty property : includeProperties) {
                List<PandoraProperty> pandoraProps = schema.getProperties(property.getProperty(), property.getType());
                for (PandoraProperty pandoraProp : pandoraProps) {
                    Set<String> propFields = schema.getFieldHelper().getFields(property.getProperty(), pandoraProp.getType());
                    if (this._inclusionList == property.isIncluded()) {
                        this._fields.addAll(propFields);
                        continue;
                    }
                    this._fields.removeAll(propFields);
                }
            }
        }
    }

    public DocumentStoredFieldVisitor createVisitor() {
        return new PropertyFieldVisitor(this._fields, this._inclusionList);
    }
}

